#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"SCN for MWs and SGs\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                       
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0631     0.38878      0.02554
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6445     0.42415      0.03372
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3800     0.45954      0.04105
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2452     0.49151      0.04765
     C14         190.351     197.571     0.84075      250.39330     716.029     20.2213     0.52508      0.05359
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2934     0.55826      0.05893
     C16         219.058     226.301     0.85730      284.08099     748.334     18.4493     0.59100      0.06371
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6789     0.62328      0.06797
     C18         247.886     255.149     0.87063      314.32372     776.364     16.9733     0.65506      0.07174
     C19         262.339     269.611     0.87636      328.31560     789.048     16.3254     0.68633      0.07505
     C20         276.815     284.096     0.88158      341.62882     800.961     15.7287     0.71706      0.07793
     C21         291.313     298.601     0.88635      354.31270     812.177     15.1776     0.74726      0.08042
     C22         305.830     313.126     0.89074      366.41217     822.761     14.6675     0.77691      0.08254
     C23         320.366     327.669     0.89477      377.96816     832.769     14.1940     0.80601      0.08432
     C24         334.920     342.230     0.89850      389.01807     842.251     13.7535     0.83456      0.08579
     C25         349.491     356.807     0.90196      399.59611     851.252     13.3427     0.86257      0.08698
     C26         364.077     371.400     0.90517      409.73362     859.812     12.9588     0.89004      0.08790
     C27         378.678     386.007     0.90817      419.45935     867.964     12.5994     0.91698      0.08859
     C28         393.293     400.628     0.91096      428.79974     875.742     12.2620     0.94339      0.08906
     C29         407.922     415.262     0.91358      437.77907     883.172     11.9449     0.96930      0.08933
     C30+        422.563     602.891     0.93649      528.47876     956.060      9.0961     1.25946      0.08196
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_005_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle

set title "Gamma Model of Lab3_MDT1_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1039e-01    1.1755e-01    4.7659e-02    5.1095e-02
    119.36      126.50      126.09     8.7711e-02    9.8594e-02    4.2593e-02    4.7724e-02
    133.44      140.60      140.30     7.7769e-02    7.9549e-02    4.1976e-02    4.2846e-02
    147.59      154.77      154.52     6.2187e-02    6.7800e-02    3.6948e-02    4.0218e-02
    161.80      168.99      168.77     5.4506e-02    5.9146e-02    3.5360e-02    3.8320e-02
    176.05      183.26      183.06     5.4919e-02    5.2268e-02    3.8637e-02    3.6731e-02
    190.35      197.57      197.38     5.2220e-02    4.6570e-02    3.9607e-02    3.5288e-02
    204.69      211.92      211.74     4.8220e-02    4.1729e-02    3.9229e-02    3.3920e-02
    219.06      226.30      226.13     4.2675e-02    3.7547e-02    3.7074e-02    3.2594e-02
    233.46      240.71      240.55     3.9902e-02    3.3890e-02    3.6872e-02    3.1296e-02
    247.89      255.15      254.99     3.6563e-02    3.0666e-02    3.5814e-02    3.0019e-02
    262.34      269.61      269.46     3.1485e-02    2.7804e-02    3.2588e-02    2.8761e-02
    276.82      284.10      283.95     2.4680e-02    2.5251e-02    2.6917e-02    2.7525e-02
    291.31      298.60      298.46     2.0568e-02    2.2964e-02    2.3578e-02    2.6311e-02
    305.83      313.13      312.98     1.8912e-02    2.0908e-02    2.2733e-02    2.5122e-02
    320.37      327.67      327.53     1.7562e-02    1.9056e-02    2.2091e-02    2.3960e-02
    334.92      342.23      342.09     1.5213e-02    1.7382e-02    1.9986e-02    2.2828e-02
    349.49      356.81      356.67     1.4002e-02    1.5868e-02    1.9180e-02    2.1727e-02
    364.08      371.40      371.27     1.3072e-02    1.4495e-02    1.8638e-02    2.0659e-02
    378.68      386.01      385.88     1.3096e-02    1.3249e-02    1.9406e-02    1.9626e-02
    393.29      400.63      400.50     1.2208e-02    1.2116e-02    1.8776e-02    1.8628e-02
    407.92      415.26      415.13     1.0790e-02    1.1085e-02    1.7201e-02    1.7666e-02
    422.56      602.89      596.59     1.4135e-01    1.2312e-01    3.2714e-01    2.8198e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_002_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT1_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.63      112.46      113.23     1.1605e-01    1.1561e-01    4.9834e-02    4.9981e-02
    119.36      126.50      126.09     9.2210e-02    9.6967e-02    4.4537e-02    4.6683e-02
    133.44      140.60      140.30     8.1719e-02    7.8236e-02    4.3871e-02    4.1913e-02
    147.59      154.77      154.52     6.5034e-02    6.6681e-02    3.8431e-02    3.9341e-02
    161.80      168.99      168.77     5.6043e-02    5.8170e-02    3.6161e-02    3.7485e-02
    176.05      183.26      183.06     5.4545e-02    5.1406e-02    3.8167e-02    3.5930e-02
    190.35      197.57      197.38     5.0346e-02    4.5802e-02    3.7980e-02    3.4519e-02
    204.69      211.92      211.74     4.3633e-02    4.1041e-02    3.5306e-02    3.3181e-02
    219.06      226.30      226.13     3.6542e-02    3.6927e-02    3.1575e-02    3.1884e-02
    233.46      240.71      240.55     3.1898e-02    3.3331e-02    2.9317e-02    3.0614e-02
    247.89      255.15      254.99     2.9177e-02    3.0160e-02    2.8425e-02    2.9364e-02
    262.34      269.61      269.46     2.8135e-02    2.7345e-02    2.8964e-02    2.8134e-02
    276.82      284.10      283.95     2.4409e-02    2.4834e-02    2.6478e-02    2.6925e-02
    291.31      298.60      298.46     2.1326e-02    2.2585e-02    2.4314e-02    2.5737e-02
    305.83      313.13      312.98     1.9794e-02    2.0563e-02    2.3665e-02    2.4574e-02
    320.37      327.67      327.53     1.8365e-02    1.8741e-02    2.2977e-02    2.3438e-02
    334.92      342.23      342.09     1.5966e-02    1.7096e-02    2.0864e-02    2.2330e-02
    349.49      356.81      356.67     1.4682e-02    1.5606e-02    2.0002e-02    2.1253e-02
    364.08      371.40      371.27     1.3736e-02    1.4256e-02    1.9478e-02    2.0209e-02
    378.68      386.01      385.88     1.3754e-02    1.3030e-02    2.0272e-02    1.9198e-02
    393.29      400.63      400.50     1.2825e-02    1.1916e-02    1.9618e-02    1.8222e-02
    407.92      415.26      415.13     1.1328e-02    1.0902e-02    1.7962e-02    1.7281e-02
    422.56      602.89      596.59     1.4848e-01    1.2109e-01    3.4180e-01    2.7583e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_003_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1780e-01    1.1984e-01    5.1674e-02    5.2790e-02
    119.36      126.50      126.10     9.0283e-02    9.6703e-02    4.4546e-02    4.7564e-02
    133.44      140.60      140.31     8.1226e-02    7.8597e-02    4.4546e-02    4.3015e-02
    147.59      154.77      154.52     6.4936e-02    6.7285e-02    3.9201e-02    4.0555e-02
    161.80      168.99      168.77     5.6961e-02    5.8906e-02    3.7546e-02    3.8778e-02
    176.05      183.26      183.06     5.5019e-02    5.2218e-02    3.9328e-02    3.7286e-02
    190.35      197.57      197.39     4.8886e-02    4.6661e-02    3.7673e-02    3.5925e-02
    204.69      211.92      211.74     4.6038e-02    4.1925e-02    3.8055e-02    3.4627e-02
    219.06      226.30      226.13     3.8787e-02    3.7823e-02    3.4237e-02    3.3362e-02
    233.46      240.71      240.55     3.4025e-02    3.4227e-02    3.1946e-02    3.2115e-02
    247.89      255.15      254.99     3.2739e-02    3.1049e-02    3.2582e-02    3.0882e-02
    262.34      269.61      269.46     3.0378e-02    2.8222e-02    3.1946e-02    2.9662e-02
    276.82      284.10      283.95     2.4924e-02    2.5693e-02    2.7619e-02    2.8456e-02
    291.31      298.60      298.46     2.2511e-02    2.3422e-02    2.6219e-02    2.7267e-02
    305.83      313.13      312.99     1.9799e-02    2.1377e-02    2.4182e-02    2.6097e-02
    320.37      327.67      327.53     1.8522e-02    1.9529e-02    2.3673e-02    2.4950e-02
    334.92      342.23      342.10     1.6685e-02    1.7857e-02    2.2273e-02    2.3827e-02
    349.49      356.81      356.67     1.5364e-02    1.6339e-02    2.1382e-02    2.2732e-02
    364.08      371.40      371.27     1.4321e-02    1.4961e-02    2.0746e-02    2.1665e-02
    378.68      386.01      385.88     1.4624e-02    1.3706e-02    2.2019e-02    2.0630e-02
    393.29      400.63      400.50     1.2054e-02    1.2563e-02    1.8837e-02    1.9626e-02
    407.92      415.26      415.14     1.2494e-02    1.1521e-02    2.0237e-02    1.8656e-02
    422.56      602.89      601.47     1.3163e-01    1.3164e-01    3.0953e-01    3.0885e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_005_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT2_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.11      112.46      112.94     1.1936e-01    1.1935e-01    5.2293e-02    5.2512e-02
    119.36      126.50      126.10     9.1476e-02    9.6309e-02    4.5080e-02    4.7314e-02
    133.44      140.60      140.31     8.2289e-02    7.8276e-02    4.5075e-02    4.2788e-02
    147.59      154.77      154.52     6.5706e-02    6.7011e-02    3.9618e-02    4.0341e-02
    161.80      168.99      168.77     5.7389e-02    5.8665e-02    3.7783e-02    3.8573e-02
    176.05      183.26      183.06     5.4924e-02    5.2005e-02    3.9213e-02    3.7089e-02
    190.35      197.57      197.39     4.8359e-02    4.6470e-02    3.7223e-02    3.5735e-02
    204.69      211.92      211.74     4.4828e-02    4.1754e-02    3.7010e-02    3.4444e-02
    219.06      226.30      226.13     3.7156e-02    3.7669e-02    3.2758e-02    3.3186e-02
    233.46      240.71      240.55     3.1886e-02    3.4088e-02    2.9902e-02    3.1946e-02
    247.89      255.15      254.99     3.0786e-02    3.0923e-02    3.0602e-02    3.0719e-02
    262.34      269.61      269.46     2.9500e-02    2.8106e-02    3.0986e-02    2.9506e-02
    276.82      284.10      283.95     2.4857e-02    2.5588e-02    2.7512e-02    2.8306e-02
    291.31      298.60      298.46     2.2732e-02    2.3327e-02    2.6444e-02    2.7123e-02
    305.83      313.13      312.99     2.0038e-02    2.1290e-02    2.4445e-02    2.5960e-02
    320.37      327.67      327.53     1.8742e-02    1.9450e-02    2.3925e-02    2.4818e-02
    334.92      342.23      342.10     1.6899e-02    1.7784e-02    2.2531e-02    2.3702e-02
    349.49      356.81      356.67     1.5557e-02    1.6273e-02    2.1625e-02    2.2612e-02
    364.08      371.40      371.27     1.4508e-02    1.4900e-02    2.0992e-02    2.1551e-02
    378.68      386.01      385.88     1.4814e-02    1.3650e-02    2.2277e-02    2.0521e-02
    393.29      400.63      400.50     1.2211e-02    1.2512e-02    1.9059e-02    1.9522e-02
    407.92      415.26      415.14     1.2655e-02    1.1474e-02    2.0473e-02    1.8557e-02
    422.56      602.89      601.47     1.3333e-01    1.3111e-01    3.1318e-01    3.0722e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_006_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Contaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.1891e-01    1.2086e-01    5.1487e-02    5.2604e-02
    119.36      126.50      126.08     9.0316e-02    9.7063e-02    4.3987e-02    4.7118e-02
    133.44      140.60      140.30     8.0786e-02    7.8013e-02    4.3733e-02    4.2141e-02
    147.59      154.77      154.52     6.4217e-02    6.6411e-02    3.8266e-02    3.9509e-02
    161.80      168.99      168.77     5.6078e-02    5.7941e-02    3.6486e-02    3.7649e-02
    176.05      183.26      183.06     5.4053e-02    5.1249e-02    3.8139e-02    3.6120e-02
    190.35      197.57      197.38     4.8132e-02    4.5727e-02    3.6613e-02    3.4751e-02
    204.69      211.92      211.74     4.5029e-02    4.1047e-02    3.6740e-02    3.3464e-02
    219.06      226.30      226.13     3.8082e-02    3.7010e-02    3.3181e-02    3.2223e-02
    233.46      240.71      240.55     3.3333e-02    3.3483e-02    3.0892e-02    3.1010e-02
    247.89      255.15      254.99     3.1965e-02    3.0372e-02    3.1401e-02    2.9819e-02
    262.34      269.61      269.46     2.9760e-02    2.7610e-02    3.0892e-02    2.8645e-02
    276.82      284.10      283.95     2.4407e-02    2.5144e-02    2.6697e-02    2.7489e-02
    291.31      298.60      298.46     2.2005e-02    2.2932e-02    2.5299e-02    2.6351e-02
    305.83      313.13      312.99     1.9403e-02    2.0941e-02    2.3392e-02    2.5235e-02
    320.37      327.67      327.53     1.8139e-02    1.9143e-02    2.2883e-02    2.4141e-02
    334.92      342.23      342.10     1.6402e-02    1.7516e-02    2.1612e-02    2.3071e-02
    349.49      356.81      356.68     1.5362e-02    1.6041e-02    2.1103e-02    2.2028e-02
    364.08      371.40      371.27     1.3691e-02    1.4700e-02    1.9578e-02    2.1013e-02
    378.68      386.01      385.88     1.3772e-02    1.3480e-02    2.0468e-02    2.0027e-02
    393.29      400.63      400.50     1.2445e-02    1.2368e-02    1.9197e-02    1.9071e-02
    407.92      415.26      415.14     1.2245e-02    1.1353e-02    1.9578e-02    1.8147e-02
    422.56      602.89      604.88     1.4147e-01    1.3195e-01    3.2838e-01    3.0730e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_008_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Lab3_MDT3_Decontaminated C8+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    108.41      112.46      113.05     1.2048e-01    1.2033e-01    5.2096e-02    5.2305e-02
    119.36      126.50      126.08     9.1507e-02    9.6643e-02    4.4507e-02    4.6850e-02
    133.44      140.60      140.30     8.1842e-02    7.7675e-02    4.4244e-02    4.1902e-02
    147.59      154.77      154.52     6.4976e-02    6.6123e-02    3.8666e-02    3.9285e-02
    161.80      168.99      168.77     5.6493e-02    5.7690e-02    3.6707e-02    3.7436e-02
    176.05      183.26      183.06     5.3946e-02    5.1027e-02    3.8011e-02    3.5915e-02
    190.35      197.57      197.38     4.7596e-02    4.5529e-02    3.6157e-02    3.4554e-02
    204.69      211.92      211.74     4.3807e-02    4.0870e-02    3.5695e-02    3.3274e-02
    219.06      226.30      226.13     3.6444e-02    3.6850e-02    3.1711e-02    3.2040e-02
    233.46      240.71      240.55     3.1188e-02    3.3338e-02    2.8865e-02    3.0834e-02
    247.89      255.15      254.99     3.0004e-02    3.0241e-02    2.9435e-02    2.9649e-02
    262.34      269.61      269.46     2.8876e-02    2.7491e-02    2.9934e-02    2.8482e-02
    276.82      284.10      283.95     2.4334e-02    2.5035e-02    2.6581e-02    2.7333e-02
    291.31      298.60      298.46     2.2219e-02    2.2833e-02    2.5510e-02    2.6202e-02
    305.83      313.13      312.99     1.9636e-02    2.0850e-02    2.3641e-02    2.5091e-02
    320.37      327.67      327.53     1.8353e-02    1.9060e-02    2.3122e-02    2.4004e-02
    334.92      342.23      342.10     1.6612e-02    1.7440e-02    2.1858e-02    2.2940e-02
    349.49      356.81      356.68     1.5554e-02    1.5971e-02    2.1339e-02    2.1903e-02
    364.08      371.40      371.27     1.3870e-02    1.4636e-02    1.9807e-02    2.0893e-02
    378.68      386.01      385.88     1.3950e-02    1.3421e-02    2.0704e-02    1.9913e-02
    393.29      400.63      400.50     1.2607e-02    1.2314e-02    1.9419e-02    1.8963e-02
    407.92      415.26      415.14     1.2403e-02    1.1304e-02    1.9803e-02    1.8044e-02
    422.56      602.89      604.88     1.4330e-01    1.3138e-01    3.3219e-01    3.0556e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_009_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "EOS Fluid Characterization \"SCN EOS\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                                                          Visc                        Vc            VcVis
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran         Zc        ZcVis        (cp)        Pchor      (ft3/lbmol)     (ft3/lbmol)
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------   ---------   ---------   ----------   ---------   -------------   -------------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758     0.29178     0.29178          NaN       59.10        1.4433          1.4433
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191     0.27433     0.27433          NaN       80.00        1.5069          1.5069
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996     0.28620     0.28620          NaN       71.00        1.5794          1.5794
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280     0.27924     0.27924          NaN      111.00        2.3307          2.3307
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381     0.27630     0.27630          NaN      151.00        3.2037          3.2037
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197     0.28199     0.28199          NaN      188.80        4.2081          4.2081
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393     0.27385     0.27385          NaN      191.00        4.0847          4.0847
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646     0.27231     0.27231          NaN      227.40        4.9385          4.9385
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928     0.26837     0.26837          NaN      231.00        4.9817          4.9817
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474     0.26937     0.26937          NaN      238.40        5.5365          5.5365
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820     0.26470     0.26601      0.24166      271.63        6.3039          6.3351
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569     0.26056     0.26355      0.30650      304.90        7.0573          7.1382
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630     0.25684     0.26245      0.38367      338.59        7.7990          7.9693
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0637     0.38879      0.02551     0.25345     0.26198      0.47437      372.44        8.5337          8.8212
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6316     0.42389      0.03433     0.25031     0.26176      0.57993      406.44        9.2681          9.6920
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3551     0.45899      0.04227     0.24738     0.26179      0.70168      440.57        9.9972         10.5794
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2094     0.49067      0.04946     0.24461     0.26198      0.84092      474.82       10.7204         11.4819
     C14         190.351     197.571     0.84075      250.39330     716.029     20.1758     0.52390      0.05598     0.24195     0.26230      0.99891      509.17       11.4364         12.3979
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2390     0.55671      0.06189     0.23940     0.26271      1.17687      543.61       12.1441         13.3266
     C16         219.058     226.301     0.85730      284.08099     748.334     18.3869     0.58907      0.06723     0.23692     0.26320      1.37598      578.12       12.8421         14.2667
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6091     0.62093      0.07203     0.23450     0.26376      1.59738      612.71       13.5295         15.2176
     C18         247.886     255.149     0.87063      314.32372     776.364     16.8968     0.65228      0.07634     0.23213     0.26438      1.84214      647.36       14.2053         16.1785
     C19         262.339     269.611     0.87636      328.31560     789.048     16.2427     0.68308      0.08018     0.22981     0.26505      2.11132      682.07       14.8688         17.1488
     C20         276.815     284.096     0.88158      341.62882     800.961     15.6403     0.71332      0.08359     0.22754     0.26578      2.40590      716.83       15.5195         18.1278
     C21         291.313     298.601     0.88635      354.31270     812.177     15.0840     0.74300      0.08660     0.22531     0.26655      2.72683      751.64       16.1571         19.1150
     C22         305.830     313.126     0.89074      366.41217     822.761     14.5690     0.77211      0.08923     0.22311     0.26737      3.07503      786.50       16.7813         20.1102
     C23         320.366     327.669     0.89477      377.96816     832.769     14.0910     0.80064      0.09152     0.22096     0.26823      3.45136      821.41       17.3920         21.1127
     C24         334.920     342.230     0.89850      389.01807     842.251     13.6463     0.82860      0.09349     0.21884     0.26912      3.85665      856.35       17.9892         22.1223
     C25         349.491     356.807     0.90196      399.59611     851.252     13.2316     0.85600      0.09518     0.21676     0.27005      4.29169      891.34       18.5731         23.1387
     C26         364.077     371.400     0.90517      409.73362     859.812     12.8441     0.88284      0.09660     0.21472     0.27100      4.75723      926.36       19.1439         24.1616
     C27         378.678     386.007     0.90817      419.45935     867.964     12.4812     0.90912      0.09777     0.21272     0.27198      5.25399      961.42       19.7017         25.1906
     C28         393.293     400.628     0.91096      428.79974     875.742     12.1406     0.93486      0.09873     0.21075     0.27298      5.78268      996.51       20.2469         26.2256
     C29         407.922     415.262     0.91358      437.77907     883.172     11.8205     0.96007      0.09948     0.20882     0.27401      6.34396     1031.63       20.7798         27.2663
     C30+        422.563     602.891     0.93649      528.47876     956.060      8.9445     1.23959      0.09809     0.18723     0.28782     16.61871     1481.94       26.6541         40.9739
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_006_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle
set ylabel "Boiling Temperature (C)"
set output "Figures/Table_006_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:5 with points notitle
set ylabel "Critical Temperature (K)"
set output "Figures/Table_006_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:6 with points notitle
set ylabel "Critical Pressure (bar)"
set output "Figures/Table_006_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:7 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_006_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:8 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_006_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:9 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_006_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_006_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:11 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_006_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_006_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:13 with points notitle

set title "Lab1 Swelling Test"
show title

$Expt << END
#                             Mole Frac Inj                Sat Pres (barg)      Density (g/cm3)      Liq Vol Frac           C30+ K-Value
#  Stg     Mass Frac Inj           (%)           Feed       Expt    Calc         Expt     Calc       Expt    Calc         Expt        Calc
#------   ---------------   ----------------   -------   ------------------   ------------------   ----------------   ------------------------
     1        0.00000             0.000          NaN       232.42  232.42          NaN  0.69410     1.0000  1.0000            NaN  5.0547e-05
     2        0.06563            22.001          M23       272.47  286.09      0.65300  0.65825     1.0000  1.0000            NaN  8.9399e-04
     3        0.21770            52.775          M54       397.42  392.42      0.58000  0.59021     1.0000  1.0000            NaN  1.1294e-01
     4        0.26890            59.629          M61       425.37  431.32      0.56100  0.57255     1.0000  1.0000            NaN  7.5161e-01
     5        0.27500            60.368          NaN          NaN  436.93          NaN  0.57077        NaN  1.0000     1.0000e+00  1.0000e+00
     6        0.30676            63.990          M65       452.11  469.34      0.54700  0.56250     0.0000  0.0000            NaN  4.5738e-01
     7        0.45610            77.104          M78       586.05  615.17      0.49600  0.52878     0.0000  0.0000            NaN  1.4119e-01
     8        0.50000            80.063          NaN          NaN  646.57          NaN  0.51864        NaN  0.0000            NaN  1.1141e-01
     9        0.55000            83.074          NaN          NaN  672.27          NaN  0.50635        NaN  0.0000            NaN  8.5855e-02
    10        0.60000            85.762          NaN          NaN  685.42          NaN  0.49299        NaN  0.0000            NaN  6.6125e-02
    11        0.65000            88.177          NaN          NaN  684.84          NaN  0.47826        NaN  0.0000            NaN  5.0457e-02
    12        0.70000            90.357          NaN          NaN  670.23          NaN  0.46189        NaN  0.0000            NaN  3.7810e-02
    13        0.75000            92.336          NaN          NaN  642.10          NaN  0.44360        NaN  0.0000            NaN  2.7528e-02
    14        0.80000            94.139          NaN          NaN  601.30          NaN  0.42295        NaN  0.0000            NaN  1.9165e-02
    15        0.85000            95.791          NaN          NaN  548.28          NaN  0.39915        NaN  0.0000            NaN  1.2411e-02
    16        0.90000            97.308          NaN          NaN  481.73          NaN  0.37036        NaN  0.0000            NaN  7.0384e-03
    17        0.95000            98.706          NaN          NaN  394.07          NaN  0.33089        NaN  0.0000            NaN  2.8981e-03
END
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (barg)"
set output "Figures/Expt_005_SATP_vs_WFI_1.pdf"
plot [0:1][*<0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_005_DEN_vs_WFI_1.pdf"
plot [0:1][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_005_LVF_vs_WFI_1.pdf"
plot [0:1][0:1] $Expt using 2:9 with points title "Expt", $Expt using 2:10 with lines title "Calc"

set title "Lab1 Viscosity Test"
show title

$Expt << END
#                            Pres                          Liq Vis (cp)
# Stg     Mass Frac Inj     (psig)     Mole Frac Inj       Expt     Calc
#-----   ---------------   --------   ---------------   ------------------
    1        0.06563        6000.0        0.22001        0.57800  0.48157
    2        0.21770        6200.0        0.52775        0.31700  0.21280
    3        0.26890        6450.0        0.59629        0.24500  0.17639
END
set xlabel "Mole Fraction Injectant"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_006_LVIS_vs_MFI_1.pdf"
plot [0:1][0:*] $Expt using 4:5 with points title "Expt", $Expt using 4:6 with lines title "Calc"

set title "P/V Test on Lab1 0% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liquid Volume (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc           Expt       Calc        Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------------   ----------------   ----------------
     1     240.00     96.000          NaN  100.00             NaN  0.0001483        NaN   0.000        NaN  0.9981
     2     235.00     96.000          NaN  100.00             NaN  0.0001485        NaN   0.000        NaN  0.9993
     3     232.42     96.000       100.00  100.00             NaN  0.0001486        NaN   0.000        NaN  1.0000
     4     212.01     96.000        91.90   94.94             NaN  0.0001449        NaN  10.009        NaN  1.0268
     5     206.64     96.000        91.30   93.56             NaN  0.0001439        NaN  12.619        NaN  1.0351
     6     200.84     96.000        90.40   92.05             NaN  0.0001429        NaN  15.429        NaN  1.0448
     7     194.43     96.000        89.40   90.34             NaN  0.0001419        NaN  18.528        NaN  1.0565
     8     186.16     96.000        84.80   88.07             NaN  0.0001405        NaN  22.518        NaN  1.0732
     9     151.68     96.000        76.20   77.63             NaN  0.0001350        NaN  39.150        NaN  1.1704
    10     128.24     96.000        69.00   69.34             NaN  0.0001315        NaN  50.600        NaN  1.2762
    11     111.83     96.000        63.50   62.80             NaN  0.0001291        NaN  58.781        NaN  1.3829
    12      99.84     96.000        57.90   57.59             NaN  0.0001273        NaN  64.895        NaN  1.4873
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_007_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 23% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)         GOR (sm3/m3)           Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc        Expt      Calc        Expt    Calc
#------   --------   --------   --------------------   ----------------   --------------------   ----------------
     1     285.00     96.000          NaN   99.72          NaN  1.5723          NaN    0.6704        NaN  0.9885
     2     280.00     96.000          NaN   98.47          NaN  1.5595          NaN    3.7149        NaN  0.9929
     3     275.00     96.000          NaN   97.24          NaN  1.5471          NaN    6.7239        NaN  0.9975
     4     272.47     96.000       100.00   96.62          NaN  1.5410          NaN    8.2339        NaN  1.0000
     5     241.66     96.000        83.50   89.13          NaN  1.4733          NaN   26.0786        NaN  1.0363
     6     235.39     96.000        83.00   87.60          NaN  1.4607          NaN   29.6146        NaN  1.0454
     7     214.43     96.000        79.20   82.37          NaN  1.4210          NaN   41.2864        NaN  1.0815
     8     155.82     96.000        65.40   65.85          NaN  1.3219          NaN   73.6111        NaN  1.2587
     9     101.63     96.000        49.60   46.37          NaN  1.2359          NaN  105.1218        NaN  1.6709
    10      75.84     96.000        39.10   35.36          NaN  1.1928          NaN  121.8337        NaN  2.1147
    11      60.67     96.000        31.10   28.41          NaN  1.1653          NaN  132.7446        NaN  2.5716
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_008_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 54% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)        GOR (sm3/m3)          Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc        Expt     Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ------------------   ----------------
     1     400.00     96.000          NaN  100.00          NaN  2.2890         NaN    0.000        NaN  0.9991
     2     397.42     96.000       100.00  100.00          NaN  2.2910         NaN    0.000        NaN  1.0000
     3     395.21     96.000        88.10  100.00          NaN  2.2927         NaN    0.000        NaN  1.0008
     4     390.93     96.000        85.70   99.11          NaN  2.2763         NaN    2.493        NaN  1.0025
     5     381.35     96.000        79.40   94.41          NaN  2.1800         NaN   16.459        NaN  1.0079
     6     367.90     96.000        76.90   89.61          NaN  2.0861         NaN   32.162        NaN  1.0161
     7     343.36     96.000        73.60   83.21          NaN  1.9710         NaN   54.981        NaN  1.0340
     8     255.66     96.000        62.20   66.32          NaN  1.7381         NaN  116.622        NaN  1.1439
     9     197.88     96.000        51.50   54.63          NaN  1.6277         NaN  153.527        NaN  1.3004
    10     147.34     96.000        40.20   42.31          NaN  1.5332         NaN  188.204        NaN  1.5819
    11     118.73     96.000        35.20   34.31          NaN  1.4761         NaN  210.362        NaN  1.8780
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_009_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 61% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------
     1     440.00     96.000          NaN  100.00          NaN  2.4819        NaN    0.00        NaN  0.9944
     2     435.00     96.000          NaN  100.00          NaN  2.4862        NaN    0.00        NaN  0.9961
     3     430.00     96.000          NaN   89.37          NaN  2.2261        NaN   29.89        NaN  0.9979
     4     425.37     96.000       100.00   82.44          NaN  2.0578        NaN   55.04        NaN  1.0000
     5     421.96     96.000        88.60   81.30          NaN  2.0325        NaN   60.33        NaN  1.0016
     6     415.75     96.000        83.10   80.25          NaN  2.0122        NaN   65.84        NaN  1.0046
     7     410.10     96.000        79.30   79.50          NaN  1.9992        NaN   69.84        NaN  1.0075
     8     398.86     96.000        75.20   78.06          NaN  1.9748        NaN   77.31        NaN  1.0136
     9     388.45     96.000        69.70   76.71          NaN  1.9525        NaN   84.07        NaN  1.0198
    10     378.18     96.000        69.60   75.37          NaN  1.9310        NaN   90.64        NaN  1.0265
    11     368.52     96.000        66.00   74.11          NaN  1.9114        NaN   96.72        NaN  1.0333
    12     350.18     96.000        65.90   71.72          NaN  1.8757        NaN  108.04        NaN  1.0478
    13     333.36     96.000        62.80   69.52          NaN  1.8448        NaN  118.20        NaN  1.0632
    14     270.76     96.000        56.50   60.82          NaN  1.7404        NaN  155.07        NaN  1.1465
    15     218.22     96.000        51.20   52.17          NaN  1.6581        NaN  186.61        NaN  1.2733
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_010_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 65% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1               N2 x                    CO2 x                 C1 x                  C2 x                   C3 x                   I-C4 x                  N-C4 x                  I-C5 x                  N-C5 x                 C6-C7 x                C8-C9 x               C10-C13 x              C14-C19 x              C20-C29 x               C30+ x                 C6+ x          Gas N2 Mole Fraction            CO2 y                 C1 y                  C2 y                   C3 y                   I-C4 y                  N-C4 y                  I-C5 y                  N-C5 y                 C6-C7 y                C8-C9 y               C10-C13 y              C14-C19 y               C20-C29 y          Gas C30+ Mole Fraction           C6+ y            N2 K-Value         CO2 K-Value        C1 K-Value         C2 K-Value         C3 K-Value         I-C4 K-Value         N-C4 K-Value         I-C5 K-Value         N-C5 K-Value         C6-C7 K-Value        C8-C9 K-Value       C10-C13 K-Value      C14-C19 K-Value       C20-C29 K-Value          C30+ K-Value            C6+ K-Value
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt     Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc          Expt       Calc          Expt        Calc          Expt     Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt      Calc          Expt       Calc         Expt     Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ------------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ----------------------   ------------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   --------------------   ----------------------   ------------------
     1     480.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9896           NaN  0.0025899          NaN  0.013863         NaN  0.56350          NaN  0.087015          NaN  0.078486           NaN  0.0033160          NaN  0.038599           NaN  0.0042213          NaN  0.019056          NaN  0.043677          NaN  0.025165          NaN  0.030726          NaN  0.027166          NaN  0.023530          NaN  0.039093         NaN  0.18936           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180410            NaN  1.7807e-02         NaN  0.15168        NaN  1.0618        NaN  1.0192        NaN  1.0574        NaN  1.0164        NaN  1.0038         NaN  0.99686         NaN  0.99075         NaN  0.98283         NaN  0.97942         NaN  0.96251         NaN  0.93934         NaN  0.90877         NaN  0.86095          NaN  0.791513           NaN  0.5133576         NaN  0.82216
     2     475.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9912           NaN  0.0025836          NaN  0.013856         NaN  0.56256          NaN  0.087002          NaN  0.078529           NaN  0.0033192          NaN  0.038647           NaN  0.0042284          NaN  0.019092          NaN  0.043794          NaN  0.025261          NaN  0.030887          NaN  0.027366          NaN  0.023766          NaN  0.039110         NaN  0.19018           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180410            NaN  1.7807e-02         NaN  0.15168        NaN  1.0678        NaN  1.0208        NaN  1.0624        NaN  1.0175        NaN  1.0035         NaN  0.99579         NaN  0.98906         NaN  0.98030         NaN  0.97654         NaN  0.95797         NaN  0.93255         NaN  0.89916         NaN  0.84723          NaN  0.772481           NaN  0.4855502         NaN  0.80878
     3     470.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9929           NaN  0.0025781          NaN  0.013851         NaN  0.56179          NaN  0.087001          NaN  0.078581           NaN  0.0033227          NaN  0.038698           NaN  0.0042358          NaN  0.019128          NaN  0.043910          NaN  0.025355          NaN  0.031043          NaN  0.027555          NaN  0.023984          NaN  0.038964         NaN  0.19081           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180410            NaN  1.7807e-02         NaN  0.15168        NaN  1.0736        NaN  1.0222        NaN  1.0670        NaN  1.0184        NaN  1.0030         NaN  0.99453         NaN  0.98720         NaN  0.97758         NaN  0.97349         NaN  0.95327         NaN  0.92562         NaN  0.88946         NaN  0.83357          NaN  0.753817           NaN  0.4605204         NaN  0.79624
     4     465.00     96.000          NaN   4.749          NaN  0.1256        NaN  5013.6        NaN  0.9948           NaN  0.0025732          NaN  0.013847         NaN  0.56120          NaN  0.087012          NaN  0.078642           NaN  0.0033265          NaN  0.038753           NaN  0.0042434          NaN  0.019165          NaN  0.044026          NaN  0.025447          NaN  0.031193          NaN  0.027733          NaN  0.024181          NaN  0.038654         NaN  0.19124           NaN  0.0027774          NaN  0.014174         NaN  0.60135          NaN  0.088681          NaN  0.078824           NaN  0.0033034          NaN  0.038176           NaN  0.0041358          NaN  0.018594          NaN  0.041751          NaN  0.023372          NaN  0.027435          NaN  0.022734           NaN  0.0177781            NaN  1.6915e-02         NaN  0.14999        NaN  1.0794        NaN  1.0236        NaN  1.0715        NaN  1.0192        NaN  1.0023         NaN  0.99306         NaN  0.98513         NaN  0.97463         NaN  0.97019         NaN  0.94833         NaN  0.91844         NaN  0.87953         NaN  0.81975          NaN  0.735201           NaN  0.4375887         NaN  0.78430
     5     460.00     96.000          NaN   9.940          NaN  0.2634        NaN  2278.2        NaN  0.9968           NaN  0.0025691          NaN  0.013846         NaN  0.56080          NaN  0.087036          NaN  0.078712           NaN  0.0033308          NaN  0.038810           NaN  0.0042514          NaN  0.019204          NaN  0.044142          NaN  0.025537          NaN  0.031336          NaN  0.027898          NaN  0.024356          NaN  0.038177         NaN  0.19145           NaN  0.0027879          NaN  0.014191         NaN  0.60337          NaN  0.088761          NaN  0.078826           NaN  0.0033019          NaN  0.038142           NaN  0.0041297          NaN  0.018562          NaN  0.041628          NaN  0.023261          NaN  0.027236          NaN  0.022472           NaN  0.0174460            NaN  1.5888e-02         NaN  0.14793        NaN  1.0852        NaN  1.0249        NaN  1.0759        NaN  1.0198        NaN  1.0015         NaN  0.99134         NaN  0.98279         NaN  0.97139         NaN  0.96659         NaN  0.94305         NaN  0.91086         NaN  0.86916         NaN  0.80552          NaN  0.716301           NaN  0.4161755         NaN  0.77271
     6     455.00     96.000          NaN  15.009          NaN  0.3986        NaN  1432.7        NaN  0.9988           NaN  0.0025656          NaN  0.013846         NaN  0.56058          NaN  0.087074          NaN  0.078793           NaN  0.0033354          NaN  0.038872           NaN  0.0042597          NaN  0.019243          NaN  0.044258          NaN  0.025625          NaN  0.031472          NaN  0.028048          NaN  0.024503          NaN  0.037527         NaN  0.19143           NaN  0.0027995          NaN  0.014208         NaN  0.60557          NaN  0.088843          NaN  0.078820           NaN  0.0032998          NaN  0.038099           NaN  0.0041223          NaN  0.018524          NaN  0.041483          NaN  0.023132          NaN  0.027007          NaN  0.022173           NaN  0.0170719            NaN  1.4850e-02         NaN  0.14572        NaN  1.0912        NaN  1.0262        NaN  1.0803        NaN  1.0203        NaN  1.0003         NaN  0.98932         NaN  0.98012         NaN  0.96776         NaN  0.96259         NaN  0.93729         NaN  0.90271         NaN  0.85814         NaN  0.79056          NaN  0.696723           NaN  0.3957133         NaN  0.76119
     7     452.11     96.000        0.000  17.945          NaN  0.4772        NaN  1161.3        NaN  1.0000           NaN  0.0025640          NaN  0.013847         NaN  0.56054          NaN  0.087102          NaN  0.078844           NaN  0.0033382          NaN  0.038909           NaN  0.0042646          NaN  0.019267          NaN  0.044325          NaN  0.025674          NaN  0.031546          NaN  0.028126          NaN  0.024574          NaN  0.037074         NaN  0.19132           NaN  0.0028070          NaN  0.014219         NaN  0.60695          NaN  0.088892          NaN  0.078811           NaN  0.0032981          NaN  0.038069           NaN  0.0041172          NaN  0.018497          NaN  0.041385          NaN  0.023046          NaN  0.026857          NaN  0.021979           NaN  0.0168310            NaN  1.4239e-02         NaN  0.14434        NaN  1.0948        NaN  1.0269        NaN  1.0828        NaN  1.0205        NaN  0.9996         NaN  0.98799         NaN  0.97840         NaN  0.96544         NaN  0.96005         NaN  0.93368         NaN  0.89764         NaN  0.85135         NaN  0.78143          NaN  0.684904           NaN  0.3840773         NaN  0.75443
     8     438.02     96.000       40.300  32.969          NaN  0.8820        NaN   527.6        NaN  1.0061           NaN  0.0025589          NaN  0.013861         NaN  0.56119          NaN  0.087307          NaN  0.079147           NaN  0.0033542          NaN  0.039110           NaN  0.0042904          NaN  0.019389          NaN  0.044652          NaN  0.025903          NaN  0.031867          NaN  0.028424          NaN  0.024760          NaN  0.034185         NaN  0.18979           NaN  0.0028555          NaN  0.014284         NaN  0.61554          NaN  0.089149          NaN  0.078680           NaN  0.0032839          NaN  0.037825           NaN  0.0040784          NaN  0.018300          NaN  0.040690          NaN  0.022451          NaN  0.025830          NaN  0.020684           NaN  0.0152776            NaN  1.1071e-02         NaN  0.13600        NaN  1.1159        NaN  1.0305        NaN  1.0968        NaN  1.0211        NaN  0.9941         NaN  0.97904         NaN  0.96715         NaN  0.95059         NaN  0.94387         NaN  0.91126         NaN  0.86673         NaN  0.81057         NaN  0.72768          NaN  0.617040           NaN  0.3238557         NaN  0.71660
     9     431.89     96.000       40.000  39.693          NaN  1.0650        NaN   398.7        NaN  1.0090           NaN  0.0025567          NaN  0.013869         NaN  0.56159          NaN  0.087416          NaN  0.079302           NaN  0.0033623          NaN  0.039210           NaN  0.0043031          NaN  0.019448          NaN  0.044808          NaN  0.026007          NaN  0.032004          NaN  0.028532          NaN  0.024783          NaN  0.032806         NaN  0.18894           NaN  0.0028852          NaN  0.014320         NaN  0.62054          NaN  0.089266          NaN  0.078551           NaN  0.0032728          NaN  0.037647           NaN  0.0040511          NaN  0.018163          NaN  0.040225          NaN  0.022062          NaN  0.025176          NaN  0.019881           NaN  0.0143546            NaN  9.6057e-03         NaN  0.13130        NaN  1.1285        NaN  1.0325        NaN  1.1050        NaN  1.0212        NaN  0.9905         NaN  0.97338         NaN  0.96014         NaN  0.94144         NaN  0.93395         NaN  0.89773         NaN  0.84833         NaN  0.78665         NaN  0.69681          NaN  0.579217           NaN  0.2928011         NaN  0.69496
    10     426.23     96.000       41.000  45.432          NaN  1.2223        NaN   318.6        NaN  1.0118           NaN  0.0025529          NaN  0.013875         NaN  0.56169          NaN  0.087510          NaN  0.079452           NaN  0.0033703          NaN  0.039312           NaN  0.0043163          NaN  0.019510          NaN  0.044973          NaN  0.026120          NaN  0.032156          NaN  0.028656          NaN  0.024820          NaN  0.031689         NaN  0.18841           NaN  0.0029174          NaN  0.014357         NaN  0.62580          NaN  0.089368          NaN  0.078380           NaN  0.0032591          NaN  0.037436           NaN  0.0040193          NaN  0.018005          NaN  0.039697          NaN  0.021628          NaN  0.024455          NaN  0.019015           NaN  0.0133867            NaN  8.2768e-03         NaN  0.12646        NaN  1.1428        NaN  1.0348        NaN  1.1141        NaN  1.0212        NaN  0.9865         NaN  0.96701         NaN  0.95228         NaN  0.93121         NaN  0.92287         NaN  0.88269         NaN  0.82802         NaN  0.76051         NaN  0.66356          NaN  0.539344           NaN  0.2611899         NaN  0.67117
    11     420.10     96.000       42.600  50.621          NaN  1.3662        NaN   261.6        NaN  1.0150           NaN  0.0025458          NaN  0.013877         NaN  0.56126          NaN  0.087595          NaN  0.079620           NaN  0.0033798          NaN  0.039435           NaN  0.0043326          NaN  0.019587          NaN  0.045189          NaN  0.026273          NaN  0.032369          NaN  0.028846          NaN  0.024919          NaN  0.030771         NaN  0.18837           NaN  0.0029560          NaN  0.014399         NaN  0.63189          NaN  0.089463          NaN  0.078143           NaN  0.0032413          NaN  0.037165           NaN  0.0039791          NaN  0.017805          NaN  0.039044          NaN  0.021098          NaN  0.023587          NaN  0.017993           NaN  0.0122811            NaN  6.9512e-03         NaN  0.12095        NaN  1.1612        NaN  1.0376        NaN  1.1258        NaN  1.0213        NaN  0.9814         NaN  0.95901         NaN  0.94243         NaN  0.91841         NaN  0.90903         NaN  0.86402         NaN  0.80302         NaN  0.72868         NaN  0.62377          NaN  0.492841           NaN  0.2259023         NaN  0.64212
    12     414.24     96.000       43.500  54.411          NaN  1.4731        NaN   226.8        NaN  1.0182           NaN  0.0025357          NaN  0.013873         NaN  0.56027          NaN  0.087657          NaN  0.079787           NaN  0.0033896          NaN  0.039567           NaN  0.0043505          NaN  0.019673          NaN  0.045436          NaN  0.026454          NaN  0.032630          NaN  0.029094          NaN  0.025087          NaN  0.030193         NaN  0.18889           NaN  0.0029944          NaN  0.014439         NaN  0.63777          NaN  0.089534          NaN  0.077880           NaN  0.0032221          NaN  0.036880           NaN  0.0039372          NaN  0.017599          NaN  0.038378          NaN  0.020563          NaN  0.022723          NaN  0.016997           NaN  0.0112382            NaN  5.8491e-03         NaN  0.11575        NaN  1.1809        NaN  1.0408        NaN  1.1383        NaN  1.0214        NaN  0.9761         NaN  0.95057         NaN  0.93208         NaN  0.90501         NaN  0.89455         NaN  0.84465         NaN  0.77733         NaN  0.69638         NaN  0.58421          NaN  0.447971           NaN  0.1937253         NaN  0.61277
    13     402.86     96.000       46.100  59.038          NaN  1.6088        NaN   190.4        NaN  1.0248           NaN  0.0025082          NaN  0.013855         NaN  0.55700          NaN  0.087731          NaN  0.080129           NaN  0.0034110          NaN  0.039861           NaN  0.0043912          NaN  0.019870          NaN  0.046021          NaN  0.026892          NaN  0.033280          NaN  0.029745          NaN  0.025596          NaN  0.029709         NaN  0.19124           NaN  0.0030676          NaN  0.014511         NaN  0.64857          NaN  0.089620          NaN  0.077314           NaN  0.0031824          NaN  0.036299           NaN  0.0038530          NaN  0.017184          NaN  0.037065          NaN  0.019525          NaN  0.021076          NaN  0.015151           NaN  0.0093943            NaN  4.1854e-03         NaN  0.10640        NaN  1.2230        NaN  1.0473        NaN  1.1644        NaN  1.0215        NaN  0.9649         NaN  0.93297         NaN  0.91065         NaN  0.87743         NaN  0.86484         NaN  0.80538         NaN  0.72607         NaN  0.63329         NaN  0.50936          NaN  0.367023           NaN  0.1408792         NaN  0.55634
    14     381.69     96.000       48.500  62.243          NaN  1.7193        NaN   168.0        NaN  1.0388           NaN  0.0024383          NaN  0.013794         NaN  0.54784          NaN  0.087785          NaN  0.080851           NaN  0.0034583          NaN  0.040524           NaN  0.0044850          NaN  0.020326          NaN  0.047404          NaN  0.027943          NaN  0.034862          NaN  0.031359          NaN  0.026941          NaN  0.029989         NaN  0.19850           NaN  0.0031901          NaN  0.014628         NaN  0.66572          NaN  0.089665          NaN  0.076227           NaN  0.0031085          NaN  0.035241           NaN  0.0037013          NaN  0.016443          NaN  0.034767          NaN  0.017745          NaN  0.018331          NaN  0.012221           NaN  0.0067103            NaN  2.2996e-03         NaN  0.09208        NaN  1.3083        NaN  1.0605        NaN  1.2152        NaN  1.0214        NaN  0.9428         NaN  0.89884         NaN  0.86965         NaN  0.82527         NaN  0.80899         NaN  0.73342         NaN  0.63506         NaN  0.52581         NaN  0.38973          NaN  0.249070           NaN  0.0766840         NaN  0.46386
    15     362.39     96.000       49.400  62.525          NaN  1.7518        NaN   165.4        NaN  1.0537           NaN  0.0023604          NaN  0.013716         NaN  0.53737          NaN  0.087792          NaN  0.081614           NaN  0.0035097          NaN  0.041248           NaN  0.0045883          NaN  0.020828          NaN  0.048937          NaN  0.029110          NaN  0.036609          NaN  0.033120          NaN  0.028395          NaN  0.030797         NaN  0.20697           NaN  0.0032866          NaN  0.014724         NaN  0.67865          NaN  0.089650          NaN  0.075272           NaN  0.0030444          NaN  0.034339           NaN  0.0035727          NaN  0.015817          NaN  0.032861          NaN  0.016296          NaN  0.016164          NaN  0.010044           NaN  0.0049253            NaN  1.3525e-03         NaN  0.08164        NaN  1.3924        NaN  1.0735        NaN  1.2629        NaN  1.0212        NaN  0.9223         NaN  0.86742         NaN  0.83250         NaN  0.77865         NaN  0.75940         NaN  0.67151         NaN  0.55981         NaN  0.44151         NaN  0.30326          NaN  0.173458           NaN  0.0439162         NaN  0.39447
    16     314.68     96.000       48.500  59.597          NaN  1.7470        NaN   178.4        NaN  1.1024           NaN  0.0021267          NaN  0.013446         NaN  0.50541          NaN  0.087715          NaN  0.083980           NaN  0.0036727          NaN  0.043539           NaN  0.0049177          NaN  0.022431          NaN  0.053800          NaN  0.032779          NaN  0.041968          NaN  0.038257          NaN  0.032379          NaN  0.033581         NaN  0.23276           NaN  0.0034801          NaN  0.014953         NaN  0.70408          NaN  0.089606          NaN  0.073101           NaN  0.0028967          NaN  0.032290           NaN  0.0032796          NaN  0.014397          NaN  0.028611          NaN  0.013137          NaN  0.011673          NaN  0.005984           NaN  0.0021691            NaN  3.4569e-04         NaN  0.06192        NaN  1.6364        NaN  1.1121        NaN  1.3931        NaN  1.0216        NaN  0.8705         NaN  0.78873         NaN  0.74164         NaN  0.66690         NaN  0.64183         NaN  0.53179         NaN  0.40078         NaN  0.27813         NaN  0.15641          NaN  0.066993           NaN  0.0102942         NaN  0.26602
    17     259.10     96.000       45.900  53.448          NaN  1.6967        NaN   204.1        NaN  1.1939           NaN  0.0017930          NaN  0.012947         NaN  0.45750          NaN  0.087342          NaN  0.087719           NaN  0.0039420          NaN  0.047300           NaN  0.0054664          NaN  0.025095          NaN  0.061799          NaN  0.038667          NaN  0.050092          NaN  0.045326          NaN  0.037400          NaN  0.037609         NaN  0.27089           NaN  0.0036442          NaN  0.015250         NaN  0.72720          NaN  0.089750          NaN  0.070834           NaN  0.0027327          NaN  0.030040           NaN  0.0029511          NaN  0.012809          NaN  0.023954          NaN  0.009818          NaN  0.007413          NaN  0.002867           NaN  0.0006829            NaN  5.1973e-05         NaN  0.04479        NaN  2.0325        NaN  1.1779        NaN  1.5895        NaN  1.0276        NaN  0.8075         NaN  0.69322         NaN  0.63509         NaN  0.53986         NaN  0.51043         NaN  0.38761         NaN  0.25392         NaN  0.14799         NaN  0.06325          NaN  0.018258           NaN  0.0013819         NaN  0.16533
    18     222.29     96.000       42.500  48.131          NaN  1.6535        NaN   224.0        NaN  1.2920     0.0012831  0.0015415     0.014805  0.012451     0.41119  0.41833     0.084685  0.086700     0.089818  0.090842     0.0042441  0.0041815     0.051522  0.050637     0.0061194  0.0059624     0.028919  0.027501     0.073236  0.068938     0.043626  0.043760     0.062872  0.056681     0.051324  0.050599     0.038888  0.041041     0.037472  0.040836     0.29830  0.30185     0.0039012  0.0037177     0.020706  0.015482     0.72523  0.73986     0.090929  0.090089     0.070522  0.069523     0.0035011  0.0026266     0.029409  0.028589     0.0030010  0.0027321     0.011003  0.011753     0.020507  0.020907     0.009303  0.007767     0.008403  0.005108     0.002901  0.001565     0.0006002  0.0002672     8.3800e-05  1.0965e-05     0.04220  0.03563     3.0404  2.4117     1.3986  1.2434     1.7637  1.7686     1.0737  1.0391     0.7852  0.7653     0.82493  0.62815     0.57081  0.56458     0.49040  0.45822     0.38049  0.42735     0.28001  0.30328     0.21324  0.17749     0.13365  0.09012     0.05652  0.03092     0.015434  0.006511     0.0022355  0.0002685     0.14150  0.11802
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_011_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 78% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)       Liquid Volume (m3)            GOR (sm3/m3)             Rel Vol 1
#  Stg     (barg)       (C)        Expt      Calc          Expt        Calc           Expt        Calc         Expt    Calc
#------   --------   --------   --------------------   ------------------------   ------------------------   ----------------
     1     630.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9858
     2     625.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9873
     3     620.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9888
     4     615.00     96.000          NaN   0.01426            NaN  4.6856e-04            NaN  2.0233e+06        NaN  0.9904
     5     610.00     96.000          NaN   0.43012            NaN  1.4161e-02            NaN  6.6769e+04        NaN  0.9920
     6     605.00     96.000          NaN   0.84254            NaN  2.7785e-02            NaN  3.3938e+04        NaN  0.9936
     7     600.00     96.000          NaN   1.25174            NaN  4.1348e-02            NaN  2.2745e+04        NaN  0.9952
     8     595.00     96.000          NaN   1.65793            NaN  5.4858e-02            NaN  1.7098e+04        NaN  0.9969
     9     590.00     96.000          NaN   2.06133            NaN  6.8322e-02            NaN  1.3692e+04        NaN  0.9986
    10     586.05     96.000      0.00000   2.37820            NaN  7.8932e-02            NaN  1.1827e+04        NaN  1.0000
    11     442.09     96.000     18.50000  14.93222            NaN  5.2833e-01            NaN  1.6132e+03        NaN  1.0660
    12     430.92     96.000     19.80000  16.40909            NaN  5.8448e-01            NaN  1.4396e+03        NaN  1.0732
    13     419.41     96.000     20.80000  18.14305            NaN  6.5099e-01            NaN  1.2721e+03        NaN  1.0811
    14     398.03     96.000     25.40000  21.94776            NaN  7.9942e-01            NaN  9.9797e+02        NaN  1.0974
    15     377.83     96.000     26.40000  25.83454            NaN  9.5635e-01            NaN  8.0023e+02        NaN  1.1153
    16     350.39     96.000     28.90000  30.24527            NaN  1.1488e+00            NaN  6.3253e+02        NaN  1.1444
    17     284.41     96.000     31.80000  34.14489            NaN  1.4137e+00            NaN  4.8397e+02        NaN  1.2475
    18     239.94     96.000     30.20000  32.80145            NaN  1.4849e+00            NaN  4.5973e+02        NaN  1.3639
    19     210.36     96.000     28.90000  30.59452            NaN  1.5037e+00            NaN  4.5791e+02        NaN  1.4808
    20     188.43     96.000     31.60000  28.33220            NaN  1.5052e+00            NaN  4.6231e+02        NaN  1.6007
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_012_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "Lab2 Constant Composition Expansion"
show title

$Expt << END
#           Pres          Rel Vol         Liq Den (kg/m3)      Liq Vis (cp)
#  Stg     (barg)      Expt    Calc        Expt    Calc        Expt    Calc
#------   --------   ----------------   ------------------   ----------------
     1     379.21     0.9761  0.9693      706.80  710.00      0.4760  0.6793
     2     344.74     0.9819  0.9758      702.60  705.29      0.4560  0.6376
     3     310.26     0.9879  0.9829      698.40  700.20      0.4340  0.5958
     4     275.79     0.9943  0.9907      693.90  694.66      0.4130  0.5541
     5     268.90     0.9956  0.9924      692.90  693.49      0.4090  0.5458
     6     262.00     0.9970  0.9941      692.00  692.30      0.4040  0.5374
     7     255.11     0.9983  0.9958      691.10  691.09      0.4000  0.5291
     8     246.83     1.0000  1.0000      689.90  691.13      0.3950  0.5279
     9     236.35     1.0115  1.0119         NaN  695.49         NaN  0.5518
    10     215.94     1.0389  1.0399         NaN  703.98         NaN  0.6020
    11     194.09     1.0777  1.0794         NaN  713.16         NaN  0.6620
    12     170.37     1.1359  1.1382         NaN  723.28         NaN  0.7357
    13     148.10     1.2139  1.2162         NaN  733.00         NaN  0.8150
    14     126.93     1.3210  1.3226         NaN  742.51         NaN  0.9014
    15     108.32     1.4583  1.4578         NaN  751.16         NaN  0.9885
    16      90.32     1.6556  1.6504         NaN  759.87         NaN  1.0852
    17      81.91     1.7821  1.7731         NaN  764.09         NaN  1.1355
END
set xlabel "Pressure (barg)"
set ylabel "Relative Volume"
set output "Figures/Expt_016_RV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Lab2 Differential Liberation"
show title

$Expt << END
#           Temp       Pres                    Liq Vol (m3)        Removed (sm3)       Liq Den (kg/m3)      Liq Vis (cp)       Gas Z-Factor      Gas Sp Gravity        Gas Vis (cp)
#  Stg       (C)      (barg)      Stg Wgt      Expt    Calc        Expt     Calc        Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc        Expt      Calc
#------   --------   --------   ----------   ----------------   ------------------   ------------------   ----------------   ----------------   ----------------   --------------------
     1     100.00     379.21       1.00       1.4660  1.4559         NaN    0.000      706.80  710.00      0.4760  0.6793        NaN  1.0396        NaN  0.9490          NaN  0.040545
     2     100.00     344.74       1.00       1.4750  1.4656         NaN    0.000      702.60  705.29      0.4560  0.6376        NaN  0.9907        NaN  0.8859          NaN  0.035255
     3     100.00     310.26       1.00       1.4840  1.4763         NaN    0.000      698.40  700.20      0.4340  0.5958        NaN  0.9516        NaN  0.8382          NaN  0.030979
     4     100.00     275.79       1.00       1.4930  1.4881         NaN    0.000      693.90  694.66      0.4130  0.5541        NaN  0.9205        NaN  0.8007          NaN  0.027300
     5     100.00     268.90       1.00       1.4950  1.4906         NaN    0.000      692.90  693.49      0.4090  0.5458        NaN  0.9153        NaN  0.7942          NaN  0.026619
     6     100.00     262.00       1.00       1.4970  1.4931         NaN    0.000      692.00  692.30      0.4040  0.5374        NaN  0.9103        NaN  0.7880          NaN  0.025953
     7     100.00     255.11       1.00       1.4990  1.4957         NaN    0.000      691.10  691.09      0.4000  0.5291        NaN  0.9056        NaN  0.7821          NaN  0.025304
     8     100.00     246.83       1.00       1.5020  1.4931       0.000    1.873      689.90  691.13      0.3950  0.5279        NaN  0.9004        NaN  0.7753          NaN  0.024545
     9     100.00     220.63       1.00       1.4550  1.4458      18.340   20.129      700.10  702.04      0.4250  0.5901     0.8780  0.8869     0.7920  0.7565     0.022900  0.022289
    10     100.00     193.05       1.00       1.4110  1.3995      35.950   38.026      710.20  713.70      0.4730  0.6660     0.8670  0.8778     0.7650  0.7405     0.020700  0.020164
    11     100.00     165.47       1.00       1.3700  1.3560      52.490   54.765      720.20  725.59      0.5380  0.7544     0.8640  0.8740     0.7490  0.7286     0.019000  0.018313
    12     100.00     137.90       1.00       1.3320  1.3149      68.140   70.498      730.20  737.72      0.6170  0.8579     0.8690  0.8757     0.7430  0.7213     0.017500  0.016752
    13     100.00     110.32       1.00       1.2950  1.2757      83.430   85.373      740.00  750.14      0.7080  0.9794     0.8790  0.8832     0.7510  0.7199     0.016200  0.015477
    14     100.00      82.74       1.00       1.2590  1.2379      98.370   99.527      750.00  762.90      0.8310  1.1222     0.8940  0.8963     0.7720  0.7275     0.015100  0.014463
    15     100.00      55.16       1.00       1.2230  1.2005     112.950  113.186      760.70  776.16      1.0360  1.2917     0.9130  0.9150     0.7930  0.7533     0.014100  0.013646
    16     100.00      27.58       1.00       1.1830  1.1606     128.420  127.057      772.30  790.65      1.4090  1.5036     0.9380  0.9393     0.8870  0.8366     0.012900  0.012861
    17     100.00      11.86       1.00       1.1520  1.1320     138.740  136.072      781.70  800.66      1.7390  1.6687     0.9630  0.9555     1.0470  1.0220     0.012400  0.012091
    18     100.00       0.00       0.00       1.0710  1.0221     157.590  159.367      802.30  827.94      2.0560  2.3182     1.0000  0.9844     1.7690  2.1111     0.009500  0.009698
    19      15.60       0.00       0.00       1.0000  0.9798         NaN  159.367      858.60  863.68         NaN  4.0404        NaN  0.9981        NaN  1.0280          NaN  0.015095
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_017_LV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_017_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_017_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_017_LVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_017_GZ_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_017_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_017_GVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Lab2 CCE of Surface Sample"
show title

$Expt << END
#           Pres          Rel Vol         Density (g/cm3)
#  Stg     (psig)      Expt    Calc        Expt     Calc
#------   --------   ----------------   ------------------
     1     3650.0     1.0000  1.0000     0.69540  0.69842
     2     3700.0     0.9992  0.9991     0.69600  0.69902
     3     3800.0     0.9978  0.9975     0.69700  0.70021
     4     3900.0     0.9963  0.9958     0.69800  0.70137
     5     4000.0     0.9949  0.9942     0.69900  0.70251
     6     4100.0     0.9935  0.9926     0.70000  0.70363
     7     4200.0     0.9922  0.9910     0.70090  0.70473
     8     4300.0     0.9909  0.9895     0.70190  0.70581
     9     4500.0     0.9883  0.9866     0.70370  0.70792
    10     5000.0     0.9823  0.9797     0.70800  0.71291
    11     5500.0     0.9768  0.9734     0.71200  0.71752
    12     6000.0     0.9717  0.9676     0.71570  0.72180
    13     6500.0     0.9671  0.9623     0.71910  0.72579
END
set xlabel "Pressure (psig)"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_019_DEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Pres          Rel Vol          Liq Sat (%)       Liq Den (g/cm3)
#  Stg      (bar)      Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ----------------   ----------------   ------------------
     1     981.73     0.9130  0.9036     100.00  100.00     0.76800  0.76063
     2     930.09     0.9160  0.9069     100.00  100.00     0.76600  0.75785
     3     861.28     0.9210  0.9117     100.00  100.00     0.76100  0.75385
     4     758.96     0.9300  0.9198     100.00  100.00     0.75400  0.74724
     5     647.82     0.9410  0.9301     100.00  100.00     0.74500  0.73894
     6     585.70     0.9480  0.9368     100.00  100.00     0.74000  0.73366
     7     516.41     0.9560  0.9452     100.00  100.00     0.73400  0.72711
     8     481.11     0.9600  0.9500     100.00  100.00     0.73000  0.72345
     9     445.60     0.9650  0.9552     100.00  100.00     0.72700  0.71953
    10     411.13     0.9700  0.9606     100.00  100.00     0.72300  0.71546
    11     372.66     0.9750  0.9673     100.00  100.00     0.71900  0.71055
    12     354.11     0.9790  0.9707     100.00  100.00     0.71600  0.70804
    13     310.54     0.9850  0.9794     100.00  100.00     0.71100  0.70171
    14     275.92     0.9920  0.9872     100.00  100.00     0.70700  0.69618
    15     242.90     0.9990  0.9955     100.00  100.00     0.70200  0.69042
    16     230.63     1.0000  1.0000     100.00   99.67     0.70100  0.68896
    17     227.66     1.0030  1.0038      99.94   98.90         NaN  0.69028
    18     206.77     1.0300  1.0348      95.27   93.39         NaN  0.69954
    19     190.29     1.0580  1.0662      91.25   88.81         NaN  0.70687
    20     155.13     1.1460  1.1643      81.88   77.98         NaN  0.72276
    21     120.45     1.3050  1.3362      69.78   65.25         NaN  0.73900
    22      54.33     2.3520  2.4410      36.41   32.81         NaN  0.77372
END
set xlabel "Pressure (bar)"
set ylabel "Relative Volume"
set output "Figures/Expt_021_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_021_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_021_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Temp        Pres                   Tot Vol 2 (m3)        Removed (sm3)        Liq Den (g/cm3)      Liq Vis (cp)        Gas Den (g/cm3)      Gas Sp Gravity      Gas Z-Factor
#  Stg       (C)       (bar)       Stg Wgt      Expt    Calc        Expt      Calc         Expt     Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc
#------   --------   ---------   ----------   ----------------   --------------------   ------------------   ----------------   --------------------   ----------------   ----------------
     1     102.00     354.110       1.00          NaN  1.4259          NaN    0.0000         NaN  0.70804     0.5870  0.6271          NaN  0.295827        NaN  0.9016        NaN  1.0022
     2     102.00     330.940       1.00          NaN  1.4326          NaN    0.0000         NaN  0.70476     0.5740  0.6005          NaN  0.273779        NaN  0.8675        NaN  0.9737
     3     102.00     303.360       1.00          NaN  1.4411          NaN    0.0000         NaN  0.70060     0.5570  0.5687          NaN  0.248598        NaN  0.8338        NaN  0.9448
     4     102.00     275.850       1.00          NaN  1.4503          NaN    0.0000         NaN  0.69617     0.5420  0.5370          NaN  0.224206        NaN  0.8060        NaN  0.9209
     5     102.00     248.280       1.00          NaN  1.4603          NaN    0.0000         NaN  0.69140     0.5270  0.5053          NaN  0.200205        NaN  0.7829        NaN  0.9016
     6     102.00     234.420       1.00          NaN  1.4657          NaN    0.0000         NaN  0.68886     0.5190  0.4893          NaN  0.188254        NaN  0.7730        NaN  0.8938
     7     102.00     230.630       1.00       1.4690  1.4641       0.0000    0.9580         NaN  0.68896     0.5170  0.4892          NaN  0.184997        NaN  0.7704        NaN  0.8918
     8     102.00     175.810       1.00       1.4130  1.3668      35.1000   38.1277         NaN  0.71338     0.7370  0.6264     0.137300  0.138380     0.7340  0.7416     0.8730  0.8749
     9     102.00     113.760       1.00       1.3180  1.2700      70.8000   74.6190         NaN  0.74209     0.8840  0.8443     0.084900  0.087482     0.7120  0.7305     0.8860  0.8821
    10     102.00      44.820       1.00       1.2140  1.1676     107.9000  111.3463         NaN  0.77698     1.2500  1.2177     0.034400  0.035259     0.7670  0.7837     0.9280  0.9251
    11     102.00      13.790       1.00       1.1610  1.1122     124.5000  129.0270         NaN  0.79632     1.5150  1.4869     0.012600  0.013343     0.9410  0.9965     0.9600  0.9564
    12     102.00       3.030       0.25       1.1160  1.0636     138.3000  141.0145         NaN  0.81047     1.7510  1.7337     0.004300  0.004668     1.5060  1.6140     0.9760  0.9729
    13     102.00       1.010       0.00       1.0760  1.0256     146.0000  148.5661         NaN  0.81963     2.0380  1.9336     0.002000  0.002221     2.0930  2.3241     0.9840  0.9814
    14      15.00       1.010       0.00       1.0000  0.9797          NaN  148.5661     0.86900  0.85799        NaN  3.4802          NaN  0.001310        NaN  1.0715        NaN  0.9983
END
set xlabel "Pressure (bar)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_022_V2_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_022_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_022_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_022_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_022_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_022_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Swelling of Lab3_Surface_Oil with 23% C2+ Gas"
show title

$Expt << END
#                                        Sat Pres (psia)      Liq Vol Frac       Density (g/cm3)         Rel Vol             C30+ K-Value
#  Stg      Rel Moles Inj      Feed       Expt    Calc        Expt    Calc        Expt     Calc       Expt    Calc         Expt        Calc
#------   ----------------   -------   ------------------   ----------------   ------------------   ----------------   ------------------------
     1         0.0000          NaN        3720.   3670.      1.0000  1.0000     0.69900  0.68705     1.0000  1.0009            NaN  1.1329e-04
     2         0.2500          F20        4500.   4550.      1.0000  1.0000     0.67700  0.65513     1.1100  1.1108            NaN  1.5851e-03
     3         0.6667          F40        5800.   5723.      1.0000  1.0000     0.62100  0.61587     1.3000  1.2900            NaN  2.7627e-02
     4         1.0000          F50        6710.   6533.      1.0000  1.0000     0.58300  0.59339     1.4800  1.4290            NaN  1.5562e-01
     5         1.0500          NaN          NaN   6653.         NaN  1.0000         NaN  0.59059        NaN  1.4493            NaN  2.0235e-01
     6         1.1000          NaN          NaN   6774.         NaN  1.0000         NaN  0.58793        NaN  1.4695            NaN  2.6649e-01
     7         1.1500          NaN          NaN   6897.         NaN  1.0000         NaN  0.58543        NaN  1.4894            NaN  3.5836e-01
     8         1.2000          NaN          NaN   7025.         NaN  1.0000         NaN  0.58310        NaN  1.5091            NaN  4.9718e-01
     9         1.2500          NaN          NaN   7159.         NaN  1.0000         NaN  0.58096        NaN  1.5285            NaN  7.1214e-01
    10         1.3000          NaN          NaN   7300.         NaN  1.0000         NaN  0.57900        NaN  1.5475     1.0000e+00  1.0000e+00
    11         1.3500          NaN          NaN   7447.         NaN  0.0000         NaN  0.57722        NaN  1.5662            NaN  7.6019e-01
    12         1.4000          NaN          NaN   7599.         NaN  0.0000         NaN  0.57558        NaN  1.5846            NaN  6.2487e-01
    13         1.4500          NaN          NaN   7753.      0.0000  0.0000         NaN  0.57404        NaN  1.6028            NaN  5.3827e-01
    14         1.5000          F60        7750.   7907.      0.0000  0.0000     0.54800  0.57259     1.7300  1.6208            NaN  4.7755e-01
    15         2.3333          NaN          NaN  10297.      0.0000  0.0000         NaN  0.55491        NaN  1.9131            NaN  1.9817e-01
    16         4.0000          NaN          NaN  13547.      0.0000  0.0000         NaN  0.53289        NaN  2.4934            NaN  9.8388e-02
    17         5.6667          NaN          NaN  15002.      0.0000  0.0000         NaN  0.51526        NaN  3.0971            NaN  6.4603e-02
    18         7.0000          NaN          NaN  15280.      0.0000  0.0000         NaN  0.50208        NaN  3.6040            NaN  4.9971e-02
    19         9.0000          F90       15000.  14965.      0.0000  0.0000         NaN  0.48395        NaN  4.4013            NaN  3.6628e-02
END
set xlabel "Relative Moles Injected"
set ylabel "Saturation Pressure (psia)"
set output "Figures/Expt_024_SATP_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_024_LVF_vs_RMI_1.pdf"
plot [0:*][0:1] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_024_DEN_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:8 with points title "Expt", $Expt using 2:9 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_024_RV_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 100% Lab3_Surface_Oil, 0% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9730  0.9674     100.00  100.00         NaN   96.74      0.71900  0.71085
     2     5500.0       1.00       0.9790  0.9734     100.00  100.00         NaN   97.34      0.71500  0.70645
     3     5000.0       1.00       0.9840  0.9800     100.00  100.00         NaN   98.00      0.71100  0.70171
     4     4750.0       1.00       0.9870  0.9835     100.00  100.00         NaN   98.35      0.70900  0.69920
     5     4500.0       1.00       0.9900  0.9872     100.00  100.00         NaN   98.72      0.70700  0.69659
     6     4250.0       1.00       0.9930  0.9911     100.00  100.00         NaN   99.11      0.70400  0.69386
     7     4000.0       1.00       0.9960  0.9952     100.00  100.00         NaN   99.52      0.70200  0.69101
     8     3720.0       1.00       1.0000  1.0000     100.00  100.00         NaN  100.00      0.69900  0.68766
     9     3400.0       1.00       1.0230  1.0222      96.10   95.59       98.29   97.71          NaN  0.67274
    10     3000.0       1.00       1.0620  1.0643      90.16   88.77       95.71   94.47          NaN  0.64610
    11     2500.0       1.00       1.1380  1.1447      81.56   79.30       92.79   90.78          NaN  0.60072
    12     2000.0       1.00       1.2670  1.2807      71.14   68.17       90.16   87.31          NaN  0.53695
    13     1500.0       1.00       1.5090  1.5335      58.01   54.72       87.56   83.91          NaN  0.44843
    14     1000.0       1.00       2.0450  2.0914      41.63   38.44       85.12   80.38          NaN  0.32881
    15      450.0       1.00       4.4700  4.3562      18.17   17.35       81.21   75.57          NaN  0.15786
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_025_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_025_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_025_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 80% Lab3_Surface_Oil, 20% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9790  0.9729     100.00  100.00         NaN  97.292      0.68100  0.67160
     2     5500.0       1.00       0.9860  0.9806     100.00  100.00         NaN  98.058      0.67700  0.66636
     3     5250.0       1.00       0.9890  0.9847     100.00  100.00         NaN  98.469      0.67500  0.66358
     4     5000.0       1.00       0.9930  0.9890     100.00  100.00         NaN  98.901      0.67200  0.66068
     5     4750.0       1.00       0.9960  0.9936     100.00  100.00         NaN  99.356      0.67000  0.65765
     6     4500.0       1.00       1.0000  1.0000     100.00   99.17         NaN  99.169      0.66700  0.65342
     7     4250.0       1.00       1.0130  1.0145      95.80   95.14      97.000  96.518          NaN  0.64408
     8     3750.0       1.00       1.0460  1.0525      88.41   87.37      92.520  91.951          NaN  0.62084
     9     3250.0       1.00       1.0970  1.1081      81.59   79.45      89.510  88.038          NaN  0.58968
    10     2750.0       1.00       1.1760  1.1929      73.83   70.85      86.790  84.524          NaN  0.54773
    11     2250.0       1.00       1.3050  1.3297      64.65   61.09      84.340  81.230          NaN  0.49141
    12     1750.0       1.00       1.5300  1.5678      53.48   49.76      81.820  78.008          NaN  0.41677
    13     1250.0       1.00       1.9740  2.0384      40.13   36.64      79.220  74.676          NaN  0.32056
    14      600.0       1.00       3.9240  4.0152      19.11   17.32      75.000  69.526          NaN  0.16273
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_026_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_026_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_026_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 60% Lab3_Surface_Oil, 40% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     8000.0       1.00       0.9650  0.9629     100.00  100.00         NaN   96.29      0.64300  0.64066
     2     7500.0       1.00       0.9710  0.9701     100.00  100.00         NaN   97.01      0.63900  0.63590
     3     7000.0       1.00       0.9790  0.9779     100.00  100.00         NaN   97.79      0.63400  0.63080
     4     6500.0       1.00       0.9870  0.9865     100.00  100.00         NaN   98.65      0.62900  0.62531
     5     6250.0       1.00       0.9910  0.9911     100.00  100.00         NaN   99.11      0.62600  0.62240
     6     6000.0       1.00       0.9960  0.9959     100.00  100.00         NaN   99.59      0.62300  0.61937
     7     5800.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.62100  0.61686
     8     5500.0       0.50       1.0100  1.0103      91.77   95.35       92.67   96.34          NaN  0.61054
     9     5000.0       1.00       1.0310  1.0343      84.01   87.10       86.59   90.09          NaN  0.59638
    10     4000.0       1.00       1.1000  1.1107      73.29   73.66       80.65   81.81          NaN  0.55540
    11     3000.0       1.00       1.2460  1.2654      61.24   59.79       76.29   75.66          NaN  0.48747
    12     2000.0       1.00       1.6120  1.6443      44.78   42.58       72.17   70.02          NaN  0.37516
    13     1500.0       1.00       2.0200  2.0748      34.60   32.31       69.89   67.04          NaN  0.29732
    14      965.0       1.00       3.0260  3.1128      20.60   20.38       62.32   63.43          NaN  0.19817
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_027_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_027_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_027_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 50% Lab3_Surface_Oil, 50% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     9990.0       1.00       0.9440  0.9486     100.00  100.00         NaN   94.86      0.61800  0.62791
     2     9490.0       1.00       0.9500  0.9548     100.00  100.00         NaN   95.48      0.61400  0.62382
     3     9000.0       1.00       0.9560  0.9613     100.00  100.00         NaN   96.13      0.61000  0.61956
     4     8500.0       1.00       0.9640  0.9685     100.00  100.00         NaN   96.85      0.60500  0.61495
     5     8000.0       1.00       0.9720  0.9763     100.00  100.00         NaN   97.63      0.60000  0.61003
     6     7500.0       1.00       0.9820  0.9849     100.00  100.00         NaN   98.49      0.59400  0.60476
     7     7004.0       1.00       0.9930  0.9941     100.00  100.00         NaN   99.41      0.58800  0.59914
     8     6800.0       1.00       0.9980  0.9982     100.00  100.00         NaN   99.82      0.58500  0.59670
     9     6710.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.58300  0.59560
    10     6500.0       0.50       1.0050  1.0047      91.90   98.62       92.38   99.09          NaN  0.59280
    11     6000.0       0.50       1.0200  1.0220      78.34   86.41       79.94   88.31          NaN  0.58279
    12     5000.0       1.00       1.0680  1.0729      69.49   73.84       74.25   79.23          NaN  0.55511
    13     4000.0       1.00       1.1550  1.1631      61.75   63.22       71.31   73.54          NaN  0.51206
    14     2000.0       1.00       1.7700  1.7828      37.51   35.83       66.38   63.88          NaN  0.33408
    15     1300.0       1.00       2.6150  2.6010      24.18   23.04       63.23   59.94          NaN  0.22899
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_028_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_028_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_028_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 40% Lab3_Surface_Oil, 60% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)      Gas Z-Factor
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc       Expt    Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------   ----------------
     1     9900.0       1.00       0.9630  0.9627      0.000   0.000       0.000   0.000      0.56900  0.59267     2.0650  1.9992
     2     9500.0       1.00       0.9680  0.9687      0.000   0.000       0.000   0.000      0.56600  0.58904     1.9920  1.9302
     3     9000.0       1.00       0.9760  0.9766      0.000   0.000       0.000   0.000      0.56100  0.58424     1.9030  1.8437
     4     8750.0       1.00       0.9810  0.9809      0.000   0.000       0.000   0.000      0.55900  0.58172     1.8590  1.8002
     5     8500.0       1.00       0.9850  0.9853      0.000   0.000       0.000   0.000      0.55600  0.57912     1.8140  1.7566
     6     8250.0       1.00       0.9890  0.9899      0.000   0.000       0.000   0.000      0.55400  0.57643     1.7680  1.7129
     7     8000.0       0.50       0.9940  0.9947      0.000   0.000       0.000   0.000      0.55100  0.57365     1.7240  1.6691
     8     7750.0       0.25       1.0000  1.0000      0.000  10.498       0.000  10.498      0.54800  0.57059     1.6790  1.6006
     9     7500.0       0.25       1.0060  1.0059     19.710  26.106      19.830  26.261      0.54500  0.56723        NaN  1.5159
    10     7000.0       0.50       1.0190  1.0197     44.130  54.127      44.970  55.193      0.53800  0.55957        NaN  1.3359
    11     6000.0       1.00       1.0570  1.0582     52.790  62.907      55.810  66.567      0.51800  0.53922        NaN  1.1072
    12     5010.0       1.00       1.1180  1.1188     51.570  58.642      57.660  65.608      0.49000  0.51000        NaN  0.9781
    13     4000.0       1.00       1.2210  1.2263     47.750  51.491      58.280  63.141      0.44900  0.46531        NaN  0.8913
    14     3000.0       1.00       1.4310  1.4378     40.820  41.821      58.430  60.129      0.38300  0.39686        NaN  0.8439
    15     1750.0       1.00       2.2000  2.1899     25.310  25.207      55.690  55.202      0.24900  0.26055        NaN  0.8482
    16      950.0       1.00       4.0050  3.9656     13.360  12.769      53.510  50.637      0.13700  0.14388        NaN  0.8930
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_029_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_029_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_029_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 10% Lab3_Surface_Oil, 90% Injectant"
show title

$Expt << END
#           Pres          Liq Sat (%)         Density (g/cm3)
#  Stg     (psia)       Expt      Calc         Expt     Calc
#------   --------   --------------------   ------------------
     1     14900.      0.86000   0.03554     0.45500  0.48349
     2     14000.      1.09000   0.54685     0.44500  0.47684
     3     13000.      1.22000   1.15879     0.44200  0.46873
     4     12000.      1.41000   1.81039     0.43400  0.45973
     5     11000.      1.76000   2.49331     0.42600  0.44964
     6     10000.      2.44000   3.19890     0.41600  0.43821
     7      9000.      3.23000   3.92275     0.40200  0.42508
     8      8000.      4.59000   4.67839     0.38800  0.40974
     9      7000.      7.15000   5.54282     0.37100  0.39139
    10      6000.      9.21000   6.78318     0.35000  0.36865
    11      5000.     10.33000   8.60270     0.32600  0.33900
    12      4000.     11.22000   9.84836     0.28900  0.29885
    13      3500.     11.24000   9.86839     0.26500  0.27333
    14      3000.     10.81000   9.39787     0.23600  0.24322
    15      1685.      7.27000   5.78257     0.13400  0.14097
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_030_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_030_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT2_Oil"
show title

$Expt << END
#           Pres      Liq Vol Frac (%)         Rel Vol         Liq Den (g/cm3)
#  Stg      (kPa)       Expt    Calc        Expt    Calc        Expt     Calc
#------   --------   ------------------   ----------------   ------------------
     1     55158.      100.00  100.00      0.9530  0.9450     0.72500  0.72881
     2     48264.      100.00  100.00      0.9610  0.9538     0.71900  0.72211
     3     41383.      100.00  100.00      0.9700  0.9639     0.71300  0.71452
     4     34853.      100.00  100.00      0.9800  0.9752     0.70500  0.70629
     5     31027.      100.00  100.00      0.9860  0.9827     0.70100  0.70088
     6     27579.      100.00  100.00      0.9920  0.9902     0.69600  0.69558
     7     24146.      100.00  100.00      0.9990  0.9985     0.69200  0.68981
     8     23546.      100.00  100.00      1.0000  1.0000     0.69100  0.68874
     9     22422.       97.80   98.26      1.0130  1.0097         NaN  0.69095
    10     20684.       93.50   93.68      1.0370  1.0353         NaN  0.69869
    11     18961.       89.20   88.91      1.0680  1.0676         NaN  0.70641
    12     17237.       84.60   83.81      1.1070  1.1090         NaN  0.71421
    13     13686.       73.30   71.86      1.2370  1.2397         NaN  0.73069
    14     10370.       60.30   58.33      1.4620  1.4677         NaN  0.74685
    15      6909.       43.10   41.14      1.9770  1.9907         NaN  0.76518
END
set xlabel "Pressure (kPa)"
set ylabel "Liquid Volume Fraction (%)"
set output "Figures/Expt_033_LVF_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_033_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_033_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 92.2 C"
show title

$Expt << END
#           Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)        Gas Den (g/cm3)          Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)             N2 y (%)             CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
#  Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc         Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   --------------------   ----------------   ----------------   ------------------   --------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
     1     92.200     34853.0       1.00         0.00    0.00     0.70500  0.70629     1.4870  1.4793     0.7840  0.6164          NaN  0.298517        NaN  25.722        NaN  0.8881         NaN  0.98864          NaN  0.036492          NaN   0.58954        NaN  1.2570        NaN  80.312        NaN   5.506        NaN   4.041        NaN   8.294         NaN   4.9291
     2     92.200     32406.0       1.00         0.00    0.00         NaN  0.70289        NaN  1.4865     0.7510  0.5893          NaN  0.274884        NaN  24.687        NaN  0.8523         NaN  0.95807          NaN  0.033232          NaN   0.59417        NaN  1.2732        NaN  81.166        NaN   5.510        NaN   3.971        NaN   7.486         NaN   4.2623
     3     92.200     29648.0       1.00         0.00    0.00         NaN  0.69882        NaN  1.4951     0.7220  0.5587          NaN  0.249246        NaN  23.721        NaN  0.8190         NaN  0.92887          NaN  0.029990          NaN   0.59406        NaN  1.2940        NaN  81.998        NaN   5.527        NaN   3.903        NaN   6.685         NaN   3.6119
     4     92.200     27234.0       1.00         0.00    0.00         NaN  0.69502        NaN  1.5033     0.7000  0.5319          NaN  0.227329        NaN  23.012        NaN  0.7945         NaN  0.90756          NaN  0.027420          NaN   0.58965        NaN  1.3151        NaN  82.626        NaN   5.554        NaN   3.852        NaN   6.063         NaN   3.1145
     5     92.200     24821.0       1.00         0.00    0.00         NaN  0.69098        NaN  1.5121     0.6770  0.5051          NaN  0.205712        NaN  22.411        NaN  0.7738         NaN  0.89018          NaN  0.025051          NaN   0.58150        NaN  1.3394        NaN  83.165        NaN   5.597        NaN   3.811        NaN   5.506         NaN   2.6754
     6     92.200     23546.0       1.00         0.00    0.00     0.69100  0.68874     1.5170  1.5170     0.6670  0.4910          NaN  0.194367        NaN  22.132        NaN  0.7641         NaN  0.88261          NaN  0.023875          NaN   0.57580        NaN  1.3536        NaN  83.413        NaN   5.627        NaN   3.795        NaN   5.236         NaN   2.4649
     7     92.200     17926.0       1.00        39.00   37.73     0.71600  0.71108     1.4170  1.4218     0.7430  0.6131     0.146000  0.144862     20.900  21.194     0.7220  0.7317     0.84600  0.86339     0.019700  0.019331      0.50000   0.54044     1.4430  1.4316     84.108  84.150      5.895   5.844      3.836   3.783      4.215   4.250      1.5560   1.7027
     8     92.200     12411.0       1.00        73.00   73.08     0.73800  0.73677     1.3340  1.3301     0.9290  0.7990     0.097000  0.097711     20.400  20.776     0.7040  0.7173     0.85800  0.86872     0.016700  0.016032      0.39000   0.46622     1.5550  1.5688     84.360  83.940      6.334   6.376      3.941   3.988      3.419   3.660      0.9830   1.2072
     9     92.200      6895.0       1.00       103.00  104.98     0.76000  0.76404     1.2610  1.2451     1.1440  1.0625     0.053000  0.053600     20.900  21.234     0.7220  0.7331     0.89000  0.89920     0.014500  0.013895      0.32000   0.33766     1.7960  1.8496     81.772  81.236      7.732   7.855      4.822   4.932      3.554   3.789      0.8290   1.0018
    10     92.200      2758.0       1.00       126.00  128.40     0.78200  0.78691     1.1970  1.1787     1.4430  1.3471     0.022000  0.023208     23.200  23.985     0.8010  0.8281     0.93800  0.93831     0.013000  0.012705      0.37000   0.18360     2.0880  2.3322     73.077  71.461     11.163  11.657      7.903   8.314      5.399   6.053      1.0170   1.3721
    11     92.200       101.3       0.00       161.00  164.59     0.81200  0.82635     1.0610  1.0244     2.6010  2.1093     0.002000  0.001788     50.800  52.939     1.7530  1.8278     0.99600  0.98766     0.009300  0.009958      0.48400   0.02638     1.3280  1.4103     21.877  21.535     12.236  12.093     18.925  19.115     45.150  45.821     19.2640  20.0249
    12     15.000       101.3       0.00       161.00  164.59     0.86100  0.85941     1.0000  0.9850        NaN  3.5055          NaN  0.001197        NaN  28.253        NaN  0.9755         NaN  0.99784          NaN  0.014411          NaN  62.13352        NaN  0.6904        NaN  22.955        NaN   4.718        NaN   4.707        NaN   4.796         NaN   1.1189
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_034_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_034_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_034_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_034_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_034_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_034_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_034_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_034_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_034_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_034_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 70 C"
show title

$Expt << END
#          Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)        Gas Den (g/cm3)          Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)             N2 y (%)             CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
# Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc         Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#-----   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   --------------------   ----------------   ----------------   ------------------   --------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
    1     70.000     22408.0       1.00         0.00    0.00     0.70700  0.70371     1.4510  1.4510        NaN  0.5953          NaN  0.195500        NaN  21.154        NaN  0.7304         NaN  0.84984          NaN  0.023616          NaN   0.61372        NaN  1.2902        NaN  85.071        NaN   5.309        NaN   3.441        NaN   4.275         NaN   1.8775
    2     70.000     17926.0       1.00        29.00   27.25     0.72500  0.71921     1.3820  1.3871     1.2600  0.6948     0.146000  0.153440     19.200  20.402     0.6620  0.7044     0.82300  0.83541     0.019400  0.019621      0.46000   0.58255     1.0550  1.3494     88.686  85.850      4.490   5.422      2.779   3.351      2.527   3.446      0.7260   1.2956
    3     70.000     12411.0       1.00        65.00   63.14     0.74900  0.74448     1.2990  1.2994     1.3670  0.9037     0.098000  0.102499     18.900  19.903     0.6540  0.6872     0.83800  0.84467     0.016300  0.015847      0.25000   0.50489     1.1230  1.4799     89.378  86.041      4.502   5.826      2.616   3.397      2.132   2.751      0.6110   0.8159
    4     70.000      6895.0       1.00        94.00   96.18     0.77500  0.77187     1.2260  1.2168     1.5580  1.2061     0.052000  0.055044     19.100  20.159     0.6590  0.6960     0.88000  0.88508     0.014000  0.013473      0.16000   0.36265     1.3210  1.7745     87.938  84.024      5.528   7.149      3.108   4.055      1.948   2.635      0.3880   0.5920
    5     70.000      2758.0       1.00       116.00  120.45     0.79700  0.79479     1.1660  1.1529     1.8480  1.5318     0.022000  0.023068     21.300  22.296     0.7340  0.7698     0.93000  0.93432     0.012600  0.012292      0.10000   0.19373     1.9570  2.3592     79.085  75.584      9.551  10.981      5.975   6.848      3.335   4.034      0.4900   0.7376
    6     70.000       103.0       0.00       152.00  154.96     0.82300  0.83093     1.0410  1.0224     3.1250  2.2781     0.002000  0.001670     48.900  45.739     1.6890  1.5792     0.99100  0.98866     0.008800  0.009839      2.03000   0.02947     1.8090  1.7840     14.932  25.846     15.914  14.683     23.980  21.607     41.335  36.051     12.0260  11.5539
    7     15.000       101.3       0.00       152.00  154.96     0.85700  0.85438     1.0000  0.9944        NaN  3.2667          NaN  0.001220        NaN  28.756        NaN  0.9928         NaN  0.99673          NaN  0.013230          NaN  47.40330        NaN  1.0608        NaN  29.897        NaN   7.257        NaN   7.451        NaN   6.931         NaN   1.3311
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_035_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_035_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_035_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_035_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_035_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_035_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_035_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_035_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_035_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_035_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set title "Damped Isothermal Segregation from Averaged Sample"
show title

$Expt << END
#           Depth                               Pressure (bar)     Sat Pres (bar)      Density (g/cm3)      Viscosity (cp)            MW           Overall C6+ MW           C1 zwt                C2-C5 zwt              C6+ zwt
#  Stg       (m)         Feed         Zone       Expt    Calc       Expt    Calc        Expt     Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc         Expt      Calc         Expt     Calc
#------   ---------   ----------   ---------   ----------------   ----------------   ------------------   ------------------   ----------------   ----------------   --------------------   --------------------   ------------------
     1     3200.00     F_3200         Oil          NaN  328.47        NaN  237.97         NaN  0.69741         NaN  0.55564        NaN   97.03        NaN  229.80          NaN  0.075637          NaN  0.085513         NaN  0.83293
     2     3220.00          NaN       Oil          NaN  329.84        NaN  237.60         NaN  0.69831         NaN  0.56213        NaN   97.33        NaN  230.20          NaN  0.075299          NaN  0.085194         NaN  0.83361
     3     3240.00          NaN       Oil          NaN  331.21        NaN  237.22         NaN  0.69920         NaN  0.56867        NaN   97.63        NaN  230.60          NaN  0.074963          NaN  0.084877         NaN  0.83428
     4     3260.00          NaN       Oil          NaN  332.58        NaN  236.85         NaN  0.70009         NaN  0.57528        NaN   97.93        NaN  231.00          NaN  0.074630          NaN  0.084561         NaN  0.83495
     5     3280.00          NaN       Oil          NaN  333.95        NaN  236.47         NaN  0.70098         NaN  0.58194        NaN   98.23        NaN  231.41          NaN  0.074298          NaN  0.084247         NaN  0.83561
     6     3300.00          NaN       Oil          NaN  335.33        NaN  236.10         NaN  0.70186         NaN  0.58867        NaN   98.54        NaN  231.81          NaN  0.073969          NaN  0.083935         NaN  0.83627
     7     3317.90     F_3317.9       Oil       336.63  336.56        NaN  235.77         NaN  0.70265         NaN  0.59474        NaN   98.81        NaN  232.17     0.073180  0.073677     0.083951  0.083657     0.83733  0.83686
     8     3320.00          NaN       Oil          NaN  336.71        NaN  235.73         NaN  0.70274         NaN  0.59546        NaN   98.84        NaN  232.21          NaN  0.073643          NaN  0.083624         NaN  0.83693
     9     3340.00          NaN       Oil          NaN  338.09        NaN  235.36         NaN  0.70361         NaN  0.60230        NaN   99.14        NaN  232.61          NaN  0.073318          NaN  0.083315         NaN  0.83758
    10     3346.40     F_3346.4       Oil       338.55  338.53        NaN  235.25         NaN  0.70389         NaN  0.60451        NaN   99.24        NaN  232.74     0.073692  0.073215     0.082350  0.083216     0.83842  0.83779
    11     3350.00     F_3350         Oil          NaN  338.78        NaN  235.18         NaN  0.70405         NaN  0.60575        NaN   99.29        NaN  232.82          NaN  0.073157          NaN  0.083161         NaN  0.83790
    12     3360.00          NaN       Oil          NaN  339.47        NaN  235.00         NaN  0.70448         NaN  0.60921        NaN   99.44        NaN  233.02          NaN  0.072996          NaN  0.083007         NaN  0.83823
    13     3380.00          NaN       Oil          NaN  340.85        NaN  234.63         NaN  0.70535         NaN  0.61618        NaN   99.74        NaN  233.42          NaN  0.072676          NaN  0.082701         NaN  0.83887
    14     3400.00          NaN       Oil          NaN  342.23        NaN  234.27         NaN  0.70621         NaN  0.62321        NaN  100.04        NaN  233.82          NaN  0.072358          NaN  0.082397         NaN  0.83951
    15     3403.80     F_3403.8       Oil       342.40  342.50        NaN  234.20         NaN  0.70637         NaN  0.62456        NaN  100.10        NaN  233.90     0.071692  0.072298     0.082205  0.082339     0.83991  0.83963
    16     3420.00          NaN       Oil          NaN  343.62        NaN  233.90         NaN  0.70706         NaN  0.63031        NaN  100.35        NaN  234.23          NaN  0.072042          NaN  0.082094         NaN  0.84015
    17     3440.00          NaN       Oil          NaN  345.01        NaN  233.54         NaN  0.70791         NaN  0.63746        NaN  100.65        NaN  234.63          NaN  0.071728          NaN  0.081793         NaN  0.84078
    18     3460.00          NaN       Oil          NaN  346.40        NaN  233.18         NaN  0.70876         NaN  0.64469        NaN  100.95        NaN  235.03          NaN  0.071417          NaN  0.081493         NaN  0.84141
    19     3480.00          NaN       Oil          NaN  347.79        NaN  232.82         NaN  0.70960         NaN  0.65197        NaN  101.26        NaN  235.44          NaN  0.071107          NaN  0.081195         NaN  0.84204
    20     3500.00     F_3500         Oil          NaN  349.18        NaN  232.46         NaN  0.71044         NaN  0.65932        NaN  101.56        NaN  235.84          NaN  0.070799          NaN  0.080898         NaN  0.84266
END
set xlabel "Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_PRES_1.pdf"
plot [*:*][*:*] $Expt using 5:2 with points title "Expt", $Expt using 6:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Saturation Pressure (bar)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_SATP_1.pdf"
plot [*:*][*:*] $Expt using 7:2 with points title "Expt", $Expt using 8:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall Density (g/cm3)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_DEN_1.pdf"
plot [*:*][*:*] $Expt using 9:2 with points title "Expt", $Expt using 10:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Viscosity (cp)"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_VIS_1.pdf"
plot [*:*][*:*] $Expt using 11:2 with points title "Expt", $Expt using 12:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C1 Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C1_1.pdf"
plot [*:*][*:*] $Expt using 17:2 with points title "Expt", $Expt using 18:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C2-C5 Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C2-C5_1.pdf"
plot [*:*][*:*] $Expt using 19:2 with points title "Expt", $Expt using 20:2 with lines title "Calc"
set yrange [] noreverse
set xlabel "Overall C6+ Mass Fraction"
set ylabel "Depth (m)"
set yrange [] reverse
set output "Figures/Expt_037_DEPTH_vs_ZWT-C6+_1.pdf"
plot [*:*][*:*] $Expt using 21:2 with points title "Expt", $Expt using 22:2 with lines title "Calc"
set yrange [] noreverse

set title "P-T Diagram for Lab1_Recombined_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   32.692     1.00000e-13        0.00000         2.54262e-15          1.00000       602.891     103.158     0.932450     4.05668e-16     7.79127e-18
   35.000     1.60832e-13        0.00000         4.06060e-15          1.00000       602.891     103.158     0.932019     6.47557e-16     1.24936e-17
   37.500     2.66617e-13        0.00000         6.68060e-15          1.00000       602.891     103.158     0.931549     1.06484e-15     2.06481e-17
   40.000     4.37850e-13        0.00000         1.08891e-14          1.00000       602.890     103.158     0.931075     1.73477e-15     3.38119e-17
   42.500     7.12506e-13        0.00000         1.75884e-14          1.00000       602.890     103.158     0.930597     2.80059e-15     5.48734e-17
   45.000     1.14915e-12        0.00000         2.81586e-14          1.00000       602.890     103.158     0.930115     4.48138e-15     8.82778e-17
   47.500     1.83732e-12        0.00000         4.46939e-14          1.00000       602.890     103.158     0.929629     7.10921e-15     1.40810e-16
   50.000     2.91279e-12        0.00000         7.03442e-14          1.00000       602.890     103.158     0.929139     1.11834e-14     2.22743e-16
   52.500     4.57972e-12        0.00000         1.09810e-13          1.00000       602.890     103.158     0.928645     1.74484e-14     3.49499e-16
   55.000     7.14270e-12        0.00000         1.70050e-13          1.00000       602.890     103.158     0.928148     2.70058e-14     5.44062e-16
   57.500     1.10526e-11        0.00000         2.61286e-13          1.00000       602.890     103.158     0.927645     4.14727e-14     8.40416e-16
   60.000     1.69717e-11        0.00000         3.98422e-13          1.00000       602.889     103.158     0.927139     6.32052e-14     1.28844e-15
   62.500     2.58659e-11        0.00000         6.03028e-13          1.00000       602.889     103.158     0.926629     9.56110e-14     1.96082e-15
   65.000     3.91333e-11        0.00000         9.06098e-13          1.00000       602.889     103.158     0.926115     1.43583e-13     2.96270e-15
   67.500     5.87838e-11        0.00000         1.35186e-12          1.00000       602.889     103.158     0.925596     2.14100e-13     4.44519e-15
   70.000     8.76868e-11        0.00000         2.00298e-12          1.00000       602.888     103.158     0.925073     3.17043e-13     6.62394e-15
   72.500     1.29911e-10        0.00000         2.94770e-12          1.00000       602.888     103.158     0.924545     4.66313e-13     9.80470e-15
   75.000     1.91188e-10        0.00000         4.30942e-12          1.00000       602.887     103.158     0.924014     6.81338e-13     1.44182e-14
   77.500     2.79542e-10        0.00000         6.25962e-12          1.00000       602.887     103.158     0.923478     9.89101e-13     2.10675e-14
   80.000     4.06131e-10        0.00000         9.03517e-12          1.00000       602.886     103.158     0.922937     1.42684e-12     3.05917e-14
   82.500     5.86385e-10        0.00000         1.29612e-11          1.00000       602.886     103.158     0.922393     2.04563e-12     4.41511e-14
   85.000     8.41504e-10        0.00000         1.84814e-11          1.00000       602.885     103.158     0.921843     2.91514e-12     6.33415e-14
   87.500     1.20046e-09        0.00000         2.61977e-11          1.00000       602.884     103.158     0.921290     4.12979e-12     9.03444e-14
   90.000     1.70259e-09        0.00000         3.69224e-11          1.00000       602.884     103.158     0.920731     5.81689e-12     1.28126e-13
   92.500     2.40105e-09        0.00000         5.17449e-11          1.00000       602.883     103.158     0.920168     8.14711e-12     1.80696e-13
   95.000     3.36726e-09        0.00000         7.21192e-11          1.00000       602.882     103.158     0.919601     1.13480e-11     2.53450e-13
   97.500     4.69664e-09        0.00000         9.99750e-11          1.00000       602.881     103.158     0.919028     1.57214e-11     3.53604e-13
  100.000     6.51605e-09        0.00000         1.37861e-10          1.00000       602.879     103.158     0.918451     2.16655e-11     4.90764e-13
  102.500     8.99326e-09        0.00000         1.89125e-10          1.00000       602.878     103.158     0.917870     2.97031e-11     6.77656e-13
  105.000     1.23491e-08        0.00000         2.58143e-10          1.00000       602.877     103.158     0.917283     4.05170e-11     9.31052e-13
  107.500     1.68726e-08        0.00000         3.50611e-10          1.00000       602.875     103.158     0.916692     5.49950e-11     1.27295e-12
  110.000     2.29407e-08        0.00000         4.73902e-10          1.00000       602.873     103.158     0.916095     7.42857e-11     1.73208e-12
  112.500     3.10421e-08        0.00000         6.37519e-10          1.00000       602.871     103.158     0.915494     9.98679e-11     2.34579e-12
  115.000     4.18081e-08        0.00000         8.53655e-10          1.00000       602.869     103.158     0.914888     1.33638e-10     3.16237e-12
  117.500     5.60501e-08        0.00000         1.13788e-09          1.00000       602.867     103.158     0.914277     1.78015e-10     4.24407e-12
  120.000     7.48064e-08        0.00000         1.51001e-09          1.00000       602.864     103.158     0.913661     2.36074e-10     5.67073e-12
  122.500     9.94004e-08        0.00000         1.99513e-09          1.00000       602.862     103.158     0.913039     3.11706e-10     7.54433e-12
  125.000     1.31511e-07        0.00000         2.62486e-09          1.00000       602.859     103.158     0.912413     4.09811e-10     9.99461e-12
  127.500     1.73261e-07        0.00000         3.43894e-09          1.00000       602.855     103.158     0.911781     5.36542e-10     1.31860e-11
  130.000     2.27321e-07        0.00000         4.48706e-09          1.00000       602.852     103.158     0.911144     6.99584e-10     1.73258e-11
  132.500     2.97038e-07        0.00000         5.83115e-09          1.00000       602.848     103.158     0.910502     9.08508e-10     2.26751e-11
  135.000     3.86596e-07        0.00000         7.54807e-09          1.00000       602.844     103.158     0.909855     1.17518e-09     2.95604e-11
  137.500     5.01194e-07        0.00000         9.73289e-09          1.00000       602.840     103.158     0.909202     1.51427e-09     3.83894e-11
  140.000     6.47281e-07        0.00000         1.25027e-08          1.00000       602.835     103.158     0.908543     1.94381e-09     4.96689e-11
  142.500     8.32818e-07        0.00000         1.60013e-08          1.00000       602.830     103.158     0.907880     2.48594e-09     6.40268e-11
  145.000     1.06760e-06        0.00000         2.04045e-08          1.00000       602.824     103.158     0.907210     3.16770e-09     8.22384e-11
  147.500     1.36364e-06        0.00000         2.59266e-08          1.00000       602.818     103.158     0.906535     4.02204e-09     1.05257e-10
  150.000     1.73561e-06        0.00000         3.28282e-08          1.00000       602.812     103.158     0.905854     5.08892e-09     1.34254e-10
  152.500     2.20139e-06        0.00000         4.14246e-08          1.00000       602.805     103.158     0.905168     6.41670e-09     1.70657e-10
  155.000     2.78267e-06        0.00000         5.20962e-08          1.00000       602.798     103.158     0.904476     8.06367e-09     2.16208e-10
  157.500     3.50569e-06        0.00000         6.53008e-08          1.00000       602.790     103.158     0.903778     1.00999e-08     2.73024e-10
  160.000     4.40209e-06        0.00000         8.15875e-08          1.00000       602.781     103.158     0.903074     1.26092e-08     3.43664e-10
  162.500     5.50994e-06        0.00000         1.01612e-07          1.00000       602.772     103.158     0.902364     1.56920e-08     4.31221e-10
  165.000     6.87482e-06        0.00000         1.26158e-07          1.00000       602.762     103.158     0.901648     1.94673e-08     5.39415e-10
  167.500     8.55122e-06        0.00000         1.56153e-07          1.00000       602.752     103.158     0.900926     2.40770e-08     6.72712e-10
  170.000     1.06040e-05        0.00000         1.92699e-07          1.00000       602.741     103.158     0.900198     2.96885e-08     8.36452e-10
  172.500     1.31104e-05        0.00000         2.37097e-07          1.00000       602.729     103.158     0.899464     3.64997e-08     1.03701e-09
  175.000     1.61616e-05        0.00000         2.90880e-07          1.00000       602.716     103.158     0.898723     4.47433e-08     1.28198e-09
  177.500     1.98655e-05        0.00000         3.55848e-07          1.00000       602.703     103.158     0.897976     5.46924e-08     1.58034e-09
  180.000     2.43491e-05        0.00000         4.34110e-07          1.00000       602.689     103.158     0.897223     6.66668e-08     1.94277e-09
  182.500     2.97618e-05        0.00000         5.28133e-07          1.00000       602.673     103.158     0.896463     8.10393e-08     2.38184e-09
  185.000     3.62783e-05        0.00000         6.40789e-07          1.00000       602.657     103.158     0.895696     9.82444e-08     2.91234e-09
  187.500     4.41031e-05        0.00000         7.75418e-07          1.00000       602.640     103.158     0.894923     1.18786e-07     3.55169e-09
  190.000     5.34742e-05        0.00000         9.35892e-07          1.00000       602.621     103.158     0.894144     1.43249e-07     4.32025e-09
  192.500     6.46686e-05        0.00000         1.12669e-06          1.00000       602.602     103.158     0.893357     1.72307e-07     5.24184e-09
  195.000     7.80074e-05        0.00000         1.35298e-06          1.00000       602.581     103.158     0.892564     2.06737e-07     6.34424e-09
  197.500     9.38620e-05        0.00000         1.62072e-06          1.00000       602.559     103.158     0.891764     2.47434e-07     7.65975e-09
  200.000     1.12661e-04        0.00000         1.93672e-06          1.00000       602.536     103.158     0.890956     2.95423e-07     9.22588e-09
  202.500     1.34899e-04        0.00000         2.30883e-06          1.00000       602.511     103.158     0.890142     3.51876e-07     1.10860e-08
  205.000     1.61142e-04        0.00000         2.74598e-06          1.00000       602.485     103.158     0.889321     4.18132e-07     1.32904e-08
  207.500     1.92040e-04        0.00000         3.25839e-06          1.00000       602.458     103.158     0.888492     4.95716e-07     1.58969e-08
  210.000     2.28338e-04        0.00000         3.85765e-06          1.00000       602.428     103.158     0.887656     5.86361e-07     1.89720e-08
  212.500     2.70883e-04        0.00000         4.55696e-06          1.00000       602.397     103.158     0.886812     6.92033e-07     2.25923e-08
  215.000     3.20640e-04        0.00000         5.37125e-06          0.99999       602.365     103.158     0.885961     8.14956e-07     2.68451e-08
  217.500     3.78708e-04        0.00000         6.31742e-06          0.99999       602.330     103.158     0.885102     9.57641e-07     3.18308e-08
  220.000     4.46330e-04        0.00000         7.41453e-06          0.99999       602.294     103.158     0.884236     1.12292e-06     3.76637e-08
  222.500     5.24915e-04        0.00000         8.68405e-06          0.99999       602.256     103.158     0.883362     1.31397e-06     4.44738e-08
  225.000     6.16052e-04        0.00000         1.01501e-05          0.99999       602.215     103.158     0.882479     1.53437e-06     5.24092e-08
  227.500     7.21533e-04        0.00000         1.18398e-05          0.99999       602.173     103.158     0.881589     1.78811e-06     6.16379e-08
  230.000     8.43372e-04        0.00000         1.37833e-05          0.99999       602.128     103.158     0.880691     2.07967e-06     7.23500e-08
  232.500     9.83831e-04        0.00000         1.60146e-05          0.99999       602.081     103.158     0.879784     2.41404e-06     8.47607e-08
  235.000     1.14545e-03        0.00000         1.85713e-05          0.99998       602.031     103.158     0.878869     2.79677e-06     9.91128e-08
  237.500     1.33105e-03        0.00000         2.14956e-05          0.99998       601.979     103.158     0.877946     3.23405e-06     1.15680e-07
  240.000     1.54381e-03        0.00000         2.48342e-05          0.99998       601.924     103.158     0.877014     3.73272e-06     1.34769e-07
  242.500     1.78724e-03        0.00000         2.86387e-05          0.99998       601.866     103.158     0.876074     4.30037e-06     1.56726e-07
  245.000     2.06528e-03        0.00000         3.29667e-05          0.99997       601.806     103.158     0.875124     4.94541e-06     1.81938e-07
  247.500     2.38227e-03        0.00000         3.78815e-05          0.99997       601.742     103.158     0.874166     5.67708e-06     2.10838e-07
  250.000     2.74304e-03        0.00000         4.34530e-05          0.99997       601.675     103.158     0.873198     6.50561e-06     2.43911e-07
  252.500     3.15293e-03        0.00000         4.97585e-05          0.99996       601.605     103.158     0.872222     7.44221e-06     2.81696e-07
  255.000     3.61784e-03        0.00000         5.68826e-05          0.99996       601.531     103.158     0.871236     8.49921e-06     3.24796e-07
  257.500     4.14427e-03        0.00000         6.49186e-05          0.99995       601.454     103.158     0.870241     9.69012e-06     3.73881e-07
  260.000     4.73940e-03        0.00000         7.39684e-05          0.99994       601.373     103.158     0.869236     1.10298e-05     4.29693e-07
  262.500     5.41109e-03        0.00000         8.41438e-05          0.99994       601.288     103.158     0.868221     1.25343e-05     4.93057e-07
  265.000     6.16800e-03        0.00000         9.55670e-05          0.99993       601.199     103.158     0.867196     1.42213e-05     5.64888e-07
  267.500     7.01960e-03        0.00000         1.08371e-04          0.99992       601.106     103.158     0.866162     1.61101e-05     6.46195e-07
  270.000     7.97625e-03        0.00000         1.22702e-04          0.99991       601.008     103.158     0.865117     1.82215e-05     7.38094e-07
  272.500     9.04929e-03        0.00000         1.38717e-04          0.99990       600.906     103.158     0.864061     2.05784e-05     8.41816e-07
  275.000     1.02511e-02        0.00000         1.56587e-04          0.99989       600.799     103.158     0.862996     2.32052e-05     9.58719e-07
  277.500     1.15951e-02        0.00000         1.76501e-04          0.99988       600.688     103.158     0.861919     2.61288e-05     1.09029e-06
  280.000     1.30960e-02        0.00000         1.98658e-04          0.99986       600.571     103.158     0.860832     2.93779e-05     1.23818e-06
  282.500     1.47696e-02        0.00000         2.23278e-04          0.99985       600.448     103.158     0.859733     3.29839e-05     1.40418e-06
  285.000     1.66334e-02        0.00000         2.50597e-04          0.99983       600.321     103.158     0.858624     3.69803e-05     1.59027e-06
  287.500     1.87059e-02        0.00000         2.80869e-04          0.99981       600.187     103.158     0.857503     4.14033e-05     1.79860e-06
  290.000     2.10075e-02        0.00000         3.14369e-04          0.99979       600.048     103.158     0.856370     4.62921e-05     2.03155e-06
  292.500     2.35600e-02        0.00000         3.51392e-04          0.99977       599.902     103.158     0.855226     5.16884e-05     2.29170e-06
  295.000     2.63871e-02        0.00000         3.92257e-04          0.99975       599.750     103.158     0.854069     5.76374e-05     2.58186e-06
  297.500     2.95142e-02        0.00000         4.37304e-04          0.99972       599.591     103.158     0.852900     6.41872e-05     2.90512e-06
  300.000     3.29688e-02        0.00000         4.86899e-04          0.99970       599.425     103.158     0.851719     7.13896e-05     3.26483e-06
  302.500     3.67804e-02        0.00000         5.41435e-04          0.99967       599.252     103.158     0.850525     7.92996e-05     3.66463e-06
  305.000     4.09808e-02        0.00000         6.01330e-04          0.99963       599.071     103.158     0.849319     8.79765e-05     4.10849e-06
  307.500     4.56038e-02        0.00000         6.67034e-04          0.99960       598.883     103.158     0.848099     9.74830e-05     4.60073e-06
  310.000     5.06861e-02        0.00000         7.39025e-04          0.99956       598.686     103.158     0.846865     1.07887e-04     5.14602e-06
  312.500     5.62666e-02        0.00000         8.17814e-04          0.99952       598.482     103.158     0.845618     1.19258e-04     5.74943e-06
  315.000     6.23871e-02        0.00000         9.03945e-04          0.99947       598.268     103.158     0.844357     1.31675e-04     6.41646e-06
  317.500     6.90923e-02        0.00000         9.97997e-04          0.99943       598.046     103.158     0.843082     1.45217e-04     7.15308e-06
  320.000     7.64298e-02        0.00000         1.10059e-03          0.99937       597.814     103.158     0.841793     1.59969e-04     7.96572e-06
  322.500     8.44504e-02        0.00000         1.21237e-03          0.99932       597.572     103.158     0.840489     1.76025e-04     8.86137e-06
  325.000     9.32084e-02        0.00000         1.33404e-03          0.99926       597.320     103.158     0.839169     1.93479e-04     9.84754e-06
  327.500     1.02761e-01        0.00000         1.46633e-03          0.99920       597.058     103.158     0.837835     2.12435e-04     1.09324e-05
  330.000     1.13171e-01        0.00000         1.61003e-03          0.99913       596.785     103.158     0.836484     2.33000e-04     1.21247e-05
  332.500     1.24502e-01        0.00000         1.76596e-03          0.99906       596.500     103.158     0.835118     2.55289e-04     1.34339e-05
  335.000     1.36823e-01        0.00000         1.93500e-03          0.99898       596.204     103.158     0.833736     2.79423e-04     1.48702e-05
  337.500     1.50209e-01        0.00000         2.11808e-03          0.99889       595.896     103.158     0.832336     3.05529e-04     1.64447e-05
  340.000     1.64737e-01        0.00000         2.31616e-03          0.99880       595.575     103.158     0.830920     3.33743e-04     1.81693e-05
  342.500     1.80490e-01        0.00000         2.53028e-03          0.99871       595.241     103.158     0.829487     3.64207e-04     2.00566e-05
  345.000     1.97555e-01        0.00000         2.76154e-03          0.99861       594.894     103.158     0.828035     3.97070e-04     2.21205e-05
  347.500     2.16025e-01        0.00000         3.01108e-03          0.99850       594.532     103.158     0.826566     4.32491e-04     2.43757e-05
  350.000     2.35998e-01        0.00000         3.28010e-03          0.99839       594.156     103.158     0.825077     4.70635e-04     2.68382e-05
  352.500     2.57576e-01        0.00000         3.56988e-03          0.99827       593.765     103.158     0.823570     5.11677e-04     2.95250e-05
  355.000     2.80871e-01        0.00000         3.88177e-03          0.99814       593.358     103.158     0.822044     5.55802e-04     3.24547e-05
  357.500     3.05996e-01        0.00000         4.21718e-03          0.99800       592.934     103.158     0.820497     6.03203e-04     3.56471e-05
  360.000     3.33073e-01        0.00000         4.57758e-03          0.99786       592.494     103.158     0.818930     6.54083e-04     3.91233e-05
  362.500     3.62233e-01        0.00000         4.96454e-03          0.99770       592.036     103.158     0.817343     7.08657e-04     4.29063e-05
  365.000     3.93609e-01        0.00000         5.37970e-03          0.99754       591.559     103.158     0.815733     7.67148e-04     4.70206e-05
  367.500     4.27345e-01        0.00000         5.82477e-03          0.99737       591.064     103.158     0.814102     8.29793e-04     5.14928e-05
  370.000     4.63592e-01        0.00000         6.30158e-03          0.99719       590.549     103.158     0.812449     8.96839e-04     5.63513e-05
  372.500     5.02509e-01        0.00000         6.81201e-03          0.99700       590.013     103.158     0.810773     9.68546e-04     6.16265e-05
  375.000     5.44263e-01        0.00000         7.35806e-03          0.99680       589.456     103.158     0.809073     1.04519e-03     6.73514e-05
  377.500     5.89031e-01        0.00000         7.94183e-03          0.99658       588.877     103.158     0.807348     1.12705e-03     7.35613e-05
  380.000     6.36998e-01        0.00000         8.56550e-03          0.99636       588.275     103.158     0.805599     1.21444e-03     8.02942e-05
  382.500     6.88360e-01        0.00000         9.23138e-03          0.99613       587.649     103.158     0.803825     1.30767e-03     8.75909e-05
  385.000     7.43323e-01        0.00000         9.94188e-03          0.99588       586.998     103.158     0.802024     1.40706e-03     9.54955e-05
  387.500     8.02105e-01        0.00000         1.06995e-02          0.99562       586.322     103.158     0.800196     1.51298e-03     1.04055e-04
  390.000     8.64934e-01        0.00000         1.15070e-02          0.99535       585.618     103.158     0.798340     1.62579e-03     1.13321e-04
  392.500     9.32051e-01        0.00000         1.23671e-02          0.99506       584.887     103.158     0.796456     1.74587e-03     1.23349e-04
  395.000     1.00371e+00        0.00000         1.32828e-02          0.99476       584.126     103.158     0.794543     1.87363e-03     1.34197e-04
  397.500     1.08018e+00        0.00000         1.42571e-02          0.99445       583.335     103.158     0.792600     2.00949e-03     1.45929e-04
  400.000     1.16174e+00        0.00000         1.52932e-02          0.99412       582.512     103.158     0.790625     2.15391e-03     1.58615e-04
  402.500     1.24869e+00        0.00000         1.63946e-02          0.99377       581.656     103.158     0.788618     2.30736e-03     1.72329e-04
  405.000     1.34135e+00        0.00000         1.75647e-02          0.99341       580.766     103.158     0.786579     2.47033e-03     1.87152e-04
  407.500     1.44004e+00        0.00000         1.88074e-02          0.99303       579.841     103.158     0.784505     2.64335e-03     2.03170e-04
  410.000     1.54512e+00        0.00000         2.01267e-02          0.99264       578.878     103.158     0.782396     2.82698e-03     2.20478e-04
  412.500     1.65695e+00        0.00000         2.15265e-02          0.99222       577.875     103.158     0.780251     3.02180e-03     2.39179e-04
  415.000     1.77594e+00        0.00000         2.30113e-02          0.99179       576.833     103.158     0.778069     3.22842e-03     2.59383e-04
  417.500     1.90248e+00        0.00000         2.45858e-02          0.99134       575.747     103.158     0.775847     3.44751e-03     2.81211e-04
  420.000     2.03703e+00        0.00000         2.62546e-02          0.99087       574.617     103.158     0.773586     3.67976e-03     3.04794e-04
  422.500     2.18004e+00        0.00000         2.80230e-02          0.99038       573.441     103.158     0.771283     3.92589e-03     3.30273e-04
  425.000     2.33202e+00        0.00000         2.98964e-02          0.98987       572.216     103.158     0.768937     4.18670e-03     3.57805e-04
  427.500     2.49348e+00        0.00000         3.18803e-02          0.98934       570.940     103.158     0.766546     4.46300e-03     3.87559e-04
  430.000     2.66498e+00        0.00000         3.39810e-02          0.98878       569.611     103.158     0.764109     4.75568e-03     4.19718e-04
  432.500     2.84713e+00        0.00000         3.62046e-02          0.98820       568.226     103.158     0.761624     5.06568e-03     4.54487e-04
  435.000     3.04054e+00        0.00000         3.85581e-02          0.98760       566.782     103.158     0.759089     5.39401e-03     4.92087e-04
  437.500     3.24591e+00        0.00000         4.10485e-02          0.98697       565.277     103.158     0.756502     5.74172e-03     5.32761e-04
  440.000     3.46395e+00        0.00000         4.36836e-02          0.98632       563.707     103.158     0.753860     6.10998e-03     5.76777e-04
  442.500     3.69543e+00        0.00000         4.64714e-02          0.98564       562.069     103.158     0.751163     6.50001e-03     6.24430e-04
  445.000     3.94120e+00        0.00000         4.94206e-02          0.98493       560.359     103.158     0.748406     6.91313e-03     6.76047e-04
  447.500     4.20214e+00        0.00000         5.25405e-02          0.98420       558.573     103.158     0.745588     7.35077e-03     7.31987e-04
  450.000     4.47923e+00        0.00000         5.58408e-02          0.98343       556.708     103.158     0.742705     7.81447e-03     7.92650e-04
  452.500     4.77349e+00        0.00000         5.93323e-02          0.98263       554.758     103.158     0.739755     8.30588e-03     8.58481e-04
  455.000     5.08607e+00        0.00000         6.30263e-02          0.98180       552.720     103.158     0.736733     8.82683e-03     9.29975e-04
  457.500     5.41817e+00        0.00000         6.69351e-02          0.98094       550.587     103.158     0.733638     9.37926e-03     1.00769e-03
  460.000     5.77114e+00        0.00000         7.10719e-02          0.98004       548.355     103.158     0.730464     9.96533e-03     1.09224e-03
  462.500     6.14643e+00        0.00000         7.54509e-02          0.97911       546.016     103.158     0.727207     1.05874e-02     1.18432e-03
  465.000     6.54562e+00        0.00000         8.00878e-02          0.97814       543.564     103.158     0.723863     1.12480e-02     1.28473e-03
  467.500     6.97047e+00        0.00000         8.49995e-02          0.97713       540.992     103.158     0.720427     1.19499e-02     1.39436e-03
  470.000     7.42290e+00        0.00000         9.02043e-02          0.97608       538.292     103.158     0.716892     1.26964e-02     1.51422e-03
  472.500     7.90506e+00        0.00000         9.57225e-02          0.97498       535.454     103.158     0.713253     1.34909e-02     1.64547e-03
  475.000     8.41931e+00        0.00000         1.01577e-01          0.97384       532.469     103.158     0.709503     1.43373e-02     1.78945e-03
  477.500     8.96831e+00        0.00000         1.07791e-01          0.97265       529.325     103.158     0.705634     1.52400e-02     1.94769e-03
  480.000     9.55505e+00        0.00000         1.14393e-01          0.97141       526.011     103.158     0.701637     1.62038e-02     2.12198e-03
  482.500     1.01829e+01        0.00000         1.21414e-01          0.97012       522.512     103.158     0.697503     1.72343e-02     2.31439e-03
  485.000     1.08557e+01        0.00000         1.28887e-01          0.96877       518.812     103.158     0.693220     1.83380e-02     2.52738e-03
  487.500     1.15779e+01        0.00000         1.36852e-01          0.96736       514.894     103.158     0.688776     1.95221e-02     2.76384e-03
  490.000     1.23545e+01        0.00000         1.45354e-01          0.96588       510.738     103.158     0.684156     2.07951e-02     3.02725e-03
  492.500     1.31916e+01        0.00000         1.54443e-01          0.96433       506.318     103.158     0.679342     2.21670e-02     3.32177e-03
  495.000     1.40960e+01        0.00000         1.64179e-01          0.96271       501.608     103.158     0.674315     2.36495e-02     3.65251e-03
  497.500     1.50762e+01        0.00000         1.74633e-01          0.96101       496.573     103.158     0.669051     2.52566e-02     4.02575e-03
  500.000     1.61422e+01        0.00000         1.85887e-01          0.95921       491.176     103.158     0.663520     2.70055e-02     4.44937e-03
  502.500     1.73065e+01        0.00000         1.98044e-01          0.95732       485.367     103.158     0.657687     2.89171e-02     4.93341e-03
  505.000     1.85846e+01        0.00000         2.11228e-01          0.95531       479.087     103.158     0.651508     3.10180e-02     5.49088e-03
  507.500     1.99964e+01        0.00000         2.25597e-01          0.95318       472.260     103.158     0.644926     3.33419e-02     6.13908e-03
  510.000     2.15682e+01        0.00000         2.41357e-01          0.95089       464.786     103.158     0.637865     3.59339e-02     6.90167e-03
  512.500     2.33357e+01        0.00000         2.58782e-01          0.94844       456.533     103.158     0.630225     3.88553e-02     7.81222e-03
  515.000     2.53500e+01        0.00000         2.78261e-01          0.94577       447.312     103.158     0.621861     4.21942e-02     8.92054e-03
  517.500     2.76888e+01        0.00000         3.00375e-01          0.94283       436.838     103.158     0.612553     4.60844e-02     1.03054e-02
  520.000     3.04807e+01        0.00000         3.26071e-01          0.93953       424.647     103.158     0.601937     5.07487e-02     1.21030e-02
  522.500     3.39702e+01        0.00000         3.57130e-01          0.93570       409.865     103.158     0.589326     5.66116e-02     1.45837e-02
  525.000     3.87561e+01        0.00000         3.97848e-01          0.93093       390.371     103.158     0.573038     6.47155e-02     1.84424e-02
  527.500     4.81025e+01        0.00000         4.71289e-01          0.92298       354.764     103.158     0.543931     8.07611e-02     2.77042e-02
  527.829     5.33661e+01        0.00000         5.09254e-01          0.91921       336.072     103.158     0.528819     8.99284e-02     3.40776e-02
  527.829     5.34028e+01        0.00000         5.09510e-01          0.91919       335.945     103.158     0.528717     8.99926e-02     3.41253e-02
  527.500     5.89540e+01        0.00000         5.47011e-01          0.91571       317.249     103.158     0.513618     9.97652e-02     4.19035e-02
  526.584     6.44839e+01        0.00000         5.81907e-01          0.91273       299.618     103.158     0.499328     1.09606e-01     5.08651e-02
  525.000     7.05324e+01        0.00000         6.17407e-01          0.90996       281.423     103.158     0.484461     1.20489e-01     6.22509e-02
  522.500     7.75383e+01        0.00000         6.55242e-01          0.90739       261.704     103.158     0.468132     1.33250e-01     7.78341e-02
  520.000     8.32356e+01        0.00000         6.83574e-01          0.90576       246.687     103.158     0.455492     1.43750e-01     9.27097e-02
  517.500     8.82231e+01        0.00000         7.06696e-01          0.90467       234.255     103.158     0.444857     1.53029e-01     1.07606e-01
  515.000     9.27452e+01        0.00000         7.26380e-01          0.90394       223.534     103.158     0.435539     1.61514e-01     1.22827e-01
  512.500     9.69304e+01        0.00000         7.43569e-01          0.90348       214.058     103.158     0.427175     1.69426e-01     1.38546e-01
  510.000     1.00856e+02        0.00000         7.58837e-01          0.90323       205.544     103.158     0.419545     1.76900e-01     1.54882e-01
  507.500     1.04573e+02        0.00000         7.72569e-01          0.90316       197.804     103.158     0.412504     1.84022e-01     1.71922e-01
  505.000     1.08118e+02        0.00000         7.85033e-01          0.90323       190.705     103.158     0.405950     1.90855e-01     1.89745e-01
  502.500     1.11516e+02        0.00000         7.96432e-01          0.90343       184.147     103.158     0.399809     1.97443e-01     2.08418e-01
  500.000     1.14787e+02        0.00000         8.06917e-01          0.90375       178.055     103.158     0.394022     2.03821e-01     2.28007e-01
  497.500     1.17946e+02        0.00000         8.16609e-01          0.90416       172.371     103.158     0.388546     2.10014e-01     2.48573e-01
  495.000     1.21007e+02        0.00000         8.25605e-01          0.90467       167.045     103.158     0.383345     2.16044e-01     2.70179e-01
  492.500     1.23978e+02        0.00000         8.33985e-01          0.90526       162.038     103.158     0.378390     2.21927e-01     2.92888e-01
  490.000     1.26869e+02        0.00000         8.41814e-01          0.90592       157.318     103.158     0.373656     2.27677e-01     3.16765e-01
  487.500     1.29685e+02        0.00000         8.49149e-01          0.90666       152.857     103.158     0.369123     2.33307e-01     3.41875e-01
  485.000     1.32433e+02        0.00000         8.56036e-01          0.90746       148.631     103.158     0.364775     2.38826e-01     3.68289e-01
  482.500     1.35119e+02        0.00000         8.62517e-01          0.90832       144.620     103.158     0.360595     2.44243e-01     3.96076e-01
  480.000     1.37745e+02        0.00000         8.68627e-01          0.90924       140.806     103.158     0.356572     2.49564e-01     4.25313e-01
  477.500     1.40316e+02        0.00000         8.74396e-01          0.91021       137.173     103.158     0.352693     2.54797e-01     4.56078e-01
  475.000     1.42835e+02        0.00000         8.79852e-01          0.91124       133.709     103.158     0.348949     2.59946e-01     4.88451e-01
  472.500     1.45305e+02        0.00000         8.85020e-01          0.91231       130.400     103.158     0.345332     2.65016e-01     5.22521e-01
  470.000     1.47729e+02        0.00000         8.89920e-01          0.91342       127.236     103.158     0.341833     2.70013e-01     5.58376e-01
  467.500     1.50109e+02        0.00000         8.94573e-01          0.91458       124.207     103.158     0.338444     2.74940e-01     5.96114e-01
  465.000     1.52446e+02        0.00000         8.98994e-01          0.91578       121.303     103.158     0.335161     2.79799e-01     6.35834e-01
  462.500     1.54743e+02        0.00000         9.03200e-01          0.91702       118.518     103.158     0.331976     2.84595e-01     6.77643e-01
  460.000     1.57001e+02        0.00000         9.07205e-01          0.91830       115.844     103.158     0.328886     2.89330e-01     7.21652e-01
  457.500     1.59223e+02        0.00000         9.11022e-01          0.91961       113.274     103.158     0.325884     2.94007e-01     7.67981e-01
  455.000     1.61408e+02        0.00000         9.14662e-01          0.92096       110.802     103.158     0.322967     2.98628e-01     8.16754e-01
  452.500     1.63559e+02        0.00000         9.18136e-01          0.92234       108.423     103.158     0.320130     3.03195e-01     8.68102e-01
  450.000     1.65676e+02        0.00000         9.21454e-01          0.92375       106.131     103.158     0.317370     3.07711e-01     9.22166e-01
  447.500     1.67761e+02        0.00000         9.24624e-01          0.92520       103.922     103.158     0.314684     3.12176e-01     9.79094e-01
  447.033     1.68147e+02        0.00000         9.25201e-01          0.92547       103.519     103.158     0.314191     3.13005e-01     9.90047e-01
  446.613     1.68493e+02        0.50000         9.25715e-01          0.92571       103.158     103.158     0.313748     3.13748e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   15.775     1.71149e+02        0.00000         1.28419e+00          0.98896       144.543     103.158     0.801907     7.43154e-01     3.24250e-01
   16.321     2.54853e+02        0.00000         1.88526e+00          1.45426       143.686     103.158     0.807036     7.51122e-01     3.22818e-01
   17.645     3.79492e+02        0.00000         2.75021e+00          2.12881       142.475     103.158     0.813120     7.60584e-01     3.24577e-01
   19.970     5.65089e+02        0.00000         3.98641e+00          3.10066       141.023     103.158     0.820248     7.71408e-01     3.29764e-01
   23.425     8.41455e+02        0.00000         5.74611e+00          4.49409       139.489     103.158     0.828374     7.83289e-01     3.37949e-01
   27.982     1.25298e+03        0.00000         8.24944e+00          6.48769       138.010     103.158     0.837219     7.95731e-01     3.48136e-01
   33.426     1.86578e+03        0.00000         1.18202e+01          9.34376       136.664     103.158     0.846286     8.08104e-01     3.59385e-01
   39.379     2.77826e+03        0.00000         1.69411e+01         13.45464       135.471     103.158     0.854977     8.19745e-01     3.70882e-01
   45.370     4.13702e+03        0.00000         2.43388e+01         19.41291       134.424     103.158     0.862767     8.30096e-01     3.81987e-01
   50.948     6.16029e+03        0.00000         3.51106e+01         28.11443       133.515     103.158     0.869329     8.38810e-01     3.92229e-01
   55.787     9.17309e+03        0.00000         5.09096e+01         40.90795       132.746     103.158     0.874565     8.45790e-01     4.01209e-01
   59.735     1.36593e+04        0.00000         7.42158e+01         59.81360       132.119     103.158     0.878559     8.51144e-01     4.08711e-01
   62.796     2.03397e+04        0.00000         1.08734e+02         87.84579       131.628     103.158     0.881501     8.55108e-01     4.14626e-01
   65.075     3.02871e+04        0.00000         1.59986e+02        129.49416       131.258     103.158     0.883610     8.57964e-01     4.19165e-01
   66.722     4.50995e+04        0.00000         2.36191e+02        191.44142       130.987     103.158     0.885093     8.59979e-01     4.22482e-01
   67.886     6.71562e+04        0.00000         3.49581e+02        283.63434       130.795     103.158     0.886121     8.61379e-01     4.24850e-01
   68.695     1.00000e+05        0.00000         5.18369e+02        420.87984       130.660     103.158     0.886826     8.62342e-01     4.26518e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                    Liq Den      Gas Den           
#   (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  446.613      168.493          0.5000            0.92571          0.925715       103.158     103.158     0.313748     0.313748     1.00000e+00
  446.193      168.838          1.0000            0.92596          0.926226       103.158     102.799     0.314491     0.313307     9.90051e-01
  445.000      169.814          1.0000            0.92667          0.927656       103.158     101.791     0.316593     0.312067     9.62426e-01
  442.500      171.837          1.0000            0.92817          0.930556       103.158      99.735     0.320963     0.309518     9.07298e-01
  440.000      173.829          1.0000            0.92970          0.933332       103.158      97.749     0.325288     0.307034     8.55676e-01
  437.500      175.793          1.0000            0.93125          0.935990       103.158      95.831     0.329569     0.304611     8.07295e-01
  435.000      177.728          1.0000            0.93283          0.938537       103.158      93.976     0.333807     0.302247     7.61912e-01
  432.500      179.635          1.0000            0.93444          0.940977       103.158      92.182     0.338003     0.299941     7.19311e-01
  430.000      181.516          1.0000            0.93606          0.943316       103.158      90.446     0.342159     0.297689     6.79290e-01
  427.500      183.369          1.0000            0.93772          0.945559       103.158      88.765     0.346275     0.295491     6.41668e-01
  425.000      185.196          1.0000            0.93939          0.947710       103.158      87.137     0.350353     0.293344     6.06278e-01
  422.500      186.998          1.0000            0.94109          0.949774       103.158      85.560     0.354393     0.291246     5.72968e-01
  420.000      188.774          1.0000            0.94280          0.951755       103.158      84.030     0.358396     0.289196     5.41597e-01
  417.500      190.526          1.0000            0.94454          0.953655       103.158      82.547     0.362363     0.287192     5.12037e-01
  415.000      192.252          1.0000            0.94629          0.955480       103.158      81.108     0.366295     0.285232     4.84170e-01
  412.500      193.955          1.0000            0.94807          0.957231       103.158      79.712     0.370192     0.283316     4.57885e-01
  410.000      195.634          1.0000            0.94986          0.958913       103.158      78.356     0.374056     0.281441     4.33082e-01
  407.500      197.290          1.0000            0.95167          0.960527       103.158      77.039     0.377887     0.279607     4.09668e-01
  405.000      198.922          1.0000            0.95350          0.962077       103.158      75.760     0.381685     0.277812     3.87556e-01
  402.500      200.531          1.0000            0.95534          0.963564       103.158      74.516     0.385451     0.276055     3.66667e-01
  400.000      202.117          1.0000            0.95720          0.964993       103.158      73.307     0.389186     0.274334     3.46925e-01
  397.500      203.681          1.0000            0.95907          0.966363       103.158      72.131     0.392890     0.272650     3.28262e-01
  395.000      205.223          1.0000            0.96096          0.967679       103.158      70.988     0.396564     0.271000     3.10614e-01
  392.500      206.743          1.0000            0.96287          0.968941       103.158      69.875     0.400208     0.269385     2.93921e-01
  390.000      208.241          1.0000            0.96479          0.970152       103.158      68.791     0.403822     0.267802     2.78127e-01
  387.500      209.717          1.0000            0.96672          0.971313       103.158      67.736     0.407408     0.266251     2.63181e-01
  385.000      211.172          1.0000            0.96866          0.972426       103.158      66.709     0.410966     0.264731     2.49033e-01
  382.500      212.605          1.0000            0.97062          0.973493       103.158      65.708     0.414496     0.263241     2.35639e-01
  380.000      214.017          1.0000            0.97259          0.974514       103.158      64.733     0.417998     0.261781     2.22955e-01
  377.500      215.408          1.0000            0.97457          0.975492       103.158      63.782     0.421473     0.260349     2.10943e-01
  375.000      216.778          1.0000            0.97656          0.976428       103.158      62.855     0.424921     0.258946     1.99565e-01
  372.500      218.127          1.0000            0.97856          0.977322       103.158      61.952     0.428343     0.257569     1.88786e-01
  370.000      219.456          1.0000            0.98057          0.978177       103.158      61.070     0.431739     0.256219     1.78573e-01
  367.500      220.763          1.0000            0.98260          0.978993       103.158      60.210     0.435110     0.254895     1.68897e-01
  365.000      222.051          1.0000            0.98463          0.979771       103.158      59.371     0.438455     0.253596     1.59727e-01
  362.500      223.317          1.0000            0.98667          0.980513       103.158      58.551     0.441775     0.252321     1.51036e-01
  360.000      224.564          1.0000            0.98871          0.981218       103.158      57.752     0.445071     0.251071     1.42800e-01
  357.500      225.790          1.0000            0.99077          0.981889       103.158      56.970     0.448342     0.249844     1.34994e-01
  355.000      226.995          1.0000            0.99283          0.982525       103.158      56.208     0.451590     0.248640     1.27595e-01
  352.500      228.181          1.0000            0.99491          0.983128       103.158      55.462     0.454813     0.247458     1.20582e-01
  350.000      229.346          1.0000            0.99698          0.983699       103.158      54.734     0.458013     0.246298     1.13935e-01
  347.500      230.491          1.0000            0.99907          0.984237       103.158      54.022     0.461190     0.245159     1.07635e-01
  345.000      231.616          1.0000            1.00116          0.984745       103.158      53.327     0.464345     0.244040     1.01663e-01
  342.500      232.721          1.0000            1.00325          0.985221       103.158      52.647     0.467476     0.242943     9.60037e-02
  340.000      233.806          1.0000            1.00535          0.985668       103.158      51.981     0.470585     0.241864     9.06400e-02
  337.500      234.871          1.0000            1.00746          0.986084       103.158      51.331     0.473673     0.240806     8.55571e-02
  335.000      235.916          1.0000            1.00957          0.986472       103.158      50.694     0.476738     0.239766     8.07405e-02
  332.500      236.941          1.0000            1.01168          0.986831       103.158      50.072     0.479782     0.238745     7.61767e-02
  330.000      237.946          1.0000            1.01379          0.987162       103.158      49.462     0.482804     0.237742     7.18528e-02
  327.500      238.931          1.0000            1.01591          0.987465       103.158      48.866     0.485805     0.236756     6.77568e-02
  325.000      239.896          1.0000            1.01803          0.987741       103.158      48.282     0.488786     0.235788     6.38770e-02
  322.500      240.841          1.0000            1.02016          0.987989       103.158      47.710     0.491745     0.234837     6.02024e-02
  320.000      241.766          1.0000            1.02228          0.988211       103.158      47.151     0.494685     0.233902     5.67229e-02
  317.500      242.671          1.0000            1.02441          0.988407       103.158      46.602     0.497604     0.232984     5.34284e-02
  315.000      243.556          1.0000            1.02653          0.988576       103.158      46.065     0.500503     0.232082     5.03098e-02
  312.500      244.421          1.0000            1.02866          0.988719       103.158      45.539     0.503382     0.231195     4.73581e-02
  310.000      245.266          1.0000            1.03078          0.988837       103.158      45.023     0.506241     0.230323     4.45649e-02
  307.500      246.091          1.0000            1.03291          0.988929       103.158      44.518     0.509081     0.229466     4.19223e-02
  305.000      246.896          1.0000            1.03503          0.988996       103.158      44.023     0.511902     0.228624     3.94227e-02
  302.500      247.681          1.0000            1.03716          0.989037       103.158      43.537     0.514704     0.227796     3.70589e-02
  300.000      248.445          1.0000            1.03928          0.989054       103.158      43.061     0.517487     0.226983     3.48239e-02
  297.500      249.190          1.0000            1.04139          0.989045       103.158      42.594     0.520251     0.226183     3.27114e-02
  295.000      249.914          1.0000            1.04351          0.989012       103.158      42.136     0.522997     0.225396     3.07151e-02
  292.500      250.618          1.0000            1.04562          0.988954       103.158      41.687     0.525725     0.224623     2.88292e-02
  290.000      251.301          1.0000            1.04773          0.988872       103.158      41.246     0.528434     0.223862     2.70480e-02
  287.500      251.964          1.0000            1.04983          0.988764       103.158      40.814     0.531125     0.223115     2.53663e-02
  285.000      252.607          1.0000            1.05192          0.988633       103.158      40.390     0.533799     0.222379     2.37789e-02
  282.500      253.229          1.0000            1.05401          0.988476       103.158      39.973     0.536455     0.221656     2.22810e-02
  280.000      253.831          1.0000            1.05610          0.988295       103.158      39.564     0.539093     0.220945     2.08682e-02
  277.500      254.412          1.0000            1.05818          0.988089       103.158      39.163     0.541714     0.220246     1.95359e-02
  275.000      254.972          1.0000            1.06025          0.987859       103.158      38.769     0.544318     0.219558     1.82801e-02
  272.500      255.511          1.0000            1.06231          0.987604       103.158      38.382     0.546905     0.218882     1.70967e-02
  270.000      256.030          1.0000            1.06436          0.987324       103.158      38.002     0.549476     0.218217     1.59821e-02
  267.500      256.527          1.0000            1.06641          0.987019       103.158      37.629     0.552029     0.217562     1.49326e-02
  265.000      257.004          1.0000            1.06844          0.986690       103.158      37.263     0.554566     0.216919     1.39449e-02
  262.500      257.460          1.0000            1.07047          0.986335       103.158      36.903     0.557086     0.216286     1.30157e-02
  260.000      257.894          1.0000            1.07248          0.985955       103.158      36.549     0.559591     0.215663     1.21418e-02
  257.500      258.308          1.0000            1.07448          0.985549       103.158      36.201     0.562079     0.215050     1.13204e-02
  255.000      258.699          1.0000            1.07647          0.985118       103.158      35.860     0.564551     0.214448     1.05487e-02
  252.500      259.070          1.0000            1.07845          0.984661       103.158      35.524     0.567007     0.213855     9.82395e-03
  250.000      259.419          1.0000            1.08041          0.984178       103.158      35.194     0.569448     0.213272     9.14366e-03
  247.500      259.746          1.0000            1.08236          0.983669       103.158      34.869     0.571873     0.212699     8.50542e-03
  245.000      260.052          1.0000            1.08429          0.983133       103.158      34.551     0.574283     0.212135     7.90692e-03
  242.500      260.336          1.0000            1.08621          0.982571       103.158      34.237     0.576677     0.211580     7.34598e-03
  240.000      260.598          1.0000            1.08811          0.981982       103.158      33.929     0.579056     0.211034     6.82052e-03
  237.500      260.837          1.0000            1.08999          0.981366       103.158      33.625     0.581420     0.210498     6.32857e-03
  235.000      261.055          1.0000            1.09186          0.980723       103.158      33.327     0.583769     0.209970     5.86824e-03
  232.500      261.251          1.0000            1.09371          0.980051       103.158      33.034     0.586104     0.209451     5.43774e-03
  230.000      261.424          1.0000            1.09553          0.979352       103.158      32.745     0.588423     0.208940     5.03539e-03
  227.500      261.574          1.0000            1.09734          0.978624       103.158      32.461     0.590729     0.208438     4.65956e-03
  225.000      261.702          1.0000            1.09912          0.977867       103.158      32.182     0.593019     0.207944     4.30871e-03
  222.500      261.807          1.0000            1.10088          0.977081       103.158      31.907     0.595296     0.207458     3.98141e-03
  220.000      261.890          1.0000            1.10262          0.976266       103.158      31.637     0.597558     0.206981     3.67625e-03
  217.500      261.949          1.0000            1.10434          0.975421       103.158      31.371     0.599806     0.206511     3.39193e-03
  215.000      261.985          1.0000            1.10603          0.974545       103.158      31.109     0.602040     0.206049     3.12721e-03
  212.500      261.998          1.0000            1.10769          0.973639       103.158      30.851     0.604260     0.205596     2.88089e-03
  210.000      261.987          1.0000            1.10932          0.972701       103.158      30.598     0.606467     0.205150     2.65187e-03
  207.500      261.953          1.0000            1.11093          0.971732       103.158      30.348     0.608660     0.204711     2.43908e-03
  205.000      261.895          1.0000            1.11251          0.970731       103.158      30.102     0.610839     0.204280     2.24151e-03
  202.500      261.813          1.0000            1.11406          0.969697       103.158      29.860     0.613005     0.203857     2.05822e-03
  200.000      261.707          1.0000            1.11557          0.968629       103.158      29.622     0.615158     0.203440     1.88829e-03
  197.500      261.577          1.0000            1.11706          0.967528       103.158      29.387     0.617297     0.203031     1.73089e-03
  195.000      261.423          1.0000            1.11851          0.966393       103.158      29.156     0.619423     0.202630     1.58519e-03
  192.500      261.244          1.0000            1.11992          0.965223       103.158      28.929     0.621537     0.202235     1.45045e-03
  190.000      261.040          1.0000            1.12130          0.964017       103.158      28.705     0.623637     0.201848     1.32593e-03
  187.500      260.812          1.0000            1.12264          0.962776       103.158      28.484     0.625725     0.201467     1.21097e-03
  185.000      260.558          1.0000            1.12394          0.961497       103.158      28.267     0.627799     0.201094     1.10491e-03
  182.500      260.279          1.0000            1.12520          0.960181       103.158      28.053     0.629862     0.200727     1.00716e-03
  180.000      259.975          1.0000            1.12642          0.958827       103.158      27.843     0.631911     0.200367     9.17152e-04
  177.500      259.645          1.0000            1.12760          0.957435       103.158      27.635     0.633948     0.200014     8.34339e-04
  175.000      259.290          1.0000            1.12873          0.956003       103.158      27.431     0.635973     0.199667     7.58221e-04
  172.500      258.908          1.0000            1.12982          0.954530       103.158      27.229     0.637986     0.199327     6.88324e-04
  170.000      258.500          1.0000            1.13085          0.953017       103.158      27.031     0.639987     0.198993     6.24202e-04
  167.500      258.066          1.0000            1.13184          0.951461       103.158      26.836     0.641975     0.198666     5.65436e-04
  165.000      257.605          1.0000            1.13278          0.949864       103.158      26.643     0.643952     0.198346     5.11633e-04
  162.500      257.117          1.0000            1.13367          0.948222       103.158      26.454     0.645916     0.198032     4.62426e-04
  160.000      256.603          1.0000            1.13450          0.946537       103.158      26.267     0.647869     0.197724     4.17468e-04
  157.500      256.061          1.0000            1.13527          0.944806       103.158      26.083     0.649810     0.197422     3.76438e-04
  155.000      255.491          1.0000            1.13599          0.943029       103.158      25.901     0.651740     0.197126     3.39033e-04
  152.500      254.894          1.0000            1.13664          0.941205       103.158      25.723     0.653658     0.196837     3.04971e-04
  150.000      254.269          1.0000            1.13724          0.939332       103.158      25.547     0.655564     0.196554     2.73989e-04
  147.500      253.615          1.0000            1.13777          0.937411       103.158      25.373     0.657459     0.196276     2.45841e-04
  145.000      252.934          1.0000            1.13823          0.935439       103.158      25.202     0.659343     0.196005     2.20299e-04
  142.500      252.223          1.0000            1.13863          0.933416       103.158      25.034     0.661216     0.195739     1.97149e-04
  140.000      251.484          1.0000            1.13895          0.931341       103.158      24.868     0.663077     0.195480     1.76193e-04
  137.500      250.715          1.0000            1.13920          0.929213       103.158      24.705     0.664928     0.195226     1.57247e-04
  135.000      249.917          1.0000            1.13938          0.927030       103.158      24.543     0.666768     0.194978     1.40141e-04
  132.500      249.089          1.0000            1.13948          0.924790       103.158      24.385     0.668596     0.194735     1.24717e-04
  130.000      248.231          1.0000            1.13950          0.922494       103.158      24.228     0.670414     0.194498     1.10827e-04
  127.500      247.343          1.0000            1.13944          0.920140       103.158      24.074     0.672221     0.194266     9.83362e-05
  125.000      246.425          1.0000            1.13929          0.917726       103.158      23.922     0.674018     0.194040     8.71199e-05
  122.500      245.475          1.0000            1.13905          0.915250       103.158      23.772     0.675804     0.193819     7.70621e-05
  120.000      244.494          1.0000            1.13872          0.912713       103.158      23.625     0.677579     0.193604     6.80565e-05
  117.500      243.482          1.0000            1.13830          0.910111       103.158      23.480     0.679344     0.193393     6.00050e-05
  115.000      242.438          1.0000            1.13778          0.907444       103.158      23.336     0.681099     0.193188     5.28177e-05
  112.500      241.362          1.0000            1.13716          0.904710       103.158      23.195     0.682843     0.192987     4.64118e-05
  110.000      240.254          1.0000            1.13644          0.901908       103.158      23.056     0.684577     0.192792     4.07115e-05
  107.500      239.113          1.0000            1.13561          0.899036       103.158      22.919     0.686301     0.192601     3.56474e-05
  105.000      237.939          1.0000            1.13467          0.896092       103.158      22.784     0.688015     0.192415     3.11561e-05
  102.500      236.731          1.0000            1.13362          0.893075       103.158      22.651     0.689720     0.192233     2.71796e-05
  100.000      235.490          1.0000            1.13245          0.889982       103.158      22.519     0.691414     0.192056     2.36651e-05
   97.500      234.215          1.0000            1.13116          0.886813       103.158      22.390     0.693098     0.191883     2.05645e-05
   95.000      232.905          1.0000            1.12974          0.883565       103.158      22.262     0.694772     0.191714     1.78340e-05
   92.500      231.561          1.0000            1.12820          0.880236       103.158      22.137     0.696437     0.191549     1.54342e-05
   90.000      230.181          1.0000            1.12652          0.876824       103.158      22.013     0.698092     0.191388     1.33289e-05
   87.500      228.766          1.0000            1.12470          0.873328       103.158      21.891     0.699738     0.191231     1.14858e-05
   85.000      227.315          1.0000            1.12274          0.869745       103.158      21.771     0.701374     0.191077     9.87538e-06
   82.500      225.827          1.0000            1.12064          0.866072       103.158      21.652     0.703001     0.190927     8.47131e-06
   80.000      224.303          1.0000            1.11838          0.862309       103.158      21.535     0.704618     0.190779     7.24975e-06
   77.500      222.742          1.0000            1.11597          0.858452       103.158      21.420     0.706226     0.190635     6.18931e-06
   75.000      221.143          1.0000            1.11340          0.854500       103.158      21.307     0.707824     0.190493     5.27083e-06
   72.500      219.507          1.0000            1.11066          0.850449       103.158      21.195     0.709414     0.190353     4.47714e-06
   70.000      217.832          1.0000            1.10774          0.846298       103.158      21.085     0.710994     0.190216     3.79295e-06
   67.500      216.118          1.0000            1.10465          0.842044       103.158      20.976     0.712566     0.190081     3.20459e-06
   65.000      214.365          1.0000            1.10138          0.837684       103.158      20.869     0.714128     0.189947     2.69992e-06
   62.500      212.572          1.0000            1.09791          0.833215       103.158      20.763     0.715682     0.189814     2.26816e-06
   60.000      210.740          1.0000            1.09425          0.828636       103.158      20.659     0.717226     0.189682     1.89978e-06
   57.500      208.866          1.0000            1.09039          0.823942       103.158      20.557     0.718762     0.189551     1.58634e-06
   55.000      206.952          1.0000            1.08632          0.819131       103.158      20.456     0.720289     0.189420     1.32041e-06
   52.500      204.996          1.0000            1.08203          0.814201       103.158      20.356     0.721808     0.189289     1.09546e-06
   50.000      202.998          1.0000            1.07752          0.809148       103.158      20.258     0.723317     0.189156     9.05748e-07
   47.500      200.958          1.0000            1.07278          0.803969       103.158      20.161     0.724819     0.189023     7.46259e-07
   45.000      198.874          1.0000            1.06780          0.798660       103.158      20.066     0.726311     0.188888     6.12616e-07
   42.500      196.747          1.0000            1.06258          0.793219       103.158      19.972     0.727796     0.188750     5.01009e-07
   40.000      194.576          1.0000            1.05710          0.787642       103.158      19.879     0.729272     0.188609     4.08129e-07
   37.500      192.360          1.0000            1.05136          0.781927       103.158      19.787     0.730740     0.188465     3.31114e-07
   35.000      190.100          1.0000            1.04534          0.776068       103.158      19.697     0.732199     0.188316     2.67495e-07
   32.500      187.793          1.0000            1.03905          0.770064       103.158      19.608     0.733650     0.188161     2.15147e-07
   30.000      185.441          1.0000            1.03246          0.763909       103.158      19.520     0.735093     0.188001     1.72247e-07
   27.500      183.042          1.0000            1.02557          0.757602       103.158      19.434     0.736529     0.187833     1.37241e-07
   25.000      180.595          1.0000            1.01838          0.751137       103.158      19.348     0.737956     0.187657     1.08800e-07
   22.500      178.101          1.0000            1.01086          0.744512       103.158      19.264     0.739375     0.187471     8.58006e-08
   20.000      175.558          1.0000            1.00301          0.737722       103.158      19.181     0.740786     0.187274     6.72908e-08
   17.500      172.966          1.0000            0.99482          0.730764       103.158      19.099     0.742190     0.187066     5.24692e-08
   15.775      171.149          1.0000            0.98896          0.725863       103.158      19.043     0.743154     0.186914     4.40360e-08
END

set output "Figures/Env_001_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_001_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab1_Recombined_Oil\n with Lab1_Swelling_Gas at 96 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-12        1.00000e+00        2.49017e-13        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-12        1.00000e+00        4.98034e-13        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-12        1.00000e+00        1.24509e-12        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-11        1.00000e+00        2.49017e-12        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-11        1.00000e+00        4.98034e-12        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-11        1.00000e+00        1.24509e-11        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-10        1.00000e+00        2.49017e-11        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-10        1.00000e+00        4.98034e-11        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-10        1.00000e+00        1.24509e-10        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-09        1.00000e+00        2.49017e-10        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-09        1.00000e+00        4.98034e-10        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-09        1.00000e+00        1.24509e-09        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-08        1.00000e+00        2.49017e-09        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-08        1.00000e+00        4.98034e-09        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-08        1.00000e+00        1.24509e-08        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-07        1.00000e+00        2.49017e-08        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-07        1.00000e+00        4.98034e-08        1.00000e+00       3.84912e-09        0.00000         8.22366e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-07        1.00000e+00        1.24509e-07        1.00000e+00       3.84913e-09        0.00000         8.22367e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   1.00000e-06        9.99999e-01        2.49017e-07        1.00000e+00       3.84913e-09        0.00000         8.22367e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   2.00000e-06        9.99998e-01        4.98035e-07        1.00000e+00       3.84913e-09        0.00000         8.22368e-11         1.00000        602.881     103.158     0.919372     1.29368e-11     2.89746e-13
   5.00000e-06        9.99995e-01        1.24509e-06        9.99999e-01       3.84914e-09        0.00000         8.22370e-11         1.00000        602.881     103.157     0.919372     1.29368e-11     2.89746e-13
   1.00000e-05        9.99990e-01        2.49019e-06        9.99998e-01       3.84916e-09        0.00000         8.22374e-11         1.00000        602.881     103.157     0.919372     1.29368e-11     2.89746e-13
   2.00000e-05        9.99980e-01        4.98042e-06        9.99995e-01       3.84920e-09        0.00000         8.22383e-11         1.00000        602.881     103.156     0.919372     1.29369e-11     2.89746e-13
   5.00000e-05        9.99950e-01        1.24513e-05        9.99988e-01       3.84932e-09        0.00000         8.22407e-11         1.00000        602.881     103.154     0.919372     1.29370e-11     2.89746e-13
   1.00000e-04        9.99900e-01        2.49036e-05        9.99975e-01       3.84951e-09        0.00000         8.22448e-11         1.00000        602.881     103.150     0.919372     1.29371e-11     2.89746e-13
   2.00000e-04        9.99800e-01        4.98109e-05        9.99950e-01       3.84989e-09        0.00000         8.22531e-11         1.00000        602.881     103.142     0.919372     1.29374e-11     2.89746e-13
   5.00000e-04        9.99500e-01        1.24555e-04        9.99875e-01       3.85105e-09        0.00000         8.22778e-11         1.00000        602.881     103.119     0.919372     1.29384e-11     2.89746e-13
   1.00000e-03        9.99000e-01        2.49204e-04        9.99751e-01       3.85298e-09        0.00000         8.23189e-11         1.00000        602.881     103.080     0.919372     1.29400e-11     2.89746e-13
   2.00000e-03        9.98000e-01        4.98783e-04        9.99501e-01       3.85684e-09        0.00000         8.24014e-11         1.00000        602.881     103.003     0.919372     1.29433e-11     2.89746e-13
   5.00000e-03        9.95000e-01        1.24978e-03        9.98750e-01       3.86847e-09        0.00000         8.26499e-11         1.00000        602.881     102.770     0.919372     1.29530e-11     2.89746e-13
   1.00000e-02        9.90000e-01        2.50901e-03        9.97491e-01       3.88800e-09        0.00000         8.30673e-11         1.00000        602.881     102.383     0.919372     1.29693e-11     2.89746e-13
   2.00000e-02        9.80000e-01        5.05629e-03        9.94944e-01       3.92768e-09        0.00000         8.39149e-11         1.00000        602.881     101.608     0.919372     1.30025e-11     2.89746e-13
   3.00000e-02        9.70000e-01        7.64270e-03        9.92357e-01       3.96817e-09        0.00000         8.47800e-11         1.00000        602.881     100.834     0.919372     1.30364e-11     2.89746e-13
   4.00000e-02        9.60000e-01        1.02692e-02        9.89731e-01       4.00950e-09        0.00000         8.56631e-11         1.00000        602.881     100.059     0.919372     1.30710e-11     2.89746e-13
   5.00000e-02        9.50000e-01        1.29366e-02        9.87063e-01       4.05171e-09        0.00000         8.65649e-11         1.00000        602.881      99.284     0.919372     1.31063e-11     2.89746e-13
   6.00000e-02        9.40000e-01        1.56460e-02        9.84354e-01       4.09481e-09        0.00000         8.74858e-11         1.00000        602.881      98.510     0.919372     1.31424e-11     2.89746e-13
   7.00000e-02        9.30000e-01        1.83984e-02        9.81602e-01       4.13884e-09        0.00000         8.84265e-11         1.00000        602.881      97.735     0.919372     1.31793e-11     2.89746e-13
   8.00000e-02        9.20000e-01        2.11947e-02        9.78805e-01       4.18383e-09        0.00000         8.93876e-11         1.00000        602.881      96.960     0.919372     1.32169e-11     2.89746e-13
   9.00000e-02        9.10000e-01        2.40361e-02        9.75964e-01       4.22981e-09        0.00000         9.03699e-11         1.00000        602.881      96.185     0.919372     1.32554e-11     2.89746e-13
   1.00000e-01        9.00000e-01        2.69236e-02        9.73076e-01       4.27680e-09        0.00000         9.13740e-11         1.00000        602.881      95.411     0.919372     1.32947e-11     2.89746e-13
   1.10000e-01        8.90000e-01        2.98584e-02        9.70142e-01       4.32486e-09        0.00000         9.24007e-11         1.00000        602.881      94.636     0.919372     1.33350e-11     2.89746e-13
   1.20000e-01        8.80000e-01        3.28417e-02        9.67158e-01       4.37400e-09        0.00000         9.34507e-11         1.00000        602.881      93.861     0.919372     1.33761e-11     2.89746e-13
   1.30000e-01        8.70000e-01        3.58746e-02        9.64125e-01       4.42428e-09        0.00000         9.45248e-11         1.00000        602.881      93.087     0.919372     1.34182e-11     2.89746e-13
   1.40000e-01        8.60000e-01        3.89584e-02        9.61042e-01       4.47573e-09        0.00000         9.56240e-11         1.00000        602.881      92.312     0.919372     1.34612e-11     2.89746e-13
   1.50000e-01        8.50000e-01        4.20944e-02        9.57906e-01       4.52838e-09        0.00000         9.67490e-11         1.00000        602.881      91.537     0.919372     1.35053e-11     2.89746e-13
   1.60000e-01        8.40000e-01        4.52839e-02        9.54716e-01       4.58229e-09        0.00000         9.79007e-11         1.00000        602.881      90.763     0.919372     1.35504e-11     2.89746e-13
   1.70000e-01        8.30000e-01        4.85284e-02        9.51472e-01       4.63750e-09        0.00000         9.90803e-11         1.00000        602.881      89.988     0.919372     1.35966e-11     2.89746e-13
   1.80000e-01        8.20000e-01        5.18292e-02        9.48171e-01       4.69405e-09        0.00000         1.00289e-10         1.00000        602.881      89.213     0.919372     1.36439e-11     2.89746e-13
   1.90000e-01        8.10000e-01        5.51878e-02        9.44812e-01       4.75201e-09        0.00000         1.01527e-10         1.00000        602.881      88.438     0.919372     1.36925e-11     2.89746e-13
   2.00000e-01        8.00000e-01        5.86058e-02        9.41394e-01       4.81141e-09        0.00000         1.02796e-10         1.00000        602.881      87.664     0.919372     1.37422e-11     2.89746e-13
   2.10000e-01        7.90000e-01        6.20848e-02        9.37915e-01       4.87231e-09        0.00000         1.04097e-10         1.00000        602.881      86.889     0.919372     1.37931e-11     2.89746e-13
   2.20000e-01        7.80000e-01        6.56263e-02        9.34374e-01       4.93477e-09        0.00000         1.05432e-10         1.00000        602.881      86.114     0.919372     1.38454e-11     2.89746e-13
   2.30000e-01        7.70000e-01        6.92321e-02        9.30768e-01       4.99886e-09        0.00000         1.06801e-10         1.00000        602.881      85.340     0.919372     1.38991e-11     2.89746e-13
   2.40000e-01        7.60000e-01        7.29040e-02        9.27096e-01       5.06464e-09        0.00000         1.08206e-10         1.00000        602.881      84.565     0.919372     1.39541e-11     2.89746e-13
   2.50000e-01        7.50000e-01        7.66438e-02        9.23356e-01       5.13217e-09        0.00000         1.09649e-10         1.00000        602.881      83.790     0.919372     1.40106e-11     2.89746e-13
   2.60000e-01        7.40000e-01        8.04534e-02        9.19547e-01       5.20152e-09        0.00000         1.11131e-10         1.00000        602.881      83.016     0.919372     1.40687e-11     2.89746e-13
   2.70000e-01        7.30000e-01        8.43348e-02        9.15665e-01       5.27277e-09        0.00000         1.12653e-10         1.00000        602.881      82.241     0.919372     1.41283e-11     2.89746e-13
   2.80000e-01        7.20000e-01        8.82900e-02        9.11710e-01       5.34601e-09        0.00000         1.14218e-10         1.00000        602.881      81.466     0.919372     1.41896e-11     2.89746e-13
   2.90000e-01        7.10000e-01        9.23211e-02        9.07679e-01       5.42130e-09        0.00000         1.15826e-10         1.00000        602.881      80.692     0.919372     1.42526e-11     2.89746e-13
   3.00000e-01        7.00000e-01        9.64304e-02        9.03570e-01       5.49875e-09        0.00000         1.17481e-10         1.00000        602.881      79.917     0.919372     1.43174e-11     2.89746e-13
   3.10000e-01        6.90000e-01        1.00620e-01        8.99380e-01       5.57844e-09        0.00000         1.19183e-10         1.00000        602.881      79.142     0.919372     1.43841e-11     2.89746e-13
   3.20000e-01        6.80000e-01        1.04893e-01        8.95107e-01       5.66048e-09        0.00000         1.20936e-10         1.00000        602.881      78.367     0.919372     1.44528e-11     2.89746e-13
   3.30000e-01        6.70000e-01        1.09251e-01        8.90749e-01       5.74496e-09        0.00000         1.22741e-10         1.00000        602.881      77.593     0.919372     1.45235e-11     2.89746e-13
   3.40000e-01        6.60000e-01        1.13696e-01        8.86304e-01       5.83201e-09        0.00000         1.24601e-10         1.00000        602.881      76.818     0.919372     1.45963e-11     2.89746e-13
   3.50000e-01        6.50000e-01        1.18233e-01        8.81767e-01       5.92173e-09        0.00000         1.26518e-10         1.00000        602.881      76.043     0.919372     1.46714e-11     2.89746e-13
   3.60000e-01        6.40000e-01        1.22863e-01        8.77137e-01       6.01426e-09        0.00000         1.28495e-10         1.00000        602.881      75.269     0.919372     1.47489e-11     2.89746e-13
   3.70000e-01        6.30000e-01        1.27589e-01        8.72411e-01       6.10972e-09        0.00000         1.30534e-10         1.00000        602.881      74.494     0.919372     1.48288e-11     2.89746e-13
   3.80000e-01        6.20000e-01        1.32414e-01        8.67586e-01       6.20826e-09        0.00000         1.32640e-10         1.00000        602.881      73.719     0.919372     1.49113e-11     2.89746e-13
   3.90000e-01        6.10000e-01        1.37342e-01        8.62658e-01       6.31004e-09        0.00000         1.34814e-10         1.00000        602.881      72.945     0.919372     1.49964e-11     2.89746e-13
   4.00000e-01        6.00000e-01        1.42375e-01        8.57625e-01       6.41521e-09        0.00000         1.37061e-10         1.00000        602.881      72.170     0.919372     1.50845e-11     2.89746e-13
   4.10000e-01        5.90000e-01        1.47518e-01        8.52482e-01       6.52394e-09        0.00000         1.39384e-10         1.00000        602.881      71.395     0.919372     1.51755e-11     2.89746e-13
   4.20000e-01        5.80000e-01        1.52774e-01        8.47226e-01       6.63642e-09        0.00000         1.41787e-10         1.00000        602.881      70.620     0.919372     1.52696e-11     2.89746e-13
   4.30000e-01        5.70000e-01        1.58146e-01        8.41854e-01       6.75285e-09        0.00000         1.44275e-10         1.00000        602.881      69.846     0.919372     1.53670e-11     2.89746e-13
   4.40000e-01        5.60000e-01        1.63639e-01        8.36361e-01       6.87344e-09        0.00000         1.46851e-10         1.00000        602.881      69.071     0.919372     1.54680e-11     2.89746e-13
   4.50000e-01        5.50000e-01        1.69257e-01        8.30743e-01       6.99841e-09        0.00000         1.49521e-10         1.00000        602.881      68.296     0.919372     1.55726e-11     2.89746e-13
   4.60000e-01        5.40000e-01        1.75003e-01        8.24997e-01       7.12801e-09        0.00000         1.52290e-10         1.00000        602.881      67.522     0.919372     1.56810e-11     2.89746e-13
   4.70000e-01        5.30000e-01        1.80883e-01        8.19117e-01       7.26250e-09        0.00000         1.55163e-10         1.00000        602.881      66.747     0.919372     1.57936e-11     2.89746e-13
   4.80000e-01        5.20000e-01        1.86901e-01        8.13099e-01       7.40216e-09        0.00000         1.58147e-10         1.00000        602.881      65.972     0.919372     1.59105e-11     2.89746e-13
   4.90000e-01        5.10000e-01        1.93061e-01        8.06939e-01       7.54730e-09        0.00000         1.61248e-10         1.00000        602.881      65.198     0.919372     1.60319e-11     2.89746e-13
   5.00000e-01        5.00000e-01        1.99370e-01        8.00630e-01       7.69825e-09        0.00000         1.64473e-10         1.00000        602.881      64.423     0.919372     1.61583e-11     2.89746e-13
   5.10000e-01        4.90000e-01        2.05833e-01        7.94167e-01       7.85536e-09        0.00000         1.67830e-10         1.00000        602.881      63.648     0.919372     1.62898e-11     2.89746e-13
   5.20000e-01        4.80000e-01        2.12455e-01        7.87545e-01       8.01901e-09        0.00000         1.71326e-10         1.00000        602.881      62.873     0.919372     1.64267e-11     2.89746e-13
   5.30000e-01        4.70000e-01        2.19242e-01        7.80758e-01       8.18963e-09        0.00000         1.74972e-10         1.00000        602.881      62.099     0.919372     1.65695e-11     2.89746e-13
   5.40000e-01        4.60000e-01        2.26201e-01        7.73799e-01       8.36766e-09        0.00000         1.78775e-10         1.00000        602.881      61.324     0.919372     1.67185e-11     2.89746e-13
   5.50000e-01        4.50000e-01        2.33337e-01        7.66663e-01       8.55361e-09        0.00000         1.82748e-10         1.00000        602.881      60.549     0.919372     1.68742e-11     2.89746e-13
   5.60000e-01        4.40000e-01        2.40659e-01        7.59341e-01       8.74801e-09        0.00000         1.86901e-10         1.00000        602.881      59.775     0.919372     1.70369e-11     2.89746e-13
   5.70000e-01        4.30000e-01        2.48173e-01        7.51827e-01       8.95145e-09        0.00000         1.91248e-10         1.00000        602.881      59.000     0.919372     1.72071e-11     2.89746e-13
   5.80000e-01        4.20000e-01        2.55886e-01        7.44114e-01       9.16458e-09        0.00000         1.95801e-10         1.00000        602.881      58.225     0.919372     1.73855e-11     2.89746e-13
   5.90000e-01        4.10000e-01        2.63808e-01        7.36192e-01       9.38811e-09        0.00000         2.00577e-10         1.00000        602.881      57.451     0.919372     1.75726e-11     2.89746e-13
   6.00000e-01        4.00000e-01        2.71947e-01        7.28053e-01       9.62281e-09        0.00000         2.05592e-10         1.00000        602.881      56.676     0.919372     1.77690e-11     2.89746e-13
   6.10000e-01        3.90000e-01        2.80311e-01        7.19689e-01       9.86955e-09        0.00000         2.10863e-10         1.00000        602.881      55.901     0.919372     1.79755e-11     2.89746e-13
   6.20000e-01        3.80000e-01        2.88910e-01        7.11090e-01       1.01293e-08        0.00000         2.16412e-10         1.00000        602.881      55.127     0.919372     1.81929e-11     2.89746e-13
   6.30000e-01        3.70000e-01        2.97754e-01        7.02246e-01       1.04030e-08        0.00000         2.22261e-10         1.00000        602.881      54.352     0.919372     1.84220e-11     2.89746e-13
   6.40000e-01        3.60000e-01        3.06854e-01        6.93146e-01       1.06920e-08        0.00000         2.28435e-10         1.00000        602.881      53.577     0.919372     1.86639e-11     2.89746e-13
   6.50000e-01        3.50000e-01        3.16221e-01        6.83779e-01       1.09975e-08        0.00000         2.34962e-10         1.00000        602.881      52.802     0.919372     1.89195e-11     2.89746e-13
   6.60000e-01        3.40000e-01        3.25867e-01        6.74133e-01       1.13210e-08        0.00000         2.41872e-10         1.00000        602.881      52.028     0.919372     1.91903e-11     2.89746e-13
   6.70000e-01        3.30000e-01        3.35804e-01        6.64196e-01       1.16640e-08        0.00000         2.49202e-10         1.00000        602.881      51.253     0.919372     1.94774e-11     2.89746e-13
   6.80000e-01        3.20000e-01        3.46047e-01        6.53953e-01       1.20285e-08        0.00000         2.56989e-10         1.00000        602.881      50.478     0.919372     1.97824e-11     2.89746e-13
   6.90000e-01        3.10000e-01        3.56609e-01        6.43391e-01       1.24165e-08        0.00000         2.65279e-10         1.00000        602.881      49.704     0.919372     2.01072e-11     2.89746e-13
   7.00000e-01        3.00000e-01        3.67505e-01        6.32495e-01       1.28304e-08        0.00000         2.74122e-10         1.00000        602.881      48.929     0.919372     2.04536e-11     2.89746e-13
   7.10000e-01        2.90000e-01        3.78752e-01        6.21248e-01       1.32728e-08        0.00000         2.83575e-10         1.00000        602.881      48.154     0.919372     2.08239e-11     2.89746e-13
   7.20000e-01        2.80000e-01        3.90366e-01        6.09634e-01       1.37469e-08        0.00000         2.93702e-10         1.00000        602.881      47.380     0.919372     2.12206e-11     2.89746e-13
   7.30000e-01        2.70000e-01        4.02367e-01        5.97633e-01       1.42560e-08        0.00000         3.04580e-10         1.00000        602.881      46.605     0.919372     2.16467e-11     2.89746e-13
   7.40000e-01        2.60000e-01        4.14774e-01        5.85226e-01       1.48043e-08        0.00000         3.16295e-10         1.00000        602.881      45.830     0.919372     2.21056e-11     2.89746e-13
   7.50000e-01        2.50000e-01        4.27607e-01        5.72393e-01       1.53965e-08        0.00000         3.28946e-10         1.00000        602.881      45.055     0.919372     2.26012e-11     2.89746e-13
   7.60000e-01        2.40000e-01        4.40889e-01        5.59111e-01       1.60380e-08        0.00000         3.42653e-10         1.00000        602.881      44.281     0.919372     2.31382e-11     2.89746e-13
   7.70000e-01        2.30000e-01        4.54644e-01        5.45356e-01       1.67353e-08        0.00000         3.57550e-10         1.00000        602.881      43.506     0.919372     2.37218e-11     2.89746e-13
   7.80000e-01        2.20000e-01        4.68898e-01        5.31102e-01       1.74960e-08        0.00000         3.73803e-10         1.00000        602.881      42.731     0.919372     2.43584e-11     2.89746e-13
   7.90000e-01        2.10000e-01        4.83679e-01        5.16321e-01       1.83292e-08        0.00000         3.91603e-10         1.00000        602.881      41.957     0.919372     2.50557e-11     2.89746e-13
   8.00000e-01        2.00000e-01        4.99015e-01        5.00985e-01       1.92456e-08        0.00000         4.11183e-10         1.00000        602.881      41.182     0.919372     2.58227e-11     2.89746e-13
   8.10000e-01        1.90000e-01        5.14940e-01        4.85060e-01       2.02585e-08        0.00000         4.32824e-10         1.00000        602.881      40.407     0.919372     2.66705e-11     2.89746e-13
   8.20000e-01        1.80000e-01        5.31487e-01        4.68513e-01       2.13840e-08        0.00000         4.56870e-10         1.00000        602.881      39.633     0.919372     2.76124e-11     2.89746e-13
   8.30000e-01        1.70000e-01        5.48694e-01        4.51306e-01       2.26419e-08        0.00000         4.83745e-10         1.00000        602.881      38.858     0.919372     2.86652e-11     2.89746e-13
   8.40000e-01        1.60000e-01        5.66600e-01        4.33400e-01       2.40570e-08        0.00000         5.13979e-10         1.00000        602.881      38.083     0.919372     2.98496e-11     2.89746e-13
   8.50000e-01        1.50000e-01        5.85251e-01        4.14749e-01       2.56608e-08        0.00000         5.48244e-10         1.00000        602.881      37.308     0.919372     3.11919e-11     2.89746e-13
   8.60000e-01        1.40000e-01        6.04693e-01        3.95307e-01       2.74937e-08        0.00000         5.87404e-10         1.00000        602.881      36.534     0.919372     3.27259e-11     2.89746e-13
   8.70000e-01        1.30000e-01        6.24976e-01        3.75024e-01       2.96086e-08        0.00000         6.32589e-10         1.00000        602.881      35.759     0.919372     3.44960e-11     2.89746e-13
   8.80000e-01        1.20000e-01        6.46159e-01        3.53841e-01       3.20760e-08        0.00000         6.85305e-10         1.00000        602.881      34.984     0.919372     3.65610e-11     2.89746e-13
   8.90000e-01        1.10000e-01        6.68300e-01        3.31700e-01       3.49920e-08        0.00000         7.47606e-10         1.00000        602.881      34.210     0.919372     3.90015e-11     2.89746e-13
   9.00000e-01        1.00000e-01        6.91468e-01        3.08532e-01       3.84912e-08        0.00000         8.22366e-10         1.00000        602.881      33.435     0.919372     4.19301e-11     2.89746e-13
   9.10000e-01        9.00000e-02        7.15735e-01        2.84265e-01       4.27680e-08        0.00000         9.13740e-10         1.00000        602.881      32.660     0.919372     4.55096e-11     2.89746e-13
   9.20000e-01        8.00000e-02        7.41181e-01        2.58819e-01       4.81141e-08        0.00000         1.02796e-09         1.00000        602.881      31.886     0.919372     4.99839e-11     2.89746e-13
   9.30000e-01        7.00000e-02        7.67894e-01        2.32106e-01       5.49875e-08        0.00000         1.17481e-09         1.00000        602.881      31.111     0.919372     5.57365e-11     2.89746e-13
   9.40000e-01        6.00000e-02        7.95971e-01        2.04029e-01       6.41521e-08        0.00000         1.37061e-09         1.00000        602.881      30.336     0.919372     6.34067e-11     2.89746e-13
   9.50000e-01        5.00000e-02        8.25520e-01        1.74480e-01       7.69825e-08        0.00000         1.64473e-09         1.00000        602.881      29.562     0.919372     7.41450e-11     2.89746e-13
   9.60000e-01        4.00000e-02        8.56660e-01        1.43340e-01       9.62281e-08        0.00000         2.05592e-09         1.00000        602.881      28.787     0.919372     9.02524e-11     2.89746e-13
   9.70000e-01        3.00000e-02        8.89522e-01        1.10478e-01       1.28304e-07        0.00000         2.74122e-09         1.00000        602.881      28.012     0.919372     1.17098e-10     2.89746e-13
   9.80000e-01        2.00000e-02        9.24253e-01        7.57470e-02       1.92456e-07        0.00000         4.11183e-09         1.00000        602.881      27.237     0.919372     1.70789e-10     2.89746e-13
   9.90000e-01        1.00000e-02        9.61018e-01        3.89823e-02       3.84912e-07        0.00000         8.22366e-09         1.00000        602.881      26.463     0.919372     3.31864e-10     2.89746e-13
   9.95000e-01        5.00000e-03        9.80219e-01        1.97807e-02       7.69825e-07        0.00000         1.64473e-08         1.00000        602.881      26.075     0.919372     6.54012e-10     2.89746e-13
   9.98000e-01        2.00000e-03        9.92017e-01        7.98342e-03       1.92456e-06        0.00000         4.11183e-08         1.00000        602.881      25.843     0.919372     1.62046e-09     2.89746e-13
   9.99000e-01        1.00000e-03        9.95996e-01        4.00371e-03       3.84913e-06        0.00000         8.22366e-08         1.00000        602.881      25.766     0.919372     3.23120e-09     2.89746e-13
   9.99500e-01        5.00000e-04        9.97995e-01        2.00487e-03       7.69825e-06        0.00000         1.64473e-07         1.00000        602.881      25.727     0.919372     6.45269e-09     2.89746e-13
   9.99800e-01        2.00000e-04        9.99197e-01        8.02674e-04       1.92457e-05        0.00000         4.11184e-07         1.00000        602.881      25.704     0.919372     1.61172e-08     2.89747e-13
   9.99900e-01        1.00000e-04        9.99599e-01        4.01458e-04       3.84914e-05        0.00000         8.22369e-07         1.00000        602.881      25.696     0.919372     3.22247e-08     2.89747e-13
   9.99950e-01        5.00000e-05        9.99799e-01        2.00759e-04       7.69831e-05        0.00000         1.64474e-06         1.00000        602.880      25.692     0.919372     6.44399e-08     2.89749e-13
   9.99980e-01        2.00000e-05        9.99920e-01        8.03109e-05       1.92460e-04        0.00000         4.11189e-06         1.00000        602.879      25.690     0.919372     1.61087e-07     2.89753e-13
   9.99990e-01        1.00000e-05        9.99960e-01        4.01567e-05       3.84927e-04        0.00000         8.22391e-06         1.00000        602.877      25.689     0.919372     3.22170e-07     2.89759e-13
   9.99995e-01        5.00000e-06        9.99980e-01        2.00786e-05       7.69882e-04        0.00000         1.64483e-05         1.00000        602.872      25.688     0.919371     6.44355e-07     2.89772e-13
   9.99998e-01        2.00000e-06        9.99992e-01        8.03153e-06       1.92492e-03        0.00000         4.11245e-05         0.99999        602.859      25.688     0.919370     1.61106e-06     2.89812e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.01578e-06       3.85055e-03        0.00000         8.22614e-05         0.99999        602.837      25.688     0.919367     3.22272e-06     2.89878e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.00789e-06       7.70394e-03        0.00000         1.64572e-04         0.99998        602.792      25.688     0.919362     6.44788e-06     2.90010e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.03157e-07       1.92813e-02        0.00000         4.11804e-04         0.99995        602.659      25.688     0.919347     1.61381e-05     2.90408e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.01579e-07       3.86343e-02        0.00000         8.24858e-04         0.99990        602.436      25.688     0.919322     3.23379e-05     2.91073e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.00789e-07       7.75579e-02        0.00000         1.65475e-03         0.99979        601.988      25.688     0.919271     6.49247e-05     2.92416e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.03158e-08       1.96115e-01        0.00000         4.17548e-03         0.99948        600.626      25.688     0.919117     1.64222e-04     2.96546e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.01579e-08       3.99986e-01        0.00000         8.48548e-03         0.99893        598.293      25.688     0.918851     3.35122e-04     3.03785e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.00789e-08       8.34048e-01        0.00000         1.75590e-02         0.99778        593.367      25.688     0.918284     6.99603e-04     3.19797e-13
   1.00000e+00        3.09922e-09        1.00000e+00        1.24458e-08       1.42415e+00        0.00000         2.96734e-02         0.99621        586.755      25.688     0.917508     1.19647e-03     3.42935e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.03158e-09       2.43178e+00        0.00000         4.97850e-02         0.99353        575.692      25.688     0.916174     2.04850e-03     3.86405e-13
   1.00000e+00        1.54529e-09        1.00000e+00        6.20554e-09       3.48338e+00        0.00000         7.00283e-02         0.99074        564.444      25.688     0.914768     2.94262e-03     4.37700e-13
   1.00000e+00        1.24788e-09        1.00000e+00        5.01122e-09       4.98976e+00        0.00000         9.77574e-02         0.98676        548.846      25.688     0.912731     4.23214e-03     5.23345e-13
   1.00000e+00        1.07390e-09        1.00000e+00        4.31255e-09       7.14755e+00        0.00000         1.35030e-01         0.98109        527.523      25.688     0.909770     6.09735e-03     6.76235e-13
   1.00000e+00        1.01305e-09        1.00000e+00        4.06819e-09       1.02385e+01        0.00000         1.83826e-01         0.97303        498.965      25.688     0.905444     8.80653e-03     9.76799e-13
   1.00000e+00        1.01305e-09        1.00000e+00        4.06819e-09       1.02413e+01        0.00000         1.83868e-01         0.97302        498.940      25.688     0.905440     8.80899e-03     9.77123e-13
   1.00000e+00        1.04613e-09        1.00000e+00        4.20102e-09       1.30279e+01        0.00000         2.23694e-01         0.96581        475.078      25.688     0.901464     1.12896e-02     1.36200e-12
   1.00000e+00        1.16578e-09        1.00000e+00        4.68152e-09       1.65729e+01        0.00000         2.69355e-01         0.95673        447.126      25.688     0.896323     1.44978e-02     2.07942e-12
   1.00000e+00        1.43308e-09        1.00000e+00        5.75496e-09       2.10824e+01        0.00000         3.20517e-01         0.94533        415.150      25.688     0.889686     1.86650e-02     3.56513e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.03158e-09       2.68189e+01        0.00000         3.76518e-01         0.93112        379.705      25.688     0.881180     2.41062e-02     7.08354e-12
   1.00000e+00        2.95648e-09        1.00000e+00        1.18726e-08       3.26249e+01        0.00000         4.25275e-01         0.91708        349.135      25.688     0.872640     2.97738e-02     1.41898e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.00789e-08       3.96878e+01        0.00000         4.77059e-01         0.90054        318.244      25.688     0.862596     3.68847e-02     3.29665e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.01579e-08       4.83031e+01        0.00000         5.33532e-01         0.88127        288.608      25.688     0.851305     4.58735e-02     9.14904e-11
   1.00000e+00        2.00000e-08        1.00000e+00        8.03158e-08       5.64623e+01        0.00000         5.84221e-01         0.86404        267.420      25.688     0.842050     5.46912e-02     2.37412e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.00789e-07       6.68716e+01        0.00000         6.49573e-01         0.84374        248.294      25.688     0.832802     6.63326e-02     7.79232e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.01579e-07       7.46210e+01        0.00000         7.00792e-01         0.82999        238.640      25.688     0.827902     7.52462e-02     1.83806e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.03157e-07       8.23736e+01        0.00000         7.55061e-01         0.81750        231.987      25.688     0.824580     8.43321e-02     4.22067e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.00789e-06       9.27835e+01        0.00000         8.32781e-01         0.80290        226.491      25.688     0.822154     9.67170e-02     1.22787e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.01578e-06       1.00901e+02        0.00000         8.96676e-01         0.79333        224.053      25.688     0.821438     1.06448e-01     2.70782e-08
   9.99998e-01        2.00000e-06        9.99992e-01        8.03153e-06       1.09342e+02        0.00000         9.65291e-01         0.78511        222.564      25.688     0.821384     1.16561e-01     5.91287e-08
   9.99995e-01        5.00000e-06        9.99980e-01        2.00786e-05       1.21201e+02        0.00000         1.06368e+00         0.77655        221.397      25.688     0.821921     1.30628e-01     1.64502e-07
   9.99990e-01        1.00000e-05        9.99960e-01        4.01567e-05       1.30893e+02        0.00000         1.14434e+00         0.77209        220.713      25.689     0.822528     1.41891e-01     3.55582e-07
   9.99980e-01        2.00000e-05        9.99920e-01        8.03109e-05       1.41414e+02        0.00000         1.23090e+00         0.76968        219.903      25.690     0.823123     1.53781e-01     7.68623e-07
   9.99950e-01        5.00000e-05        9.99799e-01        2.00759e-04       1.57026e+02        0.00000         1.35555e+00         0.77033        218.235      25.692     0.823650     1.70629e-01     2.13749e-06
   9.99900e-01        1.00000e-04        9.99599e-01        4.01458e-04       1.70571e+02        0.00000         1.45889e+00         0.77445        216.231      25.696     0.823688     1.84389e-01     4.65973e-06
   9.99800e-01        2.00000e-04        9.99197e-01        8.02674e-04       1.86147e+02        0.00000         1.57160e+00         0.78258        213.337      25.704     0.823272     1.99197e-01     1.02328e-05
   9.99680e-01        3.20155e-04        9.98716e-01        1.28443e-03       1.98220e+02        0.00000         1.65440e+00         0.79095        210.741      25.713     0.822658     2.09950e-01     1.75488e-05
   9.99500e-01        5.00000e-04        9.97995e-01        2.00487e-03       2.11077e+02        0.00000         1.73834e+00         0.80148        207.723      25.727     0.821773     2.20749e-01     2.94031e-05
   9.99287e-01        7.13292e-04        9.97142e-01        2.85828e-03       2.22521e+02        0.00000         1.80958e+00         0.81203        204.876      25.743     0.820822     2.29840e-01     4.45460e-05
   9.99000e-01        1.00000e-03        9.95996e-01        4.00371e-03       2.34586e+02        0.00000         1.88133e+00         0.82417        201.765      25.766     0.819683     2.38938e-01     6.63851e-05
   9.98571e-01        1.42851e-03        9.94288e-01        5.71199e-03       2.48806e+02        0.00000         1.96178e+00         0.83960        198.009      25.799     0.818197     2.49085e-01     1.01624e-04
   9.98000e-01        2.00000e-03        9.92017e-01        7.98342e-03       2.63889e+02        0.00000         2.04262e+00         0.85707        193.979      25.843     0.816491     2.59244e-01     1.52639e-04
   9.97237e-01        2.76332e-03        9.88995e-01        1.10052e-02       2.80192e+02        0.00000         2.12524e+00         0.87702        189.626      25.902     0.814532     2.69616e-01     2.26803e-04
   9.96251e-01        3.74861e-03        9.85115e-01        1.48854e-02       2.97503e+02        0.00000         2.20803e+00         0.89920        185.054      25.978     0.812358     2.80033e-01     3.31255e-04
   9.95000e-01        5.00000e-03        9.80219e-01        1.97807e-02       3.15883e+02        0.00000         2.29089e+00         0.92372        180.296      26.075     0.809973     2.90521e-01     4.76245e-04
   9.93633e-01        6.36739e-03        9.74912e-01        2.50883e-02       3.33075e+02        0.00000         2.36410e+00         0.94744        175.958      26.181     0.807695     2.99877e-01     6.48688e-04
   9.91980e-01        8.01969e-03        9.68555e-01        3.14448e-02       3.51204e+02        0.00000         2.43720e+00         0.97319        171.516      26.309     0.805258     3.09340e-01     8.74692e-04
   9.90000e-01        1.00000e-02        9.61018e-01        3.89823e-02       3.70319e+02        0.00000         2.51010e+00         1.00108        166.988      26.463     0.802664     3.18937e-01     1.16883e-03
   9.88010e-01        1.19903e-02        9.53530e-01        4.64702e-02       3.87485e+02        0.00000         2.57218e+00         1.02674        163.060      26.617     0.800320     3.27276e-01     1.48814e-03
   9.85708e-01        1.42917e-02        9.44979e-01        5.50211e-02       4.05448e+02        0.00000         2.63396e+00         1.05421        159.088      26.795     0.797859     3.35761e-01     1.88506e-03
   9.83055e-01        1.69453e-02        9.35260e-01        6.47404e-02       4.24243e+02        0.00000         2.69534e+00         1.08360        155.079      27.001     0.795278     3.44419e-01     2.37747e-03
   9.80000e-01        2.00000e-02        9.24253e-01        7.57470e-02       4.43909e+02        0.00000         2.75618e+00         1.11507        151.039      27.237     0.792569     3.53282e-01     2.98791e-03
   9.77059e-01        2.29408e-02        9.13836e-01        8.61643e-02       4.61255e+02        0.00000         2.80712e+00         1.14346        147.598      27.465     0.790173     3.60966e-01     3.61756e-03
   9.73744e-01        2.62556e-02        9.02299e-01        9.77010e-02       4.79279e+02        0.00000         2.85744e+00         1.17362        144.135      27.722     0.787672     3.68851e-01     4.37441e-03
   9.70000e-01        3.00000e-02        8.89522e-01        1.10478e-01       4.98007e+02        0.00000         2.90696e+00         1.20569        140.650      28.012     0.785055     3.76971e-01     5.28694e-03
   9.65359e-01        3.46410e-02        8.74047e-01        1.25953e-01       5.19193e+02        0.00000         2.95959e+00         1.24297        136.830      28.372     0.782060     3.86113e-01     6.49917e-03
   9.60000e-01        4.00000e-02        8.56660e-01        1.43340e-01       5.41280e+02        0.00000         3.01055e+00         1.28309        132.963      28.787     0.778878     3.95661e-01     8.00581e-03
   9.55320e-01        4.46802e-02        8.41880e-01        1.58120e-01       5.58756e+02        0.00000         3.04790e+00         1.31585        129.970      29.149     0.776295     4.03282e-01     9.41133e-03
   9.50000e-01        5.00000e-02        8.25520e-01        1.74480e-01       5.76797e+02        0.00000         3.08344e+00         1.35078        126.921      29.562     0.773542     4.11272e-01     1.11064e-02
   9.40000e-01        6.00000e-02        7.95971e-01        2.04029e-01       6.06052e+02        0.00000         3.13342e+00         1.41038        121.997      30.336     0.768784     4.24716e-01     1.45603e-02
   9.30000e-01        7.00000e-02        7.67894e-01        2.32106e-01       6.29923e+02        0.00000         3.16496e+00         1.46275        117.886      31.111     0.764441     4.36509e-01     1.83450e-02
   9.20000e-01        8.00000e-02        7.41181e-01        2.58819e-01       6.49016e+02        0.00000         3.18098e+00         1.50843        114.389      31.886     0.760401     4.46981e-01     2.24427e-02
   9.10000e-01        9.00000e-02        7.15735e-01        2.84265e-01       6.63808e+02        0.00000         3.18364e+00         1.54782        111.372      32.660     0.756585     4.56359e-01     2.68397e-02
   9.00000e-01        1.00000e-01        6.91468e-01        3.08532e-01       6.74714e+02        0.00000         3.17466e+00         1.58128        108.736      33.435     0.752934     4.64811e-01     3.14477e-02
   8.90000e-01        1.10000e-01        6.68300e-01        3.31700e-01       6.82121e+02        0.00000         3.15556e+00         1.60916        106.406      34.210     0.749401     4.72471e-01     3.63359e-02
   8.80000e-01        1.20000e-01        6.46159e-01        3.53841e-01       6.86399e+02        0.00000         3.12769e+00         1.63184        104.326      34.984     0.745951     4.79443e-01     4.15110e-02
   8.70000e-01        1.30000e-01        6.24976e-01        3.75024e-01       6.87904e+02        0.00000         3.09228e+00         1.64970        102.451      35.759     0.742556     4.85818e-01     4.69786e-02
   8.60000e-01        1.40000e-01        6.04693e-01        3.95307e-01       6.86979e+02        0.00000         3.05047e+00         1.66314        100.744      36.534     0.739192     4.91668e-01     5.27488e-02
   8.50000e-01        1.50000e-01        5.85251e-01        4.14749e-01       6.83948e+02        0.00000         3.00330e+00         1.67257         99.174      37.308     0.735840     4.97061e-01     5.88357e-02
   8.40000e-01        1.60000e-01        5.66600e-01        4.33400e-01       6.79116e+02        0.00000         2.95172e+00         1.67839         97.716      38.083     0.732485     5.02050e-01     6.52579e-02
   8.30000e-01        1.70000e-01        5.48694e-01        4.51306e-01       6.72761e+02        0.00000         2.89656e+00         1.68098         96.350      38.858     0.729111     5.06686e-01     7.20389e-02
   8.20000e-01        1.80000e-01        5.31487e-01        4.68513e-01       6.65137e+02        0.00000         2.83858e+00         1.68072         95.058      39.633     0.725708     5.11011e-01     7.92077e-02
   8.10000e-01        1.90000e-01        5.14940e-01        4.85060e-01       6.56470e+02        0.00000         2.77840e+00         1.67795         93.823      40.407     0.722260     5.15061e-01     8.67995e-02
   8.00000e-01        2.00000e-01        4.99015e-01        5.00985e-01       6.46960e+02        0.00000         2.71658e+00         1.67297         92.633      41.182     0.718758     5.18870e-01     9.48567e-02
   7.90000e-01        2.10000e-01        4.83679e-01        5.16321e-01       6.36784e+02        0.00000         2.65359e+00         1.66609         91.474      41.957     0.715187     5.22465e-01     1.03430e-01
   7.80000e-01        2.20000e-01        4.68898e-01        5.31102e-01       6.26094e+02        0.00000         2.58982e+00         1.65756         90.336      42.731     0.711535     5.25872e-01     1.12582e-01
   7.70000e-01        2.30000e-01        4.54644e-01        5.45356e-01       6.15020e+02        0.00000         2.52557e+00         1.64761         89.209      43.506     0.707785     5.29111e-01     1.22385e-01
   7.60000e-01        2.40000e-01        4.40889e-01        5.59111e-01       6.03675e+02        0.00000         2.46110e+00         1.63645         88.082      44.281     0.703922     5.32204e-01     1.32931e-01
   7.50000e-01        2.50000e-01        4.27607e-01        5.72393e-01       5.92155e+02        0.00000         2.39661e+00         1.62427         86.946      45.055     0.699924     5.35165e-01     1.44328e-01
   7.40000e-01        2.60000e-01        4.14774e-01        5.85226e-01       5.80540e+02        0.00000         2.33223e+00         1.61123         85.791      45.830     0.695770     5.38009e-01     1.56714e-01
   7.30000e-01        2.70000e-01        4.02367e-01        5.97633e-01       5.68900e+02        0.00000         2.26807e+00         1.59747         84.607      46.605     0.691432     5.40751e-01     1.70156e-01
   7.20000e-01        2.80000e-01        3.90366e-01        6.09634e-01       5.57292e+02        0.00000         2.20416e+00         1.58313         83.383      47.380     0.686875     5.43402e-01     1.84910e-01
   7.10000e-01        2.90000e-01        3.78752e-01        6.21248e-01       5.45766e+02        0.00000         2.14053e+00         1.56832         82.106      48.154     0.682059     5.45973e-01     2.01300e-01
   7.00000e-01        3.00000e-01        3.67505e-01        6.32495e-01       5.34365e+02        0.00000         2.07713e+00         1.55315         80.762      48.929     0.676930     5.48472e-01     2.19699e-01
   6.90000e-01        3.10000e-01        3.56609e-01        6.43391e-01       5.23125e+02        0.00000         2.01387e+00         1.53772         79.334      49.704     0.671422     5.50910e-01     2.40612e-01
   6.80000e-01        3.20000e-01        3.46047e-01        6.53953e-01       5.12080e+02        0.00000         1.95061e+00         1.52212         77.800      50.478     0.665444     5.53295e-01     2.64750e-01
   6.70000e-01        3.30000e-01        3.35804e-01        6.64196e-01       5.01259e+02        0.00000         1.88711e+00         1.50645         76.133      51.253     0.658874     5.55634e-01     2.93141e-01
   6.60000e-01        3.40000e-01        3.25867e-01        6.74133e-01       4.90693e+02        0.00000         1.82305e+00         1.49081         74.296      52.028     0.651539     5.57938e-01     3.27350e-01
   6.50000e-01        3.50000e-01        3.16221e-01        6.83779e-01       4.80412e+02        0.00000         1.75790e+00         1.47529         72.236      52.802     0.643183     5.60214e-01     3.69886e-01
   6.40000e-01        3.60000e-01        3.06854e-01        6.93146e-01       4.70452e+02        0.00000         1.69090e+00         1.46001         69.875      53.577     0.633409     5.62473e-01     4.25082e-01
   6.30000e-01        3.70000e-01        2.97754e-01        7.02246e-01       4.60859e+02        0.00000         1.62083e+00         1.44513         67.095      54.352     0.621561     5.64726e-01     5.01120e-01
   6.20000e-01        3.80000e-01        2.88910e-01        7.11090e-01       4.51696e+02        0.00000         1.54578e+00         1.43085         63.704      55.127     0.606498     5.66990e-01     6.15318e-01
   6.10000e-01        3.90000e-01        2.80311e-01        7.19689e-01       4.43063e+02        0.00000         1.46338e+00         1.41748         59.436      55.901     0.586301     5.69289e-01     8.08538e-01
   6.04187e-01        3.95813e-01        2.75421e-01        7.24579e-01       4.38341e+02        0.00000         1.41232e+00         1.41029         56.511      56.352     0.571444     5.70654e-01     9.90047e-01
   6.03937e-01        3.96063e-01        2.75212e-01        7.24788e-01       4.38143e+02        0.50000         1.40999e+00         1.40999         56.371      56.371     0.570713     5.70713e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   6.03937e-01          0.39606          2.75212e-01          0.72479          438.143          0.5000            1.40999           1.40999         56.371     56.3710     0.570713     0.570713     1.00000e+00
   6.03686e-01          0.39631          2.75003e-01          0.72500          437.946          1.0000            1.40970           1.40768         56.390     56.2315     0.570772     0.569980     9.90016e-01
   6.00000e-01          0.40000          2.71947e-01          0.72805          435.097          1.0000            1.40545           1.37526         56.676     54.2668     0.571654     0.559370     8.54581e-01
   5.90000e-01          0.41000          2.63808e-01          0.73619          427.894          1.0000            1.39508           1.29670         57.451     49.2937     0.574109     0.529972     5.59429e-01
   5.80000e-01          0.42000          2.55886e-01          0.74411          421.370          1.0000            1.38622           1.23886         58.225     45.5575     0.576640     0.504853     3.79244e-01
   5.70000e-01          0.43000          2.48173e-01          0.75183          415.361          1.0000            1.37847           1.19683         59.000     42.8614     0.579218     0.484645     2.70948e-01
   5.60000e-01          0.44000          2.40659e-01          0.75934          409.740          1.0000            1.37152           1.16458         59.775     40.8206     0.581818     0.467931     2.01341e-01
   5.50000e-01          0.45000          2.33337e-01          0.76666          404.424          1.0000            1.36515           1.13861         60.549     39.1983     0.584426     0.453623     1.53789e-01
   5.40000e-01          0.46000          2.26201e-01          0.77380          399.357          1.0000            1.35923           1.11693         61.324     37.8596     0.587032     0.441037     1.19810e-01
   5.30000e-01          0.47000          2.19242e-01          0.78076          394.497          1.0000            1.35367           1.09837         62.099     36.7238     0.589628     0.429741     9.47240e-02
   5.20000e-01          0.48000          2.12455e-01          0.78755          389.815          1.0000            1.34839           1.08217         62.873     35.7397     0.592209     0.419448     7.57455e-02
   5.10000e-01          0.49000          2.05833e-01          0.79417          385.289          1.0000            1.34334           1.06783         63.648     34.8732     0.594773     0.409956     6.11176e-02
   5.00000e-01          0.50000          1.99370e-01          0.80063          380.900          1.0000            1.33848           1.05500         64.423     34.1003     0.597316     0.401124     4.96766e-02
   4.90000e-01          0.51000          1.93061e-01          0.80694          376.634          1.0000            1.33377           1.04341         65.198     33.4036     0.599837     0.392845     4.06225e-02
   4.80000e-01          0.52000          1.86901e-01          0.81310          372.480          1.0000            1.32920           1.03287         65.972     32.7702     0.602334     0.385036     3.33884e-02
   4.70000e-01          0.53000          1.80883e-01          0.81912          368.427          1.0000            1.32474           1.02321         66.747     32.1902     0.604806     0.377635     2.75622e-02
   4.60000e-01          0.54000          1.75003e-01          0.82500          364.467          1.0000            1.32037           1.01433         67.522     31.6558     0.607253     0.370591     2.28384e-02
   4.50000e-01          0.55000          1.69257e-01          0.83074          360.594          1.0000            1.31608           1.00613         68.296     31.1608     0.609673     0.363862     1.89866e-02
   4.40000e-01          0.56000          1.63639e-01          0.83636          356.801          1.0000            1.31186           0.99853         69.071     30.7003     0.612068     0.357414     1.58303e-02
   4.30000e-01          0.57000          1.58146e-01          0.84185          353.083          1.0000            1.30769           0.99145         69.846     30.2700     0.614435     0.351221     1.32329e-02
   4.20000e-01          0.58000          1.52774e-01          0.84723          349.435          1.0000            1.30356           0.98486         70.620     29.8666     0.616776     0.345257     1.10875e-02
   4.10000e-01          0.59000          1.47518e-01          0.85248          345.854          1.0000            1.29948           0.97869         71.395     29.4873     0.619090     0.339504     9.30958e-03
   4.00000e-01          0.60000          1.42375e-01          0.85762          342.335          1.0000            1.29543           0.97292         72.170     29.1295     0.621378     0.333943     7.83184e-03
   3.90000e-01          0.61000          1.37342e-01          0.86266          338.876          1.0000            1.29141           0.96750         72.945     28.7913     0.623639     0.328560     6.60037e-03
   3.80000e-01          0.62000          1.32414e-01          0.86759          335.473          1.0000            1.28740           0.96241         73.719     28.4708     0.625874     0.323342     5.57168e-03
   3.70000e-01          0.63000          1.27589e-01          0.87241          332.124          1.0000            1.28342           0.95761         74.494     28.1665     0.628082     0.318277     4.71052e-03
   3.60000e-01          0.64000          1.22863e-01          0.87714          328.826          1.0000            1.27944           0.95310         75.269     27.8770     0.630264     0.313356     3.98817e-03
   3.50000e-01          0.65000          1.18233e-01          0.88177          325.578          1.0000            1.27548           0.94884         76.043     27.6011     0.632421     0.308569     3.38117e-03
   3.40000e-01          0.66000          1.13696e-01          0.88630          322.378          1.0000            1.27152           0.94482         76.818     27.3378     0.634552     0.303909     2.87023e-03
   3.30000e-01          0.67000          1.09251e-01          0.89075          319.222          1.0000            1.26757           0.94102         77.593     27.0861     0.636658     0.299368     2.43946e-03
   3.20000e-01          0.68000          1.04893e-01          0.89511          316.111          1.0000            1.26361           0.93743         78.367     26.8453     0.638740     0.294940     2.07577e-03
   3.10000e-01          0.69000          1.00620e-01          0.89938          313.041          1.0000            1.25966           0.93403         79.142     26.6145     0.640796     0.290619     1.76826e-03
   3.00000e-01          0.70000          9.64304e-02          0.90357          310.013          1.0000            1.25570           0.93081         79.917     26.3931     0.642829     0.286399     1.50794e-03
   2.90000e-01          0.71000          9.23211e-02          0.90768          307.023          1.0000            1.25173           0.92776         80.692     26.1805     0.644837     0.282277     1.28727e-03
   2.80000e-01          0.72000          8.82900e-02          0.91171          304.072          1.0000            1.24776           0.92487         81.466     25.9761     0.646822     0.278247     1.10000e-03
   2.70000e-01          0.73000          8.43348e-02          0.91567          301.158          1.0000            1.24379           0.92214         82.241     25.7794     0.648783     0.274305     9.40896e-04
   2.60000e-01          0.74000          8.04534e-02          0.91955          298.279          1.0000            1.23980           0.91954         83.016     25.5900     0.650722     0.270448     8.05569e-04
   2.50000e-01          0.75000          7.66438e-02          0.92336          295.436          1.0000            1.23580           0.91709         83.790     25.4075     0.652638     0.266672     6.90345e-04
   2.40000e-01          0.76000          7.29040e-02          0.92710          292.626          1.0000            1.23179           0.91475         84.565     25.2314     0.654532     0.262974     5.92139e-04
   2.30000e-01          0.77000          6.92321e-02          0.93077          289.848          1.0000            1.22776           0.91254         85.340     25.0615     0.656403     0.259350     5.08355e-04
   2.20000e-01          0.78000          6.56263e-02          0.93437          287.103          1.0000            1.22372           0.91045         86.114     24.8973     0.658254     0.255799     4.36805e-04
   2.10000e-01          0.79000          6.20848e-02          0.93792          284.389          1.0000            1.21967           0.90846         86.889     24.7387     0.660082     0.252317     3.75646e-04
   2.00000e-01          0.80000          5.86058e-02          0.94139          281.705          1.0000            1.21560           0.90658         87.664     24.5852     0.661890     0.248901     3.23322e-04
   1.90000e-01          0.81000          5.51878e-02          0.94481          279.051          1.0000            1.21152           0.90479         88.438     24.4368     0.663677     0.245550     2.78515e-04
   1.80000e-01          0.82000          5.18292e-02          0.94817          276.425          1.0000            1.20742           0.90310         89.213     24.2930     0.665444     0.242262     2.40113e-04
   1.70000e-01          0.83000          4.85284e-02          0.95147          273.828          1.0000            1.20330           0.90150         89.988     24.1538     0.667191     0.239033     2.07172e-04
   1.60000e-01          0.84000          4.52839e-02          0.95472          271.258          1.0000            1.19917           0.89999         90.763     24.0188     0.668918     0.235863     1.78891e-04
   1.50000e-01          0.85000          4.20944e-02          0.95791          268.715          1.0000            1.19501           0.89855         91.537     23.8879     0.670626     0.232749     1.54591e-04
   1.40000e-01          0.86000          3.89584e-02          0.96104          266.198          1.0000            1.19084           0.89720         92.312     23.7609     0.672314     0.229690     1.33694e-04
   1.30000e-01          0.87000          3.58746e-02          0.96413          263.707          1.0000            1.18665           0.89592         93.087     23.6377     0.673984     0.226683     1.15710e-04
   1.20000e-01          0.88000          3.28417e-02          0.96716          261.241          1.0000            1.18244           0.89471         93.861     23.5180     0.675635     0.223728     1.00221e-04
   1.10000e-01          0.89000          2.98584e-02          0.97014          258.799          1.0000            1.17821           0.89357         94.636     23.4017     0.677268     0.220823     8.68687e-05
   1.00000e-01          0.90000          2.69236e-02          0.97308          256.382          1.0000            1.17396           0.89250         95.411     23.2888     0.678883     0.217966     7.53508e-05
   9.00000e-02          0.91000          2.40361e-02          0.97596          253.988          1.0000            1.16969           0.89149         96.185     23.1789     0.680480     0.215156     6.54074e-05
   8.00000e-02          0.92000          2.11947e-02          0.97881          251.617          1.0000            1.16540           0.89054         96.960     23.0721     0.682060     0.212392     5.68168e-05
   7.00000e-02          0.93000          1.83984e-02          0.98160          249.269          1.0000            1.16109           0.88965         97.735     22.9682     0.683623     0.209672     4.93896e-05
   6.00000e-02          0.94000          1.56460e-02          0.98435          246.944          1.0000            1.15675           0.88881         98.510     22.8671     0.685169     0.206995     4.29633e-05
   5.00000e-02          0.95000          1.29366e-02          0.98706          244.640          1.0000            1.15240           0.88803         99.284     22.7687     0.686698     0.204361     3.73992e-05
   4.00000e-02          0.96000          1.02692e-02          0.98973          242.357          1.0000            1.14803           0.88730        100.059     22.6728     0.688211     0.201767     3.25780e-05
   3.00000e-02          0.97000          7.64270e-03          0.99236          240.096          1.0000            1.14363           0.88663        100.834     22.5794     0.689708     0.199213     2.83977e-05
   2.00000e-02          0.98000          5.05629e-03          0.99494          237.855          1.0000            1.13922           0.88600        101.608     22.4884     0.691189     0.196699     2.47705e-05
   1.00000e-02          0.99000          2.50901e-03          0.99749          235.634          1.0000            1.13478           0.88541        102.383     22.3997     0.692654     0.194221     2.16210e-05
   5.00000e-03          0.99500          1.24978e-03          0.99875          234.531          1.0000            1.13256           0.88514        102.770     22.3562     0.693381     0.192997     2.02048e-05
   2.00000e-03          0.99800          4.98783e-04          0.99950          233.872          1.0000            1.13122           0.88498        103.003     22.3303     0.693815     0.192266     1.94015e-05
   1.00000e-03          0.99900          2.49204e-04          0.99975          233.652          1.0000            1.13077           0.88493        103.080     22.3217     0.693959     0.192024     1.91411e-05
   5.00000e-04          0.99950          1.24555e-04          0.99988          233.543          1.0000            1.13055           0.88490        103.119     22.3175     0.694032     0.191902     1.90123e-05
   2.00000e-04          0.99980          4.98109e-05          0.99995          233.477          1.0000            1.13041           0.88488        103.142     22.3149     0.694075     0.191830     1.89355e-05
   1.00000e-04          0.99990          2.49036e-05          0.99998          233.455          1.0000            1.13037           0.88488        103.150     22.3141     0.694089     0.191806     1.89099e-05
   5.00000e-05          0.99995          1.24513e-05          0.99999          233.444          1.0000            1.13035           0.88488        103.154     22.3136     0.694097     0.191793     1.88972e-05
   2.00000e-05          0.99998          4.98042e-06          1.00000          233.438          1.0000            1.13033           0.88487        103.156     22.3134     0.694101     0.191786     1.88895e-05
   1.00000e-05          0.99999          2.49019e-06          1.00000          233.435          1.0000            1.13033           0.88487        103.157     22.3133     0.694102     0.191784     1.88870e-05
   5.00000e-06          0.99999          1.24509e-06          1.00000          233.434          1.0000            1.13033           0.88487        103.157     22.3132     0.694103     0.191783     1.88857e-05
   2.00000e-06          1.00000          4.98035e-07          1.00000          233.434          1.0000            1.13033           0.88487        103.158     22.3132     0.694103     0.191782     1.88849e-05
   1.00000e-06          1.00000          2.49017e-07          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191782     1.88847e-05
   5.00000e-07          1.00000          1.24509e-07          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88845e-05
   2.00000e-07          1.00000          4.98034e-08          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88845e-05
   1.00000e-07          1.00000          2.49017e-08          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   5.00000e-08          1.00000          1.24509e-08          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   2.00000e-08          1.00000          4.98034e-09          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   1.00000e-08          1.00000          2.49017e-09          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   5.00000e-09          1.00000          1.24509e-09          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   2.00000e-09          1.00000          4.98034e-10          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   1.00000e-09          1.00000          2.49017e-10          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   5.00000e-10          1.00000          1.24509e-10          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   2.00000e-10          1.00000          4.98034e-11          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   1.00000e-10          1.00000          2.49017e-11          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   5.00000e-11          1.00000          1.24509e-11          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   2.00000e-11          1.00000          4.98034e-12          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   1.00000e-11          1.00000          2.49017e-12          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   5.00000e-12          1.00000          1.24509e-12          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   2.00000e-12          1.00000          4.98034e-13          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   1.00000e-12          1.00000          2.49017e-13          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          233.433          1.0000            1.13032           0.88487        103.158     22.3132     0.694104     0.191781     1.88844e-05
END

set output "Figures/Env_002_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_002_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_002_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_002_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Lab2_Slimtube_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   33.798     1.00000e-13        0.00000         2.53402e-15          1.00000       602.891     103.565     0.932244     4.05802e-16     9.77882e-18
   35.000     1.27958e-13        0.00000         3.23061e-15          1.00000       602.891     103.565     0.932019     5.17229e-16     1.24936e-17
   37.500     2.12120e-13        0.00000         5.31508e-15          1.00000       602.891     103.565     0.931549     8.50529e-16     2.06481e-17
   40.000     3.48353e-13        0.00000         8.66338e-15          1.00000       602.891     103.565     0.931075     1.38563e-15     3.38119e-17
   42.500     5.66869e-13        0.00000         1.39933e-14          1.00000       602.891     103.565     0.930597     2.23694e-15     5.48733e-17
   45.000     9.14261e-13        0.00000         2.24030e-14          1.00000       602.891     103.565     0.930115     3.57945e-15     8.82778e-17
   47.500     1.46177e-12        0.00000         3.55584e-14          1.00000       602.891     103.565     0.929629     5.67841e-15     1.40810e-16
   50.000     2.31741e-12        0.00000         5.59658e-14          1.00000       602.890     103.565     0.929139     8.93260e-15     2.22743e-16
   52.500     3.64362e-12        0.00000         8.73648e-14          1.00000       602.890     103.565     0.928646     1.39367e-14     3.49499e-16
   55.000     5.68273e-12        0.00000         1.35292e-13          1.00000       602.890     103.565     0.928148     2.15706e-14     5.44062e-16
   57.500     8.79343e-12        0.00000         2.07879e-13          1.00000       602.890     103.565     0.927646     3.31259e-14     8.40416e-16
   60.000     1.35027e-11        0.00000         3.16985e-13          1.00000       602.890     103.565     0.927139     5.04846e-14     1.28844e-15
   62.500     2.05789e-11        0.00000         4.79770e-13          1.00000       602.890     103.565     0.926629     7.63684e-14     1.96082e-15
   65.000     3.11345e-11        0.00000         7.20894e-13          1.00000       602.890     103.565     0.926115     1.14686e-13     2.96270e-15
   67.500     4.67685e-11        0.00000         1.07554e-12          1.00000       602.889     103.565     0.925596     1.71011e-13     4.44519e-15
   70.000     6.97638e-11        0.00000         1.59358e-12          1.00000       602.889     103.565     0.925073     2.53235e-13     6.62394e-15
   72.500     1.03358e-10        0.00000         2.34520e-12          1.00000       602.889     103.565     0.924546     3.72464e-13     9.80470e-15
   75.000     1.52110e-10        0.00000         3.42859e-12          1.00000       602.889     103.565     0.924014     5.44214e-13     1.44182e-14
   77.500     2.22405e-10        0.00000         4.98019e-12          1.00000       602.888     103.565     0.923478     7.90038e-13     2.10675e-14
   80.000     3.23120e-10        0.00000         7.18844e-12          1.00000       602.888     103.565     0.922938     1.13968e-12     3.05916e-14
   82.500     4.66531e-10        0.00000         1.03120e-11          1.00000       602.888     103.565     0.922393     1.63394e-12     4.41510e-14
   85.000     6.69506e-10        0.00000         1.47040e-11          1.00000       602.887     103.565     0.921844     2.32846e-12     6.33414e-14
   87.500     9.55092e-10        0.00000         2.08432e-11          1.00000       602.887     103.565     0.921290     3.29866e-12     9.03443e-14
   90.000     1.35459e-09        0.00000         2.93759e-11          1.00000       602.886     103.565     0.920731     4.64624e-12     1.28126e-13
   92.500     1.91030e-09        0.00000         4.11690e-11          1.00000       602.886     103.565     0.920169     6.50751e-12     1.80696e-13
   95.000     2.67903e-09        0.00000         5.73791e-11          1.00000       602.885     103.565     0.919601     9.06424e-12     2.53450e-13
   97.500     3.73671e-09        0.00000         7.95419e-11          1.00000       602.884     103.565     0.919029     1.25575e-11     3.53603e-13
  100.000     5.18426e-09        0.00000         1.09685e-10          1.00000       602.884     103.565     0.918452     1.73054e-11     4.90764e-13
  102.500     7.15519e-09        0.00000         1.50472e-10          1.00000       602.883     103.565     0.917870     2.37255e-11     6.77655e-13
  105.000     9.82514e-09        0.00000         2.05385e-10          1.00000       602.882     103.565     0.917284     3.23633e-11     9.31051e-13
  107.500     1.34242e-08        0.00000         2.78956e-10          1.00000       602.881     103.565     0.916692     4.39279e-11     1.27295e-12
  110.000     1.82521e-08        0.00000         3.77051e-10          1.00000       602.880     103.565     0.916096     5.93367e-11     1.73208e-12
  112.500     2.46979e-08        0.00000         5.07232e-10          1.00000       602.879     103.565     0.915495     7.97711e-11     2.34578e-12
  115.000     3.32638e-08        0.00000         6.79201e-10          1.00000       602.877     103.565     0.914889     1.06746e-10     3.16236e-12
  117.500     4.45953e-08        0.00000         9.05350e-10          1.00000       602.876     103.565     0.914278     1.42193e-10     4.24406e-12
  120.000     5.95187e-08        0.00000         1.20144e-09          1.00000       602.874     103.565     0.913662     1.88570e-10     5.67071e-12
  122.500     7.90869e-08        0.00000         1.58743e-09          1.00000       602.873     103.565     0.913041     2.48984e-10     7.54431e-12
  125.000     1.04636e-07        0.00000         2.08849e-09          1.00000       602.871     103.565     0.912415     3.27351e-10     9.99458e-12
  127.500     1.37855e-07        0.00000         2.73624e-09          1.00000       602.869     103.565     0.911783     4.28583e-10     1.31859e-11
  130.000     1.80868e-07        0.00000         3.57022e-09          1.00000       602.867     103.565     0.911146     5.58823e-10     1.73258e-11
  132.500     2.36341e-07        0.00000         4.63971e-09          1.00000       602.864     103.565     0.910504     7.25715e-10     2.26750e-11
  135.000     3.07600e-07        0.00000         6.00589e-09          1.00000       602.862     103.565     0.909857     9.38740e-10     2.95602e-11
  137.500     3.98785e-07        0.00000         7.74439e-09          1.00000       602.859     103.565     0.909204     1.20961e-09     3.83892e-11
  140.000     5.15026e-07        0.00000         9.94842e-09          1.00000       602.856     103.565     0.908546     1.55275e-09     4.96686e-11
  142.500     6.62659e-07        0.00000         1.27324e-08          1.00000       602.853     103.565     0.907883     1.98583e-09     6.40264e-11
  145.000     8.49480e-07        0.00000         1.62363e-08          1.00000       602.849     103.565     0.907214     2.53046e-09     8.22379e-11
  147.500     1.08505e-06        0.00000         2.06306e-08          1.00000       602.845     103.565     0.906539     3.21296e-09     1.05257e-10
  150.000     1.38104e-06        0.00000         2.61228e-08          1.00000       602.841     103.565     0.905858     4.06528e-09     1.34253e-10
  152.500     1.75168e-06        0.00000         3.29638e-08          1.00000       602.837     103.565     0.905172     5.12603e-09     1.70655e-10
  155.000     2.21424e-06        0.00000         4.14564e-08          1.00000       602.832     103.565     0.904481     6.44180e-09     2.16206e-10
  157.500     2.78960e-06        0.00000         5.19652e-08          1.00000       602.827     103.565     0.903783     8.06857e-09     2.73021e-10
  160.000     3.50296e-06        0.00000         6.49270e-08          1.00000       602.822     103.565     0.903080     1.00734e-08     3.43661e-10
  162.500     4.38459e-06        0.00000         8.08644e-08          1.00000       602.816     103.565     0.902370     1.25363e-08     4.31216e-10
  165.000     5.47080e-06        0.00000         1.00400e-07          1.00000       602.810     103.565     0.901655     1.55527e-08     5.39409e-10
  167.500     6.80494e-06        0.00000         1.24274e-07          1.00000       602.803     103.565     0.900934     1.92358e-08     6.72703e-10
  170.000     8.43871e-06        0.00000         1.53363e-07          1.00000       602.796     103.565     0.900206     2.37194e-08     8.36441e-10
  172.500     1.04335e-05        0.00000         1.88702e-07          1.00000       602.789     103.565     0.899472     2.91617e-08     1.03700e-09
  175.000     1.28619e-05        0.00000         2.31514e-07          1.00000       602.781     103.565     0.898733     3.57487e-08     1.28195e-09
  177.500     1.58099e-05        0.00000         2.83230e-07          1.00000       602.772     103.565     0.897986     4.36988e-08     1.58032e-09
  180.000     1.93787e-05        0.00000         3.45533e-07          1.00000       602.763     103.565     0.897234     5.32673e-08     1.94274e-09
  182.500     2.36870e-05        0.00000         4.20384e-07          1.00000       602.753     103.565     0.896475     6.47527e-08     2.38179e-09
  185.000     2.88742e-05        0.00000         5.10074e-07          1.00000       602.743     103.565     0.895710     7.85021e-08     2.91228e-09
  187.500     3.51030e-05        0.00000         6.17262e-07          1.00000       602.732     103.565     0.894938     9.49186e-08     3.55160e-09
  190.000     4.25629e-05        0.00000         7.45034e-07          1.00000       602.720     103.565     0.894159     1.14469e-07     4.32014e-09
  192.500     5.14747e-05        0.00000         8.96960e-07          1.00000       602.707     103.565     0.893374     1.37693e-07     5.24169e-09
  195.000     6.20940e-05        0.00000         1.07716e-06          1.00000       602.694     103.565     0.892582     1.65213e-07     6.34405e-09
  197.500     7.47168e-05        0.00000         1.29037e-06          1.00000       602.680     103.565     0.891783     1.97742e-07     7.65950e-09
  200.000     8.96848e-05        0.00000         1.54204e-06          1.00000       602.665     103.565     0.890977     2.36102e-07     9.22556e-09
  202.500     1.07391e-04        0.00000         1.83840e-06          1.00000       602.649     103.565     0.890165     2.81229e-07     1.10856e-08
  205.000     1.28288e-04        0.00000         2.18660e-06          1.00000       602.632     103.565     0.889345     3.34196e-07     1.32899e-08
  207.500     1.52893e-04        0.00000         2.59477e-06          1.00000       602.614     103.565     0.888518     3.96222e-07     1.58962e-08
  210.000     1.81799e-04        0.00000         3.07216e-06          1.00000       602.595     103.565     0.887684     4.68695e-07     1.89711e-08
  212.500     2.15683e-04        0.00000         3.62930e-06          1.00000       602.575     103.565     0.886842     5.53187e-07     2.25911e-08
  215.000     2.55313e-04        0.00000         4.27810e-06          1.00000       602.554     103.565     0.885993     6.51478e-07     2.68436e-08
  217.500     3.01565e-04        0.00000         5.03205e-06          1.00000       602.532     103.565     0.885137     7.65578e-07     3.18289e-08
  220.000     3.55431e-04        0.00000         5.90635e-06          0.99999       602.508     103.565     0.884273     8.97754e-07     3.76612e-08
  222.500     4.18035e-04        0.00000         6.91815e-06          0.99999       602.484     103.565     0.883401     1.05055e-06     4.44706e-08
  225.000     4.90643e-04        0.00000         8.08671e-06          0.99999       602.457     103.565     0.882522     1.22684e-06     5.24051e-08
  227.500     5.74685e-04        0.00000         9.43363e-06          0.99999       602.430     103.565     0.881634     1.42981e-06     6.16326e-08
  230.000     6.71769e-04        0.00000         1.09831e-05          0.99999       602.400     103.565     0.880739     1.66305e-06     7.23432e-08
  232.500     7.83699e-04        0.00000         1.27622e-05          0.99999       602.370     103.565     0.879836     1.93056e-06     8.47521e-08
  235.000     9.12500e-04        0.00000         1.48011e-05          0.99999       602.337     103.565     0.878925     2.23679e-06     9.91017e-08
  237.500     1.06043e-03        0.00000         1.71334e-05          0.99999       602.303     103.565     0.878005     2.58669e-06     1.15666e-07
  240.000     1.23002e-03        0.00000         1.97964e-05          0.99998       602.267     103.565     0.877077     2.98576e-06     1.34751e-07
  242.500     1.42409e-03        0.00000         2.28316e-05          0.99998       602.229     103.565     0.876141     3.44008e-06     1.56703e-07
  245.000     1.64576e-03        0.00000         2.62848e-05          0.99998       602.189     103.565     0.875196     3.95638e-06     1.81909e-07
  247.500     1.89851e-03        0.00000         3.02068e-05          0.99998       602.148     103.565     0.874242     4.54210e-06     2.10801e-07
  250.000     2.18621e-03        0.00000         3.46536e-05          0.99997       602.104     103.565     0.873280     5.20542e-06     2.43864e-07
  252.500     2.51311e-03        0.00000         3.96871e-05          0.99997       602.057     103.565     0.872308     5.95534e-06     2.81638e-07
  255.000     2.88394e-03        0.00000         4.53749e-05          0.99997       602.009     103.565     0.871328     6.80178e-06     3.24723e-07
  257.500     3.30390e-03        0.00000         5.17919e-05          0.99996       601.958     103.565     0.870338     7.75557e-06     3.73788e-07
  260.000     3.77871e-03        0.00000         5.90198e-05          0.99996       601.904     103.565     0.869339     8.82859e-06     4.29576e-07
  262.500     4.31468e-03        0.00000         6.71483e-05          0.99995       601.848     103.565     0.868331     1.00338e-05     4.92911e-07
  265.000     4.91873e-03        0.00000         7.62752e-05          0.99994       601.789     103.565     0.867313     1.13855e-05     5.64705e-07
  267.500     5.59843e-03        0.00000         8.65077e-05          0.99994       601.728     103.565     0.866286     1.28990e-05     6.45965e-07
  270.000     6.36210e-03        0.00000         9.79622e-05          0.99993       601.663     103.565     0.865249     1.45911e-05     7.37807e-07
  272.500     7.21879e-03        0.00000         1.10766e-04          0.99992       601.595     103.565     0.864202     1.64802e-05     8.41459e-07
  275.000     8.17842e-03        0.00000         1.25056e-04          0.99991       601.524     103.565     0.863144     1.85860e-05     9.58274e-07
  277.500     9.25177e-03        0.00000         1.40984e-04          0.99990       601.450     103.565     0.862077     2.09300e-05     1.08974e-06
  280.000     1.04506e-02        0.00000         1.58710e-04          0.99989       601.372     103.565     0.860999     2.35355e-05     1.23749e-06
  282.500     1.17876e-02        0.00000         1.78411e-04          0.99988       601.290     103.565     0.859910     2.64275e-05     1.40333e-06
  285.000     1.32768e-02        0.00000         2.00277e-04          0.99987       601.205     103.565     0.858811     2.96331e-05     1.58922e-06
  287.500     1.49330e-02        0.00000         2.24513e-04          0.99985       601.116     103.565     0.857701     3.31815e-05     1.79731e-06
  290.000     1.67725e-02        0.00000         2.51341e-04          0.99984       601.022     103.565     0.856580     3.71042e-05     2.02995e-06
  292.500     1.88130e-02        0.00000         2.80997e-04          0.99982       600.925     103.565     0.855448     4.14349e-05     2.28973e-06
  295.000     2.10733e-02        0.00000         3.13740e-04          0.99980       600.822     103.565     0.854304     4.62098e-05     2.57945e-06
  297.500     2.35740e-02        0.00000         3.49843e-04          0.99978       600.716     103.565     0.853149     5.14678e-05     2.90217e-06
  300.000     2.63370e-02        0.00000         3.89602e-04          0.99976       600.604     103.565     0.851982     5.72506e-05     3.26122e-06
  302.500     2.93861e-02        0.00000         4.33335e-04          0.99974       600.487     103.565     0.850803     6.36026e-05     3.66022e-06
  305.000     3.27466e-02        0.00000         4.81379e-04          0.99971       600.366     103.565     0.849612     7.05715e-05     4.10312e-06
  307.500     3.64461e-02        0.00000         5.34098e-04          0.99968       600.238     103.565     0.848408     7.82081e-05     4.59419e-06
  310.000     4.05137e-02        0.00000         5.91879e-04          0.99965       600.106     103.565     0.847192     8.65665e-05     5.13808e-06
  312.500     4.49808e-02        0.00000         6.55135e-04          0.99962       599.967     103.565     0.845963     9.57043e-05     5.73981e-06
  315.000     4.98811e-02        0.00000         7.24306e-04          0.99959       599.822     103.565     0.844722     1.05683e-04     6.40482e-06
  317.500     5.52503e-02        0.00000         7.99863e-04          0.99955       599.671     103.565     0.843467     1.16568e-04     7.13902e-06
  320.000     6.11269e-02        0.00000         8.82304e-04          0.99951       599.513     103.565     0.842198     1.28428e-04     7.94877e-06
  322.500     6.75517e-02        0.00000         9.72161e-04          0.99947       599.349     103.565     0.840916     1.41337e-04     8.84095e-06
  325.000     7.45682e-02        0.00000         1.07000e-03          0.99942       599.177     103.565     0.839620     1.55372e-04     9.82300e-06
  327.500     8.22228e-02        0.00000         1.17641e-03          0.99937       598.998     103.565     0.838309     1.70617e-04     1.09029e-05
  330.000     9.05648e-02        0.00000         1.29203e-03          0.99932       598.811     103.565     0.836984     1.87159e-04     1.20894e-05
  332.500     9.96467e-02        0.00000         1.41754e-03          0.99926       598.617     103.565     0.835645     2.05089e-04     1.33917e-05
  335.000     1.09524e-01        0.00000         1.55364e-03          0.99920       598.414     103.565     0.834290     2.24505e-04     1.48199e-05
  337.500     1.20256e-01        0.00000         1.70108e-03          0.99913       598.202     103.565     0.832920     2.45510e-04     1.63848e-05
  340.000     1.31905e-01        0.00000         1.86067e-03          0.99906       597.982     103.565     0.831535     2.68213e-04     1.80979e-05
  342.500     1.44538e-01        0.00000         2.03323e-03          0.99899       597.752     103.565     0.830133     2.92729e-04     1.99718e-05
  345.000     1.58224e-01        0.00000         2.21966e-03          0.99891       597.512     103.565     0.828715     3.19177e-04     2.20199e-05
  347.500     1.73038e-01        0.00000         2.42088e-03          0.99883       597.263     103.565     0.827281     3.47684e-04     2.42566e-05
  350.000     1.89059e-01        0.00000         2.63789e-03          0.99874       597.003     103.565     0.825830     3.78385e-04     2.66974e-05
  352.500     2.06370e-01        0.00000         2.87172e-03          0.99864       596.732     103.565     0.824362     4.11419e-04     2.93589e-05
  355.000     2.25057e-01        0.00000         3.12345e-03          0.99854       596.449     103.565     0.822876     4.46934e-04     3.22588e-05
  357.500     2.45215e-01        0.00000         3.39425e-03          0.99843       596.156     103.565     0.821372     4.85085e-04     3.54164e-05
  360.000     2.66939e-01        0.00000         3.68531e-03          0.99832       595.849     103.565     0.819850     5.26035e-04     3.88521e-05
  362.500     2.90334e-01        0.00000         3.99790e-03          0.99820       595.530     103.565     0.818309     5.69956e-04     4.25879e-05
  365.000     3.15507e-01        0.00000         4.33337e-03          0.99807       595.198     103.565     0.816749     6.17025e-04     4.66474e-05
  367.500     3.42573e-01        0.00000         4.69310e-03          0.99794       594.853     103.565     0.815169     6.67431e-04     5.10559e-05
  370.000     3.71651e-01        0.00000         5.07856e-03          0.99780       594.492     103.565     0.813569     7.21373e-04     5.58404e-05
  372.500     4.02869e-01        0.00000         5.49131e-03          0.99765       594.117     103.565     0.811949     7.79055e-04     6.10299e-05
  375.000     4.36359e-01        0.00000         5.93296e-03          0.99749       593.727     103.565     0.810308     8.40695e-04     6.66556e-05
  377.500     4.72262e-01        0.00000         6.40520e-03          0.99732       593.320     103.565     0.808646     9.06521e-04     7.27507e-05
  380.000     5.10725e-01        0.00000         6.90982e-03          0.99715       592.897     103.565     0.806961     9.76770e-04     7.93510e-05
  382.500     5.51902e-01        0.00000         7.44869e-03          0.99697       592.457     103.565     0.805254     1.05169e-03     8.64947e-05
  385.000     5.95958e-01        0.00000         8.02375e-03          0.99677       591.998     103.565     0.803524     1.13155e-03     9.42230e-05
  387.500     6.43061e-01        0.00000         8.63706e-03          0.99657       591.520     103.565     0.801771     1.21661e-03     1.02580e-04
  390.000     6.93394e-01        0.00000         9.29078e-03          0.99636       591.023     103.565     0.799993     1.30717e-03     1.11612e-04
  392.500     7.47144e-01        0.00000         9.98714e-03          0.99613       590.505     103.565     0.798191     1.40352e-03     1.21371e-04
  395.000     8.04511e-01        0.00000         1.07285e-02          0.99590       589.966     103.565     0.796363     1.50599e-03     1.31910e-04
  397.500     8.65704e-01        0.00000         1.15174e-02          0.99566       589.404     103.565     0.794510     1.61489e-03     1.43288e-04
  400.000     9.30942e-01        0.00000         1.23563e-02          0.99540       588.820     103.565     0.792629     1.73058e-03     1.55567e-04
  402.500     1.00046e+00        0.00000         1.32481e-02          0.99513       588.211     103.565     0.790721     1.85342e-03     1.68815e-04
  405.000     1.07449e+00        0.00000         1.41954e-02          0.99485       587.577     103.565     0.788785     1.98380e-03     1.83104e-04
  407.500     1.15330e+00        0.00000         1.52015e-02          0.99456       586.917     103.565     0.786820     2.12211e-03     1.98511e-04
  410.000     1.23715e+00        0.00000         1.62692e-02          0.99425       586.230     103.565     0.784825     2.26877e-03     2.15119e-04
  412.500     1.32633e+00        0.00000         1.74021e-02          0.99393       585.514     103.565     0.782800     2.42422e-03     2.33020e-04
  415.000     1.42113e+00        0.00000         1.86034e-02          0.99359       584.768     103.565     0.780742     2.58893e-03     2.52309e-04
  417.500     1.52187e+00        0.00000         1.98769e-02          0.99325       583.991     103.565     0.778653     2.76339e-03     2.73092e-04
  420.000     1.62888e+00        0.00000         2.12263e-02          0.99288       583.181     103.565     0.776530     2.94811e-03     2.95480e-04
  422.500     1.74251e+00        0.00000         2.26556e-02          0.99250       582.337     103.565     0.774373     3.14363e-03     3.19595e-04
  425.000     1.86313e+00        0.00000         2.41691e-02          0.99211       581.457     103.565     0.772180     3.35053e-03     3.45568e-04
  427.500     1.99112e+00        0.00000         2.57711e-02          0.99170       580.541     103.565     0.769950     3.56940e-03     3.73542e-04
  430.000     2.12690e+00        0.00000         2.74663e-02          0.99127       579.585     103.565     0.767682     3.80089e-03     4.03670e-04
  432.500     2.27090e+00        0.00000         2.92597e-02          0.99083       578.588     103.565     0.765376     4.04566e-03     4.36119e-04
  435.000     2.42358e+00        0.00000         3.11563e-02          0.99037       577.549     103.565     0.763029     4.30443e-03     4.71070e-04
  437.500     2.58543e+00        0.00000         3.31617e-02          0.98989       576.465     103.565     0.760640     4.57795e-03     5.08718e-04
  440.000     2.75697e+00        0.00000         3.52816e-02          0.98939       575.333     103.565     0.758208     4.86703e-03     5.49279e-04
  442.500     2.93874e+00        0.00000         3.75221e-02          0.98887       574.152     103.565     0.755731     5.17251e-03     5.92983e-04
  445.000     3.13134e+00        0.00000         3.98896e-02          0.98833       572.920     103.565     0.753208     5.49530e-03     6.40085e-04
  447.500     3.33537e+00        0.00000         4.23910e-02          0.98777       571.633     103.565     0.750636     5.83636e-03     6.90863e-04
  450.000     3.55151e+00        0.00000         4.50334e-02          0.98719       570.288     103.565     0.748014     6.19673e-03     7.45618e-04
  452.500     3.78046e+00        0.00000         4.78247e-02          0.98659       568.883     103.565     0.745340     6.57749e-03     8.04683e-04
  455.000     4.02299e+00        0.00000         5.07729e-02          0.98596       567.415     103.565     0.742612     6.97983e-03     8.68423e-04
  457.500     4.27989e+00        0.00000         5.38868e-02          0.98532       565.879     103.565     0.739828     7.40501e-03     9.37239e-04
  460.000     4.55204e+00        0.00000         5.71756e-02          0.98464       564.273     103.565     0.736984     7.85439e-03     1.01157e-03
  462.500     4.84039e+00        0.00000         6.06492e-02          0.98395       562.592     103.565     0.734079     8.32942e-03     1.09191e-03
  465.000     5.14592e+00        0.00000         6.43183e-02          0.98323       560.832     103.565     0.731110     8.83168e-03     1.17880e-03
  467.500     5.46975e+00        0.00000         6.81942e-02          0.98248       558.988     103.565     0.728074     9.36288e-03     1.27283e-03
  470.000     5.81304e+00        0.00000         7.22892e-02          0.98170       557.056     103.565     0.724967     9.92487e-03     1.37467e-03
  472.500     6.17708e+00        0.00000         7.66163e-02          0.98090       555.029     103.565     0.721786     1.05197e-02     1.48507e-03
  475.000     6.56326e+00        0.00000         8.11899e-02          0.98007       552.903     103.565     0.718527     1.11494e-02     1.60486e-03
  477.500     6.97310e+00        0.00000         8.60253e-02          0.97920       550.670     103.565     0.715186     1.18166e-02     1.73498e-03
  480.000     7.40827e+00        0.00000         9.11392e-02          0.97831       548.323     103.565     0.711759     1.25239e-02     1.87647e-03
  482.500     7.87061e+00        0.50000         9.77381e-01          0.97738       103.565     103.565     0.013274     1.32740e-02     1.00000e+00
  485.000     8.36214e+00        0.00000         1.02277e-01          0.97642       543.259     103.565     0.704624     1.40703e-02     2.19851e-03
  487.500     8.88510e+00        0.00000         1.08342e-01          0.97542       540.522     103.565     0.700905     1.49164e-02     2.38195e-03
  490.000     9.44199e+00        0.00000         1.14770e-01          0.97439       537.637     103.565     0.697076     1.58161e-02     2.58262e-03
  492.500     1.00356e+01        0.00000         1.21586e-01          0.97331       534.590     103.565     0.693129     1.67741e-02     2.80255e-03
  495.000     1.06691e+01        0.00000         1.28821e-01          0.97220       531.370     103.565     0.689057     1.77952e-02     3.04408e-03
  497.500     1.13459e+01        0.00000         1.36507e-01          0.97104       527.961     103.565     0.684850     1.88853e-02     3.30998e-03
  500.000     1.20703e+01        0.00000         1.44682e-01          0.96984       524.348     103.565     0.680496     2.00508e-02     3.60344e-03
  502.500     1.28467e+01        0.00000         1.53386e-01          0.96859       520.510     103.565     0.675983     2.12993e-02     3.92828e-03
  505.000     1.36806e+01        0.00000         1.62669e-01          0.96729       516.428     103.565     0.671298     2.26394e-02     4.28902e-03
  507.500     1.45783e+01        0.00000         1.72584e-01          0.96593       512.076     103.565     0.666423     2.40814e-02     4.69111e-03
  510.000     1.55471e+01        0.00000         1.83197e-01          0.96452       507.425     103.565     0.661339     2.56373e-02     5.14120e-03
  512.500     1.65959e+01        0.00000         1.94582e-01          0.96304       502.440     103.565     0.656023     2.73216e-02     5.64745e-03
  515.000     1.77353e+01        0.00000         2.06829e-01          0.96149       497.080     103.565     0.650445     2.91516e-02     6.22007e-03
  517.500     1.89786e+01        0.00000         2.20047e-01          0.95987       491.295     103.565     0.644573     3.11491e-02     6.87202e-03
  520.000     2.03422e+01        0.00000         2.34370e-01          0.95817       485.022     103.565     0.638362     3.33411e-02     7.62008e-03
  522.500     2.18473e+01        0.00000         2.49968e-01          0.95637       478.182     103.565     0.631757     3.57626e-02     8.48651e-03
  525.000     2.35217e+01        0.00000         2.67059e-01          0.95446       470.672     103.565     0.624686     3.84597e-02     9.50166e-03
  527.500     2.54037e+01        0.00000         2.85939e-01          0.95243       462.352     103.565     0.617049     4.14956e-02     1.07085e-02
  530.000     2.75480e+01        0.00000         3.07026e-01          0.95025       453.024     103.565     0.608704     4.49610e-02     1.21707e-02
  532.500     3.00378e+01        0.00000         3.30941e-01          0.94788       442.393     103.565     0.599438     4.89946e-02     1.39887e-02
  535.000     3.30116e+01        0.00000         3.58708e-01          0.94526       429.968     103.565     0.588892     5.38272e-02     1.63362e-02
  537.500     3.67348e+01        0.00000         3.92252e-01          0.94228       414.829     103.565     0.576387     5.99021e-02     1.95586e-02
  540.000     4.18669e+01        0.00000         4.36288e-01          0.93867       394.709     103.565     0.560234     6.83228e-02     2.45512e-02
  542.500     5.23404e+01        0.00000         5.18450e-01          0.93284       356.304     103.565     0.530411     8.56850e-02     3.69510e-02
  542.736     5.70565e+01        0.00000         5.52196e-01          0.93081       340.155     103.565     0.518113     9.35819e-02     4.36245e-02
  542.736     5.70938e+01        0.00000         5.52456e-01          0.93080       340.030     103.565     0.518018     9.36446e-02     4.36803e-02
  542.500     6.20488e+01        0.00000         5.85822e-01          0.92903       323.816     103.565     0.505741     1.01995e-01     5.15193e-02
  541.619     6.81785e+01        0.00000         6.24287e-01          0.92733       304.795     103.565     0.491362     1.12398e-01     6.24985e-02
  540.000     7.49137e+01        0.00000         6.63157e-01          0.92603       285.173     103.565     0.476483     1.23921e-01     7.63870e-02
  537.500     8.24257e+01        0.00000         7.02596e-01          0.92524       264.800     103.565     0.460900     1.36884e-01     9.44386e-02
  535.000     8.85173e+01        0.00000         7.31764e-01          0.92509       249.393     103.565     0.448968     1.47479e-01     1.11334e-01
  532.500     9.38478e+01        0.00000         7.55365e-01          0.92530       236.689     103.565     0.438999     1.56811e-01     1.27994e-01
  530.000     9.86825e+01        0.00000         7.75318e-01          0.92575       225.765     103.565     0.430314     1.65321e-01     1.44789e-01
  527.500     1.03160e+02        0.00000         7.92635e-01          0.92639       216.134     103.565     0.422555     1.73241e-01     1.61918e-01
  525.000     1.07363e+02        0.00000         8.07933e-01          0.92718       207.500     103.565     0.415507     1.80710e-01     1.79511e-01
  522.500     1.11346e+02        0.00000         8.21619e-01          0.92810       199.667     103.565     0.409028     1.87817e-01     1.97660e-01
  520.000     1.15147e+02        0.00000         8.33982e-01          0.92912       192.494     103.565     0.403019     1.94627e-01     2.16438e-01
  517.500     1.18795e+02        0.00000         8.45234e-01          0.93024       185.881     103.565     0.397408     2.01186e-01     2.35906e-01
  515.000     1.22309e+02        0.00000         8.55538e-01          0.93144       179.747     103.565     0.392138     2.07528e-01     2.56120e-01
  512.500     1.25707e+02        0.00000         8.65021e-01          0.93271       174.031     103.565     0.387167     2.13680e-01     2.77131e-01
  510.000     1.29002e+02        0.00000         8.73786e-01          0.93405       168.684     103.565     0.382460     2.19664e-01     2.98988e-01
  507.500     1.32203e+02        0.00000         8.81917e-01          0.93545       163.665     103.565     0.377988     2.25498e-01     3.21737e-01
  505.000     1.35320e+02        0.00000         8.89482e-01          0.93691       158.938     103.565     0.373729     2.31196e-01     3.45427e-01
  502.500     1.38360e+02        0.00000         8.96541e-01          0.93842       154.477     103.565     0.369662     2.36769e-01     3.70105e-01
  500.000     1.41329e+02        0.00000         9.03144e-01          0.93999       150.256     103.565     0.365771     2.42229e-01     3.95819e-01
  497.500     1.44233e+02        0.00000         9.09333e-01          0.94159       146.254     103.565     0.362041     2.47584e-01     4.22618e-01
  495.000     1.47075e+02        0.00000         9.15144e-01          0.94325       142.453     103.565     0.358461     2.52841e-01     4.50552e-01
  492.500     1.49861e+02        0.00000         9.20611e-01          0.94494       138.837     103.565     0.355018     2.58006e-01     4.79674e-01
  490.000     1.52592e+02        0.00000         9.25762e-01          0.94667       135.391     103.565     0.351704     2.63087e-01     5.10036e-01
  487.500     1.55272e+02        0.00000         9.30622e-01          0.94844       132.103     103.565     0.348509     2.68087e-01     5.41696e-01
  485.000     1.57905e+02        0.00000         9.35213e-01          0.95025       128.962     103.565     0.345427     2.73011e-01     5.74709e-01
  482.500     1.60492e+02        0.00000         9.39555e-01          0.95209       125.957     103.565     0.342451     2.77864e-01     6.09138e-01
  480.000     1.63035e+02        0.00000         9.43666e-01          0.95396       123.080     103.565     0.339573     2.82648e-01     6.45044e-01
  477.500     1.65536e+02        0.00000         9.47562e-01          0.95586       120.322     103.565     0.336790     2.87367e-01     6.82493e-01
  475.000     1.67997e+02        0.00000         9.51258e-01          0.95780       117.676     103.565     0.334095     2.92024e-01     7.21553e-01
  472.500     1.70420e+02        0.00000         9.54766e-01          0.95976       115.135     103.565     0.331484     2.96621e-01     7.62295e-01
  470.000     1.72805e+02        0.00000         9.58099e-01          0.96175       112.693     103.565     0.328953     3.01161e-01     8.04795e-01
  467.500     1.75155e+02        0.00000         9.61267e-01          0.96376       110.344     103.565     0.326499     3.05647e-01     8.49129e-01
  465.000     1.77470e+02        0.00000         9.64282e-01          0.96580       108.083     103.565     0.324116     3.10080e-01     8.95380e-01
  462.500     1.79752e+02        0.00000         9.67150e-01          0.96786       105.905     103.565     0.321803     3.14462e-01     9.43634e-01
  460.191     1.81830e+02        0.00000         9.69678e-01          0.96979       103.963     103.565     0.319726     3.18466e-01     9.90049e-01
  459.707     1.82262e+02        0.50000         9.70193e-01          0.97019       103.565     103.565     0.319298     3.19298e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   24.605     1.95013e+02        0.00000         1.21905e+00          1.10077       118.640     103.565     0.766623     7.41113e-01     6.61255e-01
   24.413     2.08683e+02        0.00000         1.30394e+00          1.17605       118.772     103.565     0.768301     7.42780e-01     6.57467e-01
   24.254     2.23311e+02        0.00000         1.39426e+00          1.25629       118.873     103.565     0.769960     7.44477e-01     6.54163e-01
   24.129     2.38965e+02        0.00000         1.49034e+00          1.34181       118.944     103.565     0.771602     7.46205e-01     6.51322e-01
   24.038     2.55716e+02        0.00000         1.59253e+00          1.43293       118.988     103.565     0.773232     7.47964e-01     6.48927e-01
   23.982     2.73641e+02        0.00000         1.70117e+00          1.53000       119.006     103.565     0.774855     7.49755e-01     6.46952e-01
   23.963     2.92822e+02        0.00000         1.81664e+00          1.63338       119.000     103.565     0.776472     7.51577e-01     6.45394e-01
   24.604     4.32014e+02        0.00000         2.63311e+00          2.36975       118.570     103.565     0.785803     7.62635e-01     6.43668e-01
   26.614     6.37368e+02        0.00000         3.78301e+00          3.41904       117.677     103.565     0.795486     7.74614e-01     6.52127e-01
   30.028     9.40337e+02        0.00000         5.39721e+00          4.90749       116.563     103.565     0.805646     7.87236e-01     6.67721e-01
   34.725     1.38732e+03        0.00000         7.66330e+00          7.01553       115.395     103.565     0.816089     8.00055e-01     6.87636e-01
   40.412     2.04677e+03        0.00000         1.08548e+01         10.00686       114.258     103.565     0.826374     8.12507e-01     7.09761e-01
   46.649     3.01969e+03        0.00000         1.53768e+01         14.27335       113.189     103.565     0.835972     8.24020e-01     7.32650e-01
   52.930     4.45508e+03        0.00000         2.18344e+01         20.40208       112.204     103.565     0.844433     8.34134e-01     7.55221e-01
   58.784     6.57277e+03        0.00000         3.11350e+01         29.27248       111.319     103.565     0.851501     8.42589e-01     7.76495e-01
   63.878     9.69710e+03        0.00000         4.46349e+01         42.19602       110.555     103.565     0.857127     8.49342e-01     7.95551e-01
   68.055     1.43065e+04        0.00000         6.43509e+01         61.11844       109.923     103.565     0.861431     8.54526e-01     8.11751e-01
   71.316     2.11071e+04        0.00000         9.32688e+01         88.91614       109.424     103.565     0.864617     8.58379e-01     8.24854e-01
   73.765     3.11402e+04        0.00000         1.35796e+02        129.83355       109.044     103.565     0.866919     8.61171e-01     8.34981e-01
   75.551     4.59424e+04        0.00000         1.98435e+02        190.13010       108.765     103.565     0.868551     8.63154e-01     8.42534e-01
   76.825     6.77808e+04        0.00000         2.90773e+02        279.03665       108.563     103.565     0.869692     8.64545e-01     8.48023e-01
   77.720     1.00000e+05        0.00001         4.26947e+02        410.16731       108.421     103.565     0.870483     8.65509e-01     8.51927e-01
END

$Env_BP << END
#   Temp      Sat Pres                                                                                     Liq Den      Gas Den           
#   (C)         (bar)       Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   ----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
  482.500       7.8706         0.5000            0.97738           0.97738        103.565     103.565     0.013274     0.013274     1.00000e+00
      NaN          NaN            NaN                NaN               NaN            NaN         NaN          NaN          NaN             NaN
  459.707     182.2616         0.5000            0.97019           0.97019        103.565     103.565     0.319298     0.319298     1.00000e+00
  459.224     182.6923         1.0000            0.97060           0.97070        103.565     103.169     0.320129     0.318870     9.90047e-01
  457.500     184.2180         1.0000            0.97206           0.97248        103.565     101.780     0.323080     0.317371     9.55556e-01
  455.000     186.4042         1.0000            0.97419           0.97497        103.565      99.825     0.327319     0.315248     9.07995e-01
  452.500     188.5602         1.0000            0.97634           0.97733        103.565      97.938     0.331513     0.313182     8.63162e-01
  450.000     190.6867         1.0000            0.97851           0.97959        103.565      96.114     0.335664     0.311173     8.20862e-01
  447.500     192.7844         1.0000            0.98070           0.98174        103.565      94.351     0.339773     0.309216     7.80919e-01
  445.000     194.8538         1.0000            0.98291           0.98379        103.565      92.645     0.343841     0.307312     7.43172e-01
  442.500     196.8955         1.0000            0.98514           0.98575        103.565      90.995     0.347869     0.305457     7.07473e-01
  440.000     198.9100         1.0000            0.98738           0.98762        103.565      89.397     0.351859     0.303649     6.73689e-01
  437.500     200.8978         1.0000            0.98965           0.98941        103.565      87.849     0.355810     0.301888     6.41693e-01
  435.000     202.8592         1.0000            0.99192           0.99112        103.565      86.349     0.359724     0.300172     6.11373e-01
  432.500     204.7948         1.0000            0.99422           0.99274        103.565      84.895     0.363602     0.298498     5.82624e-01
  430.000     206.7049         1.0000            0.99653           0.99430        103.565      83.485     0.367444     0.296866     5.55348e-01
  427.500     208.5898         1.0000            0.99885           0.99578        103.565      82.117     0.371252     0.295274     5.29455e-01
  425.000     210.4498         1.0000            1.00119           0.99720        103.565      80.789     0.375026     0.293721     5.04864e-01
  422.500     212.2853         1.0000            1.00354           0.99855        103.565      79.499     0.378767     0.292205     4.81497e-01
  420.000     214.0966         1.0000            1.00591           0.99984        103.565      78.247     0.382475     0.290726     4.59284e-01
  417.500     215.8838         1.0000            1.00828           1.00107        103.565      77.030     0.386152     0.289282     4.38157e-01
  415.000     217.6473         1.0000            1.01067           1.00224        103.565      75.847     0.389797     0.287872     4.18055e-01
  412.500     219.3873         1.0000            1.01307           1.00336        103.565      74.696     0.393411     0.286496     3.98921e-01
  410.000     221.1040         1.0000            1.01548           1.00442        103.565      73.578     0.396995     0.285152     3.80701e-01
  407.500     222.7975         1.0000            1.01791           1.00544        103.565      72.489     0.400550     0.283839     3.63346e-01
  405.000     224.4682         1.0000            1.02034           1.00640        103.565      71.430     0.404075     0.282556     3.46809e-01
  402.500     226.1160         1.0000            1.02278           1.00732        103.565      70.399     0.407572     0.281303     3.31046e-01
  400.000     227.7412         1.0000            1.02524           1.00819        103.565      69.395     0.411041     0.280079     3.16017e-01
  397.500     229.3440         1.0000            1.02770           1.00901        103.565      68.416     0.414482     0.278882     3.01683e-01
  395.000     230.9244         1.0000            1.03017           1.00980        103.565      67.463     0.417895     0.277713     2.88009e-01
  392.500     232.4826         1.0000            1.03264           1.01054        103.565      66.534     0.421282     0.276570     2.74961e-01
  390.000     234.0187         1.0000            1.03513           1.01124        103.565      65.629     0.424642     0.275453     2.62506e-01
  387.500     235.5328         1.0000            1.03762           1.01190        103.565      64.746     0.427977     0.274360     2.50616e-01
  385.000     237.0250         1.0000            1.04012           1.01252        103.565      63.885     0.431285     0.273292     2.39263e-01
  382.500     238.4953         1.0000            1.04262           1.01311        103.565      63.044     0.434569     0.272248     2.28420e-01
  380.000     239.9440         1.0000            1.04514           1.01366        103.565      62.225     0.437827     0.271227     2.18062e-01
  377.500     241.3709         1.0000            1.04765           1.01417        103.565      61.424     0.441061     0.270228     2.08167e-01
  375.000     242.7763         1.0000            1.05017           1.01465        103.565      60.643     0.444271     0.269251     1.98711e-01
  372.500     244.1601         1.0000            1.05270           1.01510        103.565      59.880     0.447457     0.268296     1.89674e-01
  370.000     245.5224         1.0000            1.05523           1.01552        103.565      59.134     0.450619     0.267361     1.81037e-01
  367.500     246.8632         1.0000            1.05777           1.01590        103.565      58.406     0.453758     0.266447     1.72780e-01
  365.000     248.1827         1.0000            1.06030           1.01625        103.565      57.695     0.456874     0.265552     1.64886e-01
  362.500     249.4807         1.0000            1.06285           1.01657        103.565      56.999     0.459967     0.264677     1.57339e-01
  360.000     250.7574         1.0000            1.06539           1.01686        103.565      56.319     0.463038     0.263821     1.50122e-01
  357.500     252.0127         1.0000            1.06794           1.01713        103.565      55.655     0.466087     0.262982     1.43221e-01
  355.000     253.2468         1.0000            1.07048           1.01736        103.565      55.005     0.469114     0.262162     1.36621e-01
  352.500     254.4595         1.0000            1.07303           1.01756        103.565      54.369     0.472120     0.261360     1.30309e-01
  350.000     255.6509         1.0000            1.07558           1.01774        103.565      53.746     0.475104     0.260574     1.24272e-01
  347.500     256.8210         1.0000            1.07814           1.01789        103.565      53.137     0.478067     0.259805     1.18498e-01
  345.000     257.9698         1.0000            1.08069           1.01801        103.565      52.541     0.481010     0.259053     1.12976e-01
  342.500     259.0973         1.0000            1.08324           1.01811        103.565      51.958     0.483931     0.258316     1.07693e-01
  340.000     260.2034         1.0000            1.08579           1.01818        103.565      51.387     0.486833     0.257595     1.02641e-01
  337.500     261.2883         1.0000            1.08834           1.01822        103.565      50.827     0.489714     0.256889     9.78080e-02
  335.000     262.3518         1.0000            1.09088           1.01824        103.565      50.279     0.492576     0.256198     9.31858e-02
  332.500     263.3939         1.0000            1.09343           1.01823        103.565      49.742     0.495418     0.255521     8.87649e-02
  330.000     264.4146         1.0000            1.09597           1.01820        103.565      49.216     0.498241     0.254858     8.45368e-02
  327.500     265.4139         1.0000            1.09851           1.01814        103.565      48.700     0.501044     0.254210     8.04933e-02
  325.000     266.3918         1.0000            1.10105           1.01806        103.565      48.195     0.503829     0.253574     7.66265e-02
  322.500     267.3481         1.0000            1.10358           1.01796        103.565      47.700     0.506594     0.252952     7.29290e-02
  320.000     268.2830         1.0000            1.10611           1.01782        103.565      47.214     0.509341     0.252342     6.93937e-02
  317.500     269.1962         1.0000            1.10863           1.01767        103.565      46.737     0.512070     0.251745     6.60136e-02
  315.000     270.0879         1.0000            1.11115           1.01749        103.565      46.270     0.514781     0.251161     6.27824e-02
  312.500     270.9578         1.0000            1.11366           1.01729        103.565      45.811     0.517473     0.250588     5.96938e-02
  310.000     271.8061         1.0000            1.11617           1.01706        103.565      45.362     0.520148     0.250027     5.67419e-02
  307.500     272.6327         1.0000            1.11867           1.01681        103.565      44.920     0.522805     0.249477     5.39210e-02
  305.000     273.4374         1.0000            1.12116           1.01653        103.565      44.487     0.525445     0.248939     5.12255e-02
  302.500     274.2202         1.0000            1.12365           1.01624        103.565      44.061     0.528067     0.248411     4.86505e-02
  300.000     274.9811         1.0000            1.12612           1.01591        103.565      43.644     0.530673     0.247894     4.61907e-02
  297.500     275.7200         1.0000            1.12859           1.01557        103.565      43.234     0.533261     0.247387     4.38416e-02
  295.000     276.4368         1.0000            1.13105           1.01520        103.565      42.831     0.535833     0.246891     4.15984e-02
  292.500     277.1316         1.0000            1.13350           1.01481        103.565      42.435     0.538388     0.246404     3.94569e-02
  290.000     277.8041         1.0000            1.13594           1.01439        103.565      42.047     0.540927     0.245927     3.74128e-02
  287.500     278.4543         1.0000            1.13836           1.01395        103.565      41.665     0.543450     0.245460     3.54622e-02
  285.000     279.0822         1.0000            1.14078           1.01348        103.565      41.289     0.545956     0.245001     3.36010e-02
  282.500     279.6877         1.0000            1.14318           1.01300        103.565      40.921     0.548447     0.244552     3.18258e-02
  280.000     280.2707         1.0000            1.14557           1.01248        103.565      40.558     0.550922     0.244111     3.01328e-02
  277.500     280.8311         1.0000            1.14795           1.01195        103.565      40.201     0.553381     0.243679     2.85187e-02
  275.000     281.3688         1.0000            1.15032           1.01139        103.565      39.851     0.555825     0.243256     2.69802e-02
  272.500     281.8838         1.0000            1.15266           1.01080        103.565      39.506     0.558253     0.242840     2.55143e-02
  270.000     282.3760         1.0000            1.15500           1.01019        103.565      39.167     0.560667     0.242433     2.41177e-02
  267.500     282.8452         1.0000            1.15732           1.00956        103.565      38.834     0.563065     0.242033     2.27878e-02
  265.000     283.2914         1.0000            1.15962           1.00890        103.565      38.505     0.565448     0.241641     2.15216e-02
  262.500     283.7144         1.0000            1.16190           1.00821        103.565      38.183     0.567817     0.241256     2.03165e-02
  260.000     284.1143         1.0000            1.16417           1.00750        103.565      37.865     0.570171     0.240879     1.91700e-02
  257.500     284.4908         1.0000            1.16642           1.00677        103.565      37.552     0.572510     0.240508     1.80796e-02
  255.000     284.8440         1.0000            1.16865           1.00601        103.565      37.244     0.574836     0.240144     1.70428e-02
  252.500     285.1736         1.0000            1.17086           1.00522        103.565      36.941     0.577147     0.239788     1.60575e-02
  250.000     285.4796         1.0000            1.17305           1.00441        103.565      36.643     0.579443     0.239437     1.51214e-02
  247.500     285.7618         1.0000            1.17522           1.00357        103.565      36.349     0.581726     0.239093     1.42324e-02
  245.000     286.0203         1.0000            1.17736           1.00271        103.565      36.059     0.583995     0.238755     1.33885e-02
  242.500     286.2547         1.0000            1.17949           1.00181        103.565      35.774     0.586251     0.238424     1.25877e-02
  240.000     286.4651         1.0000            1.18158           1.00089        103.565      35.494     0.588493     0.238098     1.18282e-02
  237.500     286.6514         1.0000            1.18366           0.99995        103.565      35.217     0.590721     0.237778     1.11081e-02
  235.000     286.8133         1.0000            1.18571           0.99897        103.565      34.944     0.592936     0.237464     1.04258e-02
  232.500     286.9508         1.0000            1.18773           0.99797        103.565      34.676     0.595138     0.237155     9.77948e-03
  230.000     287.0638         1.0000            1.18973           0.99694        103.565      34.411     0.597327     0.236851     9.16762e-03
  227.500     287.1521         1.0000            1.19170           0.99587        103.565      34.150     0.599502     0.236553     8.58866e-03
  225.000     287.2156         1.0000            1.19363           0.99478        103.565      33.893     0.601665     0.236260     8.04111e-03
  222.500     287.2542         1.0000            1.19554           0.99367        103.565      33.639     0.603815     0.235972     7.52354e-03
  220.000     287.2678         1.0000            1.19742           0.99252        103.565      33.389     0.605953     0.235689     7.03457e-03
  217.500     287.2561         1.0000            1.19927           0.99134        103.565      33.142     0.608078     0.235410     6.57289e-03
  215.000     287.2192         1.0000            1.20108           0.99012        103.565      32.899     0.610190     0.235136     6.13722e-03
  212.500     287.1568         1.0000            1.20286           0.98888        103.565      32.659     0.612290     0.234867     5.72634e-03
  210.000     287.0688         1.0000            1.20461           0.98761        103.565      32.422     0.614378     0.234602     5.33907e-03
  207.500     286.9550         1.0000            1.20632           0.98630        103.565      32.189     0.616454     0.234341     4.97429e-03
  205.000     286.8154         1.0000            1.20799           0.98496        103.565      31.959     0.618518     0.234084     4.63091e-03
  202.500     286.6497         1.0000            1.20963           0.98359        103.565      31.731     0.620569     0.233832     4.30789e-03
  200.000     286.4579         1.0000            1.21122           0.98218        103.565      31.507     0.622610     0.233583     4.00422e-03
  197.500     286.2397         1.0000            1.21278           0.98074        103.565      31.286     0.624638     0.233339     3.71894e-03
  195.000     285.9950         1.0000            1.21429           0.97927        103.565      31.067     0.626655     0.233098     3.45113e-03
  192.500     285.7237         1.0000            1.21576           0.97776        103.565      30.851     0.628660     0.232861     3.19990e-03
  190.000     285.4256         1.0000            1.21719           0.97621        103.565      30.639     0.630654     0.232628     2.96441e-03
  187.500     285.1005         1.0000            1.21857           0.97463        103.565      30.428     0.632636     0.232398     2.74382e-03
  185.000     284.7483         1.0000            1.21991           0.97301        103.565      30.221     0.634607     0.232172     2.53737e-03
  182.500     284.3688         1.0000            1.22119           0.97135        103.565      30.016     0.636567     0.231949     2.34431e-03
  180.000     283.9618         1.0000            1.22243           0.96965        103.565      29.814     0.638516     0.231729     2.16390e-03
  177.500     283.5272         1.0000            1.22362           0.96792        103.565      29.614     0.640454     0.231513     1.99547e-03
  175.000     283.0647         1.0000            1.22475           0.96614        103.565      29.416     0.642381     0.231300     1.83835e-03
  172.500     282.5742         1.0000            1.22583           0.96432        103.565      29.221     0.644298     0.231091     1.69191e-03
  170.000     282.0556         1.0000            1.22686           0.96246        103.565      29.029     0.646203     0.230884     1.55556e-03
  167.500     281.5086         1.0000            1.22782           0.96056        103.565      28.839     0.648098     0.230680     1.42871e-03
  165.000     280.9330         1.0000            1.22873           0.95862        103.565      28.651     0.649983     0.230480     1.31082e-03
  162.500     280.3286         1.0000            1.22958           0.95663        103.565      28.465     0.651857     0.230282     1.20135e-03
  160.000     279.6954         1.0000            1.23036           0.95460        103.565      28.282     0.653720     0.230088     1.09981e-03
  157.500     279.0330         1.0000            1.23108           0.95253        103.565      28.100     0.655574     0.229896     1.00571e-03
  155.000     278.3412         1.0000            1.23174           0.95040        103.565      27.921     0.657417     0.229707     9.18612e-04
  152.500     277.6199         1.0000            1.23233           0.94823        103.565      27.744     0.659250     0.229521     8.38068e-04
  150.000     276.8688         1.0000            1.23285           0.94601        103.565      27.569     0.661073     0.229337     7.63670e-04
  147.500     276.0878         1.0000            1.23329           0.94375        103.565      27.397     0.662886     0.229157     6.95024e-04
  145.000     275.2765         1.0000            1.23366           0.94143        103.565      27.226     0.664689     0.228979     6.31759e-04
  142.500     274.4349         1.0000            1.23396           0.93906        103.565      27.057     0.666482     0.228803     5.73520e-04
  140.000     273.5626         1.0000            1.23418           0.93664        103.565      26.890     0.668266     0.228631     5.19971e-04
  137.500     272.6594         1.0000            1.23432           0.93417        103.565      26.725     0.670039     0.228461     4.70795e-04
  135.000     271.7252         1.0000            1.23437           0.93164        103.565      26.562     0.671804     0.228293     4.25690e-04
  132.500     270.7597         1.0000            1.23434           0.92905        103.565      26.401     0.673558     0.228128     3.84373e-04
  130.000     269.7625         1.0000            1.23422           0.92641        103.565      26.242     0.675304     0.227966     3.46575e-04
  127.500     268.7336         1.0000            1.23402           0.92371        103.565      26.084     0.677039     0.227806     3.12041e-04
  125.000     267.6726         1.0000            1.23372           0.92095        103.565      25.929     0.678766     0.227649     2.80533e-04
  122.500     266.5793         1.0000            1.23332           0.91813        103.565      25.775     0.680483     0.227494     2.51826e-04
  120.000     265.4534         1.0000            1.23283           0.91525        103.565      25.623     0.682191     0.227342     2.25707e-04
  117.500     264.2947         1.0000            1.23223           0.91231        103.565      25.472     0.683890     0.227191     2.01978e-04
  115.000     263.1028         1.0000            1.23153           0.90930        103.565      25.324     0.685580     0.227044     1.80453e-04
  112.500     261.8776         1.0000            1.23073           0.90623        103.565      25.177     0.687261     0.226899     1.60956e-04
  110.000     260.6188         1.0000            1.22981           0.90308        103.565      25.031     0.688933     0.226756     1.43324e-04
  107.500     259.3260         1.0000            1.22878           0.89987        103.565      24.888     0.690596     0.226615     1.27404e-04
  105.000     257.9990         1.0000            1.22763           0.89659        103.565      24.746     0.692251     0.226477     1.13053e-04
  102.500     256.6375         1.0000            1.22637           0.89323        103.565      24.605     0.693896     0.226341     1.00138e-04
  100.000     255.2411         1.0000            1.22498           0.88980        103.565      24.466     0.695533     0.226207     8.85346e-05
   97.500     253.8097         1.0000            1.22346           0.88630        103.565      24.329     0.697162     0.226076     7.81284e-05
   95.000     252.3428         1.0000            1.22181           0.88272        103.565      24.193     0.698781     0.225947     6.88124e-05
   92.500     250.8402         1.0000            1.22002           0.87906        103.565      24.059     0.700393     0.225819     6.04876e-05
   90.000     249.3016         1.0000            1.21810           0.87531        103.565      23.926     0.701996     0.225694     5.30624e-05
   87.500     247.7265         1.0000            1.21603           0.87148        103.565      23.795     0.703590     0.225571     4.64524e-05
   85.000     246.1148         1.0000            1.21382           0.86757        103.565      23.666     0.705176     0.225450     4.05795e-05
   82.500     244.4659         1.0000            1.21145           0.86357        103.565      23.537     0.706754     0.225331     3.53722e-05
   80.000     242.7797         1.0000            1.20893           0.85948        103.565      23.411     0.708324     0.225213     3.07644e-05
   77.500     241.0557         1.0000            1.20624           0.85530        103.565      23.285     0.709886     0.225098     2.66958e-05
   75.000     239.2936         1.0000            1.20339           0.85102        103.565      23.161     0.711439     0.224984     2.31110e-05
   72.500     237.4930         1.0000            1.20036           0.84665        103.565      23.039     0.712985     0.224872     1.99595e-05
   70.000     235.6536         1.0000            1.19716           0.84218        103.565      22.918     0.714522     0.224761     1.71953e-05
   67.500     233.7749         1.0000            1.19378           0.83761        103.565      22.798     0.716052     0.224652     1.47764e-05
   65.000     231.8566         1.0000            1.19021           0.83293        103.565      22.679     0.717573     0.224543     1.26648e-05
   62.500     229.8983         1.0000            1.18644           0.82814        103.565      22.562     0.719087     0.224436     1.08260e-05
   60.000     227.8996         1.0000            1.18247           0.82325        103.565      22.447     0.720593     0.224330     9.22872e-06
   57.500     225.8601         1.0000            1.17830           0.81824        103.565      22.332     0.722092     0.224225     7.84491e-06
   55.000     223.7793         1.0000            1.17392           0.81312        103.565      22.219     0.723583     0.224120     6.64923e-06
   52.500     221.6568         1.0000            1.16931           0.80788        103.565      22.107     0.725066     0.224016     5.61894e-06
   50.000     219.4923         1.0000            1.16448           0.80252        103.565      21.997     0.726541     0.223912     4.73368e-06
   47.500     217.2852         1.0000            1.15942           0.79704        103.565      21.887     0.728009     0.223808     3.97523e-06
   45.000     215.0351         1.0000            1.15411           0.79142        103.565      21.779     0.729470     0.223704     3.32738e-06
   42.500     212.7416         1.0000            1.14856           0.78568        103.565      21.672     0.730923     0.223599     2.77571e-06
   40.000     210.4041         1.0000            1.14275           0.77980        103.565      21.566     0.732369     0.223493     2.30744e-06
   37.500     208.0222         1.0000            1.13667           0.77378        103.565      21.462     0.733807     0.223386     1.91125e-06
   35.000     205.5955         1.0000            1.13032           0.76762        103.565      21.359     0.735239     0.223277     1.57720e-06
   32.500     203.1234         1.0000            1.12369           0.76131        103.565      21.256     0.736663     0.223166     1.29651e-06
   30.000     200.6054         1.0000            1.11676           0.75486        103.565      21.155     0.738079     0.223052     1.06152e-06
   27.500     198.0410         1.0000            1.10953           0.74825        103.565      21.055     0.739489     0.222935     8.65528e-07
   25.000     195.4297         1.0000            1.10199           0.74148        103.565      20.957     0.740892     0.222814     7.02688e-07
   24.605     195.0127         1.0000            1.10077           0.74040        103.565      20.941     0.741113     0.222795     6.79644e-07
END

set output "Figures/Env_003_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:5.0e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_003_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab2_Slimtube_Oil\n with Lab2_Slimtube_Gas at 95.6 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-12        1.00000e+00        2.23361e-13        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-12        1.00000e+00        4.46722e-13        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-12        1.00000e+00        1.11681e-12        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-11        1.00000e+00        2.23361e-12        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-11        1.00000e+00        4.46722e-12        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-11        1.00000e+00        1.11681e-11        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-10        1.00000e+00        2.23361e-11        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-10        1.00000e+00        4.46722e-11        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-10        1.00000e+00        1.11681e-10        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-09        1.00000e+00        2.23361e-10        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-09        1.00000e+00        4.46722e-10        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-09        1.00000e+00        1.11681e-09        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-08        1.00000e+00        2.23361e-09        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-08        1.00000e+00        4.46722e-09        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-08        1.00000e+00        1.11681e-08        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-07        1.00000e+00        2.23361e-08        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-07        1.00000e+00        4.46722e-08        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-07        1.00000e+00        1.11681e-07        1.00000e+00       2.88599e-09        0.00000         6.17270e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   1.00000e-06        9.99999e-01        2.23361e-07        1.00000e+00       2.88599e-09        0.00000         6.17271e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   2.00000e-06        9.99998e-01        4.46723e-07        1.00000e+00       2.88599e-09        0.00000         6.17271e-11          1.00000       602.885     103.565     0.919474     9.74974e-12     2.73042e-13
   5.00000e-06        9.99995e-01        1.11681e-06        9.99999e-01       2.88600e-09        0.00000         6.17273e-11          1.00000       602.885     103.565     0.919474     9.74975e-12     2.73042e-13
   1.00000e-05        9.99990e-01        2.23363e-06        9.99998e-01       2.88601e-09        0.00000         6.17276e-11          1.00000       602.885     103.564     0.919474     9.74976e-12     2.73042e-13
   2.00000e-05        9.99980e-01        4.46729e-06        9.99996e-01       2.88604e-09        0.00000         6.17282e-11          1.00000       602.885     103.563     0.919474     9.74978e-12     2.73042e-13
   5.00000e-05        9.99950e-01        1.11685e-05        9.99989e-01       2.88613e-09        0.00000         6.17301e-11          1.00000       602.885     103.561     0.919474     9.74984e-12     2.73042e-13
   1.00000e-04        9.99900e-01        2.23378e-05        9.99978e-01       2.88627e-09        0.00000         6.17332e-11          1.00000       602.885     103.557     0.919474     9.74995e-12     2.73042e-13
   2.00000e-04        9.99800e-01        4.46792e-05        9.99955e-01       2.88656e-09        0.00000         6.17393e-11          1.00000       602.885     103.549     0.919474     9.75017e-12     2.73042e-13
   5.00000e-04        9.99500e-01        1.11724e-04        9.99888e-01       2.88743e-09        0.00000         6.17579e-11          1.00000       602.885     103.525     0.919474     9.75082e-12     2.73042e-13
   1.00000e-03        9.99000e-01        2.23535e-04        9.99776e-01       2.88887e-09        0.00000         6.17888e-11          1.00000       602.885     103.484     0.919474     9.75192e-12     2.73042e-13
   2.00000e-03        9.98000e-01        4.47417e-04        9.99553e-01       2.89177e-09        0.00000         6.18507e-11          1.00000       602.885     103.404     0.919474     9.75410e-12     2.73042e-13
   5.00000e-03        9.95000e-01        1.12116e-03        9.98879e-01       2.90049e-09        0.00000         6.20372e-11          1.00000       602.885     103.163     0.919474     9.76068e-12     2.73042e-13
   1.00000e-02        9.90000e-01        2.25109e-03        9.97749e-01       2.91514e-09        0.00000         6.23505e-11          1.00000       602.885     102.761     0.919474     9.77173e-12     2.73042e-13
   2.00000e-02        9.80000e-01        4.53771e-03        9.95462e-01       2.94488e-09        0.00000         6.29867e-11          1.00000       602.885     101.956     0.919474     9.79418e-12     2.73042e-13
   3.00000e-02        9.70000e-01        6.86068e-03        9.93139e-01       2.97524e-09        0.00000         6.36361e-11          1.00000       602.885     101.152     0.919474     9.81709e-12     2.73042e-13
   4.00000e-02        9.60000e-01        9.22090e-03        9.90779e-01       3.00623e-09        0.00000         6.42990e-11          1.00000       602.885     100.348     0.919474     9.84047e-12     2.73042e-13
   5.00000e-02        9.50000e-01        1.16193e-02        9.88381e-01       3.03788e-09        0.00000         6.49758e-11          1.00000       602.885      99.543     0.919474     9.86435e-12     2.73042e-13
   6.00000e-02        9.40000e-01        1.40567e-02        9.85943e-01       3.07020e-09        0.00000         6.56670e-11          1.00000       602.885      98.739     0.919474     9.88874e-12     2.73042e-13
   7.00000e-02        9.30000e-01        1.65342e-02        9.83466e-01       3.10321e-09        0.00000         6.63731e-11          1.00000       602.885      97.935     0.919474     9.91365e-12     2.73042e-13
   8.00000e-02        9.20000e-01        1.90527e-02        9.80947e-01       3.13694e-09        0.00000         6.70946e-11          1.00000       602.885      97.130     0.919474     9.93910e-12     2.73042e-13
   9.00000e-02        9.10000e-01        2.16132e-02        9.78387e-01       3.17141e-09        0.00000         6.78319e-11          1.00000       602.885      96.326     0.919474     9.96511e-12     2.73042e-13
   1.00000e-01        9.00000e-01        2.42169e-02        9.75783e-01       3.20665e-09        0.00000         6.85856e-11          1.00000       602.885      95.522     0.919474     9.99170e-12     2.73042e-13
   1.10000e-01        8.90000e-01        2.68648e-02        9.73135e-01       3.24268e-09        0.00000         6.93562e-11          1.00000       602.885      94.717     0.919474     1.00189e-11     2.73042e-13
   1.20000e-01        8.80000e-01        2.95580e-02        9.70442e-01       3.27953e-09        0.00000         7.01443e-11          1.00000       602.885      93.913     0.919474     1.00467e-11     2.73042e-13
   1.30000e-01        8.70000e-01        3.22978e-02        9.67702e-01       3.31722e-09        0.00000         7.09506e-11          1.00000       602.885      93.109     0.919474     1.00751e-11     2.73042e-13
   1.40000e-01        8.60000e-01        3.50854e-02        9.64915e-01       3.35580e-09        0.00000         7.17756e-11          1.00000       602.885      92.304     0.919474     1.01042e-11     2.73042e-13
   1.50000e-01        8.50000e-01        3.79219e-02        9.62078e-01       3.39528e-09        0.00000         7.26200e-11          1.00000       602.885      91.500     0.919474     1.01340e-11     2.73042e-13
   1.60000e-01        8.40000e-01        4.08088e-02        9.59191e-01       3.43570e-09        0.00000         7.34845e-11          1.00000       602.885      90.696     0.919474     1.01645e-11     2.73042e-13
   1.70000e-01        8.30000e-01        4.37473e-02        9.56253e-01       3.47709e-09        0.00000         7.43699e-11          1.00000       602.885      89.891     0.919474     1.01958e-11     2.73042e-13
   1.80000e-01        8.20000e-01        4.67389e-02        9.53261e-01       3.51949e-09        0.00000         7.52768e-11          1.00000       602.885      89.087     0.919474     1.02278e-11     2.73042e-13
   1.90000e-01        8.10000e-01        4.97849e-02        9.50215e-01       3.56294e-09        0.00000         7.62062e-11          1.00000       602.885      88.283     0.919474     1.02606e-11     2.73042e-13
   2.00000e-01        8.00000e-01        5.28870e-02        9.47113e-01       3.60748e-09        0.00000         7.71587e-11          1.00000       602.885      87.478     0.919474     1.02942e-11     2.73042e-13
   2.10000e-01        7.90000e-01        5.60467e-02        9.43953e-01       3.65315e-09        0.00000         7.81354e-11          1.00000       602.885      86.674     0.919474     1.03286e-11     2.73042e-13
   2.20000e-01        7.80000e-01        5.92656e-02        9.40734e-01       3.69998e-09        0.00000         7.91372e-11          1.00000       602.885      85.870     0.919474     1.03640e-11     2.73042e-13
   2.30000e-01        7.70000e-01        6.25453e-02        9.37455e-01       3.74803e-09        0.00000         8.01649e-11          1.00000       602.885      85.065     0.919474     1.04002e-11     2.73042e-13
   2.40000e-01        7.60000e-01        6.58877e-02        9.34112e-01       3.79735e-09        0.00000         8.12197e-11          1.00000       602.885      84.261     0.919474     1.04374e-11     2.73042e-13
   2.50000e-01        7.50000e-01        6.92945e-02        9.30706e-01       3.84798e-09        0.00000         8.23027e-11          1.00000       602.885      83.457     0.919474     1.04756e-11     2.73042e-13
   2.60000e-01        7.40000e-01        7.27676e-02        9.27232e-01       3.89998e-09        0.00000         8.34149e-11          1.00000       602.885      82.652     0.919474     1.05149e-11     2.73042e-13
   2.70000e-01        7.30000e-01        7.63089e-02        9.23691e-01       3.95340e-09        0.00000         8.45575e-11          1.00000       602.885      81.848     0.919474     1.05552e-11     2.73042e-13
   2.80000e-01        7.20000e-01        7.99205e-02        9.20079e-01       4.00831e-09        0.00000         8.57319e-11          1.00000       602.885      81.044     0.919474     1.05966e-11     2.73042e-13
   2.90000e-01        7.10000e-01        8.36046e-02        9.16395e-01       4.06477e-09        0.00000         8.69394e-11          1.00000       602.885      80.239     0.919474     1.06392e-11     2.73042e-13
   3.00000e-01        7.00000e-01        8.73632e-02        9.12637e-01       4.12284e-09        0.00000         8.81814e-11          1.00000       602.885      79.435     0.919474     1.06830e-11     2.73042e-13
   3.10000e-01        6.90000e-01        9.11988e-02        9.08801e-01       4.18259e-09        0.00000         8.94594e-11          1.00000       602.885      78.631     0.919474     1.07281e-11     2.73042e-13
   3.20000e-01        6.80000e-01        9.51136e-02        9.04886e-01       4.24410e-09        0.00000         9.07750e-11          1.00000       602.885      77.826     0.919474     1.07745e-11     2.73042e-13
   3.30000e-01        6.70000e-01        9.91102e-02        9.00890e-01       4.30744e-09        0.00000         9.21298e-11          1.00000       602.885      77.022     0.919474     1.08223e-11     2.73042e-13
   3.40000e-01        6.60000e-01        1.03191e-01        8.96809e-01       4.37270e-09        0.00000         9.35258e-11          1.00000       602.885      76.218     0.919474     1.08716e-11     2.73042e-13
   3.50000e-01        6.50000e-01        1.07359e-01        8.92641e-01       4.43998e-09        0.00000         9.49646e-11          1.00000       602.885      75.414     0.919474     1.09223e-11     2.73042e-13
   3.60000e-01        6.40000e-01        1.11617e-01        8.88383e-01       4.50935e-09        0.00000         9.64484e-11          1.00000       602.885      74.609     0.919474     1.09747e-11     2.73042e-13
   3.70000e-01        6.30000e-01        1.15968e-01        8.84032e-01       4.58093e-09        0.00000         9.79794e-11          1.00000       602.885      73.805     0.919474     1.10287e-11     2.73042e-13
   3.80000e-01        6.20000e-01        1.20414e-01        8.79586e-01       4.65481e-09        0.00000         9.95597e-11          1.00000       602.885      73.001     0.919474     1.10845e-11     2.73042e-13
   3.90000e-01        6.10000e-01        1.24960e-01        8.75040e-01       4.73112e-09        0.00000         1.01192e-10          1.00000       602.885      72.196     0.919474     1.11420e-11     2.73042e-13
   4.00000e-01        6.00000e-01        1.29608e-01        8.70392e-01       4.80998e-09        0.00000         1.02878e-10          1.00000       602.885      71.392     0.919474     1.12015e-11     2.73042e-13
   4.10000e-01        5.90000e-01        1.34362e-01        8.65638e-01       4.89150e-09        0.00000         1.04622e-10          1.00000       602.885      70.588     0.919474     1.12631e-11     2.73042e-13
   4.20000e-01        5.80000e-01        1.39225e-01        8.60775e-01       4.97584e-09        0.00000         1.06426e-10          1.00000       602.885      69.783     0.919474     1.13267e-11     2.73042e-13
   4.30000e-01        5.70000e-01        1.44202e-01        8.55798e-01       5.06313e-09        0.00000         1.08293e-10          1.00000       602.885      68.979     0.919474     1.13926e-11     2.73042e-13
   4.40000e-01        5.60000e-01        1.49297e-01        8.50703e-01       5.15354e-09        0.00000         1.10227e-10          1.00000       602.885      68.175     0.919474     1.14608e-11     2.73042e-13
   4.50000e-01        5.50000e-01        1.54513e-01        8.45487e-01       5.24725e-09        0.00000         1.12231e-10          1.00000       602.885      67.370     0.919474     1.15315e-11     2.73042e-13
   4.60000e-01        5.40000e-01        1.59855e-01        8.40145e-01       5.34442e-09        0.00000         1.14309e-10          1.00000       602.885      66.566     0.919474     1.16048e-11     2.73042e-13
   4.70000e-01        5.30000e-01        1.65328e-01        8.34672e-01       5.44525e-09        0.00000         1.16466e-10          1.00000       602.885      65.762     0.919474     1.16809e-11     2.73042e-13
   4.80000e-01        5.20000e-01        1.70936e-01        8.29064e-01       5.54997e-09        0.00000         1.18706e-10          1.00000       602.885      64.957     0.919474     1.17599e-11     2.73042e-13
   4.90000e-01        5.10000e-01        1.76685e-01        8.23315e-01       5.65879e-09        0.00000         1.21033e-10          1.00000       602.885      64.153     0.919474     1.18420e-11     2.73042e-13
   5.00000e-01        5.00000e-01        1.82580e-01        8.17420e-01       5.77197e-09        0.00000         1.23454e-10          1.00000       602.885      63.349     0.919474     1.19274e-11     2.73042e-13
   5.10000e-01        4.90000e-01        1.88626e-01        8.11374e-01       5.88977e-09        0.00000         1.25973e-10          1.00000       602.885      62.544     0.919474     1.20163e-11     2.73042e-13
   5.20000e-01        4.80000e-01        1.94831e-01        8.05169e-01       6.01247e-09        0.00000         1.28598e-10          1.00000       602.885      61.740     0.919474     1.21089e-11     2.73042e-13
   5.30000e-01        4.70000e-01        2.01198e-01        7.98802e-01       6.14039e-09        0.00000         1.31334e-10          1.00000       602.885      60.936     0.919474     1.22055e-11     2.73042e-13
   5.40000e-01        4.60000e-01        2.07737e-01        7.92263e-01       6.27388e-09        0.00000         1.34189e-10          1.00000       602.885      60.131     0.919474     1.23062e-11     2.73042e-13
   5.50000e-01        4.50000e-01        2.14452e-01        7.85548e-01       6.41330e-09        0.00000         1.37171e-10          1.00000       602.885      59.327     0.919474     1.24114e-11     2.73042e-13
   5.60000e-01        4.40000e-01        2.21352e-01        7.78648e-01       6.55906e-09        0.00000         1.40289e-10          1.00000       602.885      58.523     0.919474     1.25214e-11     2.73042e-13
   5.70000e-01        4.30000e-01        2.28445e-01        7.71555e-01       6.71159e-09        0.00000         1.43551e-10          1.00000       602.885      57.718     0.919474     1.26365e-11     2.73042e-13
   5.80000e-01        4.20000e-01        2.35738e-01        7.64262e-01       6.87139e-09        0.00000         1.46969e-10          1.00000       602.885      56.914     0.919474     1.27571e-11     2.73042e-13
   5.90000e-01        4.10000e-01        2.43240e-01        7.56760e-01       7.03899e-09        0.00000         1.50554e-10          1.00000       602.885      56.110     0.919474     1.28835e-11     2.73042e-13
   6.00000e-01        4.00000e-01        2.50960e-01        7.49040e-01       7.21496e-09        0.00000         1.54317e-10          1.00000       602.885      55.305     0.919474     1.30163e-11     2.73042e-13
   6.10000e-01        3.90000e-01        2.58908e-01        7.41092e-01       7.39996e-09        0.00000         1.58274e-10          1.00000       602.885      54.501     0.919474     1.31559e-11     2.73042e-13
   6.20000e-01        3.80000e-01        2.67094e-01        7.32906e-01       7.59470e-09        0.00000         1.62439e-10          1.00000       602.885      53.697     0.919474     1.33028e-11     2.73042e-13
   6.30000e-01        3.70000e-01        2.75529e-01        7.24471e-01       7.79996e-09        0.00000         1.66830e-10          1.00000       602.885      52.892     0.919474     1.34577e-11     2.73042e-13
   6.40000e-01        3.60000e-01        2.84225e-01        7.15775e-01       8.01663e-09        0.00000         1.71464e-10          1.00000       602.885      52.088     0.919474     1.36212e-11     2.73042e-13
   6.50000e-01        3.50000e-01        2.93193e-01        7.06807e-01       8.24567e-09        0.00000         1.76363e-10          1.00000       602.885      51.284     0.919474     1.37941e-11     2.73042e-13
   6.60000e-01        3.40000e-01        3.02447e-01        6.97553e-01       8.48819e-09        0.00000         1.81550e-10          1.00000       602.885      50.479     0.919474     1.39771e-11     2.73042e-13
   6.70000e-01        3.30000e-01        3.12001e-01        6.87999e-01       8.74541e-09        0.00000         1.87052e-10          1.00000       602.885      49.675     0.919474     1.41711e-11     2.73042e-13
   6.80000e-01        3.20000e-01        3.21869e-01        6.78131e-01       9.01870e-09        0.00000         1.92897e-10          1.00000       602.885      48.871     0.919474     1.43774e-11     2.73042e-13
   6.90000e-01        3.10000e-01        3.32068e-01        6.67932e-01       9.30963e-09        0.00000         1.99119e-10          1.00000       602.885      48.066     0.919474     1.45969e-11     2.73042e-13
   7.00000e-01        3.00000e-01        3.42614e-01        6.57386e-01       9.61995e-09        0.00000         2.05757e-10          1.00000       602.885      47.262     0.919474     1.48311e-11     2.73042e-13
   7.10000e-01        2.90000e-01        3.53525e-01        6.46475e-01       9.95167e-09        0.00000         2.12852e-10          1.00000       602.885      46.458     0.919474     1.50814e-11     2.73042e-13
   7.20000e-01        2.80000e-01        3.64820e-01        6.35180e-01       1.03071e-08        0.00000         2.20454e-10          1.00000       602.885      45.653     0.919474     1.53496e-11     2.73042e-13
   7.30000e-01        2.70000e-01        3.76521e-01        6.23479e-01       1.06888e-08        0.00000         2.28619e-10          1.00000       602.885      44.849     0.919474     1.56376e-11     2.73042e-13
   7.40000e-01        2.60000e-01        3.88648e-01        6.11352e-01       1.10999e-08        0.00000         2.37412e-10          1.00000       602.885      44.045     0.919474     1.59478e-11     2.73042e-13
   7.50000e-01        2.50000e-01        4.01227e-01        5.98773e-01       1.15439e-08        0.00000         2.46908e-10          1.00000       602.885      43.241     0.919474     1.62829e-11     2.73042e-13
   7.60000e-01        2.40000e-01        4.14283e-01        5.85717e-01       1.20249e-08        0.00000         2.57196e-10          1.00000       602.885      42.436     0.919474     1.66458e-11     2.73042e-13
   7.70000e-01        2.30000e-01        4.27844e-01        5.72156e-01       1.25478e-08        0.00000         2.68378e-10          1.00000       602.885      41.632     0.919474     1.70403e-11     2.73042e-13
   7.80000e-01        2.20000e-01        4.41938e-01        5.58062e-01       1.31181e-08        0.00000         2.80577e-10          1.00000       602.885      40.828     0.919474     1.74707e-11     2.73042e-13
   7.90000e-01        2.10000e-01        4.56599e-01        5.43401e-01       1.37428e-08        0.00000         2.93938e-10          1.00000       602.885      40.023     0.919474     1.79421e-11     2.73042e-13
   8.00000e-01        2.00000e-01        4.71862e-01        5.28138e-01       1.44299e-08        0.00000         3.08635e-10          1.00000       602.885      39.219     0.919474     1.84606e-11     2.73042e-13
   8.10000e-01        1.90000e-01        4.87764e-01        5.12236e-01       1.51894e-08        0.00000         3.24879e-10          1.00000       602.885      38.415     0.919474     1.90337e-11     2.73042e-13
   8.20000e-01        1.80000e-01        5.04345e-01        4.95655e-01       1.60333e-08        0.00000         3.42928e-10          1.00000       602.885      37.610     0.919474     1.96704e-11     2.73042e-13
   8.30000e-01        1.70000e-01        5.21652e-01        4.78348e-01       1.69764e-08        0.00000         3.63100e-10          1.00000       602.885      36.806     0.919474     2.03821e-11     2.73042e-13
   8.40000e-01        1.60000e-01        5.39732e-01        4.60268e-01       1.80374e-08        0.00000         3.85794e-10          1.00000       602.885      36.002     0.919474     2.11827e-11     2.73042e-13
   8.50000e-01        1.50000e-01        5.58638e-01        4.41362e-01       1.92399e-08        0.00000         4.11513e-10          1.00000       602.885      35.197     0.919474     2.20901e-11     2.73042e-13
   8.60000e-01        1.40000e-01        5.78428e-01        4.21572e-01       2.06142e-08        0.00000         4.40907e-10          1.00000       602.885      34.393     0.919474     2.31271e-11     2.73042e-13
   8.70000e-01        1.30000e-01        5.99166e-01        4.00834e-01       2.21999e-08        0.00000         4.74823e-10          1.00000       602.885      33.589     0.919474     2.43237e-11     2.73042e-13
   8.80000e-01        1.20000e-01        6.20922e-01        3.79078e-01       2.40499e-08        0.00000         5.14392e-10          1.00000       602.885      32.784     0.919474     2.57196e-11     2.73042e-13
   8.90000e-01        1.10000e-01        6.43772e-01        3.56228e-01       2.62362e-08        0.00000         5.61155e-10          1.00000       602.885      31.980     0.919474     2.73694e-11     2.73042e-13
   9.00000e-01        1.00000e-01        6.67802e-01        3.32198e-01       2.88599e-08        0.00000         6.17270e-10          1.00000       602.885      31.176     0.919474     2.93491e-11     2.73042e-13
   9.10000e-01        9.00000e-02        6.93104e-01        3.06896e-01       3.20665e-08        0.00000         6.85856e-10          1.00000       602.885      30.371     0.919474     3.17688e-11     2.73042e-13
   9.20000e-01        8.00000e-02        7.19782e-01        2.80218e-01       3.60748e-08        0.00000         7.71587e-10          1.00000       602.885      29.567     0.919474     3.47934e-11     2.73042e-13
   9.30000e-01        7.00000e-02        7.47953e-01        2.52047e-01       4.12284e-08        0.00000         8.81814e-10          1.00000       602.885      28.763     0.919474     3.86822e-11     2.73042e-13
   9.40000e-01        6.00000e-02        7.77744e-01        2.22256e-01       4.80998e-08        0.00000         1.02878e-09          1.00000       602.885      27.958     0.919474     4.38672e-11     2.73042e-13
   9.50000e-01        5.00000e-02        8.09301e-01        1.90699e-01       5.77197e-08        0.00000         1.23454e-09          1.00000       602.885      27.154     0.919474     5.11263e-11     2.73042e-13
   9.60000e-01        4.00000e-02        8.42784e-01        1.57216e-01       7.21496e-08        0.00000         1.54317e-09          1.00000       602.885      26.350     0.919474     6.20148e-11     2.73042e-13
   9.70000e-01        3.00000e-02        8.78375e-01        1.21625e-01       9.61995e-08        0.00000         2.05757e-09          1.00000       602.885      25.545     0.919474     8.01624e-11     2.73042e-13
   9.80000e-01        2.00000e-02        9.16281e-01        8.37192e-02       1.44299e-07        0.00000         3.08635e-09          1.00000       602.885      24.741     0.919474     1.16458e-10     2.73042e-13
   9.90000e-01        1.00000e-02        9.56734e-01        4.32662e-02       2.88599e-07        0.00000         6.17270e-09          1.00000       602.885      23.937     0.919474     2.25343e-10     2.73042e-13
   9.95000e-01        5.00000e-03        9.77997e-01        2.20028e-02       5.77197e-07        0.00000         1.23454e-08          1.00000       602.885      23.535     0.919474     4.43114e-10     2.73042e-13
   9.98000e-01        2.00000e-03        9.91108e-01        8.89227e-03       1.44299e-06        0.00000         3.08635e-08          1.00000       602.885      23.293     0.919474     1.09643e-09     2.73042e-13
   9.99000e-01        1.00000e-03        9.95538e-01        4.46154e-03       2.88599e-06        0.00000         6.17270e-08          1.00000       602.885      23.213     0.919474     2.18528e-09     2.73042e-13
   9.99500e-01        5.00000e-04        9.97765e-01        2.23464e-03       5.77197e-06        0.00000         1.23454e-07          1.00000       602.885      23.173     0.919474     4.36300e-09     2.73042e-13
   9.99800e-01        2.00000e-04        9.99105e-01        8.94789e-04       1.44299e-05        0.00000         3.08635e-07          1.00000       602.885      23.148     0.919474     1.08961e-08     2.73042e-13
   9.99900e-01        1.00000e-04        9.99552e-01        4.47550e-04       2.88599e-05        0.00000         6.17271e-07          1.00000       602.885      23.140     0.919474     2.17847e-08     2.73043e-13
   9.99950e-01        5.00000e-05        9.99776e-01        2.23814e-04       5.77200e-05        0.00000         1.23455e-06          1.00000       602.885      23.136     0.919474     4.35620e-08     2.73044e-13
   9.99980e-01        2.00000e-05        9.99910e-01        8.95349e-05       1.44301e-04        0.00000         3.08639e-06          1.00000       602.884      23.134     0.919474     1.08895e-07     2.73046e-13
   9.99990e-01        1.00000e-05        9.99955e-01        4.47690e-05       2.88606e-04        0.00000         6.17284e-06          1.00000       602.883      23.133     0.919474     2.17785e-07     2.73050e-13
   9.99995e-01        5.00000e-06        9.99978e-01        2.23849e-05       5.77228e-04        0.00000         1.23460e-05          1.00000       602.881      23.133     0.919474     4.35574e-07     2.73059e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.95405e-06       1.44319e-03        0.00000         3.08671e-05          1.00000       602.874      23.133     0.919473     1.08901e-06     2.73084e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.47704e-06       2.88676e-03        0.00000         6.17415e-05          0.99999       602.862      23.132     0.919472     2.17832e-06     2.73127e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.23852e-06       5.77508e-03        0.00000         1.23512e-04          0.99999       602.840      23.132     0.919469     4.35783e-06     2.73212e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.95410e-07       1.44494e-02        0.00000         3.08997e-04          0.99997       602.772      23.132     0.919462     1.09036e-05     2.73467e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.47705e-07       2.89377e-02        0.00000         6.18721e-04          0.99994       602.659      23.132     0.919449     2.18372e-05     2.73894e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.23853e-07       5.80325e-02        0.00000         1.24037e-03          0.99988       602.432      23.132     0.919424     4.37957e-05     2.74753e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.95411e-08       1.46279e-01        0.00000         3.12320e-03          0.99969       601.744      23.132     0.919348     1.10414e-04     2.77377e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.47706e-08       2.96686e-01        0.00000         6.32312e-03          0.99937       600.575      23.132     0.919218     2.24015e-04     2.81906e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.23853e-08       6.11007e-01        0.00000         1.29732e-02          0.99870       598.144      23.132     0.918946     4.61656e-04     2.91610e-13
   1.00000e+00        3.12294e-09        1.00000e+00        1.39816e-08       1.01588e+00        0.00000         2.14659e-02          0.99784       595.037      23.132     0.918595     7.68227e-04     3.04602e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.95411e-09       1.68904e+00        0.00000         3.54064e-02          0.99641       589.935      23.132     0.918012     1.27911e-03     3.27495e-13
   1.00000e+00        1.37466e-09        1.00000e+00        6.15442e-09       2.70073e+00        0.00000         5.59452e-02          0.99427       582.410      23.132     0.917136     2.04967e-03     3.65167e-13
   1.00000e+00        1.00000e-09        1.00000e+00        4.47706e-09       4.31841e+00        0.00000         8.77950e-02          0.99086       570.729      23.132     0.915736     3.28865e-03     4.34584e-13
   1.00000e+00        8.53112e-10        1.00000e+00        3.81943e-09       5.83226e+00        0.00000         1.16547e-01          0.98769       560.177      23.132     0.914426     4.45578e-03     5.11407e-13
   1.00000e+00        7.65076e-10        1.00000e+00        3.42529e-09       7.87680e+00        0.00000         1.53853e-01          0.98343       546.486      23.132     0.912660     6.04382e-03     6.37055e-13
   1.00000e+00        7.34164e-10        1.00000e+00        3.28689e-09       1.06381e+01        0.00000         2.01653e-01          0.97774       528.972      23.132     0.910283     8.21006e-03     8.56835e-13
   1.00000e+00        7.34164e-10        1.00000e+00        3.28689e-09       1.06391e+01        0.00000         2.01671e-01          0.97774       528.965      23.132     0.910282     8.21089e-03     8.56933e-13
   1.00000e+00        7.55786e-10        1.00000e+00        3.38370e-09       1.33982e+01        0.00000         2.46717e-01          0.97211       512.527      23.132     0.907923     1.04001e-02     1.15181e-12
   1.00000e+00        8.32808e-10        1.00000e+00        3.72853e-09       1.68727e+01        0.00000         2.99979e-01          0.96512       493.240      23.132     0.904980     1.31920e-02     1.67039e-12
   1.00000e+00        1.00000e-09        1.00000e+00        4.47706e-09       2.12483e+01        0.00000         3.62221e-01          0.95646       471.030      23.132     0.901336     1.67635e-02     2.66404e-12
   1.00000e+00        1.32614e-09        1.00000e+00        5.93720e-09       2.66007e+01        0.00000         4.32146e-01          0.94612       446.728      23.132     0.896998     2.12154e-02     4.70388e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.95411e-09       3.33013e+01        0.00000         5.11903e-01          0.93359       420.249      23.132     0.891799     2.69161e-02     9.53974e-12
   1.00000e+00        3.00402e-09        1.00000e+00        1.34492e-08       3.93512e+01        0.00000         5.78112e-01          0.92270       399.643      23.132     0.887370     3.21815e-02     1.79647e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.23853e-08       4.65002e+01        0.00000         6.51041e-01          0.91037       378.779      23.132     0.882507     3.85426e-02     3.76466e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.47706e-08       5.58140e+01        0.00000         7.39985e-01          0.89529       356.375      23.132     0.876826     4.70418e-02     9.71504e-11
   1.00000e+00        2.00000e-08        1.00000e+00        8.95411e-08       6.48973e+01        0.00000         8.22464e-01          0.88174       338.792      23.132     0.872025     5.55384e-02     2.39879e-10
   1.00000e+00        3.10245e-08        1.00000e+00        1.38898e-07       7.06073e+01        0.00000         8.72963e-01          0.87384       329.509      23.132     0.869375     6.09712e-02     4.18338e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.23853e-07       7.68198e+01        0.00000         9.27147e-01          0.86582       320.705      23.132     0.866796     6.69504e-02     7.57204e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.47705e-07       8.59219e+01        0.00000         1.00563e+00          0.85519       309.836      23.132     0.863545     7.58138e-02     1.76299e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.95410e-07       9.52068e+01        0.00000         1.08500e+00          0.84578       300.728      23.132     0.860794     8.49409e-02     4.04205e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.23852e-06       1.07933e+02        0.00000         1.19298e+00          0.83530       290.645      23.132     0.857770     9.75025e-02     1.18954e-08
   9.99999e-01        1.00000e-06        9.99996e-01        4.47704e-06       1.18045e+02        0.00000         1.27804e+00          0.82900       284.053      23.132     0.855833     1.07449e-01     2.66590e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.95405e-06       1.28721e+02        0.00000         1.36688e+00          0.82425       278.039      23.133     0.854108     1.17842e-01     5.94093e-08
   9.99997e-01        3.15700e-06        9.99986e-01        1.41339e-05       1.36136e+02        0.00000         1.42782e+00          0.82208       274.275      23.133     0.853049     1.24960e-01     1.00490e-07
   9.99995e-01        5.00000e-06        9.99978e-01        2.23849e-05       1.43979e+02        0.00000         1.49146e+00          0.82074       270.569      23.133     0.852018     1.32374e-01     1.70451e-07
   9.99990e-01        1.00000e-05        9.99955e-01        4.47690e-05       1.56657e+02        0.00000         1.59232e+00          0.82057       265.008      23.133     0.850483     1.44063e-01     3.77697e-07
   9.99980e-01        2.00000e-05        9.99910e-01        8.95349e-05       1.70621e+02        0.00000         1.70011e+00          0.82299       259.307      23.134     0.848901     1.56450e-01     8.37318e-07
   9.99968e-01        3.17940e-05        9.99858e-01        1.42328e-04       1.80859e+02        0.00000         1.77676e+00          0.82632       255.320      23.135     0.847777     1.65176e-01     1.42758e-06
   9.99950e-01        5.00000e-05        9.99776e-01        2.23814e-04       1.91712e+02        0.00000         1.85575e+00          0.83113       251.225      23.136     0.846599     1.74084e-01     2.40747e-06
   9.99929e-01        7.10397e-05        9.99682e-01        3.17970e-04       2.00816e+02        0.00000         1.92019e+00          0.83609       247.874      23.138     0.845613     1.81285e-01     3.61592e-06
   9.99900e-01        1.00000e-04        9.99552e-01        4.47550e-04       2.10353e+02        0.00000         1.98593e+00          0.84208       244.437      23.140     0.844579     1.88562e-01     5.38062e-06
   9.99858e-01        1.42283e-04        9.99363e-01        6.36696e-04       2.20996e+02        0.00000         2.05718e+00          0.84963       240.683      23.144     0.843420     1.96370e-01     8.12145e-06
   9.99800e-01        2.00000e-04        9.99105e-01        8.94789e-04       2.32178e+02        0.00000         2.12971e+00          0.85844       236.825      23.148     0.842197     2.04230e-01     1.21104e-05
   9.99679e-01        3.20614e-04        9.98566e-01        1.43381e-03       2.49435e+02        0.00000         2.23719e+00          0.87353       231.043      23.158     0.840299     2.15710e-01     2.11533e-05
   9.99500e-01        5.00000e-04        9.97765e-01        2.23464e-03       2.67974e+02        0.00000         2.34696e+00          0.89143       225.062      23.173     0.838252     2.27230e-01     3.59463e-05
   9.99286e-01        7.14102e-04        9.96811e-01        3.18915e-03       2.84834e+02        0.00000         2.44207e+00          0.90895       219.831      23.190     0.836391     2.37046e-01     5.52330e-05
   9.99000e-01        1.00000e-03        9.95538e-01        4.46154e-03       3.02755e+02        0.00000         2.53863e+00          0.92864       214.490      23.213     0.834421     2.46864e-01     8.32165e-05
   9.98727e-01        1.27317e-03        9.94325e-01        5.67493e-03       3.17026e+02        0.00000         2.61244e+00          0.94497       210.396      23.235     0.832864     2.54274e-01     1.11967e-04
   9.98396e-01        1.60390e-03        9.92859e-01        7.14093e-03       3.31971e+02        0.00000         2.68702e+00          0.96261       206.259      23.261     0.831247     2.61682e-01     1.49066e-04
   9.98000e-01        2.00000e-03        9.91108e-01        8.89227e-03       3.47620e+02        0.00000         2.76236e+00          0.98158       202.089      23.293     0.829573     2.69089e-01     1.96440e-04
   9.97437e-01        2.56275e-03        9.88628e-01        1.13722e-02       3.67047e+02        0.00000         2.85227e+00          1.00576       197.135      23.339     0.827526     2.77836e-01     2.68680e-04
   9.96759e-01        3.24134e-03        9.85650e-01        1.43499e-02       3.87560e+02        0.00000         2.94326e+00          1.03193       192.164      23.393     0.825409     2.86590e-01     3.62715e-04
   9.95951e-01        4.04930e-03        9.82123e-01        1.78772e-02       4.09219e+02        0.00000         3.03535e+00          1.06019       187.191      23.458     0.823225     2.95359e-01     4.83624e-04
   9.95000e-01        5.00000e-03        9.77997e-01        2.20028e-02       4.32088e+02        0.00000         3.12860e+00          1.09063       182.232      23.535     0.820981     3.04148e-01     6.37298e-04
   9.93976e-01        6.02402e-03        9.73583e-01        2.64166e-02       4.54511e+02        0.00000         3.21647e+00          1.12102       177.644      23.617     0.818846     3.12350e-01     8.15615e-04
   9.92807e-01        7.19268e-03        9.68584e-01        3.14163e-02       4.78098e+02        0.00000         3.30550e+00          1.15349       173.094      23.711     0.816672     3.20582e-01     1.03430e-03
   9.91485e-01        8.51520e-03        9.62973e-01        3.70267e-02       5.02909e+02        0.00000         3.39579e+00          1.18816       168.592      23.817     0.814465     3.28847e-01     1.30023e-03
   9.90000e-01        1.00000e-02        9.56734e-01        4.32662e-02       5.29008e+02        0.00000         3.48748e+00          1.22514       164.151      23.937     0.812234     3.37152e-01     1.62101e-03
   9.88356e-01        1.16439e-02        9.49898e-01        5.01021e-02       5.56289e+02        0.00000         3.58014e+00          1.26434       159.808      24.069     0.810000     3.45447e-01     2.00241e-03
   9.86538e-01        1.34617e-02        9.42426e-01        5.75740e-02       5.84978e+02        0.00000         3.67453e+00          1.30609       155.546      24.215     0.807759     3.53785e-01     2.45506e-03
   9.84542e-01        1.54583e-02        9.34323e-01        6.56775e-02       6.15146e+02        0.00000         3.77083e+00          1.35056       151.374      24.376     0.805521     3.62166e-01     2.98840e-03
   9.82363e-01        1.76371e-02        9.25600e-01        7.43997e-02       6.46871e+02        0.00000         3.86931e+00          1.39791       147.301      24.551     0.803297     3.70590e-01     3.61241e-03
   9.80000e-01        2.00000e-02        9.16281e-01        8.37192e-02       6.80231e+02        0.00000         3.97024e+00          1.44830       143.338      24.741     0.801098     3.79054e-01     4.33742e-03
   9.77718e-01        2.22824e-02        9.07414e-01        9.25861e-02       7.11701e+02        0.00000         4.06337e+00          1.49638       139.872      24.925     0.799151     3.86697e-01     5.08441e-03
   9.75288e-01        2.47121e-02        8.98117e-01        1.01883e-01       7.44627e+02        0.00000         4.15899e+00          1.54721       136.507      25.120     0.797244     3.94364e-01     5.92916e-03
   9.72714e-01        2.72863e-02        8.88424e-01        1.11576e-01       7.79077e+02        0.00000         4.25740e+00          1.60093       133.247      25.327     0.795385     4.02049e-01     6.87899e-03
   9.70000e-01        3.00000e-02        8.78375e-01        1.21625e-01       8.15120e+02        0.00000         4.35892e+00          1.65770       130.097      25.545     0.793587     4.09745e-01     7.94065e-03
   9.67625e-01        3.23751e-02        8.69720e-01        1.30280e-01       8.46585e+02        0.00000         4.44659e+00          1.70770       127.547      25.736     0.792134     4.16192e-01     8.90887e-03
   9.65162e-01        3.48381e-02        8.60880e-01        1.39120e-01       8.79265e+02        0.00000         4.53692e+00          1.76003       125.080      25.934     0.790737     4.22633e-01     9.92358e-03
   9.62618e-01        3.73824e-02        8.51889e-01        1.48111e-01       9.13206e+02        0.00000         4.63016e+00          1.81479       122.699      26.139     0.789403     4.29063e-01     1.10166e-02
   9.60000e-01        4.00000e-02        8.42784e-01        1.57216e-01       9.48458e+02        0.00000         4.72657e+00          1.87206       120.405      26.350     0.788138     4.35472e-01     1.21884e-02
   9.56731e-01        4.32688e-02        8.31616e-01        1.68384e-01       9.93176e+02        0.00000         4.84856e+00          1.94524       117.737      26.613     0.786705     4.43227e-01     1.37186e-02
   9.53389e-01        4.66107e-02        8.20425e-01        1.79575e-01       1.04000e+03        0.00000         4.97626e+00          2.02243       115.205      26.881     0.785398     4.50919e-01     1.53598e-02
   9.50000e-01        5.00000e-02        8.09301e-01        1.90699e-01       1.08904e+03        0.00000         5.11031e+00          2.10376       112.814      27.154     0.784233     4.58528e-01     1.71035e-02
   9.46633e-01        5.33668e-02        7.98470e-01        2.01530e-01       1.13978e+03        0.00000         5.24978e+00          2.18836       110.592      27.425     0.783233     4.65942e-01     1.89152e-02
   9.43286e-01        5.67140e-02        7.87911e-01        2.12089e-01       1.19289e+03        0.00000         5.39691e+00          2.27723       108.514      27.694     0.782398     4.73223e-01     2.07962e-02
   9.40000e-01        6.00000e-02        7.77744e-01        2.22256e-01       1.24847e+03        0.00000         5.55256e+00          2.37043       106.584      27.958     0.781742     4.80341e-01     2.27223e-02
   9.37297e-01        6.27034e-02        7.69523e-01        2.30477e-01       1.29764e+03        0.00000         5.69193e+00          2.45289       105.065      28.176     0.781337     4.86226e-01     2.43685e-02
   9.34705e-01        6.52953e-02        7.61759e-01        2.38241e-01       1.34875e+03        0.00000         5.83872e+00          2.53848       103.656      28.384     0.781079     4.91949e-01     2.60020e-02
   9.32260e-01        6.77400e-02        7.54539e-01        2.45461e-01       1.40187e+03        0.00000         5.99359e+00          2.62717       102.360      28.581     0.780976     4.97485e-01     2.75968e-02
   9.30000e-01        7.00000e-02        7.47953e-01        2.52047e-01       1.45708e+03        0.00000         6.15724e+00          2.71889       101.178      28.763     0.781036     5.02814e-01     2.91236e-02
   9.27260e-01        7.27397e-02        7.40079e-01        2.59921e-01       1.53668e+03        0.00000         6.39838e+00          2.84998        99.740      28.983     0.781396     5.09767e-01     3.10578e-02
   9.25037e-01        7.49626e-02        7.33779e-01        2.66221e-01       1.62064e+03        0.00000         6.65966e+00          2.98638        98.523      29.162     0.782087     5.16227e-01     3.27235e-02
   9.23410e-01        7.65904e-02        7.29214e-01        2.70786e-01       1.70918e+03        0.00000         6.94317e+00          3.12778        97.523      29.293     0.783111     5.22152e-01     3.40481e-02
   9.22427e-01        7.75729e-02        7.26478e-01        2.73522e-01       1.80255e+03        0.00000         7.25092e+00          3.27390        96.737      29.372     0.784462     5.27519e-01     3.49780e-02
   9.22103e-01        7.78972e-02        7.25578e-01        2.74422e-01       1.90103e+03        0.00000         7.58478e+00          3.42460        96.152      29.398     0.786121     5.32330e-01     3.54873e-02
   9.34304e-01        6.56959e-02        7.60569e-01        2.39431e-01       2.82547e+03        0.00000         1.10412e+01          4.71759        96.399      28.416     0.804693     5.55170e-01     2.95238e-02
   9.52264e-01        4.77356e-02        8.16708e-01        1.83292e-01       4.19944e+03        0.00000         1.66791e+01          6.49724       100.519      26.972     0.825570     5.68669e-01     1.98155e-02
   9.65571e-01        3.44286e-02        8.62340e-01        1.37660e-01       6.24155e+03        0.00000         2.55008e+01          9.08921       105.645      25.902     0.843475     5.80200e-01     1.31204e-02
   9.74258e-01        2.57418e-02        8.94221e-01        1.05779e-01       9.27670e+03        0.00000         3.90520e+01         12.91841       110.648      25.203     0.857395     5.90364e-01     9.09766e-03
   9.79765e-01        2.02351e-02        9.15362e-01        8.46384e-02       1.37878e+04        0.00000         5.96087e+01         18.59608       114.994      24.760     0.867649     5.98837e-01     6.72922e-03
   9.83251e-01        1.67487e-02        9.29142e-01        7.08584e-02       2.04925e+04        0.00000         9.05255e+01         27.02497       118.489      24.480     0.874958     6.05507e-01     5.31681e-03
   9.85477e-01        1.45229e-02        9.38106e-01        6.18943e-02       3.04577e+04        0.00000         1.36773e+02         39.54515       121.152      24.300     0.880060     6.10527e-01     4.45534e-03
   9.86914e-01        1.30863e-02        9.43962e-01        5.60381e-02       4.52687e+04        0.00000         2.05740e+02         58.14785       123.106      24.185     0.883576     6.14179e-01     3.91765e-03
   9.87851e-01        1.21494e-02        9.47811e-01        5.21887e-02       6.72820e+04        0.00000         3.08414e+02         85.79233       124.501      24.110     0.885978     6.16774e-01     3.57530e-03
   9.88467e-01        1.15331e-02        9.50356e-01        4.96436e-02       1.00000e+05        0.00000         4.61139e+02        126.87660       125.478      24.060     0.887611     6.18586e-01     3.35234e-03
           NaN                NaN                NaN                NaN               NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   2.65542e-01        7.34458e-01        7.47217e-02        9.25278e-01       1.00000e+05        0.00000         3.48873e+02        319.58825        91.106      82.207     0.851852     8.39078e-01     7.12928e-01
   2.70000e-01        7.30000e-01        7.63089e-02        9.23691e-01       8.69371e+04        0.00000         3.02778e+02        276.93505        90.881      81.848     0.851217     8.38151e-01     7.08763e-01
   2.80000e-01        7.20000e-01        7.99205e-02        9.20079e-01       6.70232e+04        0.00000         2.32527e+02        211.93525        90.380      81.044     0.849783     8.36041e-01     6.99376e-01
   2.90000e-01        7.10000e-01        8.36046e-02        9.16395e-01       5.43332e+04        0.00000         1.87783e+02        170.54150        89.882      80.239     0.848332     8.33890e-01     6.89929e-01
   3.00000e-01        7.00000e-01        8.73632e-02        9.12637e-01       4.55384e+04        0.00000         1.56793e+02        141.87670        89.388      79.435     0.846866     8.31697e-01     6.80420e-01
   3.10000e-01        6.90000e-01        9.11988e-02        9.08801e-01       3.90829e+04        0.00000         1.34063e+02        120.85658        88.898      78.631     0.845383     8.29459e-01     6.70851e-01
   3.20000e-01        6.80000e-01        9.51136e-02        9.04886e-01       3.41420e+04        0.00000         1.16682e+02        104.78645        88.412      77.826     0.843885     8.27176e-01     6.61221e-01
   3.30000e-01        6.70000e-01        9.91102e-02        9.00890e-01       3.02381e+04        0.00000         1.02962e+02         92.10494        87.930      77.022     0.842370     8.24847e-01     6.51530e-01
   3.40000e-01        6.60000e-01        1.03191e-01        8.96809e-01       2.70750e+04        0.00000         9.18579e+01         81.84489        87.453      76.218     0.840838     8.22469e-01     6.41780e-01
   3.50000e-01        6.50000e-01        1.07359e-01        8.92641e-01       2.44596e+04        0.00000         8.26885e+01         73.37521        86.980      75.414     0.839290     8.20041e-01     6.31969e-01
   3.60000e-01        6.40000e-01        1.11617e-01        8.88383e-01       2.22606e+04        0.00000         7.49896e+01         66.26660        86.513      74.609     0.837725     8.17562e-01     6.22098e-01
   3.70000e-01        6.30000e-01        1.15968e-01        8.84032e-01       2.03855e+04        0.00000         6.84348e+01         60.21686        86.050      73.805     0.836143     8.15030e-01     6.12168e-01
   3.80000e-01        6.20000e-01        1.20414e-01        8.79586e-01       1.87672e+04        0.00000         6.27874e+01         55.00708        85.593      73.001     0.834544     8.12443e-01     6.02179e-01
   3.90000e-01        6.10000e-01        1.24960e-01        8.75040e-01       1.73561e+04        0.00000         5.78719e+01         50.47481        85.141      72.196     0.832928     8.09800e-01     5.92131e-01
   4.00000e-01        6.00000e-01        1.29608e-01        8.70392e-01       1.61145e+04        0.00000         5.35553e+01         46.49695        84.695      71.392     0.831295     8.07098e-01     5.82026e-01
   4.10000e-01        5.90000e-01        1.34362e-01        8.65638e-01       1.50133e+04        0.00000         4.97350e+01         42.97853        84.255      70.588     0.829645     8.04336e-01     5.71863e-01
   4.20000e-01        5.80000e-01        1.39225e-01        8.60775e-01       1.40297e+04        0.00000         4.63305e+01         39.84509        83.821      69.783     0.827977     8.01511e-01     5.61644e-01
   4.30000e-01        5.70000e-01        1.44202e-01        8.55798e-01       1.31456e+04        0.00000         4.32779e+01         37.03743        83.394      68.979     0.826292     7.98622e-01     5.51370e-01
   4.40000e-01        5.60000e-01        1.49297e-01        8.50703e-01       1.23464e+04        0.00000         4.05256e+01         34.50790        82.974      68.175     0.824590     7.95665e-01     5.41041e-01
   4.50000e-01        5.50000e-01        1.54513e-01        8.45487e-01       1.16203e+04        0.00000         3.80318e+01         32.21771        82.561      67.370     0.822870     7.92639e-01     5.30652e-01
   4.60000e-01        5.40000e-01        1.59855e-01        8.40145e-01       1.09574e+04        0.00000         3.57619e+01         30.13496        82.156      66.566     0.821133     7.89541e-01     5.20192e-01
   4.70000e-01        5.30000e-01        1.65328e-01        8.34672e-01       1.03497e+04        0.00000         3.36873e+01         28.23316        81.760      65.762     0.819379     7.86368e-01     5.09680e-01
   4.80000e-01        5.20000e-01        1.70936e-01        8.29064e-01       9.79034e+03        0.00000         3.17842e+01         26.49017        81.371      64.957     0.817608     7.83118e-01     4.99116e-01
   4.90000e-01        5.10000e-01        1.76685e-01        8.23315e-01       9.27364e+03        0.00000         3.00322e+01         24.88728        80.992      64.153     0.815819     7.79786e-01     4.88502e-01
   5.00000e-01        5.00000e-01        1.82580e-01        8.17420e-01       8.79472e+03        0.00000         2.84142e+01         23.40863        80.623      63.349     0.814014     7.76371e-01     4.77841e-01
   5.10000e-01        4.90000e-01        1.88626e-01        8.11374e-01       8.34942e+03        0.00000         2.69155e+01         22.04065        80.264      62.544     0.812192     7.72869e-01     4.67133e-01
   5.20000e-01        4.80000e-01        1.94831e-01        8.05169e-01       7.93416e+03        0.00000         2.55235e+01         20.77166        79.915      61.740     0.810353     7.69276e-01     4.56381e-01
   5.30000e-01        4.70000e-01        2.01198e-01        7.98802e-01       7.54583e+03        0.00000         2.42274e+01         19.59157        79.578      60.936     0.808497     7.65589e-01     4.45586e-01
   5.40000e-01        4.60000e-01        2.07737e-01        7.92263e-01       7.18174e+03        0.00000         2.30174e+01         18.49159        79.253      60.131     0.806625     7.61802e-01     4.34752e-01
   5.50000e-01        4.50000e-01        2.14452e-01        7.85548e-01       6.83952e+03        0.00000         2.18855e+01         17.46406        78.940      59.327     0.804738     7.57913e-01     4.23880e-01
   5.60000e-01        4.40000e-01        2.21352e-01        7.78648e-01       6.51711e+03        0.00000         2.08241e+01         16.50224        78.641      58.523     0.802834     7.53915e-01     4.12974e-01
   5.70000e-01        4.30000e-01        2.28445e-01        7.71555e-01       6.21266e+03        0.00000         1.98270e+01         15.60017        78.357      57.718     0.800915     7.49805e-01     4.02007e-01
   5.80000e-01        4.20000e-01        2.35738e-01        7.64262e-01       5.92454e+03        0.00000         1.88883e+01         14.75259        78.089      56.914     0.798981     7.45576e-01     3.90997e-01
   5.90000e-01        4.10000e-01        2.43240e-01        7.56760e-01       5.65130e+03        0.00000         1.80029e+01         13.95480        77.837      56.110     0.797032     7.41223e-01     3.79959e-01
   6.00000e-01        4.00000e-01        2.50960e-01        7.49040e-01       5.39163e+03        0.00000         1.71663e+01         13.20262        77.602      55.305     0.795069     7.36739e-01     3.68898e-01
   6.10000e-01        3.90000e-01        2.58908e-01        7.41092e-01       5.14435e+03        0.00000         1.63743e+01         12.49225        77.387      54.501     0.793091     7.32117e-01     3.57819e-01
   6.20000e-01        3.80000e-01        2.67094e-01        7.32906e-01       4.90837e+03        0.00000         1.56231e+01         11.82030        77.192      53.697     0.791100     7.27349e-01     3.46724e-01
   6.30000e-01        3.70000e-01        2.75529e-01        7.24471e-01       4.68272e+03        0.00000         1.49093e+01         11.18366        77.020      52.892     0.789094     7.22426e-01     3.35620e-01
   6.40000e-01        3.60000e-01        2.84225e-01        7.15775e-01       4.46647e+03        0.00000         1.42298e+01         10.57949        76.871      52.088     0.787073     7.17339e-01     3.24512e-01
   6.50000e-01        3.50000e-01        2.93193e-01        7.06807e-01       4.25877e+03        0.00000         1.35814e+01         10.00517        76.748      51.284     0.785038     7.12075e-01     3.13368e-01
   6.60000e-01        3.40000e-01        3.02447e-01        6.97553e-01       4.05880e+03        0.00000         1.29616e+01          9.45824        76.653      50.479     0.782987     7.06623e-01     3.02198e-01
   6.70000e-01        3.30000e-01        3.12001e-01        6.87999e-01       3.86575e+03        0.00000         1.23674e+01          8.93639        76.589      49.675     0.780919     7.00965e-01     2.91040e-01
   6.80000e-01        3.20000e-01        3.21869e-01        6.78131e-01       3.67883e+03        0.00000         1.17962e+01          8.43736        76.558      48.871     0.778830     6.95085e-01     2.79762e-01
   6.90000e-01        3.10000e-01        3.32068e-01        6.67932e-01       3.49719e+03        0.00000         1.12452e+01          7.95892        76.564      48.066     0.776716     6.88959e-01     2.67848e-01
   7.00000e-01        3.00000e-01        3.42614e-01        6.57386e-01       3.31993e+03        0.00000         1.07113e+01          7.49873        76.610      47.262     0.774570     6.82559e-01     2.55933e-01
   7.10000e-01        2.90000e-01        3.53525e-01        6.46475e-01       3.14597e+03        0.00000         1.01911e+01          7.05425        76.703      46.458     0.772379     6.75847e-01     2.44024e-01
   7.20000e-01        2.80000e-01        3.64820e-01        6.35180e-01       2.97398e+03        0.00000         9.68024e+00          6.62249        76.846      45.653     0.770125     6.68770e-01     2.32126e-01
   7.30000e-01        2.70000e-01        3.76521e-01        6.23479e-01       2.80211e+03        0.00000         9.17284e+00          6.19953        77.049      44.849     0.767774     6.61251e-01     2.20241e-01
   7.40000e-01        2.60000e-01        3.88648e-01        6.11352e-01       2.62745e+03        0.00000         8.65978e+00          5.77955        77.321      44.045     0.765266     6.53162e-01     2.08367e-01
   7.45174e-01        2.54826e-01        3.95099e-01        6.04901e-01       2.53440e+03        0.00000         8.38715e+00          5.56035        77.495      43.629     0.763869     6.48682e-01     2.02223e-01
   7.50000e-01        2.50000e-01        4.01227e-01        5.98773e-01       2.44465e+03        0.00000         8.12436e+00          5.35218        77.680      43.241     0.762473     6.44264e-01     1.96486e-01
   7.55313e-01        2.44687e-01        4.08102e-01        5.91898e-01       2.34051e+03        0.00000         7.81926e+00          5.11500        77.916      42.813     0.760780     6.39042e-01     1.90155e-01
   7.60000e-01        2.40000e-01        4.14283e-01        5.85717e-01       2.24081e+03        0.00000         7.52652e+00          4.89272        78.160      42.436     0.759066     6.33982e-01     1.84538e-01
   7.64232e-01        2.35768e-01        4.19958e-01        5.80042e-01       2.13917e+03        0.00000         7.22680e+00          4.67143        78.420      42.096     0.757200     6.28812e-01     1.79411e-01
   7.67591e-01        2.32409e-01        4.24529e-01        5.75471e-01       2.04215e+03        0.00000         6.93875e+00          4.46560        78.671      41.826     0.755273     6.23929e-01     1.75254e-01
   7.70000e-01        2.30000e-01        4.27844e-01        5.72156e-01       1.94952e+03        0.00000         6.66130e+00          4.27444        78.903      41.632     0.753264     6.19383e-01     1.72144e-01
   7.71301e-01        2.28699e-01        4.29647e-01        5.70353e-01       1.86968e+03        0.00000         6.41964e+00          4.11410        79.088      41.527     0.751367     6.15616e-01     1.70294e-01
   7.71742e-01        2.28258e-01        4.30259e-01        5.69741e-01       1.79310e+03        0.00000         6.18527e+00          3.96433        79.244      41.492     0.749371     6.12186e-01     1.69388e-01
   7.71742e-01        2.28258e-01        4.30259e-01        5.69741e-01       1.79287e+03        0.00000         6.18456e+00          3.96388        79.244      41.492     0.749365     6.12176e-01     1.69387e-01
   7.71306e-01        2.28694e-01        4.29653e-01        5.70347e-01       1.72015e+03        0.00000         5.95927e+00          3.82535        79.364      41.527     0.747281     6.09132e-01     1.69450e-01
   7.70000e-01        2.30000e-01        4.27844e-01        5.72156e-01       1.65038e+03        0.00000         5.74040e+00          3.69577        79.447      41.632     0.745081     6.06445e-01     1.70483e-01
   7.67626e-01        2.32374e-01        4.24577e-01        5.75423e-01       1.57823e+03        0.00000         5.51110e+00          3.56511        79.491      41.823     0.742570     6.03944e-01     1.72695e-01
   7.64279e-01        2.35721e-01        4.20022e-01        5.79978e-01       1.50924e+03        0.00000         5.28891e+00          3.44316        79.489      42.092     0.739915     6.01848e-01     1.76047e-01
   7.60000e-01        2.40000e-01        4.14283e-01        5.85717e-01       1.44326e+03        0.00000         5.07377e+00          3.32902        79.440      42.436     0.737116     6.00135e-01     1.80535e-01
   7.55345e-01        2.44655e-01        4.08145e-01        5.91855e-01       1.38580e+03        0.00000         4.88433e+00          3.23140        79.356      42.811     0.734450     5.98891e-01     1.85598e-01
   7.50000e-01        2.50000e-01        4.01227e-01        5.98773e-01       1.33064e+03        0.00000         4.70065e+00          3.13901        79.237      43.241     0.731669     5.97923e-01     1.91602e-01
   7.45203e-01        2.54797e-01        3.95135e-01        6.04865e-01       1.28767e+03        0.00000         4.55639e+00          3.06781        79.115      43.626     0.729340     5.97327e-01     1.97149e-01
   7.40000e-01        2.60000e-01        3.88648e-01        6.11352e-01       1.24609e+03        0.00000         4.41582e+00          2.99944        78.972      44.045     0.726938     5.96886e-01     2.03328e-01
   7.35142e-01        2.64858e-01        3.82702e-01        6.17298e-01       1.21090e+03        0.00000         4.29612e+00          2.94191        78.830      44.436     0.724784     5.96620e-01     2.09249e-01
   7.30000e-01        2.70000e-01        3.76521e-01        6.23479e-01       1.17671e+03        0.00000         4.17917e+00          2.88622        78.672      44.849     0.722575     5.96457e-01     2.15678e-01
   7.25108e-01        2.74892e-01        3.70745e-01        6.29255e-01       1.14658e+03        0.00000         4.07559e+00          2.83730        78.515      45.243     0.720528     5.96393e-01     2.21950e-01
   7.20000e-01        2.80000e-01        3.64820e-01        6.35180e-01       1.11722e+03        0.00000         3.97420e+00          2.78970        78.345      45.653     0.718435     5.96404e-01     2.28667e-01
   7.10000e-01        2.90000e-01        3.53525e-01        6.46475e-01       1.06486e+03        0.00000         3.79219e+00          2.70488        77.997      46.458     0.714440     5.96609e-01     2.42334e-01
   7.00000e-01        3.00000e-01        3.42614e-01        6.57386e-01       1.01796e+03        0.00000         3.62784e+00          2.62879        77.628      47.262     0.710542     5.97001e-01     2.56731e-01
   6.90000e-01        3.10000e-01        3.32068e-01        6.67932e-01       9.75428e+02        0.00000         3.47764e+00          2.55953        77.240      48.066     0.706704     5.97535e-01     2.71922e-01
   6.80000e-01        3.20000e-01        3.21869e-01        6.78131e-01       9.36486e+02        0.00000         3.33908e+00          2.49577        76.830      48.871     0.702901     5.98180e-01     2.87982e-01
   6.70000e-01        3.30000e-01        3.12001e-01        6.87999e-01       9.00569e+02        0.00000         3.21032e+00          2.43657        76.400      49.675     0.699111     5.98913e-01     3.05002e-01
   6.60000e-01        3.40000e-01        3.02447e-01        6.97553e-01       8.67245e+02        0.00000         3.08995e+00          2.38119        75.946      50.479     0.695313     5.99718e-01     3.23086e-01
   6.50000e-01        3.50000e-01        2.93193e-01        7.06807e-01       8.36175e+02        0.00000         2.97683e+00          2.32911        75.467      51.284     0.691491     6.00584e-01     3.42357e-01
   6.40000e-01        3.60000e-01        2.84225e-01        7.15775e-01       8.07089e+02        0.00000         2.87007e+00          2.27987        74.961      52.088     0.687625     6.01500e-01     3.62963e-01
   6.30000e-01        3.70000e-01        2.75529e-01        7.24471e-01       7.79765e+02        0.00000         2.76892e+00          2.23314        74.426      52.892     0.683699     6.02458e-01     3.85074e-01
   6.20000e-01        3.80000e-01        2.67094e-01        7.32906e-01       7.54021e+02        0.00000         2.67275e+00          2.18864        73.859      53.697     0.679695     6.03454e-01     4.08900e-01
   6.10000e-01        3.90000e-01        2.58908e-01        7.41092e-01       7.29702e+02        0.00000         2.58101e+00          2.14612        73.256      54.501     0.675591     6.04481e-01     4.34689e-01
   6.00000e-01        4.00000e-01        2.50960e-01        7.49040e-01       7.06680e+02        0.00000         2.49325e+00          2.10540        72.613      55.305     0.671367     6.05538e-01     4.62747e-01
   5.90000e-01        4.10000e-01        2.43240e-01        7.56760e-01       6.84843e+02        0.00000         2.40905e+00          2.06632        71.927      56.110     0.666998     6.06620e-01     4.93450e-01
   5.80000e-01        4.20000e-01        2.35738e-01        7.64262e-01       6.64096e+02        0.00000         2.32805e+00          2.02875        71.192      56.914     0.662453     6.07725e-01     5.27270e-01
   5.70000e-01        4.30000e-01        2.28445e-01        7.71555e-01       6.44357e+02        0.00000         2.24990e+00          1.99257        70.401      57.718     0.657701     6.08852e-01     5.64804e-01
   5.60000e-01        4.40000e-01        2.21352e-01        7.78648e-01       6.25554e+02        0.00000         2.17430e+00          1.95770        69.548      58.523     0.652699     6.10000e-01     6.06823e-01
   5.50000e-01        4.50000e-01        2.14452e-01        7.85548e-01       6.07628e+02        0.00000         2.10095e+00          1.92405        68.622      59.327     0.647398     6.11168e-01     6.54344e-01
   5.40000e-01        4.60000e-01        2.07737e-01        7.92263e-01       5.90525e+02        0.00000         2.02954e+00          1.89157        67.613      60.131     0.641733     6.12355e-01     7.08736e-01
   5.30000e-01        4.70000e-01        2.01198e-01        7.98802e-01       5.74200e+02        0.00000         1.95978e+00          1.86021        66.506      60.936     0.635623     6.13563e-01     7.71892e-01
   5.20000e-01        4.80000e-01        1.94831e-01        8.05169e-01       5.58617e+02        0.00000         1.89134e+00          1.82995        65.282      61.740     0.628960     6.14792e-01     8.46392e-01
   5.10000e-01        4.90000e-01        1.88626e-01        8.11374e-01       5.43746e+02        0.00000         1.82384e+00          1.80077        63.917      62.544     0.621599     6.16044e-01     9.36472e-01
   5.04910e-01        4.95090e-01        1.85530e-01        8.14470e-01       5.36444e+02        0.00000         1.78977e+00          1.78634        63.161      62.954     0.617537     6.16691e-01     9.90036e-01
   5.04052e-01        4.95948e-01        1.85011e-01        8.14989e-01       5.35229e+02        0.50000         1.78393e+00          1.78393        63.023      63.023     0.616801     6.16801e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   5.04052e-01          0.49595          1.85011e-01          0.81499          535.229          0.5000            1.78393           1.78393         63.023     63.0227     0.616801     0.616801     1.00000e+00
   5.03193e-01          0.49681          1.84494e-01          0.81551          534.020          1.0000            1.78154           1.77813         63.092     62.8852     0.616911     0.616067     9.90046e-01
   5.00000e-01          0.50000          1.82580e-01          0.81742          529.567          1.0000            1.77269           1.75686         63.349     62.3773     0.617322     0.613335     9.53774e-01
   4.90000e-01          0.51000          1.76685e-01          0.82332          516.066          1.0000            1.74574           1.68985         64.153     60.6184     0.618628     0.603875     8.38458e-01
   4.80000e-01          0.52000          1.70936e-01          0.82906          503.245          1.0000            1.71998           1.62217         64.957     58.5776     0.619969     0.592789     7.21020e-01
   4.70000e-01          0.53000          1.65328e-01          0.83467          491.117          1.0000            1.69553           1.55306         65.762     56.1734     0.621351     0.579447     6.00889e-01
   4.60000e-01          0.54000          1.59855e-01          0.84015          479.715          1.0000            1.67256           1.48203         66.566     53.3238     0.622786     0.563033     4.78996e-01
   4.50000e-01          0.55000          1.54513e-01          0.84549          469.086          1.0000            1.65129           1.41025         67.370     50.0459     0.624286     0.543014     3.60930e-01
   4.40000e-01          0.56000          1.49297e-01          0.85070          459.260          1.0000            1.63189           1.34270         68.175     46.6538     0.625860     0.520540     2.59356e-01
   4.30000e-01          0.57000          1.44202e-01          0.85580          450.197          1.0000            1.61430           1.28548         68.979     43.6462     0.627509     0.498619     1.84575e-01
   4.20000e-01          0.58000          1.39225e-01          0.86077          441.791          1.0000            1.59828           1.23980         69.783     41.2296     0.629216     0.479250     1.34146e-01
   4.10000e-01          0.59000          1.34362e-01          0.86564          433.925          1.0000            1.58351           1.20322         70.588     39.3218     0.630968     0.462580     1.00243e-01
   4.00000e-01          0.60000          1.29608e-01          0.87039          426.503          1.0000            1.56973           1.17319         71.392     37.7872     0.632748     0.448110     7.67346e-02
   3.90000e-01          0.61000          1.24960e-01          0.87504          419.455          1.0000            1.55676           1.14786         72.196     36.5210     0.634549     0.435336     5.98659e-02
   3.80000e-01          0.62000          1.20414e-01          0.87959          412.728          1.0000            1.54444           1.12603         73.001     35.4517     0.636362     0.423876     4.74002e-02
   3.70000e-01          0.63000          1.15968e-01          0.88403          406.279          1.0000            1.53268           1.10687         73.805     34.5311     0.638182     0.413451     3.79675e-02
   3.60000e-01          0.64000          1.11617e-01          0.88838          400.077          1.0000            1.52138           1.08984         74.609     33.7259     0.640004     0.403860     3.06938e-02
   3.50000e-01          0.65000          1.07359e-01          0.89264          394.095          1.0000            1.51049           1.07453         75.414     33.0125     0.641826     0.394955     2.49995e-02
   3.40000e-01          0.66000          1.03191e-01          0.89681          388.313          1.0000            1.49996           1.06065         76.218     32.3737     0.643644     0.386623     2.04867e-02
   3.30000e-01          0.67000          9.91102e-02          0.90089          382.712          1.0000            1.48973           1.04797         77.022     31.7964     0.645457     0.378780     1.68743e-02
   3.20000e-01          0.68000          9.51136e-02          0.90489          377.279          1.0000            1.47977           1.03633         77.826     31.2710     0.647263     0.371356     1.39585e-02
   3.10000e-01          0.69000          9.11988e-02          0.90880          371.999          1.0000            1.47006           1.02559         78.631     30.7897     0.649060     0.364299     1.15886e-02
   3.00000e-01          0.70000          8.73632e-02          0.91264          366.862          1.0000            1.46057           1.01564         79.435     30.3462     0.650848     0.357565     9.65112e-03
   2.90000e-01          0.71000          8.36046e-02          0.91640          361.858          1.0000            1.45127           1.00638         80.239     29.9358     0.652626     0.351117     8.05921e-03
   2.80000e-01          0.72000          7.99205e-02          0.92008          356.978          1.0000            1.44215           0.99775         81.044     29.5544     0.654392     0.344926     6.74567e-03
   2.70000e-01          0.73000          7.63089e-02          0.92369          352.216          1.0000            1.43319           0.98969         81.848     29.1985     0.656147     0.338968     5.65783e-03
   2.60000e-01          0.74000          7.27676e-02          0.92723          347.564          1.0000            1.42437           0.98213         82.652     28.8655     0.657889     0.333220     4.75402e-03
   2.50000e-01          0.75000          6.92945e-02          0.93071          343.016          1.0000            1.41569           0.97504         83.457     28.5529     0.659619     0.327665     4.00103e-03
   2.40000e-01          0.76000          6.58877e-02          0.93411          338.566          1.0000            1.40713           0.96837         84.261     28.2588     0.661335     0.322287     3.37215e-03
   2.30000e-01          0.77000          6.25453e-02          0.93745          334.211          1.0000            1.39869           0.96209         85.065     27.9814     0.663039     0.317074     2.84579e-03
   2.20000e-01          0.78000          5.92656e-02          0.94073          329.944          1.0000            1.39035           0.95618         85.870     27.7193     0.664728     0.312011     2.40440e-03
   2.10000e-01          0.79000          5.60467e-02          0.94395          325.763          1.0000            1.38210           0.95060         86.674     27.4710     0.666405     0.307091     2.03364e-03
   2.00000e-01          0.80000          5.28870e-02          0.94711          321.663          1.0000            1.37394           0.94533         87.478     27.2356     0.668067     0.302302     1.72172e-03
   1.90000e-01          0.81000          4.97849e-02          0.95022          317.640          1.0000            1.36586           0.94035         88.283     27.0120     0.669715     0.297638     1.45896e-03
   1.80000e-01          0.82000          4.67389e-02          0.95326          313.692          1.0000            1.35786           0.93564         89.087     26.7993     0.671350     0.293091     1.23733e-03
   1.70000e-01          0.83000          4.37473e-02          0.95625          309.815          1.0000            1.34993           0.93119         89.891     26.5967     0.672971     0.288654     1.05018e-03
   1.60000e-01          0.84000          4.08088e-02          0.95919          306.007          1.0000            1.34206           0.92698         90.696     26.4036     0.674577     0.284321     8.91985e-04
   1.50000e-01          0.85000          3.79219e-02          0.96208          302.265          1.0000            1.33426           0.92299         91.500     26.2192     0.676170     0.280088     7.58142e-04
   1.40000e-01          0.86000          3.50854e-02          0.96491          298.586          1.0000            1.32651           0.91922         92.304     26.0431     0.677748     0.275949     6.44802e-04
   1.30000e-01          0.87000          3.22978e-02          0.96770          294.968          1.0000            1.31881           0.91565         93.109     25.8747     0.679313     0.271900     5.48748e-04
   1.20000e-01          0.88000          2.95580e-02          0.97044          291.410          1.0000            1.31116           0.91226         93.913     25.7136     0.680864     0.267937     4.67281e-04
   1.10000e-01          0.89000          2.68648e-02          0.97314          287.908          1.0000            1.30356           0.90906         94.717     25.5593     0.682401     0.264056     3.98138e-04
   1.00000e-01          0.90000          2.42169e-02          0.97578          284.461          1.0000            1.29600           0.90603         95.522     25.4115     0.683924     0.260254     3.39414e-04
   9.00000e-02          0.91000          2.16132e-02          0.97839          281.068          1.0000            1.28847           0.90316         96.326     25.2697     0.685434     0.256527     2.89509e-04
   8.00000e-02          0.92000          1.90527e-02          0.98095          277.726          1.0000            1.28099           0.90045         97.130     25.1338     0.686930     0.252874     2.47073e-04
   7.00000e-02          0.93000          1.65342e-02          0.98347          274.435          1.0000            1.27354           0.89788         97.935     25.0033     0.688412     0.249290     2.10966e-04
   6.00000e-02          0.94000          1.40567e-02          0.98594          271.191          1.0000            1.26612           0.89545         98.739     24.8781     0.689882     0.245774     1.80227e-04
   5.00000e-02          0.95000          1.16193e-02          0.98838          267.995          1.0000            1.25874           0.89316         99.543     24.7578     0.691337     0.242323     1.54045e-04
   4.00000e-02          0.96000          9.22090e-03          0.99078          264.844          1.0000            1.25138           0.89100        100.348     24.6423     0.692780     0.238935     1.31732e-04
   3.00000e-02          0.97000          6.86068e-03          0.99314          261.738          1.0000            1.24404           0.88896        101.152     24.5313     0.694210     0.235609     1.12706e-04
   2.00000e-02          0.98000          4.53771e-03          0.99546          258.674          1.0000            1.23674           0.88703        101.956     24.4245     0.695627     0.232341     9.64759e-05
   1.00000e-02          0.99000          2.25109e-03          0.99775          255.653          1.0000            1.22945           0.88522        102.761     24.3220     0.697031     0.229130     8.26230e-05
   5.00000e-03          0.99500          1.12116e-03          0.99888          254.157          1.0000            1.22582           0.88436        103.163     24.2722     0.697728     0.227546     7.64753e-05
   2.00000e-03          0.99800          4.47417e-04          0.99955          253.265          1.0000            1.22364           0.88385        103.404     24.2428     0.698145     0.226602     7.30127e-05
   1.00000e-03          0.99900          2.23535e-04          0.99978          252.968          1.0000            1.22291           0.88369        103.484     24.2330     0.698284     0.226288     7.18944e-05
   5.00000e-04          0.99950          1.11724e-04          0.99989          252.820          1.0000            1.22255           0.88360        103.525     24.2282     0.698353     0.226132     7.13418e-05
   2.00000e-04          0.99980          4.46792e-05          0.99996          252.731          1.0000            1.22233           0.88355        103.549     24.2253     0.698394     0.226038     7.10124e-05
   1.00000e-04          0.99990          2.23378e-05          0.99998          252.702          1.0000            1.22226           0.88354        103.557     24.2243     0.698408     0.226006     7.09029e-05
   5.00000e-05          0.99995          1.11685e-05          0.99999          252.687          1.0000            1.22222           0.88353        103.561     24.2238     0.698415     0.225991     7.08482e-05
   2.00000e-05          0.99998          4.46729e-06          1.00000          252.678          1.0000            1.22220           0.88352        103.563     24.2235     0.698419     0.225981     7.08154e-05
   1.00000e-05          0.99999          2.23363e-06          1.00000          252.675          1.0000            1.22219           0.88352        103.564     24.2234     0.698421     0.225978     7.08045e-05
   5.00000e-06          0.99999          1.11681e-06          1.00000          252.673          1.0000            1.22219           0.88352        103.565     24.2234     0.698421     0.225977     7.07991e-05
   2.00000e-06          1.00000          4.46723e-07          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2234     0.698422     0.225976     7.07958e-05
   1.00000e-06          1.00000          2.23361e-07          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07947e-05
   5.00000e-07          1.00000          1.11681e-07          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07941e-05
   2.00000e-07          1.00000          4.46722e-08          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07938e-05
   1.00000e-07          1.00000          2.23361e-08          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07937e-05
   5.00000e-08          1.00000          1.11681e-08          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   2.00000e-08          1.00000          4.46722e-09          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   1.00000e-08          1.00000          2.23361e-09          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   5.00000e-09          1.00000          1.11681e-09          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   2.00000e-09          1.00000          4.46722e-10          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   1.00000e-09          1.00000          2.23361e-10          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   5.00000e-10          1.00000          1.11681e-10          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   2.00000e-10          1.00000          4.46722e-11          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   1.00000e-10          1.00000          2.23361e-11          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   5.00000e-11          1.00000          1.11681e-11          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   2.00000e-11          1.00000          4.46722e-12          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   1.00000e-11          1.00000          2.23361e-12          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   5.00000e-12          1.00000          1.11681e-12          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   2.00000e-12          1.00000          4.46722e-13          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   1.00000e-12          1.00000          2.23361e-13          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          252.672          1.0000            1.22219           0.88352        103.565     24.2233     0.698422     0.225975     7.07936e-05
END

set output "Figures/Env_004_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:1.0e+03] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_004_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:1.0e+03] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_004_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_004_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Lab3_Surface_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   32.279     1.00000e-13        0.00000         2.54585e-15          1.00000       602.891     98.5599     0.932526     3.88111e-16     7.15378e-18
   32.500     1.04709e-13        0.00000         2.66392e-15          1.00000       602.891     98.5599     0.932485     4.06092e-16     7.48843e-18
   35.000     1.75260e-13        0.00000         4.42487e-15          1.00000       602.891     98.5599     0.932019     6.74198e-16     1.24936e-17
   37.500     2.90536e-13        0.00000         7.27992e-15          1.00000       602.891     98.5599     0.931549     1.10865e-15     2.06481e-17
   40.000     4.77130e-13        0.00000         1.18660e-14          1.00000       602.891     98.5599     0.931075     1.80614e-15     3.38119e-17
   42.500     7.76425e-13        0.00000         1.91662e-14          1.00000       602.890     98.5599     0.930597     2.91581e-15     5.48734e-17
   45.000     1.25224e-12        0.00000         3.06847e-14          1.00000       602.890     98.5599     0.930115     4.66575e-15     8.82778e-17
   47.500     2.00215e-12        0.00000         4.87034e-14          1.00000       602.890     98.5599     0.929629     7.40169e-15     1.40810e-16
   50.000     3.17410e-12        0.00000         7.66548e-14          1.00000       602.890     98.5599     0.929139     1.16435e-14     2.22743e-16
   52.500     4.99057e-12        0.00000         1.19661e-13          1.00000       602.890     98.5599     0.928645     1.81662e-14     3.49499e-16
   55.000     7.78347e-12        0.00000         1.85305e-13          1.00000       602.890     98.5599     0.928148     2.81169e-14     5.44062e-16
   57.500     1.20441e-11        0.00000         2.84726e-13          1.00000       602.890     98.5599     0.927646     4.31790e-14     8.40416e-16
   60.000     1.84942e-11        0.00000         4.34165e-13          1.00000       602.889     98.5599     0.927139     6.58056e-14     1.28844e-15
   62.500     2.81863e-11        0.00000         6.57126e-13          1.00000       602.889     98.5599     0.926629     9.95446e-14     1.96082e-15
   65.000     4.26439e-11        0.00000         9.87385e-13          1.00000       602.889     98.5599     0.926115     1.49491e-13     2.96270e-15
   67.500     6.40573e-11        0.00000         1.47313e-12          1.00000       602.889     98.5599     0.925596     2.22909e-13     4.44519e-15
   70.000     9.55532e-11        0.00000         2.18267e-12          1.00000       602.888     98.5599     0.925073     3.30086e-13     6.62394e-15
   72.500     1.41565e-10        0.00000         3.21214e-12          1.00000       602.888     98.5599     0.924545     4.85497e-13     9.80470e-15
   75.000     2.08340e-10        0.00000         4.69602e-12          1.00000       602.887     98.5599     0.924014     7.09369e-13     1.44182e-14
   77.500     3.04620e-10        0.00000         6.82118e-12          1.00000       602.887     98.5599     0.923478     1.02979e-12     2.10675e-14
   80.000     4.42565e-10        0.00000         9.84572e-12          1.00000       602.886     98.5599     0.922937     1.48554e-12     3.05916e-14
   82.500     6.38990e-10        0.00000         1.41239e-11          1.00000       602.886     98.5599     0.922393     2.12979e-12     4.41511e-14
   85.000     9.16996e-10        0.00000         2.01394e-11          1.00000       602.885     98.5599     0.921843     3.03507e-12     6.33415e-14
   87.500     1.30815e-09        0.00000         2.85480e-11          1.00000       602.884     98.5599     0.921290     4.29970e-12     9.03444e-14
   90.000     1.85533e-09        0.00000         4.02347e-11          1.00000       602.884     98.5599     0.920731     6.05621e-12     1.28126e-13
   92.500     2.61645e-09        0.00000         5.63870e-11          1.00000       602.883     98.5599     0.920168     8.48230e-12     1.80696e-13
   95.000     3.66934e-09        0.00000         7.85891e-11          1.00000       602.882     98.5599     0.919601     1.18149e-11     2.53450e-13
   97.500     5.11798e-09        0.00000         1.08944e-10          1.00000       602.881     98.5599     0.919028     1.63682e-11     3.53604e-13
  100.000     7.10061e-09        0.00000         1.50229e-10          1.00000       602.879     98.5599     0.918451     2.25568e-11     4.90764e-13
  102.500     9.80005e-09        0.00000         2.06091e-10          1.00000       602.878     98.5599     0.917870     3.09251e-11     6.77656e-13
  105.000     1.34569e-08        0.00000         2.81302e-10          1.00000       602.877     98.5599     0.917283     4.21840e-11     9.31052e-13
  107.500     1.83863e-08        0.00000         3.82065e-10          1.00000       602.875     98.5599     0.916692     5.72577e-11     1.27295e-12
  110.000     2.49987e-08        0.00000         5.16417e-10          1.00000       602.873     98.5599     0.916095     7.73419e-11     1.73208e-12
  112.500     3.38270e-08        0.00000         6.94712e-10          1.00000       602.871     98.5599     0.915494     1.03977e-10     2.34579e-12
  115.000     4.55588e-08        0.00000         9.30238e-10          1.00000       602.869     98.5599     0.914888     1.39136e-10     3.16237e-12
  117.500     6.10785e-08        0.00000         1.23997e-09          1.00000       602.867     98.5599     0.914277     1.85339e-10     4.24407e-12
  120.000     8.15175e-08        0.00000         1.64548e-09          1.00000       602.865     98.5599     0.913661     2.45787e-10     5.67073e-12
  122.500     1.08318e-07        0.00000         2.17412e-09          1.00000       602.862     98.5599     0.913040     3.24530e-10     7.54433e-12
  125.000     1.43309e-07        0.00000         2.86034e-09          1.00000       602.859     98.5599     0.912413     4.26672e-10     9.99461e-12
  127.500     1.88805e-07        0.00000         3.74745e-09          1.00000       602.856     98.5599     0.911781     5.58617e-10     1.31860e-11
  130.000     2.47714e-07        0.00000         4.88961e-09          1.00000       602.852     98.5599     0.911145     7.28367e-10     1.73258e-11
  132.500     3.23687e-07        0.00000         6.35428e-09          1.00000       602.849     98.5599     0.910502     9.45888e-10     2.26751e-11
  135.000     4.21279e-07        0.00000         8.22524e-09          1.00000       602.845     98.5599     0.909855     1.22353e-09     2.95604e-11
  137.500     5.46158e-07        0.00000         1.06061e-08          1.00000       602.840     98.5599     0.909202     1.57657e-09     3.83894e-11
  140.000     7.05352e-07        0.00000         1.36244e-08          1.00000       602.835     98.5599     0.908543     2.02378e-09     4.96689e-11
  142.500     9.07534e-07        0.00000         1.74368e-08          1.00000       602.830     98.5599     0.907880     2.58822e-09     6.40268e-11
  145.000     1.16338e-06        0.00000         2.22351e-08          1.00000       602.825     98.5599     0.907210     3.29804e-09     8.22384e-11
  147.500     1.48598e-06        0.00000         2.82527e-08          1.00000       602.819     98.5599     0.906535     4.18753e-09     1.05257e-10
  150.000     1.89132e-06        0.00000         3.57734e-08          1.00000       602.812     98.5599     0.905854     5.29831e-09     1.34254e-10
  152.500     2.39889e-06        0.00000         4.51410e-08          1.00000       602.806     98.5599     0.905168     6.68072e-09     1.70657e-10
  155.000     3.03231e-06        0.00000         5.67700e-08          1.00000       602.798     98.5599     0.904476     8.39546e-09     2.16208e-10
  157.500     3.82020e-06        0.00000         7.11594e-08          1.00000       602.790     98.5599     0.903778     1.05154e-08     2.73024e-10
  160.000     4.79703e-06        0.00000         8.89072e-08          1.00000       602.782     98.5599     0.903074     1.31281e-08     3.43664e-10
  162.500     6.00427e-06        0.00000         1.10729e-07          1.00000       602.773     98.5599     0.902364     1.63376e-08     4.31221e-10
  165.000     7.49161e-06        0.00000         1.37476e-07          1.00000       602.763     98.5599     0.901648     2.02683e-08     5.39415e-10
  167.500     9.31841e-06        0.00000         1.70162e-07          1.00000       602.752     98.5599     0.900926     2.50677e-08     6.72711e-10
  170.000     1.15554e-05        0.00000         2.09987e-07          1.00000       602.741     98.5599     0.900198     3.09101e-08     8.36452e-10
  172.500     1.42866e-05        0.00000         2.58369e-07          1.00000       602.729     98.5599     0.899464     3.80016e-08     1.03701e-09
  175.000     1.76115e-05        0.00000         3.16976e-07          1.00000       602.716     98.5599     0.898723     4.65844e-08     1.28197e-09
  177.500     2.16477e-05        0.00000         3.87773e-07          1.00000       602.703     98.5599     0.897976     5.69429e-08     1.58034e-09
  180.000     2.65337e-05        0.00000         4.73057e-07          1.00000       602.688     98.5599     0.897223     6.94099e-08     1.94277e-09
  182.500     3.24319e-05        0.00000         5.75515e-07          1.00000       602.673     98.5599     0.896463     8.43738e-08     2.38183e-09
  185.000     3.95331e-05        0.00000         6.98277e-07          1.00000       602.656     98.5599     0.895696     1.02287e-07     2.91234e-09
  187.500     4.80599e-05        0.00000         8.44984e-07          1.00000       602.639     98.5599     0.894923     1.23674e-07     3.55169e-09
  190.000     5.82717e-05        0.00000         1.01985e-06          1.00000       602.620     98.5599     0.894144     1.49143e-07     4.32024e-09
  192.500     7.04704e-05        0.00000         1.22777e-06          1.00000       602.600     98.5599     0.893357     1.79396e-07     5.24184e-09
  195.000     8.50058e-05        0.00000         1.47436e-06          1.00000       602.579     98.5599     0.892564     2.15244e-07     6.34424e-09
  197.500     1.02283e-04        0.00000         1.76611e-06          1.00000       602.557     98.5599     0.891763     2.57615e-07     7.65975e-09
  200.000     1.22769e-04        0.00000         2.11047e-06          1.00000       602.533     98.5599     0.890956     3.07578e-07     9.22588e-09
  202.500     1.47001e-04        0.00000         2.51596e-06          1.00000       602.508     98.5599     0.890142     3.66353e-07     1.10861e-08
  205.000     1.75598e-04        0.00000         2.99232e-06          1.00000       602.482     98.5599     0.889320     4.35335e-07     1.32904e-08
  207.500     2.09269e-04        0.00000         3.55068e-06          1.00000       602.454     98.5599     0.888491     5.16111e-07     1.58969e-08
  210.000     2.48822e-04        0.00000         4.20370e-06          1.00000       602.424     98.5599     0.887655     6.10485e-07     1.89721e-08
  212.500     2.95183e-04        0.00000         4.96572e-06          1.00000       602.392     98.5599     0.886811     7.20504e-07     2.25923e-08
  215.000     3.49404e-04        0.00000         5.85305e-06          1.00000       602.359     98.5599     0.885960     8.48484e-07     2.68452e-08
  217.500     4.12681e-04        0.00000         6.88407e-06          0.99999       602.324     98.5599     0.885101     9.97037e-07     3.18309e-08
  220.000     4.86369e-04        0.00000         8.07957e-06          0.99999       602.287     98.5599     0.884235     1.16911e-06     3.76638e-08
  222.500     5.72003e-04        0.00000         9.46293e-06          0.99999       602.247     98.5599     0.883360     1.36802e-06     4.44739e-08
  225.000     6.71314e-04        0.00000         1.10604e-05          0.99999       602.206     98.5599     0.882478     1.59748e-06     5.24094e-08
  227.500     7.86255e-04        0.00000         1.29016e-05          0.99999       602.162     98.5599     0.881587     1.86166e-06     6.16382e-08
  230.000     9.19022e-04        0.00000         1.50194e-05          0.99999       602.116     98.5599     0.880689     2.16521e-06     7.23505e-08
  232.500     1.07208e-03        0.00000         1.74507e-05          0.99999       602.068     98.5599     0.879782     2.51332e-06     8.47614e-08
  235.000     1.24819e-03        0.00000         2.02366e-05          0.99998       602.017     98.5599     0.878867     2.91179e-06     9.91136e-08
  237.500     1.45043e-03        0.00000         2.34231e-05          0.99998       601.963     98.5599     0.877943     3.36704e-06     1.15681e-07
  240.000     1.68227e-03        0.00000         2.70608e-05          0.99998       601.906     98.5599     0.877011     3.88621e-06     1.34770e-07
  242.500     1.94753e-03        0.00000         3.12063e-05          0.99998       601.847     98.5599     0.876070     4.47720e-06     1.56728e-07
  245.000     2.25050e-03        0.00000         3.59221e-05          0.99997       601.784     98.5599     0.875120     5.14874e-06     1.81940e-07
  247.500     2.59591e-03        0.00000         4.12772e-05          0.99997       601.718     98.5599     0.874162     5.91048e-06     2.10842e-07
  250.000     2.98902e-03        0.00000         4.73480e-05          0.99997       601.649     98.5599     0.873194     6.77304e-06     2.43916e-07
  252.500     3.43566e-03        0.00000         5.42182e-05          0.99996       601.577     98.5599     0.872217     7.74811e-06     2.81703e-07
  255.000     3.94224e-03        0.00000         6.19804e-05          0.99996       601.500     98.5599     0.871230     8.84853e-06     3.24805e-07
  257.500     4.51587e-03        0.00000         7.07360e-05          0.99995       601.420     98.5599     0.870234     1.00884e-05     3.73892e-07
  260.000     5.16433e-03        0.00000         8.05961e-05          0.99994       601.336     98.5599     0.869229     1.14830e-05     4.29707e-07
  262.500     5.89623e-03        0.00000         9.16825e-05          0.99994       601.248     98.5599     0.868213     1.30493e-05     4.93076e-07
  265.000     6.72097e-03        0.00000         1.04128e-04          0.99993       601.156     98.5599     0.867188     1.48056e-05     5.64911e-07
  267.500     7.64888e-03        0.00000         1.18078e-04          0.99992       601.059     98.5599     0.866152     1.67719e-05     6.46225e-07
  270.000     8.69125e-03        0.00000         1.33691e-04          0.99991       600.958     98.5599     0.865107     1.89700e-05     7.38132e-07
  272.500     9.86043e-03        0.00000         1.51139e-04          0.99990       600.852     98.5599     0.864051     2.14235e-05     8.41866e-07
  275.000     1.11699e-02        0.00000         1.70608e-04          0.99989       600.741     98.5599     0.862984     2.41581e-05     9.58781e-07
  277.500     1.26343e-02        0.00000         1.92302e-04          0.99988       600.624     98.5599     0.861907     2.72016e-05     1.09037e-06
  280.000     1.42696e-02        0.00000         2.16441e-04          0.99986       600.503     98.5599     0.860818     3.05840e-05     1.23828e-06
  282.500     1.60932e-02        0.00000         2.43262e-04          0.99985       600.375     98.5599     0.859719     3.43378e-05     1.40431e-06
  285.000     1.81239e-02        0.00000         2.73022e-04          0.99983       600.242     98.5599     0.858608     3.84980e-05     1.59043e-06
  287.500     2.03820e-02        0.00000         3.05999e-04          0.99982       600.103     98.5599     0.857485     4.31024e-05     1.79880e-06
  290.000     2.28897e-02        0.00000         3.42492e-04          0.99980       599.957     98.5599     0.856351     4.81915e-05     2.03180e-06
  292.500     2.56708e-02        0.00000         3.82822e-04          0.99977       599.805     98.5599     0.855205     5.38090e-05     2.29201e-06
  295.000     2.87510e-02        0.00000         4.27336e-04          0.99975       599.646     98.5599     0.854047     6.00018e-05     2.58225e-06
  297.500     3.21582e-02        0.00000         4.76404e-04          0.99973       599.480     98.5599     0.852877     6.68200e-05     2.90561e-06
  300.000     3.59221e-02        0.00000         5.30426e-04          0.99970       599.307     98.5599     0.851694     7.43174e-05     3.26543e-06
  302.500     4.00750e-02        0.00000         5.89828e-04          0.99967       599.125     98.5599     0.850498     8.25514e-05     3.66537e-06
  305.000     4.46514e-02        0.00000         6.55067e-04          0.99964       598.936     98.5599     0.849289     9.15837e-05     4.10941e-06
  307.500     4.96884e-02        0.00000         7.26630e-04          0.99960       598.739     98.5599     0.848067     1.01480e-04     4.60185e-06
  310.000     5.52256e-02        0.00000         8.05040e-04          0.99956       598.533     98.5599     0.846831     1.12309e-04     5.14739e-06
  312.500     6.13058e-02        0.00000         8.90853e-04          0.99952       598.319     98.5599     0.845582     1.24147e-04     5.75111e-06
  315.000     6.79743e-02        0.00000         9.84660e-04          0.99948       598.095     98.5599     0.844318     1.37072e-04     6.41852e-06
  317.500     7.52799e-02        0.00000         1.08709e-03          0.99943       597.861     98.5599     0.843041     1.51168e-04     7.15559e-06
  320.000     8.32744e-02        0.00000         1.19882e-03          0.99938       597.618     98.5599     0.841748     1.66526e-04     7.96877e-06
  322.500     9.20134e-02        0.00000         1.32056e-03          0.99933       597.364     98.5599     0.840441     1.83239e-04     8.86506e-06
  325.000     1.01556e-01        0.00000         1.45306e-03          0.99927       597.100     98.5599     0.839118     2.01409e-04     9.85201e-06
  327.500     1.11965e-01        0.00000         1.59713e-03          0.99921       596.824     98.5599     0.837780     2.21141e-04     1.09378e-05
  330.000     1.23306e-01        0.00000         1.75362e-03          0.99914       596.537     98.5599     0.836426     2.42550e-04     1.21312e-05
  332.500     1.35653e-01        0.00000         1.92343e-03          0.99907       596.238     98.5599     0.835056     2.65753e-04     1.34417e-05
  335.000     1.49079e-01        0.00000         2.10751e-03          0.99899       595.926     98.5599     0.833669     2.90877e-04     1.48796e-05
  337.500     1.63665e-01        0.00000         2.30687e-03          0.99891       595.602     98.5599     0.832265     3.18056e-04     1.64560e-05
  340.000     1.79496e-01        0.00000         2.52257e-03          0.99882       595.264     98.5599     0.830844     3.47429e-04     1.81828e-05
  342.500     1.96662e-01        0.00000         2.75574e-03          0.99873       594.912     98.5599     0.829406     3.79145e-04     2.00727e-05
  345.000     2.15259e-01        0.00000         3.00756e-03          0.99863       594.546     98.5599     0.827949     4.13360e-04     2.21397e-05
  347.500     2.35387e-01        0.00000         3.27928e-03          0.99852       594.165     98.5599     0.826474     4.50239e-04     2.43985e-05
  350.000     2.57153e-01        0.00000         3.57223e-03          0.99841       593.768     98.5599     0.824980     4.89956e-04     2.68653e-05
  352.500     2.80671e-01        0.00000         3.88778e-03          0.99829       593.356     98.5599     0.823467     5.32691e-04     2.95573e-05
  355.000     3.06060e-01        0.00000         4.22740e-03          0.99816       592.926     98.5599     0.821934     5.78639e-04     3.24929e-05
  357.500     3.33446e-01        0.00000         4.59263e-03          0.99803       592.479     98.5599     0.820380     6.28000e-04     3.56921e-05
  360.000     3.62962e-01        0.00000         4.98508e-03          0.99789       592.014     98.5599     0.818806     6.80988e-04     3.91765e-05
  362.500     3.94749e-01        0.00000         5.40645e-03          0.99774       591.530     98.5599     0.817211     7.37825e-04     4.29690e-05
  365.000     4.28956e-01        0.00000         5.85854e-03          0.99758       591.027     98.5599     0.815594     7.98746e-04     4.70945e-05
  367.500     4.65738e-01        0.00000         6.34321e-03          0.99741       590.504     98.5599     0.813954     8.63999e-04     5.15796e-05
  370.000     5.05261e-01        0.00000         6.86245e-03          0.99723       589.959     98.5599     0.812292     9.33841e-04     5.64531e-05
  372.500     5.47698e-01        0.00000         7.41832e-03          0.99704       589.393     98.5599     0.810606     1.00855e-03     6.17459e-05
  375.000     5.93234e-01        0.00000         8.01299e-03          0.99685       588.804     98.5599     0.808896     1.08840e-03     6.74911e-05
  377.500     6.42062e-01        0.00000         8.64876e-03          0.99664       588.191     98.5599     0.807161     1.17370e-03     7.37246e-05
  380.000     6.94386e-01        0.00000         9.32802e-03          0.99642       587.554     98.5599     0.805401     1.26477e-03     8.04848e-05
  382.500     7.50419e-01        0.00000         1.00533e-02          0.99619       586.892     98.5599     0.803615     1.36193e-03     8.78132e-05
  385.000     8.10390e-01        0.00000         1.08272e-02          0.99595       586.202     98.5599     0.801802     1.46554e-03     9.57545e-05
  387.500     8.74536e-01        0.00000         1.16525e-02          0.99569       585.486     98.5599     0.799961     1.57597e-03     1.04357e-04
  390.000     9.43110e-01        0.00000         1.25322e-02          0.99543       584.740     98.5599     0.798092     1.69359e-03     1.13672e-04
  392.500     1.01638e+00        0.00000         1.34692e-02          0.99515       583.964     98.5599     0.796193     1.81881e-03     1.23756e-04
  395.000     1.09461e+00        0.00000         1.44668e-02          0.99485       583.158     98.5599     0.794265     1.95207e-03     1.34669e-04
  397.500     1.17812e+00        0.00000         1.55284e-02          0.99454       582.319     98.5599     0.792305     2.09381e-03     1.46476e-04
  400.000     1.26721e+00        0.00000         1.66575e-02          0.99422       581.446     98.5599     0.790314     2.24450e-03     1.59248e-04
  402.500     1.36220e+00        0.00000         1.78579e-02          0.99388       580.538     98.5599     0.788289     2.40464e-03     1.73061e-04
  405.000     1.46345e+00        0.00000         1.91333e-02          0.99353       579.593     98.5599     0.786231     2.57476e-03     1.87998e-04
  407.500     1.57132e+00        0.00000         2.04880e-02          0.99316       578.609     98.5599     0.784137     2.75542e-03     2.04148e-04
  410.000     1.68620e+00        0.00000         2.19263e-02          0.99277       577.586     98.5599     0.782008     2.94721e-03     2.21607e-04
  412.500     1.80851e+00        0.00000         2.34527e-02          0.99237       576.521     98.5599     0.779840     3.15073e-03     2.40481e-04
  415.000     1.93867e+00        0.00000         2.50721e-02          0.99194       575.412     98.5599     0.777634     3.36666e-03     2.60884e-04
  417.500     2.07715e+00        0.00000         2.67894e-02          0.99150       574.257     98.5599     0.775388     3.59569e-03     2.82941e-04
  420.000     2.22444e+00        0.00000         2.86102e-02          0.99104       573.055     98.5599     0.773101     3.83855e-03     3.06785e-04
  422.500     2.38106e+00        0.00000         3.05399e-02          0.99056       571.803     98.5599     0.770770     4.09603e-03     3.32566e-04
  425.000     2.54756e+00        0.00000         3.25845e-02          0.99006       570.498     98.5599     0.768395     4.36896e-03     3.60443e-04
  427.500     2.72453e+00        0.00000         3.47505e-02          0.98954       569.138     98.5599     0.765973     4.65824e-03     3.90592e-04
  430.000     2.91259e+00        0.00000         3.70443e-02          0.98900       567.721     98.5599     0.763503     4.96480e-03     4.23207e-04
  432.500     3.11242e+00        0.00000         3.94732e-02          0.98843       566.244     98.5599     0.760984     5.28965e-03     4.58498e-04
  435.000     3.32472e+00        0.00000         4.20447e-02          0.98784       564.703     98.5599     0.758412     5.63388e-03     4.96697e-04
  437.500     3.55027e+00        0.00000         4.47667e-02          0.98723       563.096     98.5599     0.755785     5.99865e-03     5.38060e-04
  440.000     3.78988e+00        0.00000         4.76478e-02          0.98659       561.418     98.5599     0.753102     6.38518e-03     5.82867e-04
  442.500     4.04444e+00        0.00000         5.06971e-02          0.98593       559.667     98.5599     0.750360     6.79483e-03     6.31431e-04
  445.000     4.31488e+00        0.00000         5.39242e-02          0.98524       557.838     98.5599     0.747557     7.22903e-03     6.84095e-04
  447.500     4.60224e+00        0.00000         5.73395e-02          0.98452       555.927     98.5599     0.744688     7.68933e-03     7.41242e-04
  450.000     4.90762e+00        0.00000         6.09542e-02          0.98377       553.929     98.5599     0.741752     8.17742e-03     8.03297e-04
  452.500     5.23221e+00        0.00000         6.47802e-02          0.98299       551.840     98.5599     0.738744     8.69513e-03     8.70734e-04
  455.000     5.57731e+00        0.00000         6.88304e-02          0.98218       549.653     98.5599     0.735662     9.24444e-03     9.44084e-04
  457.500     5.94434e+00        0.00000         7.31186e-02          0.98133       547.363     98.5599     0.732501     9.82753e-03     1.02394e-03
  460.000     6.33486e+00        0.00000         7.76600e-02          0.98046       544.964     98.5599     0.729256     1.04468e-02     1.11098e-03
  462.500     6.75054e+00        0.00000         8.24709e-02          0.97954       542.449     98.5599     0.725924     1.11048e-02     1.20596e-03
  465.000     7.19327e+00        0.00000         8.75691e-02          0.97859       539.809     98.5599     0.722498     1.18044e-02     1.30974e-03
  467.500     7.66510e+00        0.00000         9.29740e-02          0.97761       537.037     98.5599     0.718974     1.25490e-02     1.42329e-03
  470.000     8.16832e+00        0.00000         9.87071e-02          0.97658       534.123     98.5599     0.715344     1.33419e-02     1.54774e-03
  472.500     8.70548e+00        0.00000         1.04792e-01          0.97550       531.056     98.5599     0.711602     1.41871e-02     1.68437e-03
  475.000     9.27943e+00        0.00000         1.11254e-01          0.97439       527.826     98.5599     0.707740     1.50892e-02     1.83467e-03
  477.500     9.89338e+00        0.00000         1.18123e-01          0.97322       524.420     98.5599     0.703748     1.60532e-02     2.00038e-03
  480.000     1.05510e+01        0.00000         1.25431e-01          0.97201       520.822     98.5599     0.699617     1.70847e-02     2.18351e-03
  482.500     1.12564e+01        0.00000         1.33215e-01          0.97074       517.016     98.5599     0.695335     1.81903e-02     2.38646e-03
  485.000     1.20143e+01        0.00000         1.41516e-01          0.96942       512.984     98.5599     0.690890     1.93776e-02     2.61204e-03
  487.500     1.28304e+01        0.00000         1.50381e-01          0.96803       508.704     98.5599     0.686265     2.06553e-02     2.86366e-03
  490.000     1.37110e+01        0.00000         1.59866e-01          0.96658       504.151     98.5599     0.681443     2.20336e-02     3.14541e-03
  492.500     1.46638e+01        0.00000         1.70033e-01          0.96506       499.295     98.5599     0.676403     2.35249e-02     3.46232e-03
  495.000     1.56980e+01        0.00000         1.80959e-01          0.96346       494.101     98.5599     0.671121     2.51438e-02     3.82061e-03
  497.500     1.68247e+01        0.00000         1.92733e-01          0.96178       488.528     98.5599     0.665564     2.69080e-02     4.22809e-03
  500.000     1.80576e+01        0.00000         2.05465e-01          0.96000       482.524     98.5599     0.659697     2.88398e-02     4.69478e-03
  502.500     1.94141e+01        0.00000         2.19291e-01          0.95812       476.025     98.5599     0.653472     3.09670e-02     5.23377e-03
  505.000     2.09165e+01        0.00000         2.34384e-01          0.95612       468.949     98.5599     0.646828     3.33259e-02     5.86255e-03
  507.500     2.25945e+01        0.00000         2.50971e-01          0.95397       461.187     98.5599     0.639685     3.59646e-02     6.60529e-03
  510.000     2.44891e+01        0.00000         2.69359e-01          0.95167       452.594     98.5599     0.631932     3.89501e-02     7.49667e-03
  512.500     2.66598e+01        0.00000         2.89989e-01          0.94916       442.956     98.5599     0.623409     4.23793e-02     8.58898e-03
  515.000     2.91989e+01        0.00000         3.13534e-01          0.94640       431.952     98.5599     0.613868     4.64033e-02     9.96667e-03
  517.500     3.22641e+01        0.00000         3.41125e-01          0.94329       419.032     98.5599     0.602885     5.12812e-02     1.17805e-02
  520.000     3.61720e+01        0.00000         3.75006e-01          0.93964       403.109     98.5599     0.589613     5.75339e-02     1.43466e-02
  522.500     4.17947e+01        0.00000         4.21265e-01          0.93495       381.223     98.5599     0.571727     6.66007e-02     1.85800e-02
  524.067     4.80263e+01        0.00000         4.69214e-01          0.93044       358.304     98.5599     0.553285     7.67500e-02     2.41005e-02
  524.636     5.51869e+01        0.00000         5.20192e-01          0.92607       333.612     98.5599     0.533574     8.85468e-02     3.16690e-02
  524.636     5.52248e+01        0.00000         5.20450e-01          0.92605       333.486     98.5599     0.533473     8.86095e-02     3.17129e-02
  524.131     6.24647e+01        0.00000         5.67729e-01          0.92241       310.222     98.5599     0.514898     1.00685e-01     4.09120e-02
  522.500     7.06538e+01        0.00000         6.16400e-01          0.91917       285.843     98.5599     0.495274     1.14521e-01     5.35086e-02
  520.000     7.86577e+01        0.00000         6.59398e-01          0.91682       263.881     98.5599     0.477323     1.28224e-01     6.84860e-02
  517.500     8.49344e+01        0.00000         6.90193e-01          0.91551       247.868     98.5599     0.463998     1.39092e-01     8.24077e-02
  515.000     9.03560e+01        0.00000         7.14868e-01          0.91474       234.846     98.5599     0.452972     1.48565e-01     9.62184e-02
  512.500     9.52388e+01        0.00000         7.35657e-01          0.91433       223.727     98.5599     0.443399     1.57163e-01     1.10265e-01
  510.000     9.97406e+01        0.00000         7.53688e-01          0.91417       213.965     98.5599     0.434854     1.65145e-01     1.24732e-01
  507.500     1.03953e+02        0.00000         7.69627e-01          0.91422       205.235     98.5599     0.427090     1.72663e-01     1.39738e-01
  505.000     1.07937e+02        0.00000         7.83907e-01          0.91443       197.327     98.5599     0.419946     1.79812e-01     1.55370e-01
  502.500     1.11731e+02        0.00000         7.96832e-01          0.91479       190.094     98.5599     0.413312     1.86661e-01     1.71702e-01
  500.000     1.15367e+02        0.00000         8.08621e-01          0.91527       183.430     98.5599     0.407106     1.93257e-01     1.88798e-01
  497.500     1.18865e+02        0.00000         8.19444e-01          0.91585       177.251     98.5599     0.401267     1.99636e-01     2.06717e-01
  495.000     1.22244e+02        0.00000         8.29430e-01          0.91653       171.495     98.5599     0.395749     2.05826e-01     2.25517e-01
  492.500     1.25517e+02        0.00000         8.38685e-01          0.91730       166.110     98.5599     0.390514     2.11849e-01     2.45253e-01
  490.000     1.28695e+02        0.00000         8.47294e-01          0.91815       161.056     98.5599     0.385530     2.17723e-01     2.65983e-01
  487.500     1.31786e+02        0.00000         8.55327e-01          0.91907       156.296     98.5599     0.380774     2.23463e-01     2.87764e-01
  485.000     1.34800e+02        0.00000         8.62845e-01          0.92005       151.802     98.5599     0.376223     2.29080e-01     3.10655e-01
  482.500     1.37741e+02        0.00000         8.69896e-01          0.92110       147.550     98.5599     0.371861     2.34585e-01     3.34717e-01
  480.000     1.40615e+02        0.00000         8.76525e-01          0.92221       143.518     98.5599     0.367670     2.39986e-01     3.60013e-01
  477.500     1.43427e+02        0.00000         8.82770e-01          0.92337       139.688     98.5599     0.363639     2.45292e-01     3.86610e-01
  475.000     1.46182e+02        0.00000         8.88662e-01          0.92459       136.042     98.5599     0.359756     2.50508e-01     4.14576e-01
  472.500     1.48881e+02        0.00000         8.94230e-01          0.92585       132.568     98.5599     0.356009     2.55640e-01     4.43984e-01
  470.000     1.51529e+02        0.00000         8.99500e-01          0.92716       129.253     98.5599     0.352391     2.60694e-01     4.74908e-01
  467.500     1.54129e+02        0.00000         9.04494e-01          0.92852       126.084     98.5599     0.348893     2.65673e-01     5.07428e-01
  465.000     1.56682e+02        0.00000         9.09233e-01          0.92991       123.053     98.5599     0.345508     2.70582e-01     5.41627e-01
  462.500     1.59191e+02        0.00000         9.13734e-01          0.93135       120.150     98.5599     0.342229     2.75424e-01     5.77594e-01
  460.000     1.61658e+02        0.00000         9.18014e-01          0.93283       117.366     98.5599     0.339051     2.80202e-01     6.15419e-01
  457.500     1.64085e+02        0.00000         9.22087e-01          0.93434       114.695     98.5599     0.335968     2.84919e-01     6.55201e-01
  455.000     1.66473e+02        0.00000         9.25967e-01          0.93589       112.129     98.5599     0.332975     2.89578e-01     6.97041e-01
  452.500     1.68823e+02        0.00000         9.29666e-01          0.93747       109.663     98.5599     0.330068     2.94181e-01     7.41048e-01
  450.000     1.71137e+02        0.00000         9.33195e-01          0.93908       107.290     98.5599     0.327242     2.98730e-01     7.87335e-01
  447.500     1.73417e+02        0.00000         9.36564e-01          0.94073       105.006     98.5599     0.324495     3.03228e-01     8.36022e-01
  445.000     1.75663e+02        0.00000         9.39782e-01          0.94240       102.805     98.5599     0.321822     3.07676e-01     8.87236e-01
  442.500     1.77875e+02        0.00000         9.42859e-01          0.94411       100.683     98.5599     0.319221     3.12075e-01     9.41112e-01
  440.333     1.79767e+02        0.00000         9.45415e-01          0.94561        98.906     98.5599     0.317024     3.15850e-01     9.90045e-01
  439.905     1.80139e+02        0.50000         9.45910e-01          0.94591        98.560     98.5599     0.316592     3.16592e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   16.819     1.90201e+02        0.00000         1.40725e+00          1.05709       142.939     98.5599     0.801317     7.35554e-01     2.98459e-01
   16.819     1.90203e+02        0.00000         1.40727e+00          1.05710       142.939     98.5599     0.801317     7.35555e-01     2.98459e-01
   16.819     1.93260e+02        0.00000         1.42926e+00          1.07360       142.915     98.5599     0.801537     7.35892e-01     2.98248e-01
   17.180     2.85600e+02        0.00000         2.08224e+00          1.56544       142.074     98.5599     0.807264     7.44896e-01     2.94815e-01
   18.429     4.22059e+02        0.00000         3.01224e+00          2.27189       140.801     98.5599     0.813766     7.55259e-01     2.95104e-01
   20.764     6.23720e+02        0.00000         4.32855e+00          3.28056       139.262     98.5599     0.821158     7.66808e-01     2.99022e-01
   24.270     9.21735e+02        0.00000         6.18609e+00          4.71465       137.651     98.5599     0.829402     7.79206e-01     3.05870e-01
   28.873     1.36214e+03        0.00000         8.80863e+00          6.75069       136.119     98.5599     0.838222     7.91953e-01     3.14689e-01
   34.324     2.01297e+03        0.00000         1.25243e+01          9.64722       134.744     98.5599     0.847139     8.04441e-01     3.24513e-01
   40.227     2.97478e+03        0.00000         1.78197e+01         13.78903       133.541     98.5599     0.855593     8.16057e-01     3.34582e-01
   46.119     4.39613e+03        0.00000         2.54225e+01         19.75337       132.497     98.5599     0.863114     8.26303e-01     3.44301e-01
   51.574     6.49661e+03        0.00000         3.64222e+01         28.40596       131.601     98.5599     0.869420     8.34889e-01     3.53261e-01
   56.294     9.60070e+03        0.00000         5.24472e+01         41.03943       130.848     98.5599     0.874444     8.41757e-01     3.61097e-01
   60.144     1.41879e+04        0.00000         7.59201e+01         59.57424       130.237     98.5599     0.878282     8.47031e-01     3.67623e-01
   63.136     2.09670e+04        0.00000         1.10432e+02         86.85368       129.758     98.5599     0.881118     8.50950e-01     3.72828e-01
   65.375     3.09850e+04        0.00000         1.61292e+02        127.08013       129.397     98.5599     0.883161     8.53787e-01     3.76784e-01
   67.001     4.57897e+04        0.00000         2.36345e+02        186.46137       129.132     98.5599     0.884606     8.55801e-01     3.79702e-01
   68.159     6.76681e+04        0.00000         3.47179e+02        274.16736       128.942     98.5599     0.885615     8.57210e-01     3.81813e-01
   68.969     1.00000e+05        0.00000         5.10913e+02        403.74543       128.809     98.5599     0.886312     8.58185e-01     3.83310e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                     Liq Den      Gas Den           
#   (C)         (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
  439.905      180.139          0.5000            0.94591           0.94591        98.5599     98.5599     0.316592     0.316592     1.00000e+00
  439.476      180.509          1.0000            0.94621           0.94640        98.5599     98.2159     0.317334     0.316162     9.90046e-01
  437.500      182.206          1.0000            0.94760           0.94862        98.5599     96.6606     0.320735     0.314219     9.45699e-01
  435.000      184.326          1.0000            0.94939           0.95131        98.5599     94.7525     0.324999     0.311814     8.92731e-01
  432.500      186.416          1.0000            0.95121           0.95389        98.5599     92.9087     0.329220     0.309469     8.43046e-01
  430.000      188.477          1.0000            0.95304           0.95636        98.5599     91.1260     0.333399     0.307182     7.96403e-01
  427.500      190.510          1.0000            0.95491           0.95873        98.5599     89.4016     0.337538     0.304951     7.52583e-01
  425.000      192.516          1.0000            0.95679           0.96101        98.5599     87.7329     0.341638     0.302774     7.11386e-01
  422.500      194.494          1.0000            0.95870           0.96318        98.5599     86.1171     0.345699     0.300649     6.72628e-01
  420.000      196.445          1.0000            0.96063           0.96527        98.5599     84.5521     0.349722     0.298575     6.36142e-01
  417.500      198.370          1.0000            0.96258           0.96728        98.5599     83.0355     0.353709     0.296548     6.01775e-01
  415.000      200.269          1.0000            0.96455           0.96920        98.5599     81.5652     0.357661     0.294569     5.69385e-01
  412.500      202.143          1.0000            0.96654           0.97105        98.5599     80.1393     0.361577     0.292635     5.38842e-01
  410.000      203.992          1.0000            0.96855           0.97282        98.5599     78.7559     0.365459     0.290745     5.10026e-01
  407.500      205.816          1.0000            0.97058           0.97452        98.5599     77.4132     0.369307     0.288897     4.82828e-01
  405.000      207.615          1.0000            0.97263           0.97616        98.5599     76.1096     0.373122     0.287091     4.57144e-01
  402.500      209.391          1.0000            0.97470           0.97772        98.5599     74.8434     0.376905     0.285324     4.32880e-01
  400.000      211.142          1.0000            0.97678           0.97923        98.5599     73.6133     0.380656     0.283597     4.09950e-01
  397.500      212.870          1.0000            0.97888           0.98067        98.5599     72.4178     0.384376     0.281907     3.88271e-01
  395.000      214.575          1.0000            0.98099           0.98206        98.5599     71.2555     0.388065     0.280254     3.67768e-01
  392.500      216.256          1.0000            0.98312           0.98339        98.5599     70.1252     0.391725     0.278636     3.48371e-01
  390.000      217.915          1.0000            0.98527           0.98466        98.5599     69.0256     0.395354     0.277053     3.30016e-01
  387.500      219.551          1.0000            0.98743           0.98589        98.5599     67.9557     0.398955     0.275504     3.12640e-01
  385.000      221.164          1.0000            0.98960           0.98706        98.5599     66.9143     0.402527     0.273987     2.96187e-01
  382.500      222.755          1.0000            0.99179           0.98819        98.5599     65.9004     0.406071     0.272502     2.80605e-01
  380.000      224.323          1.0000            0.99399           0.98926        98.5599     64.9129     0.409586     0.271048     2.65844e-01
  377.500      225.870          1.0000            0.99620           0.99029        98.5599     63.9511     0.413075     0.269625     2.51858e-01
  375.000      227.394          1.0000            0.99843           0.99128        98.5599     63.0138     0.416537     0.268231     2.38603e-01
  372.500      228.897          1.0000            1.00067           0.99223        98.5599     62.1004     0.419972     0.266865     2.26040e-01
  370.000      230.378          1.0000            1.00291           0.99313        98.5599     61.2099     0.423381     0.265528     2.14129e-01
  367.500      231.837          1.0000            1.00517           0.99399        98.5599     60.3416     0.426764     0.264218     2.02836e-01
  365.000      233.275          1.0000            1.00744           0.99482        98.5599     59.4948     0.430121     0.262934     1.92127e-01
  362.500      234.691          1.0000            1.00972           0.99560        98.5599     58.6686     0.433454     0.261677     1.81970e-01
  360.000      236.086          1.0000            1.01201           0.99635        98.5599     57.8625     0.436761     0.260445     1.72336e-01
  357.500      237.460          1.0000            1.01431           0.99706        98.5599     57.0757     0.440044     0.259237     1.63198e-01
  355.000      238.812          1.0000            1.01662           0.99773        98.5599     56.3077     0.443303     0.258054     1.54529e-01
  352.500      240.143          1.0000            1.01893           0.99838        98.5599     55.5578     0.446538     0.256895     1.46304e-01
  350.000      241.453          1.0000            1.02126           0.99898        98.5599     54.8254     0.449750     0.255758     1.38500e-01
  347.500      242.742          1.0000            1.02359           0.99956        98.5599     54.1101     0.452938     0.254645     1.31096e-01
  345.000      244.009          1.0000            1.02593           1.00010        98.5599     53.4112     0.456103     0.253553     1.24071e-01
  342.500      245.256          1.0000            1.02827           1.00061        98.5599     52.7282     0.459246     0.252483     1.17405e-01
  340.000      246.482          1.0000            1.03062           1.00108        98.5599     52.0608     0.462365     0.251434     1.11080e-01
  337.500      247.687          1.0000            1.03298           1.00153        98.5599     51.4083     0.465463     0.250406     1.05078e-01
  335.000      248.870          1.0000            1.03534           1.00195        98.5599     50.7703     0.468539     0.249398     9.93831e-02
  332.500      250.033          1.0000            1.03771           1.00234        98.5599     50.1464     0.471593     0.248409     9.39798e-02
  330.000      251.175          1.0000            1.04008           1.00269        98.5599     49.5362     0.474626     0.247440     8.88533e-02
  327.500      252.295          1.0000            1.04245           1.00302        98.5599     48.9393     0.477637     0.246490     8.39897e-02
  325.000      253.395          1.0000            1.04483           1.00332        98.5599     48.3552     0.480627     0.245559     7.93757e-02
  322.500      254.474          1.0000            1.04721           1.00360        98.5599     47.7836     0.483597     0.244646     7.49988e-02
  320.000      255.532          1.0000            1.04960           1.00384        98.5599     47.2242     0.486546     0.243751     7.08473e-02
  317.500      256.569          1.0000            1.05198           1.00406        98.5599     46.6766     0.489474     0.242873     6.69098e-02
  315.000      257.584          1.0000            1.05437           1.00425        98.5599     46.1404     0.492383     0.242012     6.31758e-02
  312.500      258.579          1.0000            1.05676           1.00441        98.5599     45.6154     0.495272     0.241168     5.96351e-02
  310.000      259.552          1.0000            1.05915           1.00455        98.5599     45.1012     0.498140     0.240341     5.62781e-02
  307.500      260.505          1.0000            1.06155           1.00466        98.5599     44.5975     0.500990     0.239529     5.30958e-02
  305.000      261.436          1.0000            1.06394           1.00474        98.5599     44.1041     0.503820     0.238734     5.00795e-02
  302.500      262.346          1.0000            1.06633           1.00480        98.5599     43.6206     0.506631     0.237954     4.72210e-02
  300.000      263.234          1.0000            1.06872           1.00483        98.5599     43.1467     0.509423     0.237189     4.45124e-02
  297.500      264.102          1.0000            1.07110           1.00484        98.5599     42.6823     0.512196     0.236439     4.19464e-02
  295.000      264.948          1.0000            1.07349           1.00482        98.5599     42.2271     0.514950     0.235704     3.95160e-02
  292.500      265.772          1.0000            1.07587           1.00477        98.5599     41.7808     0.517687     0.234983     3.72144e-02
  290.000      266.575          1.0000            1.07825           1.00470        98.5599     41.3432     0.520405     0.234276     3.50352e-02
  287.500      267.357          1.0000            1.08063           1.00461        98.5599     40.9140     0.523105     0.233583     3.29724e-02
  285.000      268.117          1.0000            1.08300           1.00448        98.5599     40.4931     0.525787     0.232904     3.10202e-02
  282.500      268.855          1.0000            1.08537           1.00434        98.5599     40.0802     0.528451     0.232238     2.91731e-02
  280.000      269.571          1.0000            1.08773           1.00416        98.5599     39.6751     0.531098     0.231585     2.74259e-02
  277.500      270.266          1.0000            1.09009           1.00396        98.5599     39.2776     0.533727     0.230945     2.57737e-02
  275.000      270.939          1.0000            1.09244           1.00374        98.5599     38.8876     0.536340     0.230318     2.42116e-02
  272.500      271.589          1.0000            1.09478           1.00349        98.5599     38.5048     0.538935     0.229703     2.27352e-02
  270.000      272.218          1.0000            1.09712           1.00321        98.5599     38.1290     0.541513     0.229101     2.13402e-02
  267.500      272.824          1.0000            1.09945           1.00291        98.5599     37.7602     0.544075     0.228510     2.00225e-02
  265.000      273.408          1.0000            1.10177           1.00258        98.5599     37.3981     0.546619     0.227932     1.87782e-02
  262.500      273.970          1.0000            1.10408           1.00222        98.5599     37.0425     0.549148     0.227365     1.76035e-02
  260.000      274.510          1.0000            1.10638           1.00184        98.5599     36.6933     0.551660     0.226809     1.64951e-02
  257.500      275.026          1.0000            1.10866           1.00144        98.5599     36.3504     0.554156     0.226265     1.54494e-02
  255.000      275.521          1.0000            1.11094           1.00100        98.5599     36.0135     0.556636     0.225732     1.44633e-02
  252.500      275.992          1.0000            1.11321           1.00054        98.5599     35.6826     0.559100     0.225210     1.35337e-02
  250.000      276.440          1.0000            1.11546           1.00005        98.5599     35.3575     0.561549     0.224699     1.26578e-02
  247.500      276.866          1.0000            1.11770           0.99954        98.5599     35.0381     0.563982     0.224198     1.18327e-02
  245.000      277.268          1.0000            1.11992           0.99899        98.5599     34.7242     0.566399     0.223707     1.10558e-02
  242.500      277.648          1.0000            1.12213           0.99842        98.5599     34.4157     0.568801     0.223227     1.03246e-02
  240.000      278.003          1.0000            1.12433           0.99782        98.5599     34.1125     0.571188     0.222757     9.63670e-03
  237.500      278.336          1.0000            1.12651           0.99719        98.5599     33.8145     0.573559     0.222297     8.98980e-03
  235.000      278.645          1.0000            1.12867           0.99654        98.5599     33.5215     0.575916     0.221847     8.38174e-03
  232.500      278.930          1.0000            1.13081           0.99585        98.5599     33.2335     0.578258     0.221407     7.81043e-03
  230.000      279.191          1.0000            1.13293           0.99514        98.5599     32.9503     0.580586     0.220976     7.27393e-03
  227.500      279.428          1.0000            1.13504           0.99439        98.5599     32.6718     0.582898     0.220555     6.77034e-03
  225.000      279.641          1.0000            1.13712           0.99362        98.5599     32.3979     0.585196     0.220143     6.29788e-03
  222.500      279.830          1.0000            1.13918           0.99281        98.5599     32.1286     0.587480     0.219740     5.85485e-03
  220.000      279.994          1.0000            1.14122           0.99198        98.5599     31.8636     0.589750     0.219346     5.43963e-03
  217.500      280.134          1.0000            1.14323           0.99111        98.5599     31.6030     0.592006     0.218961     5.05069e-03
  215.000      280.249          1.0000            1.14522           0.99021        98.5599     31.3466     0.594247     0.218585     4.68655e-03
  212.500      280.340          1.0000            1.14719           0.98928        98.5599     31.0944     0.596475     0.218218     4.34582e-03
  210.000      280.405          1.0000            1.14913           0.98831        98.5599     30.8462     0.598689     0.217860     4.02719e-03
  207.500      280.445          1.0000            1.15104           0.98732        98.5599     30.6021     0.600890     0.217510     3.72938e-03
  205.000      280.459          1.0000            1.15292           0.98628        98.5599     30.3618     0.603077     0.217168     3.45121e-03
  202.500      280.448          1.0000            1.15477           0.98522        98.5599     30.1253     0.605250     0.216835     3.19154e-03
  200.000      280.412          1.0000            1.15660           0.98412        98.5599     29.8925     0.607410     0.216510     2.94929e-03
  197.500      280.349          1.0000            1.15839           0.98298        98.5599     29.6634     0.609557     0.216193     2.72344e-03
  195.000      280.261          1.0000            1.16014           0.98181        98.5599     29.4379     0.611691     0.215885     2.51300e-03
  192.500      280.146          1.0000            1.16186           0.98060        98.5599     29.2159     0.613812     0.215584     2.31706e-03
  190.000      280.004          1.0000            1.16355           0.97936        98.5599     28.9974     0.615920     0.215291     2.13475e-03
  187.500      279.836          1.0000            1.16520           0.97807        98.5599     28.7822     0.618015     0.215006     1.96523e-03
  185.000      279.642          1.0000            1.16681           0.97675        98.5599     28.5703     0.620097     0.214729     1.80772e-03
  182.500      279.420          1.0000            1.16838           0.97539        98.5599     28.3617     0.622167     0.214460     1.66147e-03
  180.000      279.171          1.0000            1.16991           0.97399        98.5599     28.1563     0.624225     0.214198     1.52578e-03
  177.500      278.895          1.0000            1.17140           0.97255        98.5599     27.9541     0.626270     0.213944     1.39998e-03
  175.000      278.590          1.0000            1.17284           0.97107        98.5599     27.7548     0.628302     0.213697     1.28344e-03
  172.500      278.259          1.0000            1.17424           0.96954        98.5599     27.5586     0.630323     0.213458     1.17557e-03
  170.000      277.899          1.0000            1.17559           0.96797        98.5599     27.3654     0.632331     0.213226     1.07579e-03
  167.500      277.510          1.0000            1.17690           0.96636        98.5599     27.1751     0.634328     0.213002     9.83580e-04
  165.000      277.094          1.0000            1.17815           0.96470        98.5599     26.9876     0.636312     0.212784     8.98434e-04
  162.500      276.648          1.0000            1.17935           0.96300        98.5599     26.8029     0.638285     0.212574     8.19878e-04
  160.000      276.173          1.0000            1.18049           0.96125        98.5599     26.6210     0.640246     0.212371     7.47466e-04
  157.500      275.670          1.0000            1.18158           0.95945        98.5599     26.4417     0.642195     0.212176     6.80775e-04
  155.000      275.137          1.0000            1.18261           0.95761        98.5599     26.2651     0.644133     0.211987     6.19411e-04
  152.500      274.574          1.0000            1.18359           0.95572        98.5599     26.0911     0.646059     0.211805     5.63000e-04
  150.000      273.981          1.0000            1.18450           0.95377        98.5599     25.9197     0.647974     0.211630     5.11190e-04
  147.500      273.358          1.0000            1.18535           0.95177        98.5599     25.7508     0.649877     0.211463     4.63654e-04
  145.000      272.704          1.0000            1.18613           0.94973        98.5599     25.5844     0.651769     0.211301     4.20080e-04
  142.500      272.020          1.0000            1.18684           0.94762        98.5599     25.4204     0.653651     0.211147     3.80180e-04
  140.000      271.304          1.0000            1.18749           0.94546        98.5599     25.2588     0.655521     0.211000     3.43681e-04
  137.500      270.558          1.0000            1.18806           0.94325        98.5599     25.0995     0.657380     0.210859     3.10327e-04
  135.000      269.779          1.0000            1.18856           0.94098        98.5599     24.9426     0.659228     0.210725     2.79881e-04
  132.500      268.969          1.0000            1.18898           0.93865        98.5599     24.7879     0.661066     0.210598     2.52120e-04
  130.000      268.127          1.0000            1.18932           0.93626        98.5599     24.6355     0.662892     0.210477     2.26834e-04
  127.500      267.252          1.0000            1.18957           0.93381        98.5599     24.4852     0.664708     0.210363     2.03829e-04
  125.000      266.345          1.0000            1.18975           0.93129        98.5599     24.3371     0.666514     0.210255     1.82925e-04
  122.500      265.404          1.0000            1.18983           0.92872        98.5599     24.1912     0.668309     0.210154     1.63950e-04
  120.000      264.430          1.0000            1.18983           0.92607        98.5599     24.0473     0.670094     0.210059     1.46750e-04
  117.500      263.423          1.0000            1.18973           0.92336        98.5599     23.9055     0.671868     0.209970     1.31176e-04
  115.000      262.381          1.0000            1.18953           0.92058        98.5599     23.7658     0.673632     0.209888     1.17092e-04
  112.500      261.305          1.0000            1.18924           0.91773        98.5599     23.6280     0.675386     0.209812     1.04373e-04
  110.000      260.194          1.0000            1.18884           0.91481        98.5599     23.4922     0.677130     0.209743     9.29020e-05
  107.500      259.048          1.0000            1.18834           0.91182        98.5599     23.3583     0.678863     0.209679     8.25697e-05
  105.000      257.867          1.0000            1.18772           0.90874        98.5599     23.2263     0.680587     0.209622     7.32762e-05
  102.500      256.650          1.0000            1.18699           0.90560        98.5599     23.0962     0.682301     0.209571     6.49287e-05
  100.000      255.397          1.0000            1.18615           0.90237        98.5599     22.9679     0.684005     0.209526     5.74418e-05
   97.500      254.108          1.0000            1.18519           0.89906        98.5599     22.8415     0.685699     0.209486     5.07367e-05
   95.000      252.781          1.0000            1.18410           0.89567        98.5599     22.7168     0.687384     0.209453     4.47406e-05
   92.500      251.418          1.0000            1.18288           0.89219        98.5599     22.5939     0.689059     0.209426     3.93870e-05
   90.000      250.017          1.0000            1.18153           0.88863        98.5599     22.4727     0.690724     0.209404     3.46145e-05
   87.500      248.577          1.0000            1.18004           0.88497        98.5599     22.3533     0.692380     0.209389     3.03668e-05
   85.000      247.100          1.0000            1.17841           0.88123        98.5599     22.2355     0.694027     0.209379     2.65925e-05
   82.500      245.583          1.0000            1.17663           0.87739        98.5599     22.1194     0.695664     0.209374     2.32444e-05
   80.000      244.027          1.0000            1.17471           0.87345        98.5599     22.0048     0.697292     0.209375     2.02797e-05
   77.500      242.431          1.0000            1.17263           0.86941        98.5599     21.8919     0.698911     0.209382     1.76589e-05
   75.000      240.796          1.0000            1.17038           0.86528        98.5599     21.7806     0.700521     0.209394     1.53465e-05
   72.500      239.119          1.0000            1.16797           0.86103        98.5599     21.6709     0.702122     0.209411     1.33099e-05
   70.000      237.402          1.0000            1.16539           0.85669        98.5599     21.5626     0.703713     0.209433     1.15196e-05
   67.500      235.643          1.0000            1.16263           0.85223        98.5599     21.4559     0.705296     0.209461     9.94887e-06
   65.000      233.842          1.0000            1.15968           0.84766        98.5599     21.3507     0.706870     0.209494     8.57360e-06
   62.500      231.999          1.0000            1.15655           0.84297        98.5599     21.2469     0.708435     0.209531     7.37190e-06
   60.000      230.112          1.0000            1.15322           0.83816        98.5599     21.1446     0.709991     0.209574     6.32408e-06
   57.500      228.183          1.0000            1.14969           0.83323        98.5599     21.0436     0.711539     0.209621     5.41239e-06
   55.000      226.209          1.0000            1.14595           0.82818        98.5599     20.9441     0.713078     0.209672     4.62092e-06
   52.500      224.191          1.0000            1.14200           0.82300        98.5599     20.8460     0.714608     0.209728     3.93537e-06
   50.000      222.127          1.0000            1.13782           0.81768        98.5599     20.7492     0.716130     0.209788     3.34295e-06
   47.500      220.019          1.0000            1.13341           0.81223        98.5599     20.6537     0.717644     0.209852     2.83225e-06
   45.000      217.864          1.0000            1.12876           0.80664        98.5599     20.5596     0.719149     0.209920     2.39307e-06
   42.500      215.662          1.0000            1.12386           0.80090        98.5599     20.4667     0.720646     0.209992     2.01636e-06
   40.000      213.413          1.0000            1.11871           0.79502        98.5599     20.3752     0.722134     0.210067     1.69407e-06
   37.500      211.116          1.0000            1.11329           0.78898        98.5599     20.2848     0.723615     0.210145     1.41909e-06
   35.000      208.771          1.0000            1.10760           0.78279        98.5599     20.1957     0.725087     0.210227     1.18512e-06
   32.500      206.377          1.0000            1.10163           0.77644        98.5599     20.1079     0.726551     0.210311     9.86618e-07
   30.000      203.933          1.0000            1.09537           0.76992        98.5599     20.0212     0.728007     0.210397     8.18694e-07
   27.500      201.439          1.0000            1.08880           0.76323        98.5599     19.9357     0.729456     0.210485     6.77073e-07
   25.000      198.894          1.0000            1.08192           0.75637        98.5599     19.8513     0.730896     0.210575     5.58008e-07
   22.500      196.297          1.0000            1.07472           0.74932        98.5599     19.7681     0.732328     0.210667     4.58231e-07
   20.000      193.648          1.0000            1.06718           0.74209        98.5599     19.6859     0.733753     0.210759     3.74896e-07
   17.500      190.946          1.0000            1.05930           0.73467        98.5599     19.6049     0.735170     0.210852     3.05536e-07
   16.819      190.201          1.0000            1.05709           0.73262        98.5599     19.5830     0.735554     0.210877     2.88778e-07
END

set output "Figures/Env_005_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:5.0e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_005_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Lab3_Surface_Oil\n with Lab3_Swelling_Gas at 95.5 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-12        1.00000e+00        2.33054e-13        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-12        1.00000e+00        4.66108e-13        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-12        1.00000e+00        1.16527e-12        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-11        1.00000e+00        2.33054e-12        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-11        1.00000e+00        4.66108e-12        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-11        1.00000e+00        1.16527e-11        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-10        1.00000e+00        2.33054e-11        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-10        1.00000e+00        4.66108e-11        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-10        1.00000e+00        1.16527e-10        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-09        1.00000e+00        2.33054e-10        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-09        1.00000e+00        4.66108e-10        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-09        1.00000e+00        1.16527e-09        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-08        1.00000e+00        2.33054e-09        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-08        1.00000e+00        4.66108e-09        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-08        1.00000e+00        1.16527e-08        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-07        1.00000e+00        2.33054e-08        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   2.00000e-07        1.00000e+00        4.66108e-08        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   5.00000e-07        1.00000e+00        1.16527e-07        1.00000e+00       3.92354e-09        0.00000         8.39298e-11         1.00000        602.882     98.5599     0.919487     1.26162e-11     2.71020e-13
   1.00000e-06        9.99999e-01        2.33054e-07        1.00000e+00       3.92354e-09        0.00000         8.39299e-11         1.00000        602.882     98.5598     0.919487     1.26162e-11     2.71020e-13
   2.00000e-06        9.99998e-01        4.66109e-07        1.00000e+00       3.92355e-09        0.00000         8.39299e-11         1.00000        602.882     98.5598     0.919487     1.26162e-11     2.71020e-13
   5.00000e-06        9.99995e-01        1.16527e-06        9.99999e-01       3.92356e-09        0.00000         8.39302e-11         1.00000        602.882     98.5595     0.919487     1.26162e-11     2.71020e-13
   1.00000e-05        9.99990e-01        2.33056e-06        9.99998e-01       3.92358e-09        0.00000         8.39306e-11         1.00000        602.882     98.5592     0.919487     1.26163e-11     2.71020e-13
   2.00000e-05        9.99980e-01        4.66115e-06        9.99995e-01       3.92362e-09        0.00000         8.39315e-11         1.00000        602.882     98.5584     0.919487     1.26163e-11     2.71020e-13
   5.00000e-05        9.99950e-01        1.16531e-05        9.99988e-01       3.92373e-09        0.00000         8.39340e-11         1.00000        602.882     98.5561     0.919487     1.26164e-11     2.71020e-13
   1.00000e-04        9.99900e-01        2.33072e-05        9.99977e-01       3.92393e-09        0.00000         8.39382e-11         1.00000        602.882     98.5524     0.919487     1.26165e-11     2.71020e-13
   2.00000e-04        9.99800e-01        4.66180e-05        9.99953e-01       3.92432e-09        0.00000         8.39466e-11         1.00000        602.882     98.5448     0.919487     1.26168e-11     2.71020e-13
   5.00000e-04        9.99500e-01        1.16572e-04        9.99883e-01       3.92550e-09        0.00000         8.39718e-11         1.00000        602.882     98.5221     0.919487     1.26177e-11     2.71020e-13
   1.00000e-03        9.99000e-01        2.33233e-04        9.99767e-01       3.92747e-09        0.00000         8.40138e-11         1.00000        602.882     98.4843     0.919487     1.26192e-11     2.71020e-13
   2.00000e-03        9.98000e-01        4.66824e-04        9.99533e-01       3.93140e-09        0.00000         8.40980e-11         1.00000        602.882     98.4087     0.919487     1.26221e-11     2.71020e-13
   5.00000e-03        9.95000e-01        1.16976e-03        9.98830e-01       3.94325e-09        0.00000         8.43515e-11         1.00000        602.882     98.1820     0.919487     1.26310e-11     2.71020e-13
   1.00000e-02        9.90000e-01        2.34855e-03        9.97651e-01       3.96317e-09        0.00000         8.47775e-11         1.00000        602.882     97.8040     0.919487     1.26459e-11     2.71020e-13
   2.00000e-02        9.80000e-01        4.73369e-03        9.95266e-01       4.00361e-09        0.00000         8.56426e-11         1.00000        602.882     97.0481     0.919487     1.26762e-11     2.71020e-13
   3.00000e-02        9.70000e-01        7.15627e-03        9.92844e-01       4.04488e-09        0.00000         8.65255e-11         1.00000        602.882     96.2922     0.919487     1.27072e-11     2.71020e-13
   4.00000e-02        9.60000e-01        9.61720e-03        9.90383e-01       4.08702e-09        0.00000         8.74268e-11         1.00000        602.882     95.5363     0.919487     1.27387e-11     2.71020e-13
   5.00000e-02        9.50000e-01        1.21174e-02        9.87883e-01       4.13004e-09        0.00000         8.83471e-11         1.00000        602.882     94.7804     0.919487     1.27710e-11     2.71020e-13
   6.00000e-02        9.40000e-01        1.46577e-02        9.85342e-01       4.17398e-09        0.00000         8.92870e-11         1.00000        602.882     94.0245     0.919487     1.28039e-11     2.71020e-13
   7.00000e-02        9.30000e-01        1.72393e-02        9.82761e-01       4.21886e-09        0.00000         9.02471e-11         1.00000        602.882     93.2686     0.919487     1.28375e-11     2.71020e-13
   8.00000e-02        9.20000e-01        1.98630e-02        9.80137e-01       4.26471e-09        0.00000         9.12280e-11         1.00000        602.882     92.5127     0.919487     1.28719e-11     2.71020e-13
   9.00000e-02        9.10000e-01        2.25300e-02        9.77470e-01       4.31158e-09        0.00000         9.22305e-11         1.00000        602.882     91.7568     0.919487     1.29070e-11     2.71020e-13
   1.00000e-01        9.00000e-01        2.52413e-02        9.74759e-01       4.35949e-09        0.00000         9.32553e-11         1.00000        602.882     91.0009     0.919487     1.29429e-11     2.71020e-13
   1.10000e-01        8.90000e-01        2.79980e-02        9.72002e-01       4.40847e-09        0.00000         9.43031e-11         1.00000        602.882     90.2450     0.919487     1.29796e-11     2.71020e-13
   1.20000e-01        8.80000e-01        3.08012e-02        9.69199e-01       4.45857e-09        0.00000         9.53747e-11         1.00000        602.882     89.4891     0.919487     1.30172e-11     2.71020e-13
   1.30000e-01        8.70000e-01        3.36523e-02        9.66348e-01       4.50981e-09        0.00000         9.64710e-11         1.00000        602.882     88.7332     0.919487     1.30556e-11     2.71020e-13
   1.40000e-01        8.60000e-01        3.65523e-02        9.63448e-01       4.56225e-09        0.00000         9.75928e-11         1.00000        602.882     87.9773     0.919487     1.30949e-11     2.71020e-13
   1.50000e-01        8.50000e-01        3.95026e-02        9.60497e-01       4.61593e-09        0.00000         9.87409e-11         1.00000        602.882     87.2214     0.919487     1.31351e-11     2.71020e-13
   1.60000e-01        8.40000e-01        4.25044e-02        9.57496e-01       4.67088e-09        0.00000         9.99164e-11         1.00000        602.882     86.4655     0.919487     1.31763e-11     2.71020e-13
   1.70000e-01        8.30000e-01        4.55592e-02        9.54441e-01       4.72715e-09        0.00000         1.01120e-10         1.00000        602.882     85.7096     0.919487     1.32185e-11     2.71020e-13
   1.80000e-01        8.20000e-01        4.86684e-02        9.51332e-01       4.78480e-09        0.00000         1.02353e-10         1.00000        602.882     84.9537     0.919487     1.32617e-11     2.71020e-13
   1.90000e-01        8.10000e-01        5.18334e-02        9.48167e-01       4.84387e-09        0.00000         1.03617e-10         1.00000        602.882     84.1978     0.919487     1.33059e-11     2.71020e-13
   2.00000e-01        8.00000e-01        5.50558e-02        9.44944e-01       4.90442e-09        0.00000         1.04912e-10         1.00000        602.882     83.4419     0.919487     1.33513e-11     2.71020e-13
   2.10000e-01        7.90000e-01        5.83370e-02        9.41663e-01       4.96650e-09        0.00000         1.06240e-10         1.00000        602.882     82.6860     0.919487     1.33978e-11     2.71020e-13
   2.20000e-01        7.80000e-01        6.16788e-02        9.38321e-01       5.03018e-09        0.00000         1.07602e-10         1.00000        602.882     81.9301     0.919487     1.34455e-11     2.71020e-13
   2.30000e-01        7.70000e-01        6.50829e-02        9.34917e-01       5.09550e-09        0.00000         1.09000e-10         1.00000        602.882     81.1742     0.919487     1.34945e-11     2.71020e-13
   2.40000e-01        7.60000e-01        6.85509e-02        9.31449e-01       5.16255e-09        0.00000         1.10434e-10         1.00000        602.882     80.4183     0.919487     1.35447e-11     2.71020e-13
   2.50000e-01        7.50000e-01        7.20848e-02        9.27915e-01       5.23138e-09        0.00000         1.11906e-10         1.00000        602.882     79.6624     0.919487     1.35963e-11     2.71020e-13
   2.60000e-01        7.40000e-01        7.56864e-02        9.24314e-01       5.30208e-09        0.00000         1.13419e-10         1.00000        602.882     78.9065     0.919487     1.36493e-11     2.71020e-13
   2.70000e-01        7.30000e-01        7.93576e-02        9.20642e-01       5.37471e-09        0.00000         1.14972e-10         1.00000        602.882     78.1506     0.919487     1.37037e-11     2.71020e-13
   2.80000e-01        7.20000e-01        8.31005e-02        9.16899e-01       5.44936e-09        0.00000         1.16569e-10         1.00000        602.882     77.3947     0.919487     1.37597e-11     2.71020e-13
   2.90000e-01        7.10000e-01        8.69173e-02        9.13083e-01       5.52611e-09        0.00000         1.18211e-10         1.00000        602.882     76.6388     0.919487     1.38172e-11     2.71020e-13
   3.00000e-01        7.00000e-01        9.08101e-02        9.09190e-01       5.60505e-09        0.00000         1.19900e-10         1.00000        602.882     75.8829     0.919487     1.38763e-11     2.71020e-13
   3.10000e-01        6.90000e-01        9.47813e-02        9.05219e-01       5.68629e-09        0.00000         1.21637e-10         1.00000        602.882     75.1270     0.919487     1.39372e-11     2.71020e-13
   3.20000e-01        6.80000e-01        9.88332e-02        9.01167e-01       5.76991e-09        0.00000         1.23426e-10         1.00000        602.882     74.3711     0.919487     1.39999e-11     2.71020e-13
   3.30000e-01        6.70000e-01        1.02968e-01        8.97032e-01       5.85603e-09        0.00000         1.25268e-10         1.00000        602.882     73.6152     0.919487     1.40644e-11     2.71020e-13
   3.40000e-01        6.60000e-01        1.07189e-01        8.92811e-01       5.94475e-09        0.00000         1.27166e-10         1.00000        602.882     72.8593     0.919487     1.41309e-11     2.71020e-13
   3.50000e-01        6.50000e-01        1.11499e-01        8.88501e-01       6.03621e-09        0.00000         1.29123e-10         1.00000        602.882     72.1034     0.919487     1.41995e-11     2.71020e-13
   3.60000e-01        6.40000e-01        1.15899e-01        8.84101e-01       6.13053e-09        0.00000         1.31140e-10         1.00000        602.882     71.3475     0.919487     1.42701e-11     2.71020e-13
   3.70000e-01        6.30000e-01        1.20394e-01        8.79606e-01       6.22784e-09        0.00000         1.33222e-10         1.00000        602.882     70.5916     0.919487     1.43431e-11     2.71020e-13
   3.80000e-01        6.20000e-01        1.24987e-01        8.75013e-01       6.32829e-09        0.00000         1.35371e-10         1.00000        602.882     69.8357     0.919487     1.44183e-11     2.71020e-13
   3.90000e-01        6.10000e-01        1.29679e-01        8.70321e-01       6.43203e-09        0.00000         1.37590e-10         1.00000        602.882     69.0798     0.919487     1.44961e-11     2.71020e-13
   4.00000e-01        6.00000e-01        1.34476e-01        8.65524e-01       6.53923e-09        0.00000         1.39883e-10         1.00000        602.882     68.3239     0.919487     1.45764e-11     2.71020e-13
   4.10000e-01        5.90000e-01        1.39380e-01        8.60620e-01       6.65006e-09        0.00000         1.42254e-10         1.00000        602.882     67.5680     0.919487     1.46595e-11     2.71020e-13
   4.20000e-01        5.80000e-01        1.44395e-01        8.55605e-01       6.76472e-09        0.00000         1.44707e-10         1.00000        602.882     66.8121     0.919487     1.47454e-11     2.71020e-13
   4.30000e-01        5.70000e-01        1.49524e-01        8.50476e-01       6.88340e-09        0.00000         1.47245e-10         1.00000        602.882     66.0562     0.919487     1.48343e-11     2.71020e-13
   4.40000e-01        5.60000e-01        1.54773e-01        8.45227e-01       7.00632e-09        0.00000         1.49875e-10         1.00000        602.882     65.3003     0.919487     1.49264e-11     2.71020e-13
   4.50000e-01        5.50000e-01        1.60144e-01        8.39856e-01       7.13370e-09        0.00000         1.52600e-10         1.00000        602.882     64.5444     0.919487     1.50219e-11     2.71020e-13
   4.60000e-01        5.40000e-01        1.65643e-01        8.34357e-01       7.26581e-09        0.00000         1.55426e-10         1.00000        602.882     63.7885     0.919487     1.51209e-11     2.71020e-13
   4.70000e-01        5.30000e-01        1.71273e-01        8.28727e-01       7.40290e-09        0.00000         1.58358e-10         1.00000        602.882     63.0326     0.919487     1.52236e-11     2.71020e-13
   4.80000e-01        5.20000e-01        1.77041e-01        8.22959e-01       7.54526e-09        0.00000         1.61403e-10         1.00000        602.882     62.2767     0.919487     1.53303e-11     2.71020e-13
   4.90000e-01        5.10000e-01        1.82950e-01        8.17050e-01       7.69321e-09        0.00000         1.64568e-10         1.00000        602.882     61.5208     0.919487     1.54412e-11     2.71020e-13
   5.00000e-01        5.00000e-01        1.89006e-01        8.10994e-01       7.84708e-09        0.00000         1.67860e-10         1.00000        602.882     60.7649     0.919487     1.55565e-11     2.71020e-13
   5.10000e-01        4.90000e-01        1.95214e-01        8.04786e-01       8.00722e-09        0.00000         1.71285e-10         1.00000        602.882     60.0090     0.919487     1.56765e-11     2.71020e-13
   5.20000e-01        4.80000e-01        2.01581e-01        7.98419e-01       8.17404e-09        0.00000         1.74854e-10         1.00000        602.882     59.2530     0.919487     1.58015e-11     2.71020e-13
   5.30000e-01        4.70000e-01        2.08112e-01        7.91888e-01       8.34795e-09        0.00000         1.78574e-10         1.00000        602.882     58.4971     0.919487     1.59319e-11     2.71020e-13
   5.40000e-01        4.60000e-01        2.14815e-01        7.85185e-01       8.52943e-09        0.00000         1.82456e-10         1.00000        602.882     57.7412     0.919487     1.60678e-11     2.71020e-13
   5.50000e-01        4.50000e-01        2.21695e-01        7.78305e-01       8.71897e-09        0.00000         1.86511e-10         1.00000        602.882     56.9853     0.919487     1.62099e-11     2.71020e-13
   5.60000e-01        4.40000e-01        2.28761e-01        7.71239e-01       8.91713e-09        0.00000         1.90749e-10         1.00000        602.882     56.2294     0.919487     1.63584e-11     2.71020e-13
   5.70000e-01        4.30000e-01        2.36018e-01        7.63982e-01       9.12451e-09        0.00000         1.95186e-10         1.00000        602.882     55.4735     0.919487     1.65138e-11     2.71020e-13
   5.80000e-01        4.20000e-01        2.43477e-01        7.56523e-01       9.34176e-09        0.00000         1.99833e-10         1.00000        602.882     54.7176     0.919487     1.66766e-11     2.71020e-13
   5.90000e-01        4.10000e-01        2.51144e-01        7.48856e-01       9.56960e-09        0.00000         2.04707e-10         1.00000        602.882     53.9617     0.919487     1.68473e-11     2.71020e-13
   6.00000e-01        4.00000e-01        2.59029e-01        7.40971e-01       9.80884e-09        0.00000         2.09824e-10         1.00000        602.882     53.2058     0.919487     1.70266e-11     2.71020e-13
   6.10000e-01        3.90000e-01        2.67142e-01        7.32858e-01       1.00604e-08        0.00000         2.15205e-10         1.00000        602.882     52.4499     0.919487     1.72151e-11     2.71020e-13
   6.20000e-01        3.80000e-01        2.75491e-01        7.24509e-01       1.03251e-08        0.00000         2.20868e-10         1.00000        602.882     51.6940     0.919487     1.74135e-11     2.71020e-13
   6.30000e-01        3.70000e-01        2.84089e-01        7.15911e-01       1.06042e-08        0.00000         2.26837e-10         1.00000        602.882     50.9381     0.919487     1.76226e-11     2.71020e-13
   6.40000e-01        3.60000e-01        2.92946e-01        7.07054e-01       1.08987e-08        0.00000         2.33138e-10         1.00000        602.882     50.1822     0.919487     1.78434e-11     2.71020e-13
   6.50000e-01        3.50000e-01        3.02073e-01        6.97927e-01       1.12101e-08        0.00000         2.39799e-10         1.00000        602.882     49.4263     0.919487     1.80767e-11     2.71020e-13
   6.60000e-01        3.40000e-01        3.11484e-01        6.88516e-01       1.15398e-08        0.00000         2.46852e-10         1.00000        602.882     48.6704     0.919487     1.83238e-11     2.71020e-13
   6.70000e-01        3.30000e-01        3.21192e-01        6.78808e-01       1.18895e-08        0.00000         2.54333e-10         1.00000        602.882     47.9145     0.919487     1.85859e-11     2.71020e-13
   6.80000e-01        3.20000e-01        3.31211e-01        6.68789e-01       1.22611e-08        0.00000         2.62281e-10         1.00000        602.882     47.1586     0.919487     1.88643e-11     2.71020e-13
   6.90000e-01        3.10000e-01        3.41556e-01        6.58444e-01       1.26566e-08        0.00000         2.70741e-10         1.00000        602.882     46.4027     0.919487     1.91607e-11     2.71020e-13
   7.00000e-01        3.00000e-01        3.52245e-01        6.47755e-01       1.30785e-08        0.00000         2.79766e-10         1.00000        602.882     45.6468     0.919487     1.94769e-11     2.71020e-13
   7.10000e-01        2.90000e-01        3.63293e-01        6.36707e-01       1.35294e-08        0.00000         2.89413e-10         1.00000        602.882     44.8909     0.919487     1.98148e-11     2.71020e-13
   7.20000e-01        2.80000e-01        3.74719e-01        6.25281e-01       1.40126e-08        0.00000         2.99749e-10         1.00000        602.882     44.1350     0.919487     2.01769e-11     2.71020e-13
   7.30000e-01        2.70000e-01        3.86544e-01        6.13456e-01       1.45316e-08        0.00000         3.10851e-10         1.00000        602.882     43.3791     0.919487     2.05658e-11     2.71020e-13
   7.40000e-01        2.60000e-01        3.98788e-01        6.01212e-01       1.50905e-08        0.00000         3.22807e-10         1.00000        602.882     42.6232     0.919487     2.09847e-11     2.71020e-13
   7.50000e-01        2.50000e-01        4.11475e-01        5.88525e-01       1.56942e-08        0.00000         3.35719e-10         1.00000        602.882     41.8673     0.919487     2.14370e-11     2.71020e-13
   7.60000e-01        2.40000e-01        4.24627e-01        5.75373e-01       1.63481e-08        0.00000         3.49707e-10         1.00000        602.882     41.1114     0.919487     2.19271e-11     2.71020e-13
   7.70000e-01        2.30000e-01        4.38273e-01        5.61727e-01       1.70589e-08        0.00000         3.64912e-10         1.00000        602.882     40.3555     0.919487     2.24597e-11     2.71020e-13
   7.80000e-01        2.20000e-01        4.52440e-01        5.47560e-01       1.78343e-08        0.00000         3.81499e-10         1.00000        602.882     39.5996     0.919487     2.30408e-11     2.71020e-13
   7.90000e-01        2.10000e-01        4.67157e-01        5.32843e-01       1.86835e-08        0.00000         3.99666e-10         1.00000        602.882     38.8437     0.919487     2.36772e-11     2.71020e-13
   8.00000e-01        2.00000e-01        4.82460e-01        5.17540e-01       1.96177e-08        0.00000         4.19649e-10         1.00000        602.882     38.0878     0.919487     2.43773e-11     2.71020e-13
   8.10000e-01        1.90000e-01        4.98381e-01        5.01619e-01       2.06502e-08        0.00000         4.41736e-10         1.00000        602.882     37.3319     0.919487     2.51510e-11     2.71020e-13
   8.20000e-01        1.80000e-01        5.14961e-01        4.85039e-01       2.17974e-08        0.00000         4.66277e-10         1.00000        602.882     36.5760     0.919487     2.60108e-11     2.71020e-13
   8.30000e-01        1.70000e-01        5.32241e-01        4.67759e-01       2.30796e-08        0.00000         4.93705e-10         1.00000        602.882     35.8201     0.919487     2.69716e-11     2.71020e-13
   8.40000e-01        1.60000e-01        5.50265e-01        4.49735e-01       2.45221e-08        0.00000         5.24561e-10         1.00000        602.882     35.0642     0.919487     2.80526e-11     2.71020e-13
   8.50000e-01        1.50000e-01        5.69084e-01        4.30916e-01       2.61569e-08        0.00000         5.59532e-10         1.00000        602.882     34.3083     0.919487     2.92777e-11     2.71020e-13
   8.60000e-01        1.40000e-01        5.88751e-01        4.11249e-01       2.80253e-08        0.00000         5.99498e-10         1.00000        602.882     33.5524     0.919487     3.06779e-11     2.71020e-13
   8.70000e-01        1.30000e-01        6.09325e-01        3.90675e-01       3.01811e-08        0.00000         6.45614e-10         1.00000        602.882     32.7965     0.919487     3.22934e-11     2.71020e-13
   8.80000e-01        1.20000e-01        6.30869e-01        3.69131e-01       3.26961e-08        0.00000         6.99415e-10         1.00000        602.882     32.0406     0.919487     3.41782e-11     2.71020e-13
   8.90000e-01        1.10000e-01        6.53454e-01        3.46546e-01       3.56685e-08        0.00000         7.62998e-10         1.00000        602.882     31.2847     0.919487     3.64056e-11     2.71020e-13
   9.00000e-01        1.00000e-01        6.77158e-01        3.22842e-01       3.92354e-08        0.00000         8.39298e-10         1.00000        602.882     30.5288     0.919487     3.90786e-11     2.71020e-13
   9.10000e-01        9.00000e-02        7.02065e-01        2.97935e-01       4.35949e-08        0.00000         9.32553e-10         1.00000        602.882     29.7729     0.919487     4.23456e-11     2.71020e-13
   9.20000e-01        8.00000e-02        7.28270e-01        2.71730e-01       4.90442e-08        0.00000         1.04912e-09         1.00000        602.882     29.0170     0.919487     4.64293e-11     2.71020e-13
   9.30000e-01        7.00000e-02        7.55877e-01        2.44123e-01       5.60505e-08        0.00000         1.19900e-09         1.00000        602.882     28.2611     0.919487     5.16797e-11     2.71020e-13
   9.40000e-01        6.00000e-02        7.85001e-01        2.14999e-01       6.53923e-08        0.00000         1.39883e-09         1.00000        602.882     27.5052     0.919487     5.86804e-11     2.71020e-13
   9.50000e-01        5.00000e-02        8.15771e-01        1.84229e-01       7.84708e-08        0.00000         1.67860e-09         1.00000        602.882     26.7493     0.919487     6.84813e-11     2.71020e-13
   9.60000e-01        4.00000e-02        8.48331e-01        1.51669e-01       9.80884e-08        0.00000         2.09824e-09         1.00000        602.882     25.9934     0.919487     8.31826e-11     2.71020e-13
   9.70000e-01        3.00000e-02        8.82841e-01        1.17159e-01       1.30785e-07        0.00000         2.79766e-09         1.00000        602.882     25.2375     0.919487     1.07685e-10     2.71020e-13
   9.80000e-01        2.00000e-02        9.19482e-01        8.05176e-02       1.96177e-07        0.00000         4.19649e-09         1.00000        602.882     24.4816     0.919487     1.56689e-10     2.71020e-13
   9.90000e-01        1.00000e-02        9.58459e-01        4.15414e-02       3.92354e-07        0.00000         8.39298e-09         1.00000        602.882     23.7257     0.919487     3.03702e-10     2.71020e-13
   9.95000e-01        5.00000e-03        9.78893e-01        2.11070e-02       7.84708e-07        0.00000         1.67860e-08         1.00000        602.882     23.3477     0.919487     5.97729e-10     2.71020e-13
   9.98000e-01        2.00000e-03        9.91474e-01        8.52559e-03       1.96177e-06        0.00000         4.19649e-08         1.00000        602.882     23.1210     0.919487     1.47981e-09     2.71020e-13
   9.99000e-01        1.00000e-03        9.95723e-01        4.27678e-03       3.92354e-06        0.00000         8.39298e-08         1.00000        602.882     23.0454     0.919487     2.94994e-09     2.71020e-13
   9.99500e-01        5.00000e-04        9.97858e-01        2.14190e-03       7.84708e-06        0.00000         1.67860e-07         1.00000        602.882     23.0076     0.919487     5.89021e-09     2.71020e-13
   9.99800e-01        2.00000e-04        9.99142e-01        8.57606e-04       1.96177e-05        0.00000         4.19650e-07         1.00000        602.881     22.9849     0.919486     1.47110e-08     2.71020e-13
   9.99900e-01        1.00000e-04        9.99571e-01        4.28944e-04       3.92355e-05        0.00000         8.39300e-07         1.00000        602.881     22.9773     0.919486     2.94124e-08     2.71021e-13
   9.99950e-01        5.00000e-05        9.99785e-01        2.14507e-04       7.84713e-05        0.00000         1.67861e-06         1.00000        602.881     22.9736     0.919486     5.88154e-08     2.71022e-13
   9.99980e-01        2.00000e-05        9.99914e-01        8.58114e-05       1.96180e-04        0.00000         4.19656e-06         1.00000        602.880     22.9713     0.919486     1.47026e-07     2.71025e-13
   9.99990e-01        1.00000e-05        9.99957e-01        4.29071e-05       3.92368e-04        0.00000         8.39325e-06         1.00000        602.879     22.9705     0.919486     2.94047e-07     2.71031e-13
   9.99995e-01        5.00000e-06        9.99979e-01        2.14539e-05       7.84765e-04        0.00000         1.67870e-05         1.00000        602.876     22.9702     0.919486     5.88107e-07     2.71043e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.58164e-06       1.96213e-03        0.00000         4.19717e-05         1.00000        602.867     22.9699     0.919485     1.47042e-06     2.71077e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.29084e-06       3.92498e-03        0.00000         8.39570e-05         0.99999        602.853     22.9699     0.919483     2.94138e-06     2.71134e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.14542e-06       7.85285e-03        0.00000         1.67969e-04         0.99998        602.825     22.9698     0.919480     5.88497e-06     2.71248e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.58170e-07       1.96539e-02        0.00000         4.20332e-04         0.99996        602.740     22.9698     0.919471     1.47291e-05     2.71590e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.29085e-07       3.93805e-02        0.00000         8.42036e-04         0.99992        602.599     22.9698     0.919455     2.95139e-05     2.72164e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.14542e-07       7.90545e-02        0.00000         1.68961e-03         0.99983        602.314     22.9698     0.919424     5.92526e-05     2.73322e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.58170e-08       1.99888e-01        0.00000         4.26646e-03         0.99958        601.449     22.9698     0.919328     1.49857e-04     2.76878e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.29085e-08       4.07642e-01        0.00000         8.68089e-03         0.99914        599.967     22.9698     0.919164     3.05745e-04     2.83100e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.14543e-08       8.49808e-01        0.00000         1.80093e-02         0.99822        596.833     22.9698     0.918815     6.37975e-04     2.96811e-13
   1.00000e+00        3.09989e-09        1.00000e+00        1.33012e-08       1.45013e+00        0.00000         3.05307e-02         0.99696        592.625     22.9698     0.918340     1.09003e-03     3.16491e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.58170e-09       2.47455e+00        0.00000         5.15233e-02         0.99483        585.567     22.9698     0.917530     1.86405e-03     3.53124e-13
   1.00000e+00        1.53961e-09        1.00000e+00        6.60622e-09       3.55948e+00        0.00000         7.32562e-02         0.99257        578.257     22.9698     0.916673     2.68740e-03     3.96536e-13
   1.00000e+00        1.23952e-09        1.00000e+00        5.31861e-09       5.12008e+00        0.00000         1.03650e-01         0.98935        568.033     22.9698     0.915441     3.87826e-03     4.68465e-13
   1.00000e+00        1.06452e-09        1.00000e+00        4.56769e-09       7.36492e+00        0.00000         1.45668e-01         0.98474        553.906     22.9698     0.913674     5.60473e-03     5.95283e-13
   1.00000e+00        1.00347e-09        1.00000e+00        4.30575e-09       1.05940e+01        0.00000         2.02842e-01         0.97818        534.730     22.9698     0.911145     8.11611e-03     8.39808e-13
   1.00000e+00        1.00347e-09        1.00000e+00        4.30575e-09       1.05965e+01        0.00000         2.02885e-01         0.97818        534.715     22.9698     0.911143     8.11811e-03     8.40037e-13
   1.00000e+00        1.03699e-09        1.00000e+00        4.44956e-09       1.35384e+01        0.00000         2.51913e-01         0.97227        518.356     22.9698     0.908856     1.04348e-02     1.14872e-12
   1.00000e+00        1.15814e-09        1.00000e+00        4.96942e-09       1.72969e+01        0.00000         3.10753e-01         0.96484        498.893     22.9698     0.905968     1.34345e-02     1.71185e-12
   1.00000e+00        1.42849e-09        1.00000e+00        6.12942e-09       2.20990e+01        0.00000         3.80485e-01         0.95553        476.197     22.9698     0.902347     1.73315e-02     2.84479e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.58170e-09       2.82342e+01        0.00000         4.62082e-01         0.94396        450.402     22.9698     0.897861     2.24146e-02     5.42460e-12
   1.00000e+00        2.96339e-09        1.00000e+00        1.27155e-08       3.44993e+01        0.00000         5.38349e-01         0.93254        427.352     22.9698     0.893478     2.77238e-02     1.04353e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.14543e-08       4.21546e+01        0.00000         6.24013e-01         0.91917        403.112     22.9698     0.888442     3.43683e-02     2.30233e-11
   1.00000e+00        6.91803e-09        1.00000e+00        2.96842e-08       4.66892e+01        0.00000         6.71699e-01         0.91158        390.539     22.9698     0.885641     3.83824e-02     3.66089e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.29085e-08       5.17116e+01        0.00000         7.22426e-01         0.90347        377.982     22.9698     0.882709     4.28928e-02     6.08899e-11
   1.00000e+00        2.00000e-08        1.00000e+00        8.58170e-08       6.09488e+01        0.00000         8.11340e-01         0.88942        358.160     22.9698     0.877792     5.13529e-02     1.52858e-10
   1.00000e+00        3.09619e-08        1.00000e+00        1.32853e-07       6.67022e+01        0.00000         8.64595e-01         0.88128        347.657     22.9698     0.875043     5.67196e-02     2.68133e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.14542e-07       7.29986e+01        0.00000         9.21544e-01         0.87293        337.534     22.9698     0.872304     6.26674e-02     4.90459e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.29085e-07       8.21547e+01        0.00000         1.00257e+00         0.86189        324.972     22.9698     0.868793     7.14313e-02     1.15345e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.58170e-07       9.14604e+01        0.00000         1.08340e+00         0.85206        314.335     22.9698     0.865744     8.04402e-02     2.66772e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.14542e-06       1.04160e+02        0.00000         1.19197e+00         0.84098        302.460     22.9698     0.862295     9.28170e-02     7.92968e-09
   9.99999e-01        1.00000e-06        9.99996e-01        4.29084e-06       1.14206e+02        0.00000         1.27663e+00         0.83416        294.672     22.9699     0.860031     1.02601e-01     1.78881e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.58164e-06       1.24767e+02        0.00000         1.36442e+00         0.82884        287.593     22.9699     0.857987     1.12808e-01     4.00929e-08
   9.99995e-01        5.00000e-06        9.99979e-01        2.14539e-05       1.39775e+02        0.00000         1.48670e+00         0.82444        278.910     22.9702     0.855504     1.27054e-01     1.15769e-07
   9.99990e-01        1.00000e-05        9.99957e-01        4.29071e-05       1.52170e+02        0.00000         1.58509e+00         0.82345        272.571     22.9705     0.853701     1.38489e-01     2.57542e-07
   9.99980e-01        2.00000e-05        9.99914e-01        8.58114e-05       1.65739e+02        0.00000         1.68974e+00         0.82487        266.209     22.9713     0.851883     1.50584e-01     5.72763e-07
   9.99968e-01        3.17612e-05        9.99864e-01        1.36268e-04       1.75609e+02        0.00000         1.76368e+00         0.82740        261.853     22.9722     0.850623     1.59070e-01     9.77014e-07
   9.99950e-01        5.00000e-05        9.99785e-01        2.14507e-04       1.86067e+02        0.00000         1.83994e+00         0.83131        257.428     22.9736     0.849323     1.67759e-01     1.65174e-06
   9.99929e-01        7.09946e-05        9.99695e-01        3.04556e-04       1.94764e+02        0.00000         1.90170e+00         0.83545        253.868     22.9752     0.848258     1.74742e-01     2.48090e-06
   9.99900e-01        1.00000e-04        9.99571e-01        4.28944e-04       2.03868e+02        0.00000         1.96472e+00         0.84056        250.243     22.9773     0.847153     1.81816e-01     3.69633e-06
   9.99858e-01        1.42185e-04        9.99390e-01        6.09807e-04       2.13941e+02        0.00000         2.03254e+00         0.84704        246.338     22.9805     0.845937     1.89366e-01     5.57638e-06
   9.99800e-01        2.00000e-04        9.99142e-01        8.57606e-04       2.24511e+02        0.00000         2.10158e+00         0.85468        242.348     22.9849     0.844664     1.96982e-01     8.32254e-06
   9.99680e-01        3.20165e-04        9.98628e-01        1.37233e-03       2.40633e+02        0.00000         2.20281e+00         0.86778        236.460     22.9940     0.842726     2.08023e-01     1.45080e-05
   9.99500e-01        5.00000e-04        9.97858e-01        2.14190e-03       2.57912e+02        0.00000         2.30613e+00         0.88344        230.397     23.0076     0.840651     2.19138e-01     2.46747e-05
   9.99287e-01        7.13401e-04        9.96946e-01        3.05393e-03       2.73403e+02        0.00000         2.39447e+00         0.89867        225.170     23.0237     0.838794     2.28524e-01     3.78288e-05
   9.99000e-01        1.00000e-03        9.95723e-01        4.27678e-03       2.89824e+02        0.00000         2.48399e+00         0.91582        219.838     23.0454     0.836832     2.37935e-01     5.69838e-05
   9.98571e-01        1.42906e-03        9.93897e-01        6.10318e-03       3.09352e+02        0.00000         2.58533e+00         0.93736        213.769     23.0778     0.834513     2.48480e-01     8.82734e-05
   9.98000e-01        2.00000e-03        9.91474e-01        8.52559e-03       3.30196e+02        0.00000         2.68788e+00         0.96148        207.607     23.1210     0.832062     2.59053e-01     1.33946e-04
   9.97444e-01        2.55624e-03        9.89123e-01        1.08769e-02       3.47210e+02        0.00000         2.76766e+00         0.98189        202.811     23.1630     0.830083     2.67224e-01     1.82234e-04
   9.96769e-01        3.23060e-03        9.86284e-01        1.37162e-02       3.65101e+02        0.00000         2.84807e+00         1.00395        197.984     23.2140     0.828029     2.75423e-01     2.45189e-04
   9.95961e-01        4.03944e-03        9.82895e-01        1.71053e-02       3.83913e+02        0.00000         2.92906e+00         1.02774        193.140     23.2751     0.825899     2.83658e-01     3.26431e-04
   9.95000e-01        5.00000e-03        9.78893e-01        2.11070e-02       4.03695e+02        0.00000         3.01064e+00         1.05332        188.288     23.3477     0.823697     2.91938e-01     4.30287e-04
   9.93991e-01        6.00868e-03        9.74718e-01        2.52824e-02       4.22360e+02        0.00000         3.08452e+00         1.07794        183.926     23.4240     0.821657     2.99434e-01     5.47264e-04
   9.92831e-01        7.16853e-03        9.69950e-01        3.00502e-02       4.41888e+02        0.00000         3.15888e+00         1.10416        179.577     23.5117     0.819562     3.06983e-01     6.91080e-04
   9.91506e-01        8.49395e-03        9.64545e-01        3.54552e-02       4.62320e+02        0.00000         3.23371e+00         1.13206        175.247     23.6118     0.817416     3.14595e-01     8.66837e-04
   9.90000e-01        1.00000e-02        9.58459e-01        4.15414e-02       4.83695e+02        0.00000         3.30905e+00         1.16174        170.944     23.7257     0.815220     3.22279e-01     1.08045e-03
   9.87979e-01        1.20209e-02        9.50383e-01        4.96173e-02       5.10065e+02        0.00000         3.39821e+00         1.19900        165.935     23.8785     0.812581     3.31408e-01     1.38900e-03
   9.85659e-01        1.43406e-02        9.41240e-01        5.87602e-02       5.37873e+02        0.00000         3.48814e+00         1.23904        160.985     24.0538     0.809884     3.40666e-01     1.77235e-03
   9.83011e-01        1.69890e-02        9.30962e-01        6.90376e-02       5.67197e+02        0.00000         3.57892e+00         1.28207        156.103     24.2540     0.807131     3.50072e-01     2.24612e-03
   9.80000e-01        2.00000e-02        9.19482e-01        8.05176e-02       5.98119e+02        0.00000         3.67061e+00         1.32833        151.297     24.4816     0.804327     3.59643e-01     2.82907e-03
   9.77021e-01        2.29794e-02        9.08331e-01        9.16692e-02       6.26716e+02        0.00000         3.75208e+00         1.37193        147.139     24.7068     0.801820     3.68219e-01     3.45013e-03
   9.73700e-01        2.63004e-02        8.96138e-01        1.03862e-01       6.56679e+02        0.00000         3.83432e+00         1.41847        143.048     24.9578     0.799279     3.76958e-01     4.19192e-03
   9.70000e-01        3.00000e-02        8.82841e-01        1.17159e-01       6.88076e+02        0.00000         3.91737e+00         1.46819        139.028     25.2375     0.796702     3.85879e-01     5.07716e-03
   9.66941e-01        3.30588e-02        8.72067e-01        1.27933e-01       7.12669e+02        0.00000         3.98032e+00         1.50785        136.052     25.4687     0.794741     3.92724e-01     5.85406e-03
   9.63618e-01        3.63821e-02        8.60582e-01        1.39418e-01       7.38141e+02        0.00000         4.04368e+00         1.54963        133.114     25.7199     0.792756     3.99699e-01     6.74252e-03
   9.60000e-01        4.00000e-02        8.48331e-01        1.51669e-01       7.64524e+02        0.00000         4.10738e+00         1.59367        130.214     25.9934     0.790745     4.06823e-01     7.76045e-03
   9.55278e-01        4.47216e-02        8.32725e-01        1.67275e-01       7.97003e+02        0.00000         4.18314e+00         1.64908        126.821     26.3503     0.788319     4.15486e-01     9.16512e-03
   9.50000e-01        5.00000e-02        8.15771e-01        1.84229e-01       8.30862e+02        0.00000         4.25891e+00         1.70835        123.466     26.7493     0.785831     4.24439e-01     1.08327e-02
   9.45271e-01        5.47288e-02        8.01006e-01        1.98994e-01       8.59097e+02        0.00000         4.31943e+00         1.75913        120.787     27.1067     0.783769     4.31891e-01     1.23575e-02
   9.40000e-01        6.00000e-02        7.85001e-01        2.14999e-01       8.88291e+02        0.00000         4.37915e+00         1.81312        118.108     27.5052     0.781625     4.39639e-01     1.41323e-02
   9.35285e-01        6.47148e-02        7.71072e-01        2.28928e-01       9.12389e+02        0.00000         4.42588e+00         1.85903        115.948     27.8616     0.779824     4.46119e-01     1.57877e-02
   9.30000e-01        7.00000e-02        7.55877e-01        2.44123e-01       9.37140e+02        0.00000         4.47093e+00         1.90774        113.755     28.2611     0.777912     4.52924e-01     1.77160e-02
   9.20000e-01        8.00000e-02        7.28270e-01        2.71730e-01       9.77386e+02        0.00000         4.53528e+00         1.99153        110.161     29.0170     0.774536     4.64605e-01     2.15623e-02
   9.10000e-01        9.00000e-02        7.02065e-01        2.97935e-01       1.00894e+03        0.00000         4.57266e+00         2.06368        107.158     29.7729     0.771382     4.74893e-01     2.56492e-02
   9.00000e-01        1.00000e-01        6.77158e-01        3.22842e-01       1.03182e+03        0.00000         4.58370e+00         2.12357        104.623     30.5288     0.768361     4.83950e-01     2.99582e-02
   8.90000e-01        1.10000e-01        6.53454e-01        3.46546e-01       1.04630e+03        0.00000         4.56967e+00         2.17096        102.463     31.2847     0.765404     4.91912e-01     3.44754e-02
   8.80000e-01        1.20000e-01        6.30869e-01        3.69131e-01       1.05291e+03        0.00000         4.53264e+00         2.20609        100.607     32.0406     0.762464     4.98906e-01     3.91915e-02
   8.70000e-01        1.30000e-01        6.09325e-01        3.90675e-01       1.05245e+03        0.00000         4.47541e+00         2.22969         98.995     32.7965     0.759510     5.05053e-01     4.41028e-02
   8.60000e-01        1.40000e-01        5.88751e-01        4.11249e-01       1.04591e+03        0.00000         4.40128e+00         2.24286         97.578     33.5524     0.756521     5.10467e-01     4.92104e-02
   8.50000e-01        1.50000e-01        5.69084e-01        4.30916e-01       1.03434e+03        0.00000         4.31372e+00         2.24694         96.319     34.3083     0.753489     5.15257e-01     5.45204e-02
   8.40000e-01        1.60000e-01        5.50265e-01        4.49735e-01       1.01880e+03        0.00000         4.21604e+00         2.24336         95.184     35.0642     0.750410     5.19522e-01     6.00432e-02
   8.30000e-01        1.70000e-01        5.32241e-01        4.67759e-01       1.00023e+03        0.00000         4.11125e+00         2.23351         94.147     35.8201     0.747284     5.23348e-01     6.57933e-02
   8.20000e-01        1.80000e-01        5.14961e-01        4.85039e-01       9.79476e+02        0.00000         4.00187e+00         2.21864         93.187     36.5760     0.744111     5.26811e-01     7.17888e-02
   8.10000e-01        1.90000e-01        4.98381e-01        5.01619e-01       9.57232e+02        0.00000         3.88995e+00         2.19986         92.285     37.3319     0.740892     5.29973e-01     7.80514e-02
   8.00000e-01        2.00000e-01        4.82460e-01        5.17540e-01       9.34057e+02        0.00000         3.77711e+00         2.17808         91.426     38.0878     0.737626     5.32889e-01     8.46069e-02
   7.90000e-01        2.10000e-01        4.67157e-01        5.32843e-01       9.10390e+02        0.00000         3.66455e+00         2.15407         90.599     38.8437     0.734312     5.35599e-01     9.14849e-02
   7.80000e-01        2.20000e-01        4.52440e-01        5.47560e-01       8.86567e+02        0.00000         3.55314e+00         2.12843         89.791     39.5996     0.730947     5.38140e-01     9.87201e-02
   7.70000e-01        2.30000e-01        4.38273e-01        5.61727e-01       8.62841e+02        0.00000         3.44351e+00         2.10163         88.995     40.3555     0.727524     5.40540e-01     1.06353e-01
   7.60000e-01        2.40000e-01        4.24627e-01        5.75373e-01       8.39398e+02        0.00000         3.33608e+00         2.07407         88.202     41.1114     0.724037     5.42823e-01     1.14429e-01
   7.50000e-01        2.50000e-01        4.11475e-01        5.88525e-01       8.16373e+02        0.00000         3.23110e+00         2.04604         87.404     41.8673     0.720477     5.45007e-01     1.23005e-01
   7.40000e-01        2.60000e-01        3.98788e-01        6.01212e-01       7.93861e+02        0.00000         3.12870e+00         2.01776         86.594     42.6232     0.716832     5.47108e-01     1.32145e-01
   7.30000e-01        2.70000e-01        3.86544e-01        6.13456e-01       7.71926e+02        0.00000         3.02896e+00         1.98942         85.765     43.3791     0.713090     5.49139e-01     1.41927e-01
   7.20000e-01        2.80000e-01        3.74719e-01        6.25281e-01       7.50610e+02        0.00000         2.93183e+00         1.96115         84.911     44.1350     0.709235     5.51111e-01     1.52445e-01
   7.10000e-01        2.90000e-01        3.63293e-01        6.36707e-01       7.29938e+02        0.00000         2.83727e+00         1.93306         84.024     44.8909     0.705247     5.53033e-01     1.63813e-01
   7.00000e-01        3.00000e-01        3.52245e-01        6.47755e-01       7.09923e+02        0.00000         2.74515e+00         1.90524         83.097     45.6468     0.701103     5.54911e-01     1.76172e-01
   6.90000e-01        3.10000e-01        3.41556e-01        6.58444e-01       6.90568e+02        0.00000         2.65535e+00         1.87775         82.122     46.4027     0.696777     5.56754e-01     1.89700e-01
   6.80000e-01        3.20000e-01        3.31211e-01        6.68789e-01       6.71871e+02        0.00000         2.56770e+00         1.85065         81.089     47.1586     0.692234     5.58566e-01     2.04621e-01
   6.70000e-01        3.30000e-01        3.21192e-01        6.78808e-01       6.53826e+02        0.00000         2.48199e+00         1.82397         79.986     47.9145     0.687433     5.60354e-01     2.21228e-01
   6.60000e-01        3.40000e-01        3.11484e-01        6.88516e-01       6.36426e+02        0.00000         2.39800e+00         1.79777         78.802     48.6704     0.682320     5.62122e-01     2.39901e-01
   6.50000e-01        3.50000e-01        3.02073e-01        6.97927e-01       6.19660e+02        0.00000         2.31546e+00         1.77207         77.519     49.4263     0.676826     5.63874e-01     2.60902e-01
   6.40000e-01        3.60000e-01        2.92946e-01        7.07054e-01       6.03521e+02        0.00000         2.23405e+00         1.74692         76.117     50.1822     0.670861     5.65616e-01     2.85215e-01
   6.30000e-01        3.70000e-01        2.84089e-01        7.15911e-01       5.88002e+02        0.00000         2.15336e+00         1.72235         74.568     50.9381     0.664300     5.67353e-01     3.13911e-01
   6.20000e-01        3.80000e-01        2.75491e-01        7.24509e-01       5.73101e+02        0.00000         2.07289e+00         1.69841         72.834     51.6940     0.656965     5.69089e-01     3.48626e-01
   6.10000e-01        3.90000e-01        2.67142e-01        7.32858e-01       5.58820e+02        0.00000         1.99192e+00         1.67518         70.864     52.4499     0.648596     5.70831e-01     3.91995e-01
   6.00000e-01        4.00000e-01        2.59029e-01        7.40971e-01       5.45173e+02        0.00000         1.90944e+00         1.65274         68.577     53.2058     0.638788     5.72587e-01     4.48576e-01
   5.90000e-01        4.10000e-01        2.51144e-01        7.48856e-01       5.32187e+02        0.00000         1.82393e+00         1.63121         65.852     53.9617     0.626871     5.74368e-01     5.27003e-01
   5.80000e-01        4.20000e-01        2.43477e-01        7.56523e-01       5.19913e+02        0.00000         1.73311e+00         1.61081         62.500     54.7176     0.611699     5.76188e-01     6.45472e-01
   5.70000e-01        4.30000e-01        2.36018e-01        7.63982e-01       5.08446e+02        0.00000         1.63449e+00         1.59185         58.277     55.4735     0.591445     5.78070e-01     8.45846e-01
   5.65318e-01        4.34682e-01        2.32596e-01        7.67404e-01       5.03392e+02        0.00000         1.58601e+00         1.58359         55.989     55.8274     0.579772     5.78980e-01     9.90045e-01
   5.65050e-01        4.34950e-01        2.32401e-01        7.67599e-01       5.03109e+02        0.50000         1.58312e+00         1.58312         55.848     55.8477     0.579033     5.79033e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   5.65050e-01          0.43495          2.32401e-01          0.76760          503.109          0.5000            1.58312           1.58312        55.8477     55.8477     0.579033     0.579033     1.00000e+00
   5.64782e-01          0.43522          2.32207e-01          0.76779          502.826          1.0000            1.58267           1.58025        55.8680     55.7064     0.579086     0.578293     9.90017e-01
   5.60000e-01          0.44000          2.28761e-01          0.77124          497.916          1.0000            1.57475           1.53109        56.2294     53.2546     0.580043     0.565021     8.25157e-01
   5.50000e-01          0.45000          2.21695e-01          0.77830          488.386          1.0000            1.55977           1.44022        56.9853     48.5352     0.582125     0.536961     5.52916e-01
   5.40000e-01          0.46000          2.14815e-01          0.78519          479.720          1.0000            1.54665           1.37225        57.7412     44.9807     0.584298     0.513019     3.84035e-01
   5.30000e-01          0.47000          2.08112e-01          0.79189          471.719          1.0000            1.53489           1.32160        58.4971     42.3847     0.586531     0.493563     2.79941e-01
   5.20000e-01          0.48000          2.01581e-01          0.79842          464.231          1.0000            1.52415           1.28194        59.2530     40.4027     0.588800     0.477339     2.11620e-01
   5.10000e-01          0.49000          1.95214e-01          0.80479          457.154          1.0000            1.51418           1.24948        60.0090     38.8190     0.591089     0.463373     1.64139e-01
   5.00000e-01          0.50000          1.89006e-01          0.81099          450.418          1.0000            1.50481           1.22202        60.7649     37.5082     0.593387     0.451040     1.29703e-01
   4.90000e-01          0.51000          1.82950e-01          0.81705          443.971          1.0000            1.49593           1.19824        61.5208     36.3941     0.595686     0.439939     1.03930e-01
   4.80000e-01          0.52000          1.77041e-01          0.82296          437.775          1.0000            1.48744           1.17728        62.2767     35.4279     0.597981     0.429800     8.41810e-02
   4.70000e-01          0.53000          1.71273e-01          0.82873          431.799          1.0000            1.47929           1.15856        63.0326     34.5766     0.600269     0.420433     6.87699e-02
   4.60000e-01          0.54000          1.65643e-01          0.83436          426.022          1.0000            1.47142           1.14166        63.7885     33.8172     0.602546     0.411704     5.65708e-02
   4.50000e-01          0.55000          1.60144e-01          0.83986          420.422          1.0000            1.46378           1.12627        64.5444     33.1328     0.604809     0.403509     4.68026e-02
   4.40000e-01          0.56000          1.54773e-01          0.84523          414.983          1.0000            1.45636           1.11215        65.3003     32.5107     0.607057     0.395770     3.89070e-02
   4.30000e-01          0.57000          1.49524e-01          0.85048          409.693          1.0000            1.44911           1.09914        66.0562     31.9413     0.609288     0.388426     3.24751e-02
   4.20000e-01          0.58000          1.44395e-01          0.85561          404.540          1.0000            1.44202           1.08709        66.8121     31.4169     0.611502     0.381427     2.72011e-02
   4.10000e-01          0.59000          1.39380e-01          0.86062          399.514          1.0000            1.43506           1.07587        67.5680     30.9315     0.613697     0.374734     2.28524e-02
   4.00000e-01          0.60000          1.34476e-01          0.86552          394.605          1.0000            1.42822           1.06540        68.3239     30.4801     0.615873     0.368314     1.92495e-02
   3.90000e-01          0.61000          1.29679e-01          0.87032          389.808          1.0000            1.42149           1.05560        69.0798     30.0588     0.618029     0.362139     1.62523e-02
   3.80000e-01          0.62000          1.24987e-01          0.87501          385.115          1.0000            1.41485           1.04639        69.8357     29.6640     0.620165     0.356186     1.37499e-02
   3.70000e-01          0.63000          1.20394e-01          0.87961          380.519          1.0000            1.40830           1.03773        70.5916     29.2931     0.622281     0.350435     1.16541e-02
   3.60000e-01          0.64000          1.15899e-01          0.88410          376.017          1.0000            1.40182           1.02957        71.3475     28.9436     0.624376     0.344870     9.89391e-03
   3.50000e-01          0.65000          1.11499e-01          0.88850          371.603          1.0000            1.39540           1.02186        72.1034     28.6134     0.626451     0.339477     8.41201e-03
   3.40000e-01          0.66000          1.07189e-01          0.89281          367.272          1.0000            1.38904           1.01456        72.8593     28.3008     0.628504     0.334241     7.16165e-03
   3.30000e-01          0.67000          1.02968e-01          0.89703          363.021          1.0000            1.38274           1.00765        73.6152     28.0043     0.630537     0.329153     6.10459e-03
   3.20000e-01          0.68000          9.88332e-02          0.90117          358.846          1.0000            1.37648           1.00110        74.3711     27.7224     0.632550     0.324201     5.20938e-03
   3.10000e-01          0.69000          9.47813e-02          0.90522          354.745          1.0000            1.37026           0.99488        75.1270     27.4541     0.634542     0.319379     4.45002e-03
   3.00000e-01          0.70000          9.08101e-02          0.90919          350.713          1.0000            1.36408           0.98896        75.8829     27.1982     0.636513     0.314676     3.80498e-03
   2.90000e-01          0.71000          8.69173e-02          0.91308          346.748          1.0000            1.35793           0.98334        76.6388     26.9539     0.638464     0.310088     3.25631e-03
   2.80000e-01          0.72000          8.31005e-02          0.91690          342.848          1.0000            1.35181           0.97798        77.3947     26.7203     0.640394     0.305607     2.78907e-03
   2.70000e-01          0.73000          7.93576e-02          0.92064          339.010          1.0000            1.34572           0.97288        78.1506     26.4967     0.642305     0.301228     2.39072e-03
   2.60000e-01          0.74000          7.56864e-02          0.92431          335.231          1.0000            1.33965           0.96802        78.9065     26.2824     0.644195     0.296945     2.05077e-03
   2.50000e-01          0.75000          7.20848e-02          0.92792          331.511          1.0000            1.33360           0.96338        79.6624     26.0768     0.646066     0.292755     1.76037e-03
   2.40000e-01          0.76000          6.85509e-02          0.93145          327.846          1.0000            1.32757           0.95896        80.4183     25.8794     0.647917     0.288652     1.51208e-03
   2.30000e-01          0.77000          6.50829e-02          0.93492          324.235          1.0000            1.32155           0.95474        81.1742     25.6897     0.649749     0.284632     1.29963e-03
   2.20000e-01          0.78000          6.16788e-02          0.93832          320.677          1.0000            1.31555           0.95071        81.9301     25.5072     0.651562     0.280693     1.11770e-03
   2.10000e-01          0.79000          5.83370e-02          0.94166          317.169          1.0000            1.30956           0.94687        82.6860     25.3315     0.653356     0.276831     9.61795e-04
   2.00000e-01          0.80000          5.50558e-02          0.94494          313.711          1.0000            1.30358           0.94319        83.4419     25.1622     0.655131     0.273042     8.28095e-04
   1.90000e-01          0.81000          5.18334e-02          0.94817          310.300          1.0000            1.29761           0.93968        84.1978     24.9991     0.656887     0.269325     7.13366e-04
   1.80000e-01          0.82000          4.86684e-02          0.95133          306.935          1.0000            1.29164           0.93633        84.9537     24.8417     0.658626     0.265676     6.14854e-04
   1.70000e-01          0.83000          4.55592e-02          0.95444          303.615          1.0000            1.28568           0.93312        85.7096     24.6898     0.660346     0.262092     5.30216e-04
   1.60000e-01          0.84000          4.25044e-02          0.95750          300.339          1.0000            1.27973           0.93006        86.4655     24.5432     0.662049     0.258572     4.57456e-04
   1.50000e-01          0.85000          3.95026e-02          0.96050          297.106          1.0000            1.27377           0.92714        87.2214     24.4014     0.663733     0.255114     3.94873e-04
   1.40000e-01          0.86000          3.65523e-02          0.96345          293.914          1.0000            1.26782           0.92434        87.9773     24.2644     0.665401     0.251714     3.41015e-04
   1.30000e-01          0.87000          3.36523e-02          0.96635          290.762          1.0000            1.26187           0.92167        88.7332     24.1319     0.667052     0.248373     2.94641e-04
   1.20000e-01          0.88000          3.08012e-02          0.96920          287.650          1.0000            1.25593           0.91913        89.4891     24.0037     0.668685     0.245087     2.54692e-04
   1.10000e-01          0.89000          2.79980e-02          0.97200          284.576          1.0000            1.24998           0.91669        90.2450     23.8796     0.670302     0.241854     2.20259e-04
   1.00000e-01          0.90000          2.52413e-02          0.97476          281.539          1.0000            1.24403           0.91437        91.0009     23.7595     0.671902     0.238675     1.90568e-04
   9.00000e-02          0.91000          2.25300e-02          0.97747          278.539          1.0000            1.23808           0.91215        91.7568     23.6430     0.673486     0.235546     1.64953e-04
   8.00000e-02          0.92000          1.98630e-02          0.98014          275.575          1.0000            1.23212           0.91003        92.5127     23.5302     0.675055     0.232466     1.42844e-04
   7.00000e-02          0.93000          1.72393e-02          0.98276          272.645          1.0000            1.22616           0.90802        93.2686     23.4209     0.676607     0.229435     1.23753e-04
   6.00000e-02          0.94000          1.46577e-02          0.98534          269.750          1.0000            1.22020           0.90609        94.0245     23.3149     0.678144     0.226450     1.07261e-04
   5.00000e-02          0.95000          1.21174e-02          0.98788          266.887          1.0000            1.21424           0.90426        94.7804     23.2120     0.679665     0.223511     9.30064e-05
   4.00000e-02          0.96000          9.61720e-03          0.99038          264.058          1.0000            1.20827           0.90252        95.5363     23.1123     0.681171     0.220616     8.06814e-05
   3.00000e-02          0.97000          7.15627e-03          0.99284          261.260          1.0000            1.20229           0.90086        96.2922     23.0154     0.682662     0.217765     7.00199e-05
   2.00000e-02          0.98000          4.73369e-03          0.99527          258.493          1.0000            1.19631           0.89928        97.0481     22.9215     0.684139     0.214956     6.07934e-05
   1.00000e-02          0.99000          2.34855e-03          0.99765          255.756          1.0000            1.19032           0.89778        97.8040     22.8302     0.685600     0.212187     5.28053e-05
   5.00000e-03          0.99500          1.16976e-03          0.99883          254.399          1.0000            1.18732           0.89706        98.1820     22.7856     0.686326     0.210818     4.92218e-05
   2.00000e-03          0.99800          4.66824e-04          0.99953          253.589          1.0000            1.18552           0.89663        98.4087     22.7591     0.686759     0.210002     4.71919e-05
   1.00000e-03          0.99900          2.33233e-04          0.99977          253.319          1.0000            1.18492           0.89649        98.4843     22.7504     0.686904     0.209730     4.65345e-05
   5.00000e-04          0.99950          1.16572e-04          0.99988          253.184          1.0000            1.18462           0.89642        98.5221     22.7460     0.686976     0.209595     4.62093e-05
   2.00000e-04          0.99980          4.66180e-05          0.99995          253.104          1.0000            1.18444           0.89638        98.5448     22.7434     0.687019     0.209514     4.60153e-05
   1.00000e-04          0.99990          2.33072e-05          0.99998          253.077          1.0000            1.18438           0.89637        98.5524     22.7425     0.687033     0.209486     4.59508e-05
   5.00000e-05          0.99995          1.16531e-05          0.99999          253.063          1.0000            1.18435           0.89636        98.5561     22.7420     0.687041     0.209473     4.59186e-05
   2.00000e-05          0.99998          4.66115e-06          1.00000          253.055          1.0000            1.18434           0.89636        98.5584     22.7418     0.687045     0.209465     4.58993e-05
   1.00000e-05          0.99999          2.33056e-06          1.00000          253.052          1.0000            1.18433           0.89635        98.5592     22.7417     0.687046     0.209462     4.58928e-05
   5.00000e-06          0.99999          1.16527e-06          1.00000          253.051          1.0000            1.18433           0.89635        98.5595     22.7417     0.687047     0.209461     4.58896e-05
   2.00000e-06          1.00000          4.66109e-07          1.00000          253.050          1.0000            1.18433           0.89635        98.5598     22.7416     0.687047     0.209460     4.58877e-05
   1.00000e-06          1.00000          2.33054e-07          1.00000          253.050          1.0000            1.18433           0.89635        98.5598     22.7416     0.687048     0.209460     4.58870e-05
   5.00000e-07          1.00000          1.16527e-07          1.00000          253.050          1.0000            1.18433           0.89635        98.5599     22.7416     0.687048     0.209460     4.58867e-05
   2.00000e-07          1.00000          4.66108e-08          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58865e-05
   1.00000e-07          1.00000          2.33054e-08          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58865e-05
   5.00000e-08          1.00000          1.16527e-08          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   2.00000e-08          1.00000          4.66108e-09          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   1.00000e-08          1.00000          2.33054e-09          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   5.00000e-09          1.00000          1.16527e-09          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   2.00000e-09          1.00000          4.66108e-10          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   1.00000e-09          1.00000          2.33054e-10          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   5.00000e-10          1.00000          1.16527e-10          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   2.00000e-10          1.00000          4.66108e-11          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   1.00000e-10          1.00000          2.33054e-11          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   5.00000e-11          1.00000          1.16527e-11          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   2.00000e-11          1.00000          4.66108e-12          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   1.00000e-11          1.00000          2.33054e-12          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   5.00000e-12          1.00000          1.16527e-12          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   2.00000e-12          1.00000          4.66108e-13          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   1.00000e-12          1.00000          2.33054e-13          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          253.050          1.0000            1.18432           0.89635        98.5599     22.7416     0.687048     0.209459     4.58864e-05
END

set output "Figures/Env_006_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_006_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_006_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_006_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "P-T Diagram for Predicted_3350_m_Oil"
show title

$Env_DP << END
#   Temp        Sat Pres                                                                                     Liq Den       Gas Den             
#   (C)          (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   31.961     1.00000e-13        0.00000         2.54834e-15          1.00000       602.891     99.2894     0.932585     3.91391e-16     6.69722e-18
   32.500     1.11895e-13        0.00000         2.84673e-15          1.00000       602.891     99.2894     0.932485     4.37173e-16     7.48843e-18
   35.000     1.87288e-13        0.00000         4.72854e-15          1.00000       602.891     99.2894     0.932019     7.25799e-16     1.24936e-17
   37.500     3.10474e-13        0.00000         7.77952e-15          1.00000       602.891     99.2894     0.931549     1.19350e-15     2.06481e-17
   40.000     5.09874e-13        0.00000         1.26803e-14          1.00000       602.890     99.2894     0.931075     1.94437e-15     3.38119e-17
   42.500     8.29708e-13        0.00000         2.04815e-14          1.00000       602.890     99.2894     0.930597     3.13898e-15     5.48734e-17
   45.000     1.33818e-12        0.00000         3.27905e-14          1.00000       602.890     99.2894     0.930115     5.02284e-15     8.82778e-17
   47.500     2.13955e-12        0.00000         5.20457e-14          1.00000       602.890     99.2894     0.929629     7.96819e-15     1.40810e-16
   50.000     3.39193e-12        0.00000         8.19153e-14          1.00000       602.890     99.2894     0.929139     1.25346e-14     2.22743e-16
   52.500     5.33306e-12        0.00000         1.27873e-13          1.00000       602.890     99.2894     0.928645     1.95566e-14     3.49499e-16
   55.000     8.31762e-12        0.00000         1.98022e-13          1.00000       602.890     99.2894     0.928148     3.02688e-14     5.44062e-16
   57.500     1.28706e-11        0.00000         3.04266e-13          1.00000       602.889     99.2894     0.927645     4.64837e-14     8.40416e-16
   60.000     1.97634e-11        0.00000         4.63960e-13          1.00000       602.889     99.2894     0.927139     7.08420e-14     1.28844e-15
   62.500     3.01206e-11        0.00000         7.02222e-13          1.00000       602.889     99.2894     0.926629     1.07163e-13     1.96082e-15
   65.000     4.55704e-11        0.00000         1.05514e-12          1.00000       602.889     99.2894     0.926114     1.60932e-13     2.96270e-15
   67.500     6.84533e-11        0.00000         1.57423e-12          1.00000       602.888     99.2894     0.925596     2.39969e-13     4.44519e-15
   70.000     1.02111e-10        0.00000         2.33246e-12          1.00000       602.888     99.2894     0.925073     3.55349e-13     6.62394e-15
   72.500     1.51280e-10        0.00000         3.43257e-12          1.00000       602.888     99.2894     0.924545     5.22655e-13     9.80470e-15
   75.000     2.22637e-10        0.00000         5.01828e-12          1.00000       602.887     99.2894     0.924014     7.63660e-13     1.44182e-14
   77.500     3.25524e-10        0.00000         7.28928e-12          1.00000       602.887     99.2894     0.923478     1.10861e-12     2.10675e-14
   80.000     4.72936e-10        0.00000         1.05214e-11          1.00000       602.886     99.2894     0.922937     1.59923e-12     3.05917e-14
   82.500     6.82840e-10        0.00000         1.50932e-11          1.00000       602.885     99.2894     0.922393     2.29279e-12     4.41511e-14
   85.000     9.79924e-10        0.00000         2.15214e-11          1.00000       602.885     99.2894     0.921843     3.26735e-12     6.33415e-14
   87.500     1.39792e-09        0.00000         3.05070e-11          1.00000       602.884     99.2894     0.921289     4.62876e-12     9.03444e-14
   90.000     1.98265e-09        0.00000         4.29957e-11          1.00000       602.883     99.2894     0.920731     6.51971e-12     1.28126e-13
   92.500     2.79600e-09        0.00000         6.02564e-11          1.00000       602.882     99.2894     0.920168     9.13147e-12     1.80696e-13
   95.000     3.92114e-09        0.00000         8.39819e-11          1.00000       602.881     99.2894     0.919600     1.27191e-11     2.53450e-13
   97.500     5.46919e-09        0.00000         1.16420e-10          1.00000       602.880     99.2894     0.919028     1.76209e-11     3.53604e-13
  100.000     7.58786e-09        0.00000         1.60537e-10          1.00000       602.878     99.2894     0.918451     2.42831e-11     4.90764e-13
  102.500     1.04725e-08        0.00000         2.20233e-10          1.00000       602.877     99.2894     0.917869     3.32918e-11     6.77656e-13
  105.000     1.43803e-08        0.00000         3.00604e-10          1.00000       602.875     99.2894     0.917283     4.54123e-11     9.31052e-13
  107.500     1.96479e-08        0.00000         4.08281e-10          1.00000       602.874     99.2894     0.916692     6.16395e-11     1.27295e-12
  110.000     2.67141e-08        0.00000         5.51851e-10          1.00000       602.872     99.2894     0.916095     8.32607e-11     1.73209e-12
  112.500     3.61481e-08        0.00000         7.42379e-10          1.00000       602.870     99.2894     0.915494     1.11934e-10     2.34579e-12
  115.000     4.86849e-08        0.00000         9.94065e-10          1.00000       602.867     99.2894     0.914888     1.49783e-10     3.16237e-12
  117.500     6.52694e-08        0.00000         1.32504e-09          1.00000       602.865     99.2894     0.914277     1.99522e-10     4.24407e-12
  120.000     8.71107e-08        0.00000         1.75838e-09          1.00000       602.862     99.2894     0.913661     2.64595e-10     5.67073e-12
  122.500     1.15750e-07        0.00000         2.32328e-09          1.00000       602.859     99.2894     0.913039     3.49364e-10     7.54433e-12
  125.000     1.53142e-07        0.00000         3.05658e-09          1.00000       602.856     99.2894     0.912413     4.59321e-10     9.99462e-12
  127.500     2.01759e-07        0.00000         4.00455e-09          1.00000       602.852     99.2894     0.911781     6.01362e-10     1.31860e-11
  130.000     2.64709e-07        0.00000         5.22504e-09          1.00000       602.849     99.2894     0.911144     7.84100e-10     1.73259e-11
  132.500     3.45894e-07        0.00000         6.79018e-09          1.00000       602.844     99.2894     0.910502     1.01826e-09     2.26751e-11
  135.000     4.50180e-07        0.00000         8.78947e-09          1.00000       602.840     99.2894     0.909854     1.31715e-09     2.95604e-11
  137.500     5.83626e-07        0.00000         1.13336e-08          1.00000       602.835     99.2894     0.909201     1.69719e-09     3.83894e-11
  140.000     7.53739e-07        0.00000         1.45589e-08          1.00000       602.830     99.2894     0.908543     2.17862e-09     4.96689e-11
  142.500     9.69788e-07        0.00000         1.86328e-08          1.00000       602.824     99.2894     0.907879     2.78624e-09     6.40269e-11
  145.000     1.24318e-06        0.00000         2.37600e-08          1.00000       602.818     99.2894     0.907209     3.55035e-09     8.22385e-11
  147.500     1.58790e-06        0.00000         3.01902e-08          1.00000       602.812     99.2894     0.906534     4.50788e-09     1.05258e-10
  150.000     2.02105e-06        0.00000         3.82267e-08          1.00000       602.805     99.2894     0.905853     5.70362e-09     1.34254e-10
  152.500     2.56342e-06        0.00000         4.82364e-08          1.00000       602.797     99.2894     0.905167     7.19176e-09     1.70657e-10
  155.000     3.24028e-06        0.00000         6.06626e-08          1.00000       602.789     99.2894     0.904474     9.03764e-09     2.16209e-10
  157.500     4.08218e-06        0.00000         7.60382e-08          1.00000       602.780     99.2894     0.903776     1.13197e-08     2.73024e-10
  160.000     5.12599e-06        0.00000         9.50024e-08          1.00000       602.771     99.2894     0.903072     1.41321e-08     3.43665e-10
  162.500     6.41598e-06        0.00000         1.18319e-07          1.00000       602.761     99.2894     0.902362     1.75871e-08     4.31222e-10
  165.000     8.00527e-06        0.00000         1.46899e-07          1.00000       602.750     99.2894     0.901646     2.18183e-08     5.39417e-10
  167.500     9.95728e-06        0.00000         1.81825e-07          1.00000       602.738     99.2894     0.900924     2.69846e-08     6.72714e-10
  170.000     1.23476e-05        0.00000         2.24378e-07          1.00000       602.726     99.2894     0.900196     3.32736e-08     8.36455e-10
  172.500     1.52659e-05        0.00000         2.76073e-07          1.00000       602.713     99.2894     0.899461     4.09071e-08     1.03702e-09
  175.000     1.88187e-05        0.00000         3.38694e-07          1.00000       602.699     99.2894     0.898720     5.01458e-08     1.28198e-09
  177.500     2.31314e-05        0.00000         4.14338e-07          1.00000       602.684     99.2894     0.897973     6.12959e-08     1.58035e-09
  180.000     2.83520e-05        0.00000         5.05460e-07          1.00000       602.668     99.2894     0.897219     7.47155e-08     1.94278e-09
  182.500     3.46543e-05        0.00000         6.14931e-07          1.00000       602.651     99.2894     0.896459     9.08227e-08     2.38185e-09
  185.000     4.22418e-05        0.00000         7.46094e-07          1.00000       602.633     99.2894     0.895693     1.10104e-07     2.91236e-09
  187.500     5.13523e-05        0.00000         9.02838e-07          1.00000       602.613     99.2894     0.894919     1.33125e-07     3.55171e-09
  190.000     6.22633e-05        0.00000         1.08967e-06          1.00000       602.593     99.2894     0.894139     1.60539e-07     4.32027e-09
  192.500     7.52969e-05        0.00000         1.31180e-06          1.00000       602.571     99.2894     0.893352     1.93102e-07     5.24188e-09
  195.000     9.08271e-05        0.00000         1.57526e-06          1.00000       602.548     99.2894     0.892559     2.31686e-07     6.34429e-09
  197.500     1.09286e-04        0.00000         1.88695e-06          1.00000       602.523     99.2894     0.891758     2.77292e-07     7.65982e-09
  200.000     1.31173e-04        0.00000         2.25483e-06          1.00000       602.497     99.2894     0.890950     3.31067e-07     9.22597e-09
  202.500     1.57063e-04        0.00000         2.68802e-06          1.00000       602.469     99.2894     0.890135     3.94327e-07     1.10862e-08
  205.000     1.87616e-04        0.00000         3.19691e-06          1.00000       602.440     99.2894     0.889313     4.68571e-07     1.32906e-08
  207.500     2.23588e-04        0.00000         3.79339e-06          1.00000       602.409     99.2894     0.888484     5.55507e-07     1.58971e-08
  210.000     2.65845e-04        0.00000         4.49096e-06          1.00000       602.376     99.2894     0.887647     6.57078e-07     1.89723e-08
  212.500     3.15374e-04        0.00000         5.30498e-06          1.00000       602.341     99.2894     0.886803     7.75483e-07     2.25926e-08
  215.000     3.73298e-04        0.00000         6.25280e-06          0.99999       602.305     99.2894     0.885951     9.13216e-07     2.68457e-08
  217.500     4.40896e-04        0.00000         7.35411e-06          0.99999       602.266     99.2894     0.885091     1.07309e-06     3.18315e-08
  220.000     5.19614e-04        0.00000         8.63106e-06          0.99999       602.225     99.2894     0.884224     1.25827e-06     3.76645e-08
  222.500     6.11091e-04        0.00000         1.01086e-05          0.99999       602.182     99.2894     0.883349     1.47232e-06     4.44749e-08
  225.000     7.17178e-04        0.00000         1.18149e-05          0.99999       602.136     99.2894     0.882466     1.71925e-06     5.24107e-08
  227.500     8.39957e-04        0.00000         1.37813e-05          0.99999       602.088     99.2894     0.881574     2.00353e-06     6.16398e-08
  230.000     9.81774e-04        0.00000         1.60431e-05          0.99999       602.037     99.2894     0.880675     2.33017e-06     7.23526e-08
  232.500     1.14526e-03        0.00000         1.86396e-05          0.99999       601.983     99.2894     0.879767     2.70477e-06     8.47641e-08
  235.000     1.33336e-03        0.00000         2.16148e-05          0.99998       601.927     99.2894     0.878851     3.13353e-06     9.91171e-08
  237.500     1.54938e-03        0.00000         2.50175e-05          0.99998       601.868     99.2894     0.877926     3.62337e-06     1.15685e-07
  240.000     1.79700e-03        0.00000         2.89021e-05          0.99998       601.805     99.2894     0.876993     4.18197e-06     1.34776e-07
  242.500     2.08031e-03        0.00000         3.33286e-05          0.99997       601.740     99.2894     0.876050     4.81784e-06     1.56735e-07
  245.000     2.40387e-03        0.00000         3.83639e-05          0.99997       601.670     99.2894     0.875099     5.54035e-06     1.81950e-07
  247.500     2.77276e-03        0.00000         4.40816e-05          0.99997       601.598     99.2894     0.874139     6.35988e-06     2.10854e-07
  250.000     3.19257e-03        0.00000         5.05630e-05          0.99996       601.522     99.2894     0.873170     7.28785e-06     2.43931e-07
  252.500     3.66953e-03        0.00000         5.78978e-05          0.99996       601.441     99.2894     0.872191     8.33683e-06     2.81722e-07
  255.000     4.21049e-03        0.00000         6.61843e-05          0.99995       601.357     99.2894     0.871203     9.52062e-06     3.24830e-07
  257.500     4.82302e-03        0.00000         7.55308e-05          0.99995       601.269     99.2894     0.870205     1.08543e-05     3.73923e-07
  260.000     5.51544e-03        0.00000         8.60558e-05          0.99994       601.176     99.2894     0.869197     1.23545e-05     4.29747e-07
  262.500     6.29692e-03        0.00000         9.78892e-05          0.99993       601.079     99.2894     0.868180     1.40393e-05     4.93126e-07
  265.000     7.17749e-03        0.00000         1.11173e-04          0.99992       600.977     99.2894     0.867152     1.59284e-05     5.64975e-07
  267.500     8.16818e-03        0.00000         1.26061e-04          0.99991       600.871     99.2894     0.866115     1.80433e-05     6.46305e-07
  270.000     9.28104e-03        0.00000         1.42723e-04          0.99990       600.759     99.2894     0.865067     2.04074e-05     7.38234e-07
  272.500     1.05292e-02        0.00000         1.61341e-04          0.99989       600.642     99.2894     0.864008     2.30461e-05     8.41993e-07
  275.000     1.19271e-02        0.00000         1.82116e-04          0.99988       600.519     99.2894     0.862939     2.59870e-05     9.58940e-07
  277.500     1.34903e-02        0.00000         2.05263e-04          0.99987       600.390     99.2894     0.861858     2.92600e-05     1.09057e-06
  280.000     1.52359e-02        0.00000         2.31017e-04          0.99985       600.256     99.2894     0.860767     3.28972e-05     1.23853e-06
  282.500     1.71824e-02        0.00000         2.59630e-04          0.99984       600.115     99.2894     0.859664     3.69337e-05     1.40462e-06
  285.000     1.93498e-02        0.00000         2.91377e-04          0.99982       599.968     99.2894     0.858550     4.14070e-05     1.59081e-06
  287.500     2.17599e-02        0.00000         3.26552e-04          0.99980       599.814     99.2894     0.857424     4.63577e-05     1.79928e-06
  290.000     2.44363e-02        0.00000         3.65475e-04          0.99978       599.654     99.2894     0.856286     5.18294e-05     2.03239e-06
  292.500     2.74042e-02        0.00000         4.08488e-04          0.99975       599.486     99.2894     0.855136     5.78689e-05     2.29273e-06
  295.000     3.06913e-02        0.00000         4.55958e-04          0.99973       599.310     99.2894     0.853974     6.45266e-05     2.58314e-06
  297.500     3.43270e-02        0.00000         5.08282e-04          0.99970       599.127     99.2894     0.852799     7.18564e-05     2.90670e-06
  300.000     3.83434e-02        0.00000         5.65882e-04          0.99967       598.935     99.2894     0.851611     7.99160e-05     3.26677e-06
  302.500     4.27745e-02        0.00000         6.29214e-04          0.99964       598.735     99.2894     0.850410     8.87672e-05     3.66702e-06
  305.000     4.76573e-02        0.00000         6.98763e-04          0.99960       598.527     99.2894     0.849196     9.84759e-05     4.11142e-06
  307.500     5.30313e-02        0.00000         7.75049e-04          0.99956       598.309     99.2894     0.847969     1.09113e-04     4.60431e-06
  310.000     5.89387e-02        0.00000         8.58625e-04          0.99952       598.082     99.2894     0.846727     1.20753e-04     5.15038e-06
  312.500     6.54251e-02        0.00000         9.50083e-04          0.99948       597.845     99.2894     0.845472     1.33475e-04     5.75474e-06
  315.000     7.25389e-02        0.00000         1.05005e-03          0.99943       597.597     99.2894     0.844202     1.47366e-04     6.42292e-06
  317.500     8.03319e-02        0.00000         1.15921e-03          0.99938       597.340     99.2894     0.842917     1.62516e-04     7.16092e-06
  320.000     8.88596e-02        0.00000         1.27825e-03          0.99932       597.071     99.2894     0.841618     1.79020e-04     7.97522e-06
  322.500     9.81809e-02        0.00000         1.40795e-03          0.99926       596.791     99.2894     0.840303     1.96981e-04     8.87284e-06
  325.000     1.08359e-01        0.00000         1.54911e-03          0.99920       596.499     99.2894     0.838972     2.16507e-04     9.86137e-06
  327.500     1.19461e-01        0.00000         1.70258e-03          0.99913       596.195     99.2894     0.837626     2.37711e-04     1.09490e-05
  330.000     1.31557e-01        0.00000         1.86926e-03          0.99906       595.878     99.2894     0.836263     2.60716e-04     1.21447e-05
  332.500     1.44725e-01        0.00000         2.05011e-03          0.99898       595.548     99.2894     0.834884     2.85649e-04     1.34579e-05
  335.000     1.59043e-01        0.00000         2.24614e-03          0.99889       595.204     99.2894     0.833487     3.12646e-04     1.48990e-05
  337.500     1.74599e-01        0.00000         2.45842e-03          0.99880       594.846     99.2894     0.832073     3.41851e-04     1.64791e-05
  340.000     1.91481e-01        0.00000         2.68809e-03          0.99871       594.473     99.2894     0.830642     3.73414e-04     1.82103e-05
  342.500     2.09788e-01        0.00000         2.93633e-03          0.99861       594.085     99.2894     0.829192     4.07494e-04     2.01055e-05
  345.000     2.29620e-01        0.00000         3.20441e-03          0.99850       593.681     99.2894     0.827724     4.44260e-04     2.21786e-05
  347.500     2.51084e-01        0.00000         3.49366e-03          0.99838       593.261     99.2894     0.826236     4.83889e-04     2.44447e-05
  350.000     2.74297e-01        0.00000         3.80546e-03          0.99826       592.823     99.2894     0.824729     5.26568e-04     2.69201e-05
  352.500     2.99377e-01        0.00000         4.14131e-03          0.99813       592.368     99.2894     0.823202     5.72493e-04     2.96220e-05
  355.000     3.26452e-01        0.00000         4.50274e-03          0.99799       591.894     99.2894     0.821654     6.21871e-04     3.25693e-05
  357.500     3.55658e-01        0.00000         4.89140e-03          0.99784       591.401     99.2894     0.820086     6.74920e-04     3.57823e-05
  360.000     3.87137e-01        0.00000         5.30900e-03          0.99768       590.888     99.2894     0.818496     7.31870e-04     3.92827e-05
  362.500     4.21038e-01        0.00000         5.75734e-03          0.99752       590.355     99.2894     0.816884     7.92960e-04     4.30938e-05
  365.000     4.57522e-01        0.00000         6.23834e-03          0.99734       589.800     99.2894     0.815249     8.58446e-04     4.72411e-05
  367.500     4.96754e-01        0.00000         6.75398e-03          0.99716       589.223     99.2894     0.813591     9.28593e-04     5.17516e-05
  370.000     5.38913e-01        0.00000         7.30637e-03          0.99696       588.623     99.2894     0.811909     1.00368e-03     5.66546e-05
  372.500     5.84184e-01        0.00000         7.89770e-03          0.99676       587.998     99.2894     0.810203     1.08401e-03     6.19815e-05
  375.000     6.32764e-01        0.00000         8.53029e-03          0.99654       587.349     99.2894     0.808472     1.16988e-03     6.77665e-05
  377.500     6.84861e-01        0.00000         9.20657e-03          0.99631       586.674     99.2894     0.806714     1.26162e-03     7.40460e-05
  380.000     7.40694e-01        0.00000         9.92910e-03          0.99607       585.972     99.2894     0.804931     1.35958e-03     8.08595e-05
  382.500     8.00492e-01        0.00000         1.07005e-02          0.99582       585.242     99.2894     0.803119     1.46411e-03     8.82496e-05
  385.000     8.64501e-01        0.00000         1.15237e-02          0.99555       584.482     99.2894     0.801280     1.57560e-03     9.62620e-05
  387.500     9.32976e-01        0.00000         1.24016e-02          0.99527       583.693     99.2894     0.799412     1.69444e-03     1.04946e-04
  390.000     1.00619e+00        0.00000         1.33373e-02          0.99498       582.871     99.2894     0.797514     1.82106e-03     1.14356e-04
  392.500     1.08443e+00        0.00000         1.43341e-02          0.99467       582.017     99.2894     0.795585     1.95589e-03     1.24550e-04
  395.000     1.16799e+00        0.00000         1.53953e-02          0.99434       581.128     99.2894     0.793624     2.09941e-03     1.35589e-04
  397.500     1.25720e+00        0.00000         1.65246e-02          0.99400       580.204     99.2894     0.791631     2.25210e-03     1.47541e-04
  400.000     1.35239e+00        0.00000         1.77258e-02          0.99365       579.243     99.2894     0.789604     2.41449e-03     1.60480e-04
  402.500     1.45392e+00        0.00000         1.90029e-02          0.99328       578.242     99.2894     0.787542     2.58712e-03     1.74486e-04
  405.000     1.56217e+00        0.00000         2.03601e-02          0.99289       577.202     99.2894     0.785444     2.77058e-03     1.89643e-04
  407.500     1.67753e+00        0.00000         2.18017e-02          0.99248       576.119     99.2894     0.783309     2.96547e-03     2.06047e-04
  410.000     1.80043e+00        0.00000         2.33324e-02          0.99205       574.992     99.2894     0.781136     3.17245e-03     2.23798e-04
  412.500     1.93131e+00        0.00000         2.49572e-02          0.99160       573.818     99.2894     0.778923     3.39220e-03     2.43007e-04
  415.000     2.07066e+00        0.00000         2.66813e-02          0.99114       572.597     99.2894     0.776668     3.62545e-03     2.63794e-04
  417.500     2.21898e+00        0.00000         2.85100e-02          0.99065       571.326     99.2894     0.774371     3.87298e-03     2.86291e-04
  420.000     2.37681e+00        0.00000         3.04491e-02          0.99014       570.001     99.2894     0.772029     4.13560e-03     3.10643e-04
  422.500     2.54471e+00        0.00000         3.25048e-02          0.98961       568.622     99.2894     0.769641     4.41420e-03     3.37004e-04
  425.000     2.72329e+00        0.00000         3.46836e-02          0.98905       567.184     99.2894     0.767205     4.70971e-03     3.65549e-04
  427.500     2.91322e+00        0.00000         3.69923e-02          0.98848       565.686     99.2894     0.764719     5.02313e-03     3.96464e-04
  430.000     3.11517e+00        0.00000         3.94381e-02          0.98787       564.125     99.2894     0.762182     5.35552e-03     4.29959e-04
  432.500     3.32990e+00        0.00000         4.20289e-02          0.98724       562.497     99.2894     0.759590     5.70803e-03     4.66260e-04
  435.000     3.55820e+00        0.00000         4.47729e-02          0.98659       560.798     99.2894     0.756942     6.08188e-03     5.05621e-04
  437.500     3.80093e+00        0.00000         4.76788e-02          0.98591       559.025     99.2894     0.754236     6.47840e-03     5.48319e-04
  440.000     4.05901e+00        0.00000         5.07560e-02          0.98519       557.175     99.2894     0.751467     6.89901e-03     5.94663e-04
  442.500     4.33344e+00        0.00000         5.40146e-02          0.98445       555.243     99.2894     0.748634     7.34524e-03     6.44996e-04
  445.000     4.62528e+00        0.00000         5.74653e-02          0.98368       553.224     99.2894     0.745733     7.81875e-03     6.99699e-04
  447.500     4.93570e+00        0.00000         6.11197e-02          0.98288       551.113     99.2894     0.742762     8.32137e-03     7.59198e-04
  450.000     5.26596e+00        0.00000         6.49902e-02          0.98204       548.906     99.2894     0.739715     8.85504e-03     8.23969e-04
  452.500     5.61744e+00        0.00000         6.90903e-02          0.98116       546.595     99.2894     0.736590     9.42191e-03     8.94548e-04
  455.000     5.99165e+00        0.00000         7.34345e-02          0.98025       544.176     99.2894     0.733382     1.00243e-02     9.71537e-04
  457.500     6.39022e+00        0.00000         7.80386e-02          0.97931       541.641     99.2894     0.730086     1.06649e-02     1.05562e-03
  460.000     6.81497e+00        0.00000         8.29197e-02          0.97832       538.982     99.2894     0.726697     1.13465e-02     1.14756e-03
  462.500     7.26790e+00        0.00000         8.80967e-02          0.97729       536.192     99.2894     0.723209     1.20721e-02     1.24825e-03
  465.000     7.75123e+00        0.00000         9.35902e-02          0.97621       533.261     99.2894     0.719616     1.28455e-02     1.35870e-03
  467.500     8.26742e+00        0.00000         9.94228e-02          0.97509       530.178     99.2894     0.715910     1.36704e-02     1.48006e-03
  470.000     8.81925e+00        0.00000         1.05620e-01          0.97392       526.933     99.2894     0.712084     1.45512e-02     1.61367e-03
  472.500     9.40982e+00        0.00000         1.12209e-01          0.97270       523.513     99.2894     0.708129     1.54930e-02     1.76110e-03
  475.000     1.00427e+01        0.00000         1.19222e-01          0.97143       519.904     99.2894     0.704034     1.65013e-02     1.92417e-03
  477.500     1.07218e+01        0.00000         1.26693e-01          0.97009       516.089     99.2894     0.699789     1.75827e-02     2.10503e-03
  480.000     1.14518e+01        0.00000         1.34664e-01          0.96870       512.050     99.2894     0.695379     1.87445e-02     2.30623e-03
  482.500     1.22381e+01        0.00000         1.43178e-01          0.96723       507.767     99.2894     0.690790     1.99954e-02     2.53085e-03
  485.000     1.30869e+01        0.00000         1.52290e-01          0.96570       503.213     99.2894     0.686004     2.13456e-02     2.78259e-03
  487.500     1.40055e+01        0.00000         1.62061e-01          0.96408       498.361     99.2894     0.680999     2.28070e-02     3.06598e-03
  490.000     1.50029e+01        0.00000         1.72562e-01          0.96238       493.176     99.2894     0.675751     2.43941e-02     3.38665e-03
  492.500     1.60897e+01        0.00000         1.83881e-01          0.96059       487.617     99.2894     0.670229     2.61244e-02     3.75167e-03
  495.000     1.72791e+01        0.00000         1.96124e-01          0.95869       481.633     99.2894     0.664396     2.80198e-02     4.17012e-03
  497.500     1.85879e+01        0.00000         2.09421e-01          0.95668       475.163     99.2894     0.658204     3.01077e-02     4.65380e-03
  500.000     2.00375e+01        0.00000         2.23939e-01          0.95453       468.125     99.2894     0.651593     3.24235e-02     5.21858e-03
  502.500     2.16563e+01        0.00000         2.39896e-01          0.95222       460.415     99.2894     0.644482     3.50147e-02     5.88631e-03
  505.000     2.34836e+01        0.00000         2.57586e-01          0.94972       451.888     99.2894     0.636761     3.79466e-02     6.68833e-03
  507.500     2.55762e+01        0.00000         2.77431e-01          0.94700       442.340     99.2894     0.628270     4.13141e-02     7.67187e-03
  510.000     2.80218e+01        0.00000         3.00073e-01          0.94398       431.455     99.2894     0.618764     4.52642e-02     8.91304e-03
  512.500     3.09696e+01        0.00000         3.26590e-01          0.94057       418.705     99.2894     0.607825     5.00480e-02     1.05472e-02
  515.000     3.47166e+01        0.00000         3.59094e-01          0.93653       403.047     99.2894     0.594624     5.61661e-02     1.28564e-02
  517.500     4.00641e+01        0.00000         4.03214e-01          0.93132       381.700     99.2894     0.576930     6.49743e-02     1.66416e-02
  519.141     4.62218e+01        0.00000         4.50829e-01          0.92601       358.481     99.2894     0.557933     7.52337e-02     2.17977e-02
  519.740     5.33259e+01        0.00000         5.01710e-01          0.92072       333.393     99.2894     0.537521     8.72297e-02     2.89648e-02
  519.740     5.33776e+01        0.00000         5.02064e-01          0.92069       333.217     99.2894     0.537378     8.73176e-02     2.90222e-02
  519.211     6.05540e+01        0.00000         5.49264e-01          0.91616       309.624     99.2894     0.518129     9.96133e-02     3.78237e-02
  517.500     6.86952e+01        0.00000         5.98063e-01          0.91191       284.839     99.2894     0.497692     1.13778e-01     5.00577e-02
  515.000     7.63247e+01        0.00000         6.39544e-01          0.90873       263.404     99.2894     0.479704     1.27259e-01     6.41291e-02
  512.500     8.23410e+01        0.00000         6.69563e-01          0.90674       247.647     99.2894     0.466223     1.38030e-01     7.73470e-02
  510.000     8.75453e+01        0.00000         6.93743e-01          0.90536       234.786     99.2894     0.455017     1.47447e-01     9.05452e-02
  507.500     9.22344e+01        0.00000         7.14191e-01          0.90439       223.781     99.2894     0.445257     1.56010e-01     1.04040e-01
  505.000     9.65574e+01        0.00000         7.31980e-01          0.90371       214.102     99.2894     0.436526     1.63969e-01     1.18002e-01
  502.500     1.00602e+02        0.00000         7.47745e-01          0.90326       205.436     99.2894     0.428577     1.71473e-01     1.32545e-01
  500.000     1.04425e+02        0.00000         7.61902e-01          0.90300       197.576     99.2894     0.421250     1.78615e-01     1.47758e-01
  497.500     1.08064e+02        0.00000         7.74743e-01          0.90291       190.381     99.2894     0.414435     1.85461e-01     1.63712e-01
  495.000     1.11550e+02        0.00000         7.86480e-01          0.90294       183.744     99.2894     0.408052     1.92058e-01     1.80476e-01
  492.500     1.14903e+02        0.00000         7.97274e-01          0.90310       177.586     99.2894     0.402039     1.98442e-01     1.98110e-01
  490.000     1.18139e+02        0.00000         8.07252e-01          0.90336       171.846     99.2894     0.396349     2.04639e-01     2.16677e-01
  487.500     1.21272e+02        0.00000         8.16516e-01          0.90373       166.471     99.2894     0.390945     2.10672e-01     2.36238e-01
  485.000     1.24312e+02        0.00000         8.25148e-01          0.90417       161.423     99.2894     0.385795     2.16558e-01     2.56855e-01
  482.500     1.27268e+02        0.00000         8.33216e-01          0.90470       156.666     99.2894     0.380874     2.22312e-01     2.78591e-01
  480.000     1.30148e+02        0.00000         8.40777e-01          0.90530       152.172     99.2894     0.376162     2.27944e-01     3.01514e-01
  477.500     1.32956e+02        0.00000         8.47882e-01          0.90597       147.918     99.2894     0.371640     2.33466e-01     3.25690e-01
  475.000     1.35700e+02        0.00000         8.54570e-01          0.90671       143.881     99.2894     0.367292     2.38887e-01     3.51192e-01
  472.500     1.38383e+02        0.00000         8.60880e-01          0.90750       140.044     99.2894     0.363106     2.44212e-01     3.78094e-01
  470.000     1.41008e+02        0.00000         8.66843e-01          0.90835       136.391     99.2894     0.359069     2.49449e-01     4.06476e-01
  467.500     1.43580e+02        0.00000         8.72486e-01          0.90926       132.907     99.2894     0.355171     2.54603e-01     4.36419e-01
  465.000     1.46102e+02        0.00000         8.77835e-01          0.91021       129.581     99.2894     0.351404     2.59680e-01     4.68012e-01
  462.500     1.48576e+02        0.00000         8.82911e-01          0.91121       126.401     99.2894     0.347758     2.64683e-01     5.01345e-01
  460.000     1.51004e+02        0.00000         8.87734e-01          0.91226       123.358     99.2894     0.344228     2.69617e-01     5.36515e-01
  457.500     1.53389e+02        0.00000         8.92321e-01          0.91335       120.441     99.2894     0.340805     2.74484e-01     5.73625e-01
  455.000     1.55733e+02        0.00000         8.96689e-01          0.91448       117.644     99.2894     0.337485     2.79288e-01     6.12783e-01
  452.500     1.58036e+02        0.00000         9.00851e-01          0.91565       114.959     99.2894     0.334261     2.84033e-01     6.54102e-01
  450.000     1.60302e+02        0.00000         9.04822e-01          0.91686       112.379     99.2894     0.331130     2.88719e-01     6.97705e-01
  447.500     1.62531e+02        0.00000         9.08612e-01          0.91811       109.898     99.2894     0.328085     2.93351e-01     7.43717e-01
  445.000     1.64724e+02        0.00000         9.12232e-01          0.91938       107.510     99.2894     0.325125     2.97929e-01     7.92276e-01
  442.500     1.66882e+02        0.00000         9.15693e-01          0.92070       105.210     99.2894     0.322243     3.02455e-01     8.43523e-01
  440.000     1.69008e+02        0.00000         9.19004e-01          0.92204       102.994     99.2894     0.319438     3.06933e-01     8.97611e-01
  437.500     1.71101e+02        0.00000         9.22172e-01          0.92342       100.857     99.2894     0.316705     3.11362e-01     9.54702e-01
  436.016     1.72328e+02        0.00000         9.23988e-01          0.92425        99.625     99.2894     0.315119     3.13969e-01     9.90048e-01
  435.608     1.72664e+02        0.50000         9.24480e-01          0.92448        99.289     99.2894     0.314684     3.14684e-01     1.00000e+00
      NaN             NaN            NaN                 NaN              NaN           NaN         NaN          NaN             NaN             NaN
   12.920     1.70278e+02        0.00000         1.33849e+00          0.96366       151.557     99.2894     0.810617     7.37617e-01     2.39730e-01
   13.532     2.53637e+02        0.00000         1.96443e+00          1.41706       150.497     99.2894     0.815208     7.45575e-01     2.38526e-01
   14.897     3.77802e+02        0.00000         2.86538e+00          2.07439       149.082     99.2894     0.820750     7.55060e-01     2.39598e-01
   17.234     5.62752e+02        0.00000         4.15356e+00          3.02147       147.434     99.2894     0.827345     7.65941e-01     2.43230e-01
   20.674     8.38243e+02        0.00000         5.98845e+00          4.37948       145.724     99.2894     0.834960     7.77909e-01     2.49191e-01
   25.194     1.24860e+03        0.00000         8.60106e+00          6.32251       144.106     99.2894     0.843336     7.90467e-01     2.56728e-01
   30.588     1.85984e+03        0.00000         1.23318e+01          9.10631       142.665     99.2894     0.851989     8.02976e-01     2.65090e-01
   36.482     2.77030e+03        0.00000         1.76884e+01         13.11348       141.419     99.2894     0.860331     8.14765e-01     2.73630e-01
   42.413     4.12648e+03        0.00000         2.54354e+01         18.92208       140.352     99.2894     0.867836     8.25264e-01     2.81826e-01
   47.936     6.14656e+03        0.00000         3.67263e+01         27.40641       139.443     99.2894     0.874170     8.34118e-01     2.89337e-01
   52.727     9.15556e+03        0.00000         5.32992e+01         39.88329       138.684     99.2894     0.879228     8.41218e-01     2.95853e-01
   56.636     1.36376e+04        0.00000         7.77612e+01         58.32575       138.069     99.2894     0.883089     8.46670e-01     3.01240e-01
   59.665     2.03137e+04        0.00000         1.14009e+02         85.67893       137.589     99.2894     0.885932     8.50710e-01     3.05485e-01
   61.921     3.02582e+04        0.00000         1.67849e+02        126.33072       137.229     99.2894     0.887970     8.53621e-01     3.08715e-01
   63.551     4.50708e+04        0.00000         2.47930e+02        186.81448       136.966     99.2894     0.889403     8.55676e-01     3.11099e-01
   64.702     6.71348e+04        0.00000         3.67131e+02        276.85770       136.778     99.2894     0.890395     8.57104e-01     3.12770e-01
   65.502     1.00000e+05        0.00000         5.44625e+02        410.94554       136.647     99.2894     0.891076     8.58085e-01     3.13946e-01
END

$Env_BP << END
#   Temp       Sat Pres                                                                                    Liq Den      Gas Den           
#   (C)         (bar)        Liq Mole Frac      Liq Z-Factor     Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------   -----------   ----------------   ---------------   --------------   ---------   ---------   ----------   ----------   -------------
  435.608      172.664          0.5000            0.92448          0.924480       99.2894     99.2894     0.314684     0.314684     1.00000e+00
  435.199      172.999          1.0000            0.92471          0.924970       99.2894     98.9556     0.315398     0.314250     9.90046e-01
  435.000      173.162          1.0000            0.92482          0.925206       99.2894     98.7943     0.315746     0.314041     9.85256e-01
  432.500      175.193          1.0000            0.92626          0.928113       99.2894     96.8030     0.320084     0.311445     9.27144e-01
  430.000      177.194          1.0000            0.92772          0.930899       99.2894     94.8792     0.324379     0.308913     8.72796e-01
  427.500      179.166          1.0000            0.92921          0.933571       99.2894     93.0198     0.328631     0.306442     8.21925e-01
  425.000      181.109          1.0000            0.93073          0.936134       99.2894     91.2216     0.332842     0.304031     7.74273e-01
  422.500      183.025          1.0000            0.93227          0.938594       99.2894     89.4817     0.337013     0.301677     7.29602e-01
  420.000      184.913          1.0000            0.93383          0.940955       99.2894     87.7975     0.341145     0.299377     6.87699e-01
  417.500      186.774          1.0000            0.93542          0.943222       99.2894     86.1665     0.345239     0.297132     6.48365e-01
  415.000      188.609          1.0000            0.93703          0.945399       99.2894     84.5863     0.349296     0.294937     6.11421e-01
  412.500      190.418          1.0000            0.93866          0.947491       99.2894     83.0546     0.353316     0.292792     5.76702e-01
  410.000      192.201          1.0000            0.94032          0.949501       99.2894     81.5695     0.357300     0.290695     5.44056e-01
  407.500      193.959          1.0000            0.94199          0.951432       99.2894     80.1289     0.361250     0.288645     5.13345e-01
  405.000      195.693          1.0000            0.94369          0.953288       99.2894     78.7309     0.365165     0.286640     4.84440e-01
  402.500      197.402          1.0000            0.94540          0.955072       99.2894     77.3738     0.369047     0.284678     4.57223e-01
  400.000      199.087          1.0000            0.94714          0.956786       99.2894     76.0560     0.372896     0.282758     4.31584e-01
  397.500      200.748          1.0000            0.94889          0.958434       99.2894     74.7759     0.376712     0.280880     4.07423e-01
  395.000      202.386          1.0000            0.95065          0.960018       99.2894     73.5319     0.380497     0.279041     3.84646e-01
  392.500      204.000          1.0000            0.95244          0.961541       99.2894     72.3228     0.384251     0.277241     3.63168e-01
  390.000      205.591          1.0000            0.95424          0.963004       99.2894     71.1470     0.387974     0.275478     3.42906e-01
  387.500      207.160          1.0000            0.95606          0.964410       99.2894     70.0035     0.391668     0.273752     3.23788e-01
  385.000      208.705          1.0000            0.95789          0.965761       99.2894     68.8909     0.395331     0.272062     3.05743e-01
  382.500      210.229          1.0000            0.95974          0.967058       99.2894     67.8082     0.398966     0.270406     2.88706e-01
  380.000      211.730          1.0000            0.96160          0.968304       99.2894     66.7541     0.402572     0.268783     2.72619e-01
  377.500      213.209          1.0000            0.96348          0.969500       99.2894     65.7278     0.406149     0.267193     2.57424e-01
  375.000      214.666          1.0000            0.96537          0.970648       99.2894     64.7282     0.409699     0.265635     2.43070e-01
  372.500      216.102          1.0000            0.96727          0.971749       99.2894     63.7543     0.413221     0.264108     2.29507e-01
  370.000      217.515          1.0000            0.96918          0.972804       99.2894     62.8053     0.416717     0.262612     2.16690e-01
  367.500      218.907          1.0000            0.97111          0.973815       99.2894     61.8802     0.420186     0.261144     2.04576e-01
  365.000      220.278          1.0000            0.97304          0.974784       99.2894     60.9783     0.423628     0.259706     1.93125e-01
  362.500      221.628          1.0000            0.97499          0.975711       99.2894     60.0988     0.427045     0.258295     1.82299e-01
  360.000      222.956          1.0000            0.97695          0.976597       99.2894     59.2410     0.430436     0.256912     1.72064e-01
  357.500      224.263          1.0000            0.97892          0.977444       99.2894     58.4040     0.433802     0.255556     1.62386e-01
  355.000      225.549          1.0000            0.98090          0.978252       99.2894     57.5873     0.437142     0.254225     1.53235e-01
  352.500      226.814          1.0000            0.98288          0.979023       99.2894     56.7901     0.440459     0.252920     1.44581e-01
  350.000      228.058          1.0000            0.98488          0.979757       99.2894     56.0118     0.443751     0.251640     1.36396e-01
  347.500      229.281          1.0000            0.98688          0.980455       99.2894     55.2519     0.447019     0.250384     1.28657e-01
  345.000      230.484          1.0000            0.98889          0.981118       99.2894     54.5097     0.450263     0.249152     1.21337e-01
  342.500      231.665          1.0000            0.99091          0.981747       99.2894     53.7847     0.453484     0.247943     1.14414e-01
  340.000      232.826          1.0000            0.99294          0.982342       99.2894     53.0763     0.456681     0.246757     1.07867e-01
  337.500      233.967          1.0000            0.99497          0.982904       99.2894     52.3840     0.459856     0.245593     1.01676e-01
  335.000      235.086          1.0000            0.99700          0.983433       99.2894     51.7074     0.463008     0.244450     9.58211e-02
  332.500      236.185          1.0000            0.99905          0.983931       99.2894     51.0460     0.466138     0.243329     9.02847e-02
  330.000      237.264          1.0000            1.00109          0.984397       99.2894     50.3992     0.469246     0.242229     8.50497e-02
  327.500      238.322          1.0000            1.00314          0.984832       99.2894     49.7667     0.472331     0.241149     8.01001e-02
  325.000      239.359          1.0000            1.00520          0.985237       99.2894     49.1481     0.475396     0.240088     7.54208e-02
  322.500      240.375          1.0000            1.00726          0.985612       99.2894     48.5429     0.478438     0.239048     7.09975e-02
  320.000      241.371          1.0000            1.00932          0.985958       99.2894     47.9507     0.481460     0.238026     6.68165e-02
  317.500      242.347          1.0000            1.01139          0.986274       99.2894     47.3712     0.484460     0.237023     6.28651e-02
  315.000      243.301          1.0000            1.01345          0.986561       99.2894     46.8040     0.487440     0.236038     5.91312e-02
  312.500      244.236          1.0000            1.01552          0.986820       99.2894     46.2488     0.490399     0.235071     5.56033e-02
  310.000      245.149          1.0000            1.01759          0.987051       99.2894     45.7052     0.493338     0.234122     5.22706e-02
  307.500      246.042          1.0000            1.01966          0.987253       99.2894     45.1728     0.496256     0.233190     4.91228e-02
  305.000      246.914          1.0000            1.02174          0.987428       99.2894     44.6515     0.499155     0.232274     4.61501e-02
  302.500      247.765          1.0000            1.02381          0.987576       99.2894     44.1408     0.502034     0.231376     4.33434e-02
  300.000      248.596          1.0000            1.02588          0.987696       99.2894     43.6404     0.504893     0.230493     4.06940e-02
  297.500      249.406          1.0000            1.02794          0.987788       99.2894     43.1502     0.507733     0.229626     3.81934e-02
  295.000      250.195          1.0000            1.03001          0.987854       99.2894     42.6698     0.510554     0.228775     3.58340e-02
  292.500      250.963          1.0000            1.03208          0.987893       99.2894     42.1990     0.513356     0.227940     3.36082e-02
  290.000      251.710          1.0000            1.03414          0.987905       99.2894     41.7375     0.516139     0.227119     3.15090e-02
  287.500      252.436          1.0000            1.03620          0.987890       99.2894     41.2850     0.518904     0.226313     2.95298e-02
  285.000      253.141          1.0000            1.03825          0.987849       99.2894     40.8414     0.521650     0.225521     2.76640e-02
  282.500      253.825          1.0000            1.04030          0.987780       99.2894     40.4063     0.524377     0.224744     2.59059e-02
  280.000      254.488          1.0000            1.04234          0.987686       99.2894     39.9797     0.527087     0.223981     2.42495e-02
  277.500      255.130          1.0000            1.04438          0.987564       99.2894     39.5612     0.529779     0.223231     2.26895e-02
  275.000      255.750          1.0000            1.04641          0.987416       99.2894     39.1506     0.532452     0.222495     2.12208e-02
  272.500      256.349          1.0000            1.04844          0.987242       99.2894     38.7478     0.535109     0.221772     1.98384e-02
  270.000      256.926          1.0000            1.05046          0.987040       99.2894     38.3526     0.537747     0.221062     1.85377e-02
  267.500      257.482          1.0000            1.05247          0.986812       99.2894     37.9647     0.540369     0.220365     1.73143e-02
  265.000      258.016          1.0000            1.05447          0.986557       99.2894     37.5840     0.542973     0.219680     1.61640e-02
  262.500      258.529          1.0000            1.05646          0.986276       99.2894     37.2103     0.545560     0.219008     1.50829e-02
  260.000      259.020          1.0000            1.05844          0.985967       99.2894     36.8435     0.548131     0.218347     1.40672e-02
  257.500      259.489          1.0000            1.06042          0.985630       99.2894     36.4833     0.550684     0.217699     1.31132e-02
  255.000      259.936          1.0000            1.06238          0.985267       99.2894     36.1297     0.553221     0.217062     1.22177e-02
  252.500      260.360          1.0000            1.06432          0.984876       99.2894     35.7824     0.555742     0.216437     1.13774e-02
  250.000      260.763          1.0000            1.06626          0.984457       99.2894     35.4413     0.558246     0.215824     1.05892e-02
  247.500      261.144          1.0000            1.06818          0.984011       99.2894     35.1063     0.560734     0.215221     9.85014e-03
  245.000      261.502          1.0000            1.07009          0.983536       99.2894     34.7773     0.563207     0.214630     9.15757e-03
  242.500      261.837          1.0000            1.07198          0.983033       99.2894     34.4540     0.565663     0.214049     8.50885e-03
  240.000      262.150          1.0000            1.07386          0.982501       99.2894     34.1363     0.568103     0.213479     7.90147e-03
  237.500      262.440          1.0000            1.07572          0.981941       99.2894     33.8242     0.570528     0.212920     7.33309e-03
  235.000      262.708          1.0000            1.07756          0.981351       99.2894     33.5175     0.572938     0.212370     6.80146e-03
  232.500      262.952          1.0000            1.07939          0.980732       99.2894     33.2161     0.575332     0.211832     6.30447e-03
  230.000      263.173          1.0000            1.08119          0.980083       99.2894     32.9199     0.577711     0.211303     5.84011e-03
  227.500      263.371          1.0000            1.08298          0.979405       99.2894     32.6286     0.580075     0.210784     5.40647e-03
  225.000      263.546          1.0000            1.08474          0.978695       99.2894     32.3424     0.582423     0.210275     5.00175e-03
  222.500      263.697          1.0000            1.08648          0.977956       99.2894     32.0609     0.584757     0.209775     4.62422e-03
  220.000      263.825          1.0000            1.08820          0.977184       99.2894     31.7842     0.587077     0.209285     4.27227e-03
  217.500      263.929          1.0000            1.08990          0.976382       99.2894     31.5122     0.589381     0.208804     3.94435e-03
  215.000      264.009          1.0000            1.09157          0.975547       99.2894     31.2446     0.591671     0.208333     3.63902e-03
  212.500      264.064          1.0000            1.09322          0.974680       99.2894     30.9815     0.593947     0.207870     3.35490e-03
  210.000      264.096          1.0000            1.09484          0.973781       99.2894     30.7227     0.596209     0.207417     3.09068e-03
  207.500      264.103          1.0000            1.09643          0.972848       99.2894     30.4682     0.598456     0.206973     2.84512e-03
  205.000      264.086          1.0000            1.09799          0.971881       99.2894     30.2179     0.600689     0.206537     2.61707e-03
  202.500      264.044          1.0000            1.09953          0.970880       99.2894     29.9716     0.602908     0.206110     2.40541e-03
  200.000      263.977          1.0000            1.10103          0.969844       99.2894     29.7293     0.605114     0.205692     2.20911e-03
  197.500      263.886          1.0000            1.10250          0.968773       99.2894     29.4910     0.607306     0.205282     2.02718e-03
  195.000      263.768          1.0000            1.10394          0.967666       99.2894     29.2564     0.609484     0.204880     1.85870e-03
  192.500      263.626          1.0000            1.10534          0.966522       99.2894     29.0257     0.611649     0.204487     1.70278e-03
  190.000      263.458          1.0000            1.10670          0.965342       99.2894     28.7986     0.613800     0.204102     1.55859e-03
  187.500      263.264          1.0000            1.10803          0.964123       99.2894     28.5752     0.615938     0.203724     1.42537e-03
  185.000      263.045          1.0000            1.10932          0.962867       99.2894     28.3553     0.618063     0.203355     1.30236e-03
  182.500      262.799          1.0000            1.11057          0.961571       99.2894     28.1388     0.620175     0.202994     1.18889e-03
  180.000      262.527          1.0000            1.11178          0.960236       99.2894     27.9258     0.622274     0.202640     1.08429e-03
  177.500      262.228          1.0000            1.11295          0.958861       99.2894     27.7162     0.624360     0.202294     9.87964e-04
  175.000      261.903          1.0000            1.11407          0.957444       99.2894     27.5098     0.626433     0.201956     8.99321e-04
  172.500      261.551          1.0000            1.11514          0.955986       99.2894     27.3066     0.628493     0.201625     8.17825e-04
  170.000      261.172          1.0000            1.11617          0.954485       99.2894     27.1066     0.630541     0.201302     7.42967e-04
  167.500      260.765          1.0000            1.11715          0.952940       99.2894     26.9097     0.632577     0.200986     6.74270e-04
  165.000      260.331          1.0000            1.11808          0.951351       99.2894     26.7159     0.634600     0.200677     6.11284e-04
  162.500      259.869          1.0000            1.11895          0.949718       99.2894     26.5250     0.636610     0.200375     5.53592e-04
  160.000      259.379          1.0000            1.11977          0.948038       99.2894     26.3371     0.638609     0.200080     5.00799e-04
  157.500      258.860          1.0000            1.12054          0.946311       99.2894     26.1521     0.640595     0.199793     4.52538e-04
  155.000      258.313          1.0000            1.12124          0.944537       99.2894     25.9699     0.642570     0.199512     4.08465e-04
  152.500      257.738          1.0000            1.12189          0.942714       99.2894     25.7905     0.644532     0.199238     3.68258e-04
  150.000      257.133          1.0000            1.12247          0.940841       99.2894     25.6138     0.646483     0.198970     3.31617e-04
  147.500      256.500          1.0000            1.12299          0.938917       99.2894     25.4399     0.648422     0.198710     2.98263e-04
  145.000      255.837          1.0000            1.12345          0.936942       99.2894     25.2685     0.650349     0.198456     2.67933e-04
  142.500      255.144          1.0000            1.12383          0.934914       99.2894     25.0998     0.652265     0.198208     2.40386e-04
  140.000      254.421          1.0000            1.12415          0.932831       99.2894     24.9336     0.654169     0.197967     2.15394e-04
  137.500      253.668          1.0000            1.12439          0.930694       99.2894     24.7699     0.656061     0.197732     1.92748e-04
  135.000      252.884          1.0000            1.12456          0.928500       99.2894     24.6087     0.657943     0.197503     1.72253e-04
  132.500      252.070          1.0000            1.12465          0.926249       99.2894     24.4499     0.659813     0.197280     1.53726e-04
  130.000      251.224          1.0000            1.12466          0.923939       99.2894     24.2934     0.661672     0.197063     1.37000e-04
  127.500      250.347          1.0000            1.12458          0.921569       99.2894     24.1394     0.663520     0.196853     1.21920e-04
  125.000      249.438          1.0000            1.12443          0.919138       99.2894     23.9876     0.665357     0.196647     1.08342e-04
  122.500      248.498          1.0000            1.12418          0.916644       99.2894     23.8381     0.667183     0.196448     9.61320e-05
  120.000      247.525          1.0000            1.12384          0.914085       99.2894     23.6908     0.668998     0.196254     8.51679e-05
  117.500      246.519          1.0000            1.12341          0.911462       99.2894     23.5457     0.670803     0.196066     7.53365e-05
  115.000      245.481          1.0000            1.12288          0.908771       99.2894     23.4027     0.672597     0.195883     6.65335e-05
  112.500      244.409          1.0000            1.12225          0.906011       99.2894     23.2619     0.674380     0.195705     5.86630e-05
  110.000      243.304          1.0000            1.12151          0.903182       99.2894     23.1231     0.676152     0.195532     5.16369e-05
  107.500      242.165          1.0000            1.12067          0.900280       99.2894     22.9864     0.677915     0.195364     4.53744e-05
  105.000      240.992          1.0000            1.11972          0.897305       99.2894     22.8517     0.679667     0.195201     3.98014e-05
  102.500      239.784          1.0000            1.11866          0.894255       99.2894     22.7190     0.681408     0.195043     3.48500e-05
  100.000      238.541          1.0000            1.11748          0.891128       99.2894     22.5883     0.683140     0.194889     3.04583e-05
   97.500      237.263          1.0000            1.11618          0.887923       99.2894     22.4594     0.684861     0.194740     2.65696e-05
   95.000      235.949          1.0000            1.11475          0.884636       99.2894     22.3325     0.686572     0.194595     2.31324e-05
   92.500      234.600          1.0000            1.11319          0.881267       99.2894     22.2074     0.688273     0.194454     2.00998e-05
   90.000      233.213          1.0000            1.11150          0.877814       99.2894     22.0841     0.689965     0.194317     1.74291e-05
   87.500      231.791          1.0000            1.10967          0.874274       99.2894     21.9626     0.691646     0.194183     1.50815e-05
   85.000      230.330          1.0000            1.10770          0.870645       99.2894     21.8429     0.693318     0.194053     1.30220e-05
   82.500      228.833          1.0000            1.10559          0.866926       99.2894     21.7249     0.694980     0.193926     1.12188e-05
   80.000      227.297          1.0000            1.10332          0.863113       99.2894     21.6086     0.696632     0.193802     9.64330e-06
   77.500      225.723          1.0000            1.10089          0.859206       99.2894     21.4940     0.698275     0.193682     8.26965e-06
   75.000      224.111          1.0000            1.09831          0.855200       99.2894     21.3810     0.699908     0.193563     7.07458e-06
   72.500      222.459          1.0000            1.09555          0.851094       99.2894     21.2697     0.701532     0.193447     6.03721e-06
   70.000      220.767          1.0000            1.09263          0.846886       99.2894     21.1600     0.703147     0.193333     5.13878e-06
   67.500      219.035          1.0000            1.08953          0.842573       99.2894     21.0518     0.704752     0.193221     4.36254e-06
   65.000      217.263          1.0000            1.08624          0.838152       99.2894     20.9452     0.706348     0.193110     3.69350e-06
   62.500      215.450          1.0000            1.08277          0.833620       99.2894     20.8401     0.707935     0.193000     3.11831e-06
   60.000      213.595          1.0000            1.07910          0.828976       99.2894     20.7364     0.709513     0.192890     2.62509e-06
   57.500      211.699          1.0000            1.07523          0.824215       99.2894     20.6343     0.711081     0.192781     2.20328e-06
   55.000      209.760          1.0000            1.07114          0.819335       99.2894     20.5336     0.712641     0.192672     1.84354e-06
   52.500      207.778          1.0000            1.06685          0.814333       99.2894     20.4343     0.714192     0.192563     1.53761e-06
   50.000      205.753          1.0000            1.06233          0.809207       99.2894     20.3364     0.715735     0.192452     1.27822e-06
   47.500      203.684          1.0000            1.05758          0.803952       99.2894     20.2398     0.717268     0.192340     1.05895e-06
   45.000      201.571          1.0000            1.05259          0.798565       99.2894     20.1446     0.718793     0.192225     8.74179e-07
   42.500      199.412          1.0000            1.04736          0.793044       99.2894     20.0507     0.720309     0.192108     7.18993e-07
   40.000      197.209          1.0000            1.04187          0.787385       99.2894     19.9581     0.721816     0.191987     5.89095e-07
   37.500      194.959          1.0000            1.03613          0.781584       99.2894     19.8668     0.723316     0.191862     4.80747e-07
   35.000      192.663          1.0000            1.03011          0.775638       99.2894     19.7767     0.724806     0.191733     3.90704e-07
   32.500      190.320          1.0000            1.02381          0.769544       99.2894     19.6878     0.726289     0.191597     3.16158e-07
   30.000      187.929          1.0000            1.01722          0.763297       99.2894     19.6001     0.727763     0.191455     2.54685e-07
   27.500      185.490          1.0000            1.01033          0.756894       99.2894     19.5135     0.729228     0.191305     2.04202e-07
   25.000      183.003          1.0000            1.00314          0.750332       99.2894     19.4281     0.730686     0.191146     1.62922e-07
   22.500      180.466          1.0000            0.99562          0.743607       99.2894     19.3438     0.732136     0.190978     1.29319e-07
   20.000      177.879          1.0000            0.98778          0.736714       99.2894     19.2606     0.733577     0.190798     1.02093e-07
   17.500      175.242          1.0000            0.97959          0.729650       99.2894     19.1785     0.735011     0.190605     8.01424e-08
   15.000      172.554          1.0000            0.97105          0.722412       99.2894     19.0973     0.736436     0.190397     6.25363e-08
   12.920      170.278          1.0000            0.96366          0.716254       99.2894     19.0306     0.737617     0.190212     5.06309e-08
END

set output "Figures/Env_007_P_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:4.5e+02] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"

set output "Figures/Env_007_LogP_vs_T_1.pdf"
set xlabel "Temperature (C)"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:2 with lines title "Dew Points", \
     $Env_BP using 1:2 with lines title "Bubble Points"
unset logscale y

set title "P-X Diagram for Predicted_3350_m_Oil\n with Lab3_Swelling_Gas at 93.4 C "
show title

$Env_DP << END
#                                                                               Sat Pres                                                                                     Liq Den       Gas Den             
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed        (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)       (g/cm3)        Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -------------   ---------------   ---------------   ---------------   ---------   ---------   ----------   -------------   -------------
   0.00000e+00        1.00000e+00        0.00000e+00        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-12        1.00000e+00        2.31342e-13        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-12        1.00000e+00        4.62684e-13        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-12        1.00000e+00        1.15671e-12        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-11        1.00000e+00        2.31342e-12        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-11        1.00000e+00        4.62684e-12        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-11        1.00000e+00        1.15671e-11        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-10        1.00000e+00        2.31342e-11        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-10        1.00000e+00        4.62684e-11        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-10        1.00000e+00        1.15671e-10        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-09        1.00000e+00        2.31342e-10        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-09        1.00000e+00        4.62684e-10        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-09        1.00000e+00        1.15671e-09        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-08        1.00000e+00        2.31342e-09        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-08        1.00000e+00        4.62684e-09        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-08        1.00000e+00        1.15671e-08        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   1.00000e-07        1.00000e+00        2.31342e-08        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   2.00000e-07        1.00000e+00        4.62684e-08        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2894     0.919964     1.02949e-11     2.04230e-13
   5.00000e-07        1.00000e+00        1.15671e-07        1.00000e+00       3.16001e-09        0.00000         6.79488e-11         1.00000        602.882     99.2893     0.919964     1.02949e-11     2.04230e-13
   1.00000e-06        9.99999e-01        2.31342e-07        1.00000e+00       3.16001e-09        0.00000         6.79489e-11         1.00000        602.882     99.2893     0.919964     1.02949e-11     2.04230e-13
   2.00000e-06        9.99998e-01        4.62684e-07        1.00000e+00       3.16001e-09        0.00000         6.79490e-11         1.00000        602.882     99.2892     0.919964     1.02949e-11     2.04230e-13
   5.00000e-06        9.99995e-01        1.15671e-06        9.99999e-01       3.16002e-09        0.00000         6.79492e-11         1.00000        602.882     99.2890     0.919964     1.02949e-11     2.04230e-13
   1.00000e-05        9.99990e-01        2.31344e-06        9.99998e-01       3.16004e-09        0.00000         6.79495e-11         1.00000        602.882     99.2886     0.919964     1.02950e-11     2.04230e-13
   2.00000e-05        9.99980e-01        4.62691e-06        9.99995e-01       3.16007e-09        0.00000         6.79502e-11         1.00000        602.882     99.2879     0.919964     1.02950e-11     2.04230e-13
   5.00000e-05        9.99950e-01        1.15675e-05        9.99988e-01       3.16017e-09        0.00000         6.79522e-11         1.00000        602.882     99.2856     0.919964     1.02951e-11     2.04230e-13
   1.00000e-04        9.99900e-01        2.31360e-05        9.99977e-01       3.16032e-09        0.00000         6.79556e-11         1.00000        602.882     99.2818     0.919964     1.02952e-11     2.04230e-13
   2.00000e-04        9.99800e-01        4.62755e-05        9.99954e-01       3.16064e-09        0.00000         6.79624e-11         1.00000        602.882     99.2741     0.919964     1.02954e-11     2.04230e-13
   5.00000e-04        9.99500e-01        1.15715e-04        9.99884e-01       3.16159e-09        0.00000         6.79828e-11         1.00000        602.882     99.2512     0.919964     1.02961e-11     2.04230e-13
   1.00000e-03        9.99000e-01        2.31520e-04        9.99768e-01       3.16317e-09        0.00000         6.80168e-11         1.00000        602.882     99.2131     0.919964     1.02973e-11     2.04230e-13
   2.00000e-03        9.98000e-01        4.63396e-04        9.99537e-01       3.16634e-09        0.00000         6.80850e-11         1.00000        602.882     99.1367     0.919964     1.02997e-11     2.04230e-13
   5.00000e-03        9.95000e-01        1.16117e-03        9.98839e-01       3.17589e-09        0.00000         6.82903e-11         1.00000        602.882     98.9078     0.919964     1.03069e-11     2.04230e-13
   1.00000e-02        9.90000e-01        2.33134e-03        9.97669e-01       3.19193e-09        0.00000         6.86352e-11         1.00000        602.882     98.5262     0.919964     1.03190e-11     2.04230e-13
   2.00000e-02        9.80000e-01        4.69908e-03        9.95301e-01       3.22450e-09        0.00000         6.93355e-11         1.00000        602.882     97.7630     0.919964     1.03435e-11     2.04230e-13
   3.00000e-02        9.70000e-01        7.10407e-03        9.92896e-01       3.25774e-09        0.00000         7.00503e-11         1.00000        602.882     96.9998     0.919964     1.03686e-11     2.04230e-13
   4.00000e-02        9.60000e-01        9.54721e-03        9.90453e-01       3.29168e-09        0.00000         7.07800e-11         1.00000        602.882     96.2366     0.919964     1.03942e-11     2.04230e-13
   5.00000e-02        9.50000e-01        1.20294e-02        9.87971e-01       3.32632e-09        0.00000         7.15251e-11         1.00000        602.882     95.4734     0.919964     1.04203e-11     2.04230e-13
   6.00000e-02        9.40000e-01        1.45516e-02        9.85448e-01       3.36171e-09        0.00000         7.22860e-11         1.00000        602.882     94.7102     0.919964     1.04470e-11     2.04230e-13
   7.00000e-02        9.30000e-01        1.71148e-02        9.82885e-01       3.39786e-09        0.00000         7.30632e-11         1.00000        602.882     93.9470     0.919964     1.04742e-11     2.04230e-13
   8.00000e-02        9.20000e-01        1.97200e-02        9.80280e-01       3.43479e-09        0.00000         7.38574e-11         1.00000        602.882     93.1838     0.919964     1.05020e-11     2.04230e-13
   9.00000e-02        9.10000e-01        2.23682e-02        9.77632e-01       3.47254e-09        0.00000         7.46690e-11         1.00000        602.882     92.4206     0.919964     1.05305e-11     2.04230e-13
   1.00000e-01        9.00000e-01        2.50605e-02        9.74940e-01       3.51112e-09        0.00000         7.54987e-11         1.00000        602.882     91.6574     0.919964     1.05596e-11     2.04230e-13
   1.10000e-01        8.90000e-01        2.77980e-02        9.72202e-01       3.55057e-09        0.00000         7.63470e-11         1.00000        602.882     90.8942     0.919964     1.05893e-11     2.04230e-13
   1.20000e-01        8.80000e-01        3.05819e-02        9.69418e-01       3.59092e-09        0.00000         7.72146e-11         1.00000        602.882     90.1310     0.919964     1.06197e-11     2.04230e-13
   1.30000e-01        8.70000e-01        3.34133e-02        9.66587e-01       3.63219e-09        0.00000         7.81021e-11         1.00000        602.882     89.3678     0.919964     1.06508e-11     2.04230e-13
   1.40000e-01        8.60000e-01        3.62935e-02        9.63707e-01       3.67443e-09        0.00000         7.90102e-11         1.00000        602.882     88.6046     0.919964     1.06826e-11     2.04230e-13
   1.50000e-01        8.50000e-01        3.92237e-02        9.60776e-01       3.71766e-09        0.00000         7.99398e-11         1.00000        602.882     87.8414     0.919964     1.07152e-11     2.04230e-13
   1.60000e-01        8.40000e-01        4.22053e-02        9.57795e-01       3.76191e-09        0.00000         8.08914e-11         1.00000        602.882     87.0783     0.919964     1.07486e-11     2.04230e-13
   1.70000e-01        8.30000e-01        4.52397e-02        9.54760e-01       3.80724e-09        0.00000         8.18660e-11         1.00000        602.882     86.3151     0.919964     1.07827e-11     2.04230e-13
   1.80000e-01        8.20000e-01        4.83281e-02        9.51672e-01       3.85367e-09        0.00000         8.28644e-11         1.00000        602.882     85.5519     0.919964     1.08177e-11     2.04230e-13
   1.90000e-01        8.10000e-01        5.14722e-02        9.48528e-01       3.90124e-09        0.00000         8.38874e-11         1.00000        602.882     84.7887     0.919964     1.08536e-11     2.04230e-13
   2.00000e-01        8.00000e-01        5.46734e-02        9.45327e-01       3.95001e-09        0.00000         8.49360e-11         1.00000        602.882     84.0255     0.919964     1.08903e-11     2.04230e-13
   2.10000e-01        7.90000e-01        5.79333e-02        9.42067e-01       4.00001e-09        0.00000         8.60112e-11         1.00000        602.882     83.2623     0.919964     1.09280e-11     2.04230e-13
   2.20000e-01        7.80000e-01        6.12534e-02        9.38747e-01       4.05129e-09        0.00000         8.71139e-11         1.00000        602.882     82.4991     0.919964     1.09667e-11     2.04230e-13
   2.30000e-01        7.70000e-01        6.46356e-02        9.35364e-01       4.10391e-09        0.00000         8.82452e-11         1.00000        602.882     81.7359     0.919964     1.10063e-11     2.04230e-13
   2.40000e-01        7.60000e-01        6.80816e-02        9.31918e-01       4.15791e-09        0.00000         8.94063e-11         1.00000        602.882     80.9727     0.919964     1.10470e-11     2.04230e-13
   2.50000e-01        7.50000e-01        7.15931e-02        9.28407e-01       4.21334e-09        0.00000         9.05984e-11         1.00000        602.882     80.2095     0.919964     1.10888e-11     2.04230e-13
   2.60000e-01        7.40000e-01        7.51721e-02        9.24828e-01       4.27028e-09        0.00000         9.18227e-11         1.00000        602.882     79.4463     0.919964     1.11317e-11     2.04230e-13
   2.70000e-01        7.30000e-01        7.88205e-02        9.21179e-01       4.32878e-09        0.00000         9.30806e-11         1.00000        602.882     78.6831     0.919964     1.11758e-11     2.04230e-13
   2.80000e-01        7.20000e-01        8.25404e-02        9.17460e-01       4.38890e-09        0.00000         9.43734e-11         1.00000        602.882     77.9199     0.919964     1.12211e-11     2.04230e-13
   2.90000e-01        7.10000e-01        8.63339e-02        9.13666e-01       4.45072e-09        0.00000         9.57026e-11         1.00000        602.882     77.1567     0.919964     1.12677e-11     2.04230e-13
   3.00000e-01        7.00000e-01        9.02032e-02        9.09797e-01       4.51430e-09        0.00000         9.70697e-11         1.00000        602.882     76.3935     0.919964     1.13156e-11     2.04230e-13
   3.10000e-01        6.90000e-01        9.41505e-02        9.05849e-01       4.57972e-09        0.00000         9.84765e-11         1.00000        602.882     75.6303     0.919964     1.13650e-11     2.04230e-13
   3.20000e-01        6.80000e-01        9.81784e-02        9.01822e-01       4.64707e-09        0.00000         9.99247e-11         1.00000        602.882     74.8671     0.919964     1.14157e-11     2.04230e-13
   3.30000e-01        6.70000e-01        1.02289e-01        8.97711e-01       4.71643e-09        0.00000         1.01416e-10         1.00000        602.882     74.1039     0.919964     1.14680e-11     2.04230e-13
   3.40000e-01        6.60000e-01        1.06486e-01        8.93514e-01       4.78789e-09        0.00000         1.02953e-10         1.00000        602.882     73.3407     0.919964     1.15218e-11     2.04230e-13
   3.50000e-01        6.50000e-01        1.10770e-01        8.89230e-01       4.86155e-09        0.00000         1.04537e-10         1.00000        602.882     72.5775     0.919964     1.15774e-11     2.04230e-13
   3.60000e-01        6.40000e-01        1.15146e-01        8.84854e-01       4.93751e-09        0.00000         1.06170e-10         1.00000        602.882     71.8143     0.919964     1.16346e-11     2.04230e-13
   3.70000e-01        6.30000e-01        1.19616e-01        8.80384e-01       5.01589e-09        0.00000         1.07855e-10         1.00000        602.882     71.0511     0.919964     1.16937e-11     2.04230e-13
   3.80000e-01        6.20000e-01        1.24182e-01        8.75818e-01       5.09679e-09        0.00000         1.09595e-10         1.00000        602.882     70.2879     0.919964     1.17547e-11     2.04230e-13
   3.90000e-01        6.10000e-01        1.28849e-01        8.71151e-01       5.18034e-09        0.00000         1.11391e-10         1.00000        602.882     69.5247     0.919964     1.18176e-11     2.04230e-13
   4.00000e-01        6.00000e-01        1.33620e-01        8.66380e-01       5.26668e-09        0.00000         1.13248e-10         1.00000        602.882     68.7615     0.919964     1.18827e-11     2.04230e-13
   4.10000e-01        5.90000e-01        1.38498e-01        8.61502e-01       5.35595e-09        0.00000         1.15167e-10         1.00000        602.882     67.9984     0.919964     1.19500e-11     2.04230e-13
   4.20000e-01        5.80000e-01        1.43486e-01        8.56514e-01       5.44829e-09        0.00000         1.17153e-10         1.00000        602.882     67.2352     0.919964     1.20196e-11     2.04230e-13
   4.30000e-01        5.70000e-01        1.48589e-01        8.51411e-01       5.54387e-09        0.00000         1.19208e-10         1.00000        602.882     66.4720     0.919964     1.20916e-11     2.04230e-13
   4.40000e-01        5.60000e-01        1.53811e-01        8.46189e-01       5.64287e-09        0.00000         1.21337e-10         1.00000        602.882     65.7088     0.919964     1.21662e-11     2.04230e-13
   4.50000e-01        5.50000e-01        1.59155e-01        8.40845e-01       5.74547e-09        0.00000         1.23543e-10         1.00000        602.882     64.9456     0.919964     1.22436e-11     2.04230e-13
   4.60000e-01        5.40000e-01        1.64626e-01        8.35374e-01       5.85187e-09        0.00000         1.25831e-10         1.00000        602.882     64.1824     0.919964     1.23237e-11     2.04230e-13
   4.70000e-01        5.30000e-01        1.70229e-01        8.29771e-01       5.96228e-09        0.00000         1.28205e-10         1.00000        602.882     63.4192     0.919964     1.24070e-11     2.04230e-13
   4.80000e-01        5.20000e-01        1.75969e-01        8.24031e-01       6.07694e-09        0.00000         1.30671e-10         1.00000        602.882     62.6560     0.919964     1.24934e-11     2.04230e-13
   4.90000e-01        5.10000e-01        1.81850e-01        8.18150e-01       6.19609e-09        0.00000         1.33233e-10         1.00000        602.882     61.8928     0.919964     1.25832e-11     2.04230e-13
   5.00000e-01        5.00000e-01        1.87878e-01        8.12122e-01       6.32002e-09        0.00000         1.35898e-10         1.00000        602.882     61.1296     0.919964     1.26766e-11     2.04230e-13
   5.10000e-01        4.90000e-01        1.94058e-01        8.05942e-01       6.44900e-09        0.00000         1.38671e-10         1.00000        602.882     60.3664     0.919964     1.27738e-11     2.04230e-13
   5.20000e-01        4.80000e-01        2.00397e-01        7.99603e-01       6.58335e-09        0.00000         1.41560e-10         1.00000        602.882     59.6032     0.919964     1.28751e-11     2.04230e-13
   5.30000e-01        4.70000e-01        2.06900e-01        7.93100e-01       6.72342e-09        0.00000         1.44572e-10         1.00000        602.882     58.8400     0.919964     1.29806e-11     2.04230e-13
   5.40000e-01        4.60000e-01        2.13574e-01        7.86426e-01       6.86958e-09        0.00000         1.47715e-10         1.00000        602.882     58.0768     0.919964     1.30908e-11     2.04230e-13
   5.50000e-01        4.50000e-01        2.20426e-01        7.79574e-01       7.02224e-09        0.00000         1.50997e-10         1.00000        602.882     57.3136     0.919964     1.32058e-11     2.04230e-13
   5.60000e-01        4.40000e-01        2.27462e-01        7.72538e-01       7.18184e-09        0.00000         1.54429e-10         1.00000        602.882     56.5504     0.919964     1.33261e-11     2.04230e-13
   5.70000e-01        4.30000e-01        2.34691e-01        7.65309e-01       7.34886e-09        0.00000         1.58020e-10         1.00000        602.882     55.7872     0.919964     1.34520e-11     2.04230e-13
   5.80000e-01        4.20000e-01        2.42121e-01        7.57879e-01       7.52383e-09        0.00000         1.61783e-10         1.00000        602.882     55.0240     0.919964     1.35839e-11     2.04230e-13
   5.90000e-01        4.10000e-01        2.49760e-01        7.50240e-01       7.70734e-09        0.00000         1.65729e-10         1.00000        602.882     54.2608     0.919964     1.37222e-11     2.04230e-13
   6.00000e-01        4.00000e-01        2.57616e-01        7.42384e-01       7.90002e-09        0.00000         1.69872e-10         1.00000        602.882     53.4976     0.919964     1.38674e-11     2.04230e-13
   6.10000e-01        3.90000e-01        2.65701e-01        7.34299e-01       8.10259e-09        0.00000         1.74228e-10         1.00000        602.882     52.7344     0.919964     1.40201e-11     2.04230e-13
   6.20000e-01        3.80000e-01        2.74022e-01        7.25978e-01       8.31581e-09        0.00000         1.78813e-10         1.00000        602.882     51.9712     0.919964     1.41808e-11     2.04230e-13
   6.30000e-01        3.70000e-01        2.82592e-01        7.17408e-01       8.54056e-09        0.00000         1.83645e-10         1.00000        602.882     51.2080     0.919964     1.43502e-11     2.04230e-13
   6.40000e-01        3.60000e-01        2.91421e-01        7.08579e-01       8.77780e-09        0.00000         1.88747e-10         1.00000        602.882     50.4448     0.919964     1.45290e-11     2.04230e-13
   6.50000e-01        3.50000e-01        3.00521e-01        6.99479e-01       9.02860e-09        0.00000         1.94139e-10         1.00000        602.882     49.6816     0.919964     1.47180e-11     2.04230e-13
   6.60000e-01        3.40000e-01        3.09905e-01        6.90095e-01       9.29414e-09        0.00000         1.99849e-10         1.00000        602.882     48.9184     0.919964     1.49181e-11     2.04230e-13
   6.70000e-01        3.30000e-01        3.19586e-01        6.80414e-01       9.57578e-09        0.00000         2.05905e-10         1.00000        602.882     48.1553     0.919964     1.51304e-11     2.04230e-13
   6.80000e-01        3.20000e-01        3.29580e-01        6.70420e-01       9.87503e-09        0.00000         2.12340e-10         1.00000        602.882     47.3921     0.919964     1.53559e-11     2.04230e-13
   6.90000e-01        3.10000e-01        3.39900e-01        6.60100e-01       1.01936e-08        0.00000         2.19190e-10         1.00000        602.882     46.6289     0.919964     1.55960e-11     2.04230e-13
   7.00000e-01        3.00000e-01        3.50564e-01        6.49436e-01       1.05334e-08        0.00000         2.26496e-10         1.00000        602.882     45.8657     0.919964     1.58521e-11     2.04230e-13
   7.10000e-01        2.90000e-01        3.61589e-01        6.38411e-01       1.08966e-08        0.00000         2.34306e-10         1.00000        602.882     45.1025     0.919964     1.61259e-11     2.04230e-13
   7.20000e-01        2.80000e-01        3.72993e-01        6.27007e-01       1.12857e-08        0.00000         2.42674e-10         1.00000        602.882     44.3393     0.919964     1.64192e-11     2.04230e-13
   7.30000e-01        2.70000e-01        3.84797e-01        6.15203e-01       1.17037e-08        0.00000         2.51662e-10         1.00000        602.882     43.5761     0.919964     1.67342e-11     2.04230e-13
   7.40000e-01        2.60000e-01        3.97022e-01        6.02978e-01       1.21539e-08        0.00000         2.61342e-10         1.00000        602.882     42.8129     0.919964     1.70735e-11     2.04230e-13
   7.50000e-01        2.50000e-01        4.09690e-01        5.90310e-01       1.26400e-08        0.00000         2.71795e-10         1.00000        602.882     42.0497     0.919964     1.74399e-11     2.04230e-13
   7.60000e-01        2.40000e-01        4.22827e-01        5.77173e-01       1.31667e-08        0.00000         2.83120e-10         1.00000        602.882     41.2865     0.919964     1.78368e-11     2.04230e-13
   7.70000e-01        2.30000e-01        4.36458e-01        5.63542e-01       1.37392e-08        0.00000         2.95430e-10         1.00000        602.882     40.5233     0.919964     1.82683e-11     2.04230e-13
   7.80000e-01        2.20000e-01        4.50613e-01        5.49387e-01       1.43637e-08        0.00000         3.08858e-10         1.00000        602.882     39.7601     0.919964     1.87390e-11     2.04230e-13
   7.90000e-01        2.10000e-01        4.65322e-01        5.34678e-01       1.50477e-08        0.00000         3.23566e-10         1.00000        602.882     38.9969     0.919964     1.92545e-11     2.04230e-13
   8.00000e-01        2.00000e-01        4.80619e-01        5.19381e-01       1.58000e-08        0.00000         3.39744e-10         1.00000        602.882     38.2337     0.919964     1.98215e-11     2.04230e-13
   8.10000e-01        1.90000e-01        4.96538e-01        5.03462e-01       1.66316e-08        0.00000         3.57625e-10         1.00000        602.882     37.4705     0.919964     2.04483e-11     2.04230e-13
   8.20000e-01        1.80000e-01        5.13119e-01        4.86881e-01       1.75556e-08        0.00000         3.77493e-10         1.00000        602.882     36.7073     0.919964     2.11447e-11     2.04230e-13
   8.30000e-01        1.70000e-01        5.30405e-01        4.69595e-01       1.85883e-08        0.00000         3.99699e-10         1.00000        602.882     35.9441     0.919964     2.19230e-11     2.04230e-13
   8.40000e-01        1.60000e-01        5.48440e-01        4.51560e-01       1.97501e-08        0.00000         4.24680e-10         1.00000        602.882     35.1809     0.919964     2.27986e-11     2.04230e-13
   8.50000e-01        1.50000e-01        5.67275e-01        4.32725e-01       2.10667e-08        0.00000         4.52992e-10         1.00000        602.882     34.4177     0.919964     2.37909e-11     2.04230e-13
   8.60000e-01        1.40000e-01        5.86965e-01        4.13035e-01       2.25715e-08        0.00000         4.85349e-10         1.00000        602.882     33.6545     0.919964     2.49251e-11     2.04230e-13
   8.70000e-01        1.30000e-01        6.07568e-01        3.92432e-01       2.43078e-08        0.00000         5.22683e-10         1.00000        602.882     32.8913     0.919964     2.62337e-11     2.04230e-13
   8.80000e-01        1.20000e-01        6.29150e-01        3.70850e-01       2.63334e-08        0.00000         5.66240e-10         1.00000        602.882     32.1281     0.919964     2.77604e-11     2.04230e-13
   8.90000e-01        1.10000e-01        6.51782e-01        3.48218e-01       2.87273e-08        0.00000         6.17716e-10         1.00000        602.882     31.3649     0.919964     2.95646e-11     2.04230e-13
   9.00000e-01        1.00000e-01        6.75543e-01        3.24457e-01       3.16001e-08        0.00000         6.79488e-10         1.00000        602.882     30.6017     0.919964     3.17298e-11     2.04230e-13
   9.10000e-01        9.00000e-02        7.00520e-01        2.99480e-01       3.51112e-08        0.00000         7.54987e-10         1.00000        602.882     29.8385     0.919964     3.43761e-11     2.04230e-13
   9.20000e-01        8.00000e-02        7.26808e-01        2.73192e-01       3.95001e-08        0.00000         8.49360e-10         1.00000        602.882     29.0754     0.919964     3.76839e-11     2.04230e-13
   9.30000e-01        7.00000e-02        7.54513e-01        2.45487e-01       4.51430e-08        0.00000         9.70697e-10         1.00000        602.882     28.3122     0.919964     4.19368e-11     2.04230e-13
   9.40000e-01        6.00000e-02        7.83754e-01        2.16246e-01       5.26668e-08        0.00000         1.13248e-09         1.00000        602.882     27.5490     0.919964     4.76074e-11     2.04230e-13
   9.50000e-01        5.00000e-02        8.14660e-01        1.85340e-01       6.32002e-08        0.00000         1.35898e-09         1.00000        602.882     26.7858     0.919964     5.55463e-11     2.04230e-13
   9.60000e-01        4.00000e-02        8.47380e-01        1.52620e-01       7.90002e-08        0.00000         1.69872e-09         1.00000        602.882     26.0226     0.919964     6.74545e-11     2.04230e-13
   9.70000e-01        3.00000e-02        8.82076e-01        1.17924e-01       1.05334e-07        0.00000         2.26496e-09         1.00000        602.882     25.2594     0.919964     8.73016e-11     2.04230e-13
   9.80000e-01        2.00000e-02        9.18935e-01        8.10652e-02       1.58000e-07        0.00000         3.39744e-09         1.00000        602.882     24.4962     0.919964     1.26996e-10     2.04230e-13
   9.90000e-01        1.00000e-02        9.58164e-01        4.18360e-02       3.16001e-07        0.00000         6.79488e-09         1.00000        602.882     23.7330     0.919964     2.46078e-10     2.04230e-13
   9.95000e-01        5.00000e-03        9.78740e-01        2.12599e-02       6.32002e-07        0.00000         1.35898e-08         1.00000        602.882     23.3514     0.919964     4.84243e-10     2.04230e-13
   9.98000e-01        2.00000e-03        9.91412e-01        8.58815e-03       1.58000e-06        0.00000         3.39744e-08         1.00000        602.882     23.1224     0.919964     1.19874e-09     2.04230e-13
   9.99000e-01        1.00000e-03        9.95692e-01        4.30829e-03       3.16001e-06        0.00000         6.79488e-08         1.00000        602.882     23.0461     0.919964     2.38956e-09     2.04230e-13
   9.99500e-01        5.00000e-04        9.97842e-01        2.15772e-03       6.32002e-06        0.00000         1.35898e-07         1.00000        602.882     23.0079     0.919964     4.77121e-09     2.04230e-13
   9.99800e-01        2.00000e-04        9.99136e-01        8.63948e-04       1.58001e-05        0.00000         3.39745e-07         1.00000        602.881     22.9850     0.919964     1.19162e-08     2.04230e-13
   9.99900e-01        1.00000e-04        9.99568e-01        4.32117e-04       3.16002e-05        0.00000         6.79490e-07         1.00000        602.881     22.9774     0.919964     2.38245e-08     2.04231e-13
   9.99950e-01        5.00000e-05        9.99784e-01        2.16095e-04       6.32005e-05        0.00000         1.35898e-06         1.00000        602.881     22.9736     0.919964     4.76412e-08     2.04231e-13
   9.99980e-01        2.00000e-05        9.99914e-01        8.64464e-05       1.58003e-04        0.00000         3.39749e-06         1.00000        602.880     22.9713     0.919964     1.19092e-07     2.04233e-13
   9.99990e-01        1.00000e-05        9.99957e-01        4.32246e-05       3.16010e-04        0.00000         6.79506e-06         1.00000        602.879     22.9705     0.919964     2.38180e-07     2.04237e-13
   9.99995e-01        5.00000e-06        9.99978e-01        2.16127e-05       6.32040e-04        0.00000         1.35905e-05         1.00000        602.877     22.9702     0.919964     4.76367e-07     2.04244e-13
   9.99998e-01        2.00000e-06        9.99991e-01        8.64516e-06       1.58024e-03        0.00000         3.39789e-05         1.00000        602.870     22.9699     0.919963     1.19102e-06     2.04265e-13
   9.99999e-01        1.00000e-06        9.99996e-01        4.32259e-06       3.16096e-03        0.00000         6.79668e-05         0.99999        602.858     22.9699     0.919962     2.38239e-06     2.04300e-13
   1.00000e+00        5.00000e-07        9.99998e-01        2.16130e-06       6.32381e-03        0.00000         1.35969e-04         0.99999        602.835     22.9698     0.919959     4.76623e-06     2.04370e-13
   1.00000e+00        2.00000e-07        9.99999e-01        8.64521e-07       1.58238e-02        0.00000         3.40194e-04         0.99997        602.764     22.9698     0.919951     1.19266e-05     2.04581e-13
   1.00000e+00        1.00000e-07        1.00000e+00        4.32261e-07       3.16953e-02        0.00000         6.81290e-04         0.99993        602.647     22.9698     0.919939     2.38899e-05     2.04934e-13
   1.00000e+00        5.00000e-08        1.00000e+00        2.16130e-07       6.35829e-02        0.00000         1.36622e-03         0.99986        602.411     22.9698     0.919913     4.79280e-05     2.05645e-13
   1.00000e+00        2.00000e-08        1.00000e+00        8.64522e-08       1.60426e-01        0.00000         3.44330e-03         0.99966        601.696     22.9698     0.919834     1.20952e-04     2.07820e-13
   1.00000e+00        1.00000e-08        1.00000e+00        4.32261e-08       3.25936e-01        0.00000         6.98257e-03         0.99930        600.477     22.9698     0.919700     2.45824e-04     2.11590e-13
   1.00000e+00        5.00000e-09        1.00000e+00        2.16130e-08       6.73773e-01        0.00000         1.43775e-02         0.99856        597.930     22.9698     0.919417     5.08545e-04     2.19736e-13
   1.00000e+00        3.11639e-09        1.00000e+00        1.34709e-08       1.12879e+00        0.00000         2.39635e-02         0.99759        594.627     22.9698     0.919048     8.52807e-04     2.30867e-13
   1.00000e+00        2.00000e-09        1.00000e+00        8.64522e-09       1.89108e+00        0.00000         3.98046e-02         0.99596        589.164     22.9698     0.918428     1.43106e-03     2.50789e-13
   1.00000e+00        1.36083e-09        1.00000e+00        5.88234e-09       3.12579e+00        0.00000         6.48975e-02         0.99334        580.506     22.9698     0.917426     2.37166e-03     2.86759e-13
   1.00000e+00        1.00000e-09        1.00000e+00        4.32261e-09       5.16667e+00        0.00000         1.04906e-01         0.98903        566.690     22.9698     0.915770     3.93724e-03     3.57831e-13
   1.00000e+00        8.65855e-10        1.00000e+00        3.74275e-09       7.34766e+00        0.00000         1.45758e-01         0.98446        552.584     22.9698     0.914004     5.62526e-03     4.53274e-13
   1.00000e+00        8.18987e-10        1.00000e+00        3.54016e-09       1.04493e+01        0.00000         2.00729e-01         0.97802        533.639     22.9698     0.911503     8.05249e-03     6.34191e-13
   1.00000e+00        8.18987e-10        1.00000e+00        3.54016e-09       1.04512e+01        0.00000         2.00761e-01         0.97801        533.628     22.9698     0.911501     8.05399e-03     6.34322e-13
   1.00000e+00        8.56729e-10        1.00000e+00        3.70330e-09       1.38945e+01        0.00000         2.57886e-01         0.97096        514.038     22.9698     0.908747     1.07852e-02     9.20363e-13
   1.00000e+00        1.00000e-09        1.00000e+00        4.32261e-09       1.84721e+01        0.00000         3.28234e-01         0.96174        490.171     22.9698     0.905135     1.44760e-02     1.50772e-12
   1.00000e+00        1.17695e-09        1.00000e+00        5.08750e-09       2.19706e+01        0.00000         3.78234e-01         0.95482        473.474     22.9698     0.902424     1.73424e-02     2.19607e-12
   1.00000e+00        1.47696e-09        1.00000e+00        6.38430e-09       2.61317e+01        0.00000         4.34039e-01         0.94674        455.216     22.9698     0.899267     2.08030e-02     3.42954e-12
   1.00000e+00        2.00000e-09        1.00000e+00        8.64522e-09       3.10809e+01        0.00000         4.95973e-01         0.93736        435.571     22.9698     0.895626     2.49905e-02     5.81276e-12
   1.00000e+00        2.99193e-09        1.00000e+00        1.29330e-08       3.71063e+01        0.00000         5.66005e-01         0.92629        414.388     22.9698     0.891387     3.01918e-02     1.10011e-11
   1.00000e+00        5.00000e-09        1.00000e+00        2.16130e-08       4.42998e+01        0.00000         6.43549e-01         0.91362        392.551     22.9698     0.886644     3.65447e-02     2.33820e-11
   1.00000e+00        1.00000e-08        1.00000e+00        4.32261e-08       5.35517e+01        0.00000         7.36208e-01         0.89827        369.166     22.9698     0.881103     4.49320e-02     6.07552e-11
   1.00000e+00        2.00000e-08        1.00000e+00        8.64522e-08       6.25453e+01        0.00000         8.21093e-01         0.88446        350.627     22.9698     0.876354     5.32976e-02     1.50775e-10
   1.00000e+00        3.10001e-08        1.00000e+00        1.34001e-07       6.81773e+01        0.00000         8.72501e-01         0.87640        340.766     22.9698     0.873701     5.86308e-02     2.63417e-10
   1.00000e+00        5.00000e-08        1.00000e+00        2.16130e-07       7.43165e+01        0.00000         9.27473e-01         0.86817        331.315     22.9698     0.871079     6.45161e-02     4.78610e-10
   1.00000e+00        1.00000e-07        1.00000e+00        4.32261e-07       8.32784e+01        0.00000         1.00633e+00         0.85724        319.565     22.9698     0.867728     7.32179e-02     1.11860e-09
   1.00000e+00        2.00000e-07        9.99999e-01        8.64521e-07       9.23970e+01        0.00000         1.08543e+00         0.84750        309.631     22.9698     0.864837     8.21691e-02     2.57367e-09
   1.00000e+00        5.00000e-07        9.99998e-01        2.16130e-06       1.04853e+02        0.00000         1.19218e+00         0.83651        298.559     22.9698     0.861593     9.44719e-02     7.60583e-09
   9.99999e-01        1.00000e-06        9.99996e-01        4.32259e-06       1.14714e+02        0.00000         1.27574e+00         0.82974        291.306     22.9699     0.859481     1.04199e-01     1.70925e-08
   9.99998e-01        2.00000e-06        9.99991e-01        8.64516e-06       1.25084e+02        0.00000         1.36258e+00         0.82445        284.711     22.9699     0.857584     1.14349e-01     3.81798e-08
   9.99995e-01        5.00000e-06        9.99978e-01        2.16127e-05       1.39831e+02        0.00000         1.48381e+00         0.82007        276.601     22.9702     0.855287     1.28514e-01     1.09804e-07
   9.99990e-01        1.00000e-05        9.99957e-01        4.32246e-05       1.52014e+02        0.00000         1.58152e+00         0.81907        270.658     22.9705     0.853619     1.39884e-01     2.43604e-07
   9.99980e-01        2.00000e-05        9.99914e-01        8.64464e-05       1.65357e+02        0.00000         1.68555e+00         0.82047        264.661     22.9713     0.851930     1.51907e-01     5.40398e-07
   9.99968e-01        3.17677e-05        9.99863e-01        1.37305e-04       1.75068e+02        0.00000         1.75914e+00         0.82297        260.534     22.9722     0.850753     1.60345e-01     9.20556e-07
   9.99950e-01        5.00000e-05        9.99784e-01        2.16095e-04       1.85350e+02        0.00000         1.83500e+00         0.82685        256.327     22.9736     0.849534     1.68976e-01     1.55360e-06
   9.99900e-01        1.00000e-04        9.99568e-01        4.32117e-04       2.02859e+02        0.00000         1.95926e+00         0.83601        249.458     22.9774     0.847485     1.82944e-01     3.46910e-06
   9.99858e-01        1.42196e-04        9.99386e-01        6.14365e-04       2.12769e+02        0.00000         2.02683e+00         0.84243        245.706     22.9806     0.846330     1.90444e-01     5.22842e-06
   9.99800e-01        2.00000e-04        9.99136e-01        8.63948e-04       2.23163e+02        0.00000         2.09559e+00         0.85000        241.863     22.9850     0.845117     1.98006e-01     7.79450e-06
   9.99680e-01        3.20190e-04        9.98617e-01        1.38259e-03       2.39019e+02        0.00000         2.19649e+00         0.86298        236.170     22.9942     0.843260     2.08970e-01     1.35698e-05
   9.99500e-01        5.00000e-04        9.97842e-01        2.15772e-03       2.56002e+02        0.00000         2.29942e+00         0.87848        230.290     23.0079     0.841265     2.20000e-01     2.30464e-05
   9.99287e-01        7.13399e-04        9.96924e-01        3.07645e-03       2.71221e+02        0.00000         2.38743e+00         0.89354        225.206     23.0242     0.839472     2.29313e-01     3.52949e-05
   9.99000e-01        1.00000e-03        9.95692e-01        4.30829e-03       2.87346e+02        0.00000         2.47659e+00         0.91050        220.008     23.0461     0.837574     2.38646e-01     5.31126e-05
   9.98571e-01        1.42896e-03        9.93852e-01        6.14766e-03       3.06502e+02        0.00000         2.57746e+00         0.93177        214.082     23.0788     0.835325     2.49099e-01     8.21782e-05
   9.98000e-01        2.00000e-03        9.91412e-01        8.58815e-03       3.26936e+02        0.00000         2.67949e+00         0.95557        208.052     23.1224     0.832942     2.59578e-01     1.24572e-04
   9.97444e-01        2.55554e-03        9.89046e-01        1.09536e-02       3.43573e+02        0.00000         2.75869e+00         0.97565        203.359     23.1648     0.831018     2.67662e-01     1.69281e-04
   9.96771e-01        3.22940e-03        9.86189e-01        1.38112e-02       3.61056e+02        0.00000         2.83848e+00         0.99735        198.629     23.2163     0.829017     2.75774e-01     2.27542e-04
   9.95962e-01        4.03828e-03        9.82775e-01        1.72248e-02       3.79429e+02        0.00000         2.91882e+00         1.02072        193.873     23.2780     0.826939     2.83924e-01     3.02715e-04
   9.95000e-01        5.00000e-03        9.78740e-01        2.12599e-02       3.98737e+02        0.00000         2.99970e+00         1.04584        189.104     23.3514     0.824788     2.92123e-01     3.98833e-04
   9.93994e-01        6.00637e-03        9.74545e-01        2.54552e-02       4.16860e+02        0.00000         3.07255e+00         1.06990        184.829     23.4282     0.822799     2.99514e-01     5.06606e-04
   9.92835e-01        7.16483e-03        9.69749e-01        3.02506e-02       4.35806e+02        0.00000         3.14582e+00         1.09550        180.560     23.5166     0.820754     3.06963e-01     6.39107e-04
   9.91509e-01        8.49062e-03        9.64305e-01        3.56946e-02       4.55614e+02        0.00000         3.21950e+00         1.12273        176.303     23.6178     0.818655     3.14480e-01     8.01106e-04
   9.90000e-01        1.00000e-02        9.58164e-01        4.18360e-02       4.76321e+02        0.00000         3.29358e+00         1.15167        172.065     23.7330     0.816503     3.22074e-01     9.98183e-04
   9.87989e-01        1.20107e-02        9.50075e-01        4.99253e-02       5.01605e+02        0.00000         3.38032e+00         1.18765        167.168     23.8864     0.813934     3.31023e-01     1.28038e-03
   9.85676e-01        1.43241e-02        9.40896e-01        5.91043e-02       5.28230e+02        0.00000         3.46764e+00         1.22626        162.315     24.0630     0.811299     3.40113e-01     1.63121e-03
   9.83026e-01        1.69740e-02        9.30545e-01        6.94549e-02       5.56269e+02        0.00000         3.55555e+00         1.26772        157.516     24.2652     0.808600     3.49364e-01     2.06552e-03
   9.80000e-01        2.00000e-02        9.18935e-01        8.10652e-02       5.85795e+02        0.00000         3.64407e+00         1.31227        152.776     24.4962     0.805837     3.58801e-01     2.60145e-03
   9.77037e-01        2.29632e-02        9.07775e-01        9.22245e-02       6.12655e+02        0.00000         3.72126e+00         1.35360        148.720     24.7223     0.803391     3.67153e-01     3.16552e-03
   9.73719e-01        2.62812e-02        8.95520e-01        1.04480e-01       6.40746e+02        0.00000         3.79886e+00         1.39767        144.714     24.9756     0.800896     3.75689e-01     3.84096e-03
   9.70000e-01        3.00000e-02        8.82076e-01        1.17924e-01       6.70125e+02        0.00000         3.87677e+00         1.44473        140.758     25.2594     0.798348     3.84436e-01     4.65049e-03
   9.65338e-01        3.46617e-02        8.65644e-01        1.34356e-01       7.04258e+02        0.00000         3.96331e+00         1.50073        136.429     25.6152     0.795452     3.94420e-01     5.73969e-03
   9.60000e-01        4.00000e-02        8.47380e-01        1.52620e-01       7.40130e+02        0.00000         4.04972e+00         1.56127        132.149     26.0226     0.792462     4.04774e-01     7.08305e-03
   9.55308e-01        4.46924e-02        8.31791e-01        1.68209e-01       7.69110e+02        0.00000         4.11602e+00         1.61160        128.860     26.3807     0.790066     4.13095e-01     8.34373e-03
   9.50000e-01        5.00000e-02        8.14660e-01        1.85340e-01       7.99225e+02        0.00000         4.18133e+00         1.66546        125.574     26.7858     0.787568     4.21767e-01     9.85454e-03
   9.45307e-01        5.46928e-02        7.99940e-01        2.00060e-01       8.23609e+02        0.00000         4.23120e+00         1.71042        122.988     27.1439     0.785514     4.28867e-01     1.12477e-02
   9.40000e-01        6.00000e-02        7.83754e-01        2.16246e-01       8.48737e+02        0.00000         4.27924e+00         1.75830        120.367     27.5490     0.783334     4.36332e-01     1.28575e-02
   9.30000e-01        7.00000e-02        7.54513e-01        2.45487e-01       8.89230e+02        0.00000         4.34703e+00         1.83989        116.143     28.3122     0.779552     4.48981e-01     1.60786e-02
   9.20000e-01        8.00000e-02        7.26808e-01        2.73192e-01       9.21009e+02        0.00000         4.38680e+00         1.90996        112.656     29.0754     0.776074     4.60041e-01     1.95276e-02
   9.10000e-01        9.00000e-02        7.00520e-01        2.99480e-01       9.44379e+02        0.00000         4.40026e+00         1.96832        109.739     29.8385     0.772793     4.69743e-01     2.31867e-02
   9.00000e-01        1.00000e-01        6.75543e-01        3.24457e-01       9.59773e+02        0.00000         4.38932e+00         2.01501        107.270     30.6017     0.769631     4.78266e-01     2.70425e-02
   8.90000e-01        1.10000e-01        6.51782e-01        3.48218e-01       9.67803e+02        0.00000         4.35636e+00         2.05039        105.156     31.3649     0.766531     4.85766e-01     3.10864e-02
   8.80000e-01        1.20000e-01        6.29150e-01        3.70850e-01       9.69247e+02        0.00000         4.30417e+00         2.07517        103.325     32.1281     0.763452     4.92377e-01     3.53140e-02
   8.70000e-01        1.30000e-01        6.07568e-01        3.92432e-01       9.65003e+02        0.00000         4.23584e+00         2.09034        101.719     32.8913     0.760369     4.98224e-01     3.97260e-02
   8.60000e-01        1.40000e-01        5.86965e-01        4.13035e-01       9.56013e+02        0.00000         4.15452e+00         2.09706        100.293     33.6545     0.757263     5.03419e-01     4.43272e-02
   8.50000e-01        1.50000e-01        5.67275e-01        4.32725e-01       9.43202e+02        0.00000         4.06321e+00         2.09655         99.009     34.4177     0.754125     5.08060e-01     4.91268e-02
   8.40000e-01        1.60000e-01        5.48440e-01        4.51560e-01       9.27421e+02        0.00000         3.96461e+00         2.09000         97.837     35.1809     0.750949     5.12237e-01     5.41378e-02
   8.30000e-01        1.70000e-01        5.30405e-01        4.69595e-01       9.09420e+02        0.00000         3.86105e+00         2.07852         96.750     35.9441     0.747728     5.16025e-01     5.93770e-02
   8.20000e-01        1.80000e-01        5.13119e-01        4.86881e-01       8.89834e+02        0.00000         3.75446e+00         2.06309         95.730     36.7073     0.744461     5.19488e-01     6.48652e-02
   8.10000e-01        1.90000e-01        4.96538e-01        5.03462e-01       8.69185e+02        0.00000         3.64635e+00         2.04456         94.758     37.4705     0.741141     5.22679e-01     7.06273e-02
   8.00000e-01        2.00000e-01        4.80619e-01        5.19381e-01       8.47892e+02        0.00000         3.53792e+00         2.02362         93.819     38.2337     0.737764     5.25643e-01     7.66928e-02
   7.90000e-01        2.10000e-01        4.65322e-01        5.34678e-01       8.26284e+02        0.00000         3.43004e+00         2.00085         92.902     38.9969     0.734323     5.28418e-01     8.30965e-02
   7.80000e-01        2.20000e-01        4.50613e-01        5.49387e-01       8.04614e+02        0.00000         3.32336e+00         1.97672         91.995     39.7601     0.730810     5.31034e-01     8.98797e-02
   7.70000e-01        2.30000e-01        4.36458e-01        5.63542e-01       7.83076e+02        0.00000         3.21834e+00         1.95162         91.087     40.5233     0.727213     5.33515e-01     9.70912e-02
   7.60000e-01        2.40000e-01        4.22827e-01        5.77173e-01       7.61814e+02        0.00000         3.11527e+00         1.92584         90.171     41.2865     0.723521     5.35883e-01     1.04790e-01
   7.50000e-01        2.50000e-01        4.09690e-01        5.90310e-01       7.40933e+02        0.00000         3.01431e+00         1.89962         89.236     42.0497     0.719718     5.38155e-01     1.13046e-01
   7.40000e-01        2.60000e-01        3.97022e-01        6.02978e-01       7.20511e+02        0.00000         2.91556e+00         1.87317         88.274     42.8129     0.715785     5.40346e-01     1.21946e-01
   7.30000e-01        2.70000e-01        3.84797e-01        6.15203e-01       7.00601e+02        0.00000         2.81902e+00         1.84662         87.275     43.5761     0.711700     5.42467e-01     1.31597e-01
   7.20000e-01        2.80000e-01        3.72993e-01        6.27007e-01       6.81239e+02        0.00000         2.72463e+00         1.82012         86.231     44.3393     0.707436     5.44530e-01     1.42132e-01
   7.10000e-01        2.90000e-01        3.61589e-01        6.38411e-01       6.62450e+02        0.00000         2.63229e+00         1.79375         85.129     45.1025     0.702958     5.46543e-01     1.53723e-01
   7.00000e-01        3.00000e-01        3.50564e-01        6.49436e-01       6.44246e+02        0.00000         2.54185e+00         1.76760         83.958     45.8657     0.698225     5.48514e-01     1.66591e-01
   6.90000e-01        3.10000e-01        3.39900e-01        6.60100e-01       6.26637e+02        0.00000         2.45309e+00         1.74175         82.701     46.6289     0.693183     5.50450e-01     1.80988e-01
   6.80000e-01        3.20000e-01        3.29580e-01        6.70420e-01       6.09626e+02        0.00000         2.36577e+00         1.71625         81.342     47.3921     0.687761     5.52358e-01     1.97154e-01
   6.70000e-01        3.30000e-01        3.19586e-01        6.80414e-01       5.93215e+02        0.00000         2.27956e+00         1.69117         79.855     48.1553     0.681864     5.54245e-01     2.15831e-01
   6.60000e-01        3.40000e-01        3.09905e-01        6.90095e-01       5.77406e+02        0.00000         2.19402e+00         1.66656         78.210     48.9184     0.675362     5.56117e-01     2.37847e-01
   6.50000e-01        3.50000e-01        3.00521e-01        6.99479e-01       5.62204e+02        0.00000         2.10856e+00         1.64249         76.362     49.6816     0.668064     5.57981e-01     2.64485e-01
   6.40000e-01        3.60000e-01        2.91421e-01        7.08579e-01       5.47618e+02        0.00000         2.02235e+00         1.61905         74.247     50.4448     0.659682     5.59845e-01     2.97856e-01
   6.30000e-01        3.70000e-01        2.82592e-01        7.17408e-01       5.33668e+02        0.00000         1.93410e+00         1.59633         71.766     51.2080     0.649744     5.61717e-01     3.41740e-01
   6.20000e-01        3.80000e-01        2.74022e-01        7.25978e-01       5.20391e+02        0.00000         1.84166e+00         1.57451         68.749     51.9712     0.637415     5.63612e-01     4.03728e-01
   6.10000e-01        3.90000e-01        2.65701e-01        7.34299e-01       5.07860e+02        0.00000         1.74126e+00         1.55382         64.897     52.7344     0.621070     5.65549e-01     5.01615e-01
   6.00000e-01        4.00000e-01        2.57616e-01        7.42384e-01       4.96214e+02        0.00000         1.62707e+00         1.53471         59.708     53.4976     0.597492     5.67559e-01     6.84825e-01
   5.91574e-01        4.08426e-01        2.50982e-01        7.49018e-01       4.87258e+02        0.00000         1.52252e+00         1.52033         54.293     54.1407     0.570128     5.69347e-01     9.89948e-01
   5.91387e-01        4.08613e-01        2.50836e-01        7.49164e-01       4.87069e+02        0.50000         1.52003e+00         1.52003         54.155     54.1550     0.569388     5.69388e-01     1.00000e+00
END

$Env_BP << END
#                                                                              Sat Pres                                                                                     Liq Den      Gas Den           
# Mole Frac Inj      Mole Frac Feed     Mass Frac Inj      Mass Frac Feed       (bar)        Liq Mole Frac      Liq Z-Factor      Gas Z-Factor      Liq MW      Gas MW      (g/cm3)      (g/cm3)      Kmin/Kmax
#---------------   -----------------   ---------------   -----------------   -----------   ----------------   ---------------   ---------------   ---------   ---------   ----------   ----------   -------------
   5.91387e-01          0.40861          2.50836e-01          0.74916          487.069          0.5000            1.52003           1.52003        54.1550     54.1550     0.569388     0.569388     1.00000e+00
   5.91200e-01          0.40880          2.50691e-01          0.74931          486.881          1.0000            1.51974           1.51758        54.1692     54.0188     0.569429     0.568656     9.90030e-01
   5.90000e-01          0.41000          2.49760e-01          0.75024          485.682          1.0000            1.51785           1.50358        54.2608     53.2612     0.569693     0.564507     9.34801e-01
   5.80000e-01          0.42000          2.42121e-01          0.75788          476.328          1.0000            1.50355           1.40558        55.0240     47.8788     0.571971     0.532387     5.88605e-01
   5.70000e-01          0.43000          2.34691e-01          0.76531          467.885          1.0000            1.49118           1.33931        55.7872     44.2987     0.574350     0.507785     4.01312e-01
   5.60000e-01          0.44000          2.27462e-01          0.77254          460.090          1.0000            1.48012           1.29134        56.5504     41.7877     0.576786     0.488522     2.90859e-01
   5.50000e-01          0.45000          2.20426e-01          0.77957          452.785          1.0000            1.46999           1.25388        57.3136     39.8852     0.579252     0.472587     2.19120e-01
   5.40000e-01          0.46000          2.13574e-01          0.78643          445.869          1.0000            1.46056           1.22312        58.0768     38.3629     0.581733     0.458861     1.69372e-01
   5.30000e-01          0.47000          2.06900e-01          0.79310          439.274          1.0000            1.45166           1.19701        58.8400     37.0982     0.584217     0.446708     1.33312e-01
   5.20000e-01          0.48000          2.00397e-01          0.79960          432.952          1.0000            1.44320           1.17431        59.6032     36.0189     0.586698     0.435731     1.06348e-01
   5.10000e-01          0.49000          1.94058e-01          0.80594          426.868          1.0000            1.43509           1.15425        60.3664     35.0793     0.589170     0.425674     8.57163e-02
   5.00000e-01          0.50000          1.87878e-01          0.81212          420.992          1.0000            1.42728           1.13628        61.1296     34.2487     0.591629     0.416356     6.96530e-02
   4.90000e-01          0.51000          1.81850e-01          0.81815          415.304          1.0000            1.41971           1.12002        61.8928     33.5054     0.594072     0.407649     5.69747e-02
   4.80000e-01          0.52000          1.75969e-01          0.82403          409.784          1.0000            1.41235           1.10520        62.6560     32.8337     0.596498     0.399455     4.68582e-02
   4.70000e-01          0.53000          1.70229e-01          0.82977          404.418          1.0000            1.40516           1.09159        63.4192     32.2218     0.598905     0.391700     3.87137e-02
   4.60000e-01          0.54000          1.64626e-01          0.83537          399.193          1.0000            1.39813           1.07903        64.1824     31.6605     0.601290     0.384327     3.21085e-02
   4.50000e-01          0.55000          1.59155e-01          0.84085          394.098          1.0000            1.39123           1.06738        64.9456     31.1427     0.603654     0.377289     2.67183e-02
   4.40000e-01          0.56000          1.53811e-01          0.84619          389.125          1.0000            1.38444           1.05654        65.7088     30.6626     0.605996     0.370547     2.22966e-02
   4.30000e-01          0.57000          1.48589e-01          0.85141          384.265          1.0000            1.37776           1.04642        66.4720     30.2156     0.608315     0.364072     1.86532e-02
   4.20000e-01          0.58000          1.43486e-01          0.85651          379.511          1.0000            1.37116           1.03695        67.2352     29.7977     0.610611     0.357835     1.56394e-02
   4.10000e-01          0.59000          1.38498e-01          0.86150          374.856          1.0000            1.36464           1.02805        67.9984     29.4059     0.612883     0.351817     1.31379e-02
   4.00000e-01          0.60000          1.33620e-01          0.86638          370.296          1.0000            1.35819           1.01968        68.7615     29.0373     0.615132     0.345997     1.10557e-02
   3.90000e-01          0.61000          1.28849e-01          0.87115          365.826          1.0000            1.35179           1.01180        69.5247     28.6896     0.617357     0.340360     9.31796e-03
   3.80000e-01          0.62000          1.24182e-01          0.87582          361.440          1.0000            1.34545           1.00435        70.2879     28.3610     0.619558     0.334892     7.86434e-03
   3.70000e-01          0.63000          1.19616e-01          0.88038          357.135          1.0000            1.33915           0.99731        71.0511     28.0496     0.621736     0.329581     6.64593e-03
   3.60000e-01          0.64000          1.15146e-01          0.88485          352.907          1.0000            1.33290           0.99065        71.8143     27.7541     0.623890     0.324415     5.62280e-03
   3.50000e-01          0.65000          1.10770e-01          0.88923          348.753          1.0000            1.32667           0.98433        72.5775     27.4730     0.626021     0.319385     4.76224e-03
   3.40000e-01          0.66000          1.06486e-01          0.89351          344.670          1.0000            1.32048           0.97835        73.3407     27.2054     0.628128     0.314484     4.03736e-03
   3.30000e-01          0.67000          1.02289e-01          0.89771          340.655          1.0000            1.31432           0.97266        74.1039     26.9500     0.630212     0.309703     3.42593e-03
   3.20000e-01          0.68000          9.81784e-02          0.90182          336.705          1.0000            1.30818           0.96726        74.8671     26.7061     0.632273     0.305036     2.90956e-03
   3.10000e-01          0.69000          9.41505e-02          0.90585          332.818          1.0000            1.30206           0.96212        75.6303     26.4729     0.634312     0.300476     2.47300e-03
   3.00000e-01          0.70000          9.02032e-02          0.90980          328.991          1.0000            1.29596           0.95724        76.3935     26.2496     0.636328     0.296019     2.10351e-03
   2.90000e-01          0.71000          8.63339e-02          0.91367          325.223          1.0000            1.28987           0.95259        77.1567     26.0355     0.638322     0.291658     1.79050e-03
   2.80000e-01          0.72000          8.25404e-02          0.91746          321.511          1.0000            1.28380           0.94816        77.9199     25.8301     0.640294     0.287391     1.52509e-03
   2.70000e-01          0.73000          7.88205e-02          0.92118          317.854          1.0000            1.27774           0.94394        78.6831     25.6329     0.642244     0.283212     1.29987e-03
   2.60000e-01          0.74000          7.51721e-02          0.92483          314.250          1.0000            1.27168           0.93993        79.4463     25.4433     0.644173     0.279118     1.10859e-03
   2.50000e-01          0.75000          7.15931e-02          0.92841          310.697          1.0000            1.26564           0.93610        80.2095     25.2610     0.646080     0.275105     9.46017e-04
   2.40000e-01          0.76000          6.80816e-02          0.93192          307.194          1.0000            1.25959           0.93245        80.9727     25.0855     0.647967     0.271170     8.07752e-04
   2.30000e-01          0.77000          6.46356e-02          0.93536          303.739          1.0000            1.25356           0.92897        81.7359     24.9164     0.649833     0.267310     6.90081e-04
   2.20000e-01          0.78000          6.12534e-02          0.93875          300.331          1.0000            1.24752           0.92566        82.4991     24.7534     0.651678     0.263522     5.89872e-04
   2.10000e-01          0.79000          5.79333e-02          0.94207          296.968          1.0000            1.24149           0.92250        83.2623     24.5962     0.653504     0.259804     5.04482e-04
   2.00000e-01          0.80000          5.46734e-02          0.94533          293.650          1.0000            1.23546           0.91949        84.0255     24.4445     0.655310     0.256153     4.31678e-04
   1.90000e-01          0.81000          5.14722e-02          0.94853          290.375          1.0000            1.22942           0.91661        84.7887     24.2980     0.657096     0.252567     3.69568e-04
   1.80000e-01          0.82000          4.83281e-02          0.95167          287.142          1.0000            1.22339           0.91388        85.5519     24.1565     0.658863     0.249043     3.16554e-04
   1.70000e-01          0.83000          4.52397e-02          0.95476          283.950          1.0000            1.21735           0.91127        86.3151     24.0197     0.660610     0.245580     2.71278e-04
   1.60000e-01          0.84000          4.22053e-02          0.95779          280.797          1.0000            1.21131           0.90879        87.0783     23.8875     0.662339     0.242176     2.32592e-04
   1.50000e-01          0.85000          3.92237e-02          0.96078          277.684          1.0000            1.20526           0.90643        87.8414     23.7595     0.664050     0.238830     1.99519e-04
   1.40000e-01          0.86000          3.62935e-02          0.96371          274.608          1.0000            1.19921           0.90418        88.6046     23.6357     0.665742     0.235538     1.71230e-04
   1.30000e-01          0.87000          3.34133e-02          0.96659          271.570          1.0000            1.19316           0.90204        89.3678     23.5158     0.667417     0.232301     1.47023e-04
   1.20000e-01          0.88000          3.05819e-02          0.96942          268.568          1.0000            1.18710           0.90000        90.1310     23.3997     0.669074     0.229115     1.26297e-04
   1.10000e-01          0.89000          2.77980e-02          0.97220          265.601          1.0000            1.18103           0.89807        90.8942     23.2873     0.670713     0.225981     1.08544e-04
   1.00000e-01          0.90000          2.50605e-02          0.97494          262.669          1.0000            1.17496           0.89623        91.6574     23.1783     0.672335     0.222896     9.33300e-05
   9.00000e-02          0.91000          2.23682e-02          0.97763          259.770          1.0000            1.16888           0.89449        92.4206     23.0726     0.673940     0.219859     8.02859e-05
   8.00000e-02          0.92000          1.97200e-02          0.98028          256.905          1.0000            1.16279           0.89284        93.1838     22.9701     0.675528     0.216869     6.90970e-05
   7.00000e-02          0.93000          1.71148e-02          0.98289          254.072          1.0000            1.15669           0.89127        93.9470     22.8707     0.677100     0.213924     5.94951e-05
   6.00000e-02          0.94000          1.45516e-02          0.98545          251.270          1.0000            1.15059           0.88979        94.7102     22.7743     0.678656     0.211024     5.12512e-05
   5.00000e-02          0.95000          1.20294e-02          0.98797          248.499          1.0000            1.14448           0.88838        95.4734     22.6808     0.680196     0.208168     4.41700e-05
   4.00000e-02          0.96000          9.54721e-03          0.99045          245.759          1.0000            1.13835           0.88706        96.2366     22.5899     0.681720     0.205354     3.80849e-05
   3.00000e-02          0.97000          7.10407e-03          0.99290          243.049          1.0000            1.13222           0.88581        96.9998     22.5017     0.683228     0.202582     3.28533e-05
   2.00000e-02          0.98000          4.69908e-03          0.99530          240.367          1.0000            1.12608           0.88463        97.7630     22.4161     0.684721     0.199850     2.83534e-05
   1.00000e-02          0.99000          2.33134e-03          0.99767          237.715          1.0000            1.11993           0.88353        98.5262     22.3330     0.686199     0.197158     2.44813e-05
   5.00000e-03          0.99500          1.16117e-03          0.99884          236.399          1.0000            1.11685           0.88300        98.9078     22.2923     0.686932     0.195826     2.27522e-05
   2.00000e-03          0.99800          4.63396e-04          0.99954          235.612          1.0000            1.11500           0.88269        99.1367     22.2681     0.687371     0.195032     2.17752e-05
   1.00000e-03          0.99900          2.31520e-04          0.99977          235.351          1.0000            1.11438           0.88259        99.2131     22.2602     0.687516     0.194768     2.14591e-05
   5.00000e-04          0.99950          1.15715e-04          0.99988          235.220          1.0000            1.11407           0.88254        99.2512     22.2562     0.687589     0.194636     2.13028e-05
   2.00000e-04          0.99980          4.62755e-05          0.99995          235.142          1.0000            1.11389           0.88251        99.2741     22.2538     0.687633     0.194557     2.12096e-05
   1.00000e-04          0.99990          2.31360e-05          0.99998          235.116          1.0000            1.11383           0.88250        99.2818     22.2530     0.687647     0.194531     2.11787e-05
   5.00000e-05          0.99995          1.15675e-05          0.99999          235.103          1.0000            1.11380           0.88249        99.2856     22.2526     0.687655     0.194517     2.11632e-05
   2.00000e-05          0.99998          4.62691e-06          1.00000          235.095          1.0000            1.11378           0.88249        99.2879     22.2523     0.687659     0.194509     2.11539e-05
   1.00000e-05          0.99999          2.31344e-06          1.00000          235.092          1.0000            1.11377           0.88249        99.2886     22.2523     0.687660     0.194507     2.11508e-05
   5.00000e-06          0.99999          1.15671e-06          1.00000          235.091          1.0000            1.11377           0.88249        99.2890     22.2522     0.687661     0.194505     2.11493e-05
   2.00000e-06          1.00000          4.62684e-07          1.00000          235.090          1.0000            1.11377           0.88249        99.2892     22.2522     0.687662     0.194505     2.11483e-05
   1.00000e-06          1.00000          2.31342e-07          1.00000          235.090          1.0000            1.11377           0.88249        99.2893     22.2522     0.687662     0.194504     2.11480e-05
   5.00000e-07          1.00000          1.15671e-07          1.00000          235.090          1.0000            1.11377           0.88249        99.2893     22.2522     0.687662     0.194504     2.11479e-05
   2.00000e-07          1.00000          4.62684e-08          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11478e-05
   1.00000e-07          1.00000          2.31342e-08          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11478e-05
   5.00000e-08          1.00000          1.15671e-08          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   2.00000e-08          1.00000          4.62684e-09          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   1.00000e-08          1.00000          2.31342e-09          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   5.00000e-09          1.00000          1.15671e-09          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   2.00000e-09          1.00000          4.62684e-10          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   1.00000e-09          1.00000          2.31342e-10          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   5.00000e-10          1.00000          1.15671e-10          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   2.00000e-10          1.00000          4.62684e-11          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   1.00000e-10          1.00000          2.31342e-11          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   5.00000e-11          1.00000          1.15671e-11          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   2.00000e-11          1.00000          4.62684e-12          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   1.00000e-11          1.00000          2.31342e-12          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   5.00000e-12          1.00000          1.15671e-12          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   2.00000e-12          1.00000          4.62684e-13          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   1.00000e-12          1.00000          2.31342e-13          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
   0.00000e+00          1.00000          0.00000e+00          1.00000          235.090          1.0000            1.11377           0.88249        99.2894     22.2522     0.687662     0.194504     2.11477e-05
END

set output "Figures/Env_008_P_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"

set output "Figures/Env_008_P_vs_Wi_1.pdf"
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
plot [*:*] [*:*] \
     $Env_DP using 3:5 with lines title "Dew Points", \
     $Env_BP using 3:5 with lines title "Bubble Points"

set output "Figures/Env_008_LogP_vs_Xi_1.pdf"
set xlabel "Mole Fraction Injectant"
set ylabel "Saturation Pressure (bar)"
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 1:5 with lines title "Dew Points", \
     $Env_BP using 1:5 with lines title "Bubble Points"
unset logscale y

set output "Figures/Env_008_LogP_vs_LogXf_1.pdf"
set xlabel "Mole Fraction Feed"
set ylabel "Saturation Pressure (bar)"
set logscale x
set logscale y
plot [*:*] [*:*] \
     $Env_DP using 2:5 with lines title "Dew Points", \
     $Env_BP using 2:5 with lines title "Bubble Points"
unset logscale x
unset logscale y

set title "Black Oil Tables from Predicted_3350_m_Oil at 93.5 C\nUsing Three-Stage Separation Process"
show title

$BOT_BP << END
#   Psat        EOS Deno     BO Deno          Rs              Bo            1/Bo          Viso
#   (bar)       (kg/m3)      (kg/m3)      (sm3/stm3)      (rm3/stm3)     (stm3/rm3)       (cp)
#----------   -----------   ---------   -------------   -------------   ------------   ---------
    1.0132      820.509      818.037          0.000        1.04238        0.959342      1.98145
    2.0000      815.013      816.784          0.000        1.04398        0.957873      1.85550
    5.0000      807.423      813.337         26.170        1.04949        0.952841      1.70295
   10.0000      801.501      806.158        114.446        1.06255        0.941135      1.59880
   20.0000      793.473      794.323        279.418        1.08541        0.921311      1.47045
   40.0000      780.805      780.198        526.015        1.11576        0.896249      1.28847
   60.0000      769.827      768.308        763.975        1.14351        0.874498      1.14836
   80.0000      759.491      757.567       1001.305        1.17033        0.854458      1.02981
  100.0000      749.536      747.372       1244.434        1.19731        0.835205      0.92708
  120.0000      739.860      737.568       1494.999        1.22473        0.816508      0.83726
  140.0000      730.414      728.071       1754.098        1.25275        0.798244      0.75835
  160.0000      721.161      718.826       2022.693        1.28151        0.780329      0.68875
  180.0000      712.073      709.792       2301.791        1.31114        0.762698      0.62713
  200.0000      703.118      700.928       2592.546        1.34176        0.745290      0.57232
  220.0000      694.261      692.197       2896.346        1.37354        0.728045      0.52332
  235.1438      687.594      685.649       3136.117        1.39850        0.715053      0.48954
  250.0000      681.093      679.275       3380.037        1.42378        0.702357      0.45898
  275.0000      670.248      668.657       3811.268        1.46822        0.681097      0.41280
  300.0000      659.453      658.118       4272.225        1.51544        0.659872      0.37213
  325.0000      648.652      647.604       4767.603        1.56595        0.638592      0.33606
  350.0000      637.774      637.047       5303.558        1.62038        0.617140      0.30385
  375.0000      626.725      626.360       5888.517        1.67964        0.595365      0.27482
  400.0000      615.368      615.414       6534.725        1.74507        0.573044      0.24836
  425.0000      603.481      604.001       7261.536        1.81878        0.549820      0.22385
  450.0000      590.658      591.740       8103.684        1.90464        0.525032      0.20058
  475.0000      575.962      577.749       9138.477        2.01140        0.497165      0.17735
  500.0000      555.934      558.758      10644.033        2.17099        0.460620      0.15064
  508.5191      543.372      546.858      11617.140        2.27847        0.438891      0.13634
END

$BOT_DP << END
#   Psat       EOS Deng      BO Deng          Rv             Bg            1/Bg           Visg
#   (bar)       (kg/m3)      (kg/m3)      (stm3/sm3)      (rm3/sm3)      (sm3/rm3)        (cp)
#----------   ----------   ----------   -------------   ------------   ------------   -----------
    1.0132       2.1909       1.8547     1.58381e-04     0.09106819        10.981      0.0093519
    2.0000       3.4840       2.4488     5.61082e-05     0.03336213        29.974      0.0100532
    5.0000       6.4305       4.3895     1.92501e-05     0.01145216        87.320      0.0110785
   10.0000      10.3572       7.7596     9.99367e-06     0.00546115       183.112      0.0118253
   20.0000      17.6230      14.4565     4.95036e-06     0.00263383       379.676      0.0124627
   40.0000      32.0290      28.2226     2.34017e-06     0.00127027       787.237      0.0131141
   60.0000      46.7859      42.7654     1.80583e-06     0.00082765      1208.247      0.0136649
   80.0000      62.0948      57.9982     1.79128e-06     0.00061006      1639.193      0.0142754
  100.0000      77.9605      73.8288     2.00945e-06     0.00048177      2075.697      0.0149986
  120.0000      94.3304      90.1784     2.38758e-06     0.00039800      2512.589      0.0158623
  140.0000     111.1268     106.9734     2.90564e-06     0.00033964      2944.298      0.0168824
  160.0000     128.2648     124.1449     3.55993e-06     0.00029716      3365.246      0.0180655
  180.0000     145.6634     141.6330     4.35271e-06     0.00026524      3770.214      0.0194107
  200.0000     163.2555     159.3900     5.28895e-06     0.00024070      4154.607      0.0209110
  220.0000     180.9945     177.3849     6.37577e-06     0.00022150      4514.602      0.0225568
  235.1438     194.5098     191.1614     7.30481e-06     0.00020968      4769.070      0.0238940
  250.0000     207.8331     204.7985     8.30902e-06     0.00019990      5002.421      0.0252785
  275.0000     230.3988     228.0217     1.02190e-05     0.00018669      5356.575      0.0277677
  300.0000     253.2083     251.6468     1.24376e-05     0.00017668      5660.024      0.0304696
  325.0000     276.3865     275.7821     1.50156e-05     0.00016919      5910.635      0.0334264
  350.0000     300.1385     300.6079     1.80301e-05     0.00016377      6106.303      0.0367241
  375.0000     324.7808     326.4076     2.16015e-05     0.00016015      6244.114      0.0405166
  400.0000     350.8045     353.6304     2.59259e-05     0.00015825      6319.127      0.0450739
  425.0000     379.0172     383.0240     3.13468e-05     0.00015817      6322.163      0.0508989
  450.0000     410.8989     415.9662     3.85396e-05     0.00016039      6234.718      0.0590533
  475.0000     449.7569     455.5272     4.91384e-05     0.00016630      6013.135      0.0723690
  500.0000     507.0921     512.2477     6.94573e-05     0.00018171      5503.221      0.1037063
  508.5191     542.6111     546.1421     8.56805e-05     0.00019576      5108.187      0.1355127
END

set output "Figures/BOT_001_Rs_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rs (sm3/stm3)"
plot [*:*] [*:*] $BOT_BP using 1:4 with lines linetype 2 notitle

set output "Figures/BOT_001_Bo_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Bo (rm3/stm3)"
plot [*:*] [*:*] $BOT_BP using 1:5 with lines linetype 2 notitle

set output "Figures/BOT_001_Rv_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rv (stm3/sm3)"
set logscale y
plot [*:*] [*:*] $BOT_DP using 1:4 with lines linetype 2 notitle
unset logscale y

set output "Figures/BOT_001_Bgi_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "1/Bg (sm3/rm3)"
plot [*:*] [*:*] $BOT_DP using 1:6 with lines linetype 2 notitle

set output "Figures/BOT_001_Vis_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Viscosity (cp)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:7 with lines title "Gas", \
     $BOT_BP using 1:7 with lines title "Oil"
unset logscale y

set output "Figures/BOT_001_Den_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Density (kg/m3)"
plot [*:*] [*:*]  \
     $BOT_BP using 1:2 with points title "Oil, EOS", \
     $BOT_BP using 1:3 with lines title "Oil, BO", \
     $BOT_DP using 1:2 with points title "Gas, EOS", \
     $BOT_DP using 1:3 with lines title "Gas, BO"

set output "Figures/BOT_001_R_vs_P_1.pdf"
set xlabel "Saturation Pressure (bar)"
set ylabel "Rs and 1/Rv (sm3/stm3)"
set logscale y
plot [*:*] [*:*]  \
     $BOT_DP using 1:(1/$4) with lines title "1/Rv", \
     $BOT_BP using 1:4 with lines title "Rs"
unset logscale y

set output
